// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.configdefinition;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of ilscripts
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class IlscriptsConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "270fbf596c4b5159d4e692a552b03553";
  public final static String CONFIG_DEF_NAME = "ilscripts";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.configdefinition";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.configdefinition",
    "maxtermoccurrences int default=10000",
    "maxtokenlength int default=1000",
    "fieldmatchmaxlength int default=1000000",
    "maxReplacementCharactersRatio double default=0.3",
    "maxReplacementCharacters int default=10000",
    "ilscript[].doctype string",
    "ilscript[].docfield[] string",
    "ilscript[].content[] string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer maxtermoccurrences = null;
    private Integer maxtokenlength = null;
    private Integer fieldmatchmaxlength = null;
    private Double maxReplacementCharactersRatio = null;
    private Integer maxReplacementCharacters = null;
    public List<Ilscript.Builder> ilscript = new ArrayList<>();

    public Builder() { }

    public Builder(IlscriptsConfig config) {
      maxtermoccurrences(config.maxtermoccurrences());
      maxtokenlength(config.maxtokenlength());
      fieldmatchmaxlength(config.fieldmatchmaxlength());
      maxReplacementCharactersRatio(config.maxReplacementCharactersRatio());
      maxReplacementCharacters(config.maxReplacementCharacters());
      for (Ilscript i : config.ilscript()) {
        ilscript(new Ilscript.Builder(i));
      }
    }

    private Builder override(Builder __superior) {
      if (__superior.maxtermoccurrences != null)
        maxtermoccurrences(__superior.maxtermoccurrences);
      if (__superior.maxtokenlength != null)
        maxtokenlength(__superior.maxtokenlength);
      if (__superior.fieldmatchmaxlength != null)
        fieldmatchmaxlength(__superior.fieldmatchmaxlength);
      if (__superior.maxReplacementCharactersRatio != null)
        maxReplacementCharactersRatio(__superior.maxReplacementCharactersRatio);
      if (__superior.maxReplacementCharacters != null)
        maxReplacementCharacters(__superior.maxReplacementCharacters);
      if (!__superior.ilscript.isEmpty())
        ilscript.addAll(__superior.ilscript);
      return this;
    }

    public Builder maxtermoccurrences(int __value) {
      maxtermoccurrences = __value;
      return this;
    }

    private Builder maxtermoccurrences(String __value) {
      return maxtermoccurrences(Integer.valueOf(__value));
    }

    public Builder maxtokenlength(int __value) {
      maxtokenlength = __value;
      return this;
    }

    private Builder maxtokenlength(String __value) {
      return maxtokenlength(Integer.valueOf(__value));
    }

    public Builder fieldmatchmaxlength(int __value) {
      fieldmatchmaxlength = __value;
      return this;
    }

    private Builder fieldmatchmaxlength(String __value) {
      return fieldmatchmaxlength(Integer.valueOf(__value));
    }

    public Builder maxReplacementCharactersRatio(double __value) {
      maxReplacementCharactersRatio = __value;
      return this;
    }

    private Builder maxReplacementCharactersRatio(String __value) {
      return maxReplacementCharactersRatio(Double.valueOf(__value));
    }

    public Builder maxReplacementCharacters(int __value) {
      maxReplacementCharacters = __value;
      return this;
    }

    private Builder maxReplacementCharacters(String __value) {
      return maxReplacementCharacters(Integer.valueOf(__value));
    }

    /**
     * Add the given builder to this builder's list of Ilscript builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder ilscript(Ilscript.Builder __builder) {
      ilscript.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder ilscript(java.util.function.Consumer<Ilscript.Builder> __func) {
      Ilscript.Builder __inner = new Ilscript.Builder();
      __func.accept(__inner);
      ilscript.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Ilscript builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder ilscript(List<Ilscript.Builder> __builders) {
      ilscript = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public IlscriptsConfig build() {
      return new IlscriptsConfig(this);
    }

  }

  // The maximum number of occurrences of a given term to index per field
  private final IntegerNode maxtermoccurrences;
  // The maximum number of characters for a token
  private final IntegerNode maxtokenlength;
  private final IntegerNode fieldmatchmaxlength;
  // Note on replacement character thresholds: both must be exceeded to skip annotation processing. See LinguisticsAnnotator for details.
  // The maximum allowed ratio of replacement characters before skipping annotation processing
  private final DoubleNode maxReplacementCharactersRatio;
  // The maximum number of replacement characters to allow before skipping annotation processing
  private final IntegerNode maxReplacementCharacters;
  private final InnerNodeVector<Ilscript> ilscript;

  public IlscriptsConfig(Builder builder) {
    this(builder, true);
  }

  private IlscriptsConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "ilscripts must be initialized: " + builder.__uninitialized);

    maxtermoccurrences = (builder.maxtermoccurrences == null) ?
        new IntegerNode(10000) : new IntegerNode(builder.maxtermoccurrences);
    maxtokenlength = (builder.maxtokenlength == null) ?
        new IntegerNode(1000) : new IntegerNode(builder.maxtokenlength);
    fieldmatchmaxlength = (builder.fieldmatchmaxlength == null) ?
        new IntegerNode(1000000) : new IntegerNode(builder.fieldmatchmaxlength);
    maxReplacementCharactersRatio = (builder.maxReplacementCharactersRatio == null) ?
        new DoubleNode(0.3D) : new DoubleNode(builder.maxReplacementCharactersRatio);
    maxReplacementCharacters = (builder.maxReplacementCharacters == null) ?
        new IntegerNode(10000) : new IntegerNode(builder.maxReplacementCharacters);
    ilscript = Ilscript.createVector(builder.ilscript);
  }

  /**
   * @return ilscripts.maxtermoccurrences
   */
  public int maxtermoccurrences() {
    return maxtermoccurrences.value();
  }

  /**
   * @return ilscripts.maxtokenlength
   */
  public int maxtokenlength() {
    return maxtokenlength.value();
  }

  /**
   * @return ilscripts.fieldmatchmaxlength
   */
  public int fieldmatchmaxlength() {
    return fieldmatchmaxlength.value();
  }

  /**
   * @return ilscripts.maxReplacementCharactersRatio
   */
  public double maxReplacementCharactersRatio() {
    return maxReplacementCharactersRatio.value();
  }

  /**
   * @return ilscripts.maxReplacementCharacters
   */
  public int maxReplacementCharacters() {
    return maxReplacementCharacters.value();
  }

  /**
   * @return ilscripts.ilscript[]
   */
  public List<Ilscript> ilscript() {
    return ilscript;
  }

  /**
   * @param i the index of the value to return
   * @return ilscripts.ilscript[]
   */
  public Ilscript ilscript(int i) {
    return ilscript.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(IlscriptsConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("ilscripts");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents ilscripts.ilscript[]
   */
  public final static class Ilscript extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "doctype"
        ));

      private String doctype = null;
      public List<String> docfield = new ArrayList<>();
      public List<String> content = new ArrayList<>();

      public Builder() { }

      public Builder(Ilscript config) {
        doctype(config.doctype());
        docfield(config.docfield());
        content(config.content());
      }

      private Builder override(Builder __superior) {
        if (__superior.doctype != null)
          doctype(__superior.doctype);
        if (!__superior.docfield.isEmpty())
          docfield.addAll(__superior.docfield);
        if (!__superior.content.isEmpty())
          content.addAll(__superior.content);
        return this;
      }

      public Builder doctype(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        doctype = __value;
        __uninitialized.remove("doctype");
        return this;
      }


      public Builder docfield(String __value) {
        docfield.add(__value);
        return this;
      }

      public Builder docfield(Collection<String> __values) {
        docfield.addAll(__values);
        return this;
      }

      public Builder content(String __value) {
        content.add(__value);
        return this;
      }

      public Builder content(Collection<String> __values) {
        content.addAll(__values);
        return this;
      }

      public Ilscript build() {
        return new Ilscript(this);
      }

    }

    private final StringNode doctype;
    private final LeafNodeVector<String, StringNode> docfield;
    private final LeafNodeVector<String, StringNode> content;

    public Ilscript(Builder builder) {
      this(builder, true);
    }

    private Ilscript(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "ilscripts.ilscript[] must be initialized: " + builder.__uninitialized);

      doctype = (builder.doctype == null) ?
          new StringNode() : new StringNode(builder.doctype);
      docfield = new LeafNodeVector<>(builder.docfield, new StringNode());
      content = new LeafNodeVector<>(builder.content, new StringNode());
    }

    /**
     * @return ilscripts.ilscript[].doctype
     */
    public String doctype() {
      return doctype.value();
    }

    /**
     * @return ilscripts.ilscript[].docfield[]
     */
    public List<String> docfield() {
      return docfield.asList();
    }

    /**
     * @param i the index of the value to return
     * @return ilscripts.ilscript[].docfield[]
     */
    public String docfield(int i) {
      return docfield.get(i).value();
    }

    /**
     * @return ilscripts.ilscript[].content[]
     */
    public List<String> content() {
      return content.asList();
    }

    /**
     * @param i the index of the value to return
     * @return ilscripts.ilscript[].content[]
     */
    public String content(int i) {
      return content.get(i).value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Ilscript newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("ilscript");
      return changes;
    }

    private static InnerNodeVector<Ilscript> createVector(List<Builder> builders) {
        List<Ilscript> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Ilscript(b));
        }
        return new InnerNodeVector<Ilscript>(elems);
    }
  }

}
