// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.search.core;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of ranking-expressions
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class RankingExpressionsConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "ff17c6b7529b1bccd49409790771212b";
  public final static String CONFIG_DEF_NAME = "ranking-expressions";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.search.core";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.search.core",
    "expression[].name string",
    "expression[].fileref file"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Expression.Builder> expression = new ArrayList<>();

    public Builder() { }

    public Builder(RankingExpressionsConfig config) {
      for (Expression e : config.expression()) {
        expression(new Expression.Builder(e));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.expression.isEmpty())
        expression.addAll(__superior.expression);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Expression builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder expression(Expression.Builder __builder) {
      expression.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder expression(java.util.function.Consumer<Expression.Builder> __func) {
      Expression.Builder __inner = new Expression.Builder();
      __func.accept(__inner);
      expression.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Expression builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder expression(List<Expression.Builder> __builders) {
      expression = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public RankingExpressionsConfig build() {
      return new RankingExpressionsConfig(this);
    }

  }

  private final InnerNodeVector<Expression> expression;

  public RankingExpressionsConfig(Builder builder) {
    this(builder, true);
  }

  private RankingExpressionsConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "ranking-expressions must be initialized: " + builder.__uninitialized);

    expression = Expression.createVector(builder.expression);
  }

  /**
   * @return ranking-expressions.expression[]
   */
  public List<Expression> expression() {
    return expression;
  }

  /**
   * @param i the index of the value to return
   * @return ranking-expressions.expression[]
   */
  public Expression expression(int i) {
    return expression.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(RankingExpressionsConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("ranking-expressions");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents ranking-expressions.expression[]
   */
  public final static class Expression extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name",
        "fileref"
        ));

      private String name = null;
      private String fileref = null;

      public Builder() { }

      public Builder(Expression config) {
        name(config.name());
        fileref(config.fileref().value());
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.fileref != null)
          fileref(__superior.fileref);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder fileref(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        fileref = __value;
        __uninitialized.remove("fileref");
        return this;
      }


      public Expression build() {
        return new Expression(this);
      }

    }

    private final StringNode name;
    private final FileNode fileref;

    public Expression(Builder builder) {
      this(builder, true);
    }

    private Expression(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "ranking-expressions.expression[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      fileref = (builder.fileref == null) ?
          new FileNode() : new FileNode(builder.fileref);
    }

    /**
     * @return ranking-expressions.expression[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return ranking-expressions.expression[].fileref
     */
    public FileReference fileref() {
      return fileref.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Expression newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("expression");
      return changes;
    }

    private static InnerNodeVector<Expression> createVector(List<Builder> builders) {
        List<Expression> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Expression(b));
        }
        return new InnerNodeVector<Expression>(elems);
    }
  }

}
