// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.search.core;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of ranking-constants
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class RankingConstantsConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "c285ed1fda604d6dd53e814bae81a008";
  public final static String CONFIG_DEF_NAME = "ranking-constants";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.search.core";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.search.core",
    "constant[].name string",
    "constant[].fileref file",
    "constant[].type string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Constant.Builder> constant = new ArrayList<>();

    public Builder() { }

    public Builder(RankingConstantsConfig config) {
      for (Constant c : config.constant()) {
        constant(new Constant.Builder(c));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.constant.isEmpty())
        constant.addAll(__superior.constant);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Constant builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder constant(Constant.Builder __builder) {
      constant.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder constant(java.util.function.Consumer<Constant.Builder> __func) {
      Constant.Builder __inner = new Constant.Builder();
      __func.accept(__inner);
      constant.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Constant builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder constant(List<Constant.Builder> __builders) {
      constant = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public RankingConstantsConfig build() {
      return new RankingConstantsConfig(this);
    }

  }

  private final InnerNodeVector<Constant> constant;

  public RankingConstantsConfig(Builder builder) {
    this(builder, true);
  }

  private RankingConstantsConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "ranking-constants must be initialized: " + builder.__uninitialized);

    constant = Constant.createVector(builder.constant);
  }

  /**
   * @return ranking-constants.constant[]
   */
  public List<Constant> constant() {
    return constant;
  }

  /**
   * @param i the index of the value to return
   * @return ranking-constants.constant[]
   */
  public Constant constant(int i) {
    return constant.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(RankingConstantsConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("ranking-constants");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents ranking-constants.constant[]
   */
  public final static class Constant extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name",
        "fileref",
        "type"
        ));

      private String name = null;
      private String fileref = null;
      private String type = null;

      public Builder() { }

      public Builder(Constant config) {
        name(config.name());
        fileref(config.fileref().value());
        type(config.type());
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.fileref != null)
          fileref(__superior.fileref);
        if (__superior.type != null)
          type(__superior.type);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder fileref(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        fileref = __value;
        __uninitialized.remove("fileref");
        return this;
      }


      public Builder type(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        type = __value;
        __uninitialized.remove("type");
        return this;
      }


      public Constant build() {
        return new Constant(this);
      }

    }

    private final StringNode name;
    private final FileNode fileref;
    private final StringNode type;

    public Constant(Builder builder) {
      this(builder, true);
    }

    private Constant(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "ranking-constants.constant[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      fileref = (builder.fileref == null) ?
          new FileNode() : new FileNode(builder.fileref);
      type = (builder.type == null) ?
          new StringNode() : new StringNode(builder.type);
    }

    /**
     * @return ranking-constants.constant[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return ranking-constants.constant[].fileref
     */
    public FileReference fileref() {
      return fileref.value();
    }

    /**
     * @return ranking-constants.constant[].type
     */
    public String type() {
      return type.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Constant newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("constant");
      return changes;
    }

    private static InnerNodeVector<Constant> createVector(List<Builder> builders) {
        List<Constant> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Constant(b));
        }
        return new InnerNodeVector<Constant>(elems);
    }
  }

}
