// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.search.core;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of proton
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class ProtonConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "c22fed022adfb0582e63ecb2a10a77b2";
  public final static String CONFIG_DEF_NAME = "proton";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.search.core";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.search.core",
    "basedir string default=\".\" restart",
    "rpcport int default=8004 restart",
    "httpport int default=0 restart",
    "clustername string default=\"\" restart",
    "distributionkey int default=-1",
    "rpc.transportthreads int default=0 restart",
    "search.async bool default=true",
    "docsum.async bool default=true",
    "numsearcherthreads int default=64 restart",
    "numthreadspersearch int default=1 restart",
    "numsummarythreads int default=16 restart",
    "validate_and_sanitize_docstore enum {NO, YES} default = NO",
    "flush.maxconcurrent int default=2 restart",
    "flush.idleinterval double default=10.0 restart",
    "flush.strategy enum {SIMPLE, MEMORY} default=MEMORY restart",
    "flush.memory.maxmemory long default=4294967296",
    "flush.memory.diskbloatfactor double default=0.25",
    "flush.memory.maxtlssize long default=21474836480",
    "flush.memory.each.maxmemory long default=1073741824",
    "flush.memory.each.diskbloatfactor double default=0.25",
    "flush.memory.maxage.time double default=111600.0",
    "flush.memory.conservative.memorylimitfactor double default=0.5",
    "flush.memory.conservative.disklimitfactor double default=0.5",
    "flush.memory.conservative.highwatermarkfactor double default=0.95",
    "flush.memory.conservative.lowwatermarkfactor double default=0.9",
    "flush.preparerestart.replaycost double default=8.0",
    "flush.preparerestart.replayoperationcost double default=3000.0",
    "flush.preparerestart.writecost double default=1.0",
    "flush.preparerestart.readcost double default=1.0",
    "indexing.write.io enum {NORMAL, OSYNC, DIRECTIO} default=DIRECTIO restart",
    "indexing.read.io enum {NORMAL, DIRECTIO} default=DIRECTIO restart",
    "indexing.optimize enum {LATENCY, THROUGHPUT, ADAPTIVE} default=THROUGHPUT restart",
    "indexing.tasklimit int default=-1000",
    "indexing.kind_of_watermark int default = 0 restart",
    "indexing.reactiontime double default = 0.001 restart",
    "index.warmup.time double default=0.0 restart",
    "index.warmup.unpack bool default=false restart",
    "index.maxflushed int default=2",
    "index.maxflushedretired int default=20",
    "attribute.write.io enum {NORMAL, OSYNC, DIRECTIO} default=DIRECTIO restart",
    "search.io enum {NORMAL, DIRECTIO, MMAP } default=MMAP restart",
    "search.mmap.options[] enum {POPULATE, HUGETLB} restart",
    "search.mmap.advise enum {NORMAL, RANDOM, SEQUENTIAL} default=SEQUENTIAL restart",
    "search.memory.limiter.maxthreads int default=0",
    "search.memory.limiter.mincoverage double default=1.0",
    "search.memory.limiter.minhits int default=1000000",
    "grouping.sessionmanager.maxentries int default=500 restart",
    "grouping.sessionmanager.pruning.interval double default=1.0",
    "distribution.redundancy long default=1",
    "distribution.searchablecopies long default=1",
    "summary.cache.maxbytes long default=-4",
    "summary.cache.compression.type enum {NONE, LZ4, ZSTD} default=LZ4",
    "summary.cache.compression.level int default=6",
    "summary.cache.update_strategy enum {INVALIDATE, UPDATE} default=INVALIDATE",
    "summary.log.compact.compression.type enum {NONE, LZ4, ZSTD} default=ZSTD",
    "summary.log.compact.compression.level int default=9",
    "summary.log.chunk.compression.type enum {NONE, LZ4, ZSTD} default=ZSTD",
    "summary.log.chunk.compression.level int default=9",
    "summary.log.chunk.maxbytes int default=65536",
    "summary.log.maxfilesize long default=1000000000",
    "summary.log.maxnumlids int default=8388608",
    "summary.log.maxdiskbloatfactor double default=0.1",
    "summary.log.maxbucketspread double default=2.5",
    "summary.log.minfilesizefactor double default=0.2",
    "summary.write.io enum {NORMAL, OSYNC, DIRECTIO} default=DIRECTIO",
    "summary.read.io enum {NORMAL, DIRECTIO, MMAP } default=MMAP restart",
    "summary.read.mmap.options[] enum {POPULATE, HUGETLB} restart",
    "summary.read.mmap.advise enum {NORMAL, RANDOM, SEQUENTIAL} default=NORMAL restart",
    "documentdb[].inputdoctypename string",
    "documentdb[].mode enum {INDEX, STREAMING, STORE_ONLY} default=INDEX",
    "documentdb[].configid string",
    "documentdb[].visibilitydelay double default=0.0",
    "documentdb[].global bool default=false",
    "documentdb[].allocation.initialnumdocs long default=1024",
    "documentdb[].allocation.growfactor double default=0.2",
    "documentdb[].allocation.growbias int default=1",
    "documentdb[].allocation.amortizecount int default=10000",
    "documentdb[].allocation.multivaluegrowfactor double default=0.2",
    "documentdb[].allocation.max_dead_bytes_ratio double default=0.05",
    "documentdb[].allocation.max_dead_address_space_ratio double default=0.2",
    "documentdb[].allocation.max_compact_buffers int default=1",
    "documentdb[].allocation.active_buffers_ratio double default=0.1",
    "periodic.interval double default=3600.0",
    "tlsspec string default=\"tcp/localhost:13700\" restart",
    "tlsconfigid string default=\"\" restart",
    "slobrokconfigid string default=\"\" restart",
    "routingconfigid string default=\"\" restart",
    "filedistributor.configid reference default=\"\" restart",
    "pruneremoveddocumentsinterval double default=0.0",
    "pruneremoveddocumentsage double default=1209600.0",
    "packetcompresslimit int default=1024",
    "packetcompresslevel int default=3",
    "packetcompresstype enum {NONE, LZ4} default=LZ4",
    "lidspacecompaction.interval double default=10.0",
    "lidspacecompaction.allowedlidbloat int default=1",
    "lidspacecompaction.allowedlidbloatfactor double default=0.01",
    "lidspacecompaction.removebatchblockrate double default=0.5",
    "lidspacecompaction.removeblockrate double default=100.0",
    "bucketmove.maxdocstomoveperbucket int default=1",
    "maxvisibilitydelay double default=1.0",
    "visit.defaultserializedsize long default=1",
    "visit.ignoremaxbytes bool default=true",
    "initialize.threads int default = 0",
    "writefilter.attribute.address_space_limit double default = 0.91",
    "writefilter.memorylimit double default = 0.8",
    "writefilter.disklimit double default = 0.8",
    "writefilter.sampleinterval double default = 60.0",
    "hwinfo.disk.size long default = 0 restart",
    "hwinfo.disk.shared bool default = false restart",
    "hwinfo.disk.writespeed double default = 200.0 restart",
    "hwinfo.disk.samplewritesize long default = 1073741824 restart",
    "hwinfo.disk.slowwritespeedlimit double default = 100.0 restart",
    "hwinfo.memory.size long default = 0 restart",
    "hwinfo.cpu.cores int default = 0 restart",
    "feeding.concurrency double default = 0.2 restart",
    "feeding.niceness double default = 0.0 restart",
    "feeding.master_task_limit int default = 0",
    "maintenancejobs.resourcelimitfactor double default = 1.05",
    "maintenancejobs.maxoutstandingmoveops int default=100",
    "bucketdb.checksumtype enum {LEGACY, XXHASH64} default = LEGACY restart",
    "replay_throttling_policy.type enum { UNLIMITED, DYNAMIC } default=DYNAMIC",
    "replay_throttling_policy.min_window_size int default=100",
    "replay_throttling_policy.max_window_size int default=10000",
    "replay_throttling_policy.window_size_increment int default=20",
    "replay_throttling_policy.memory_usage_soft_limit_bytes long default=-3",
    "indexing.semiunboundtasklimit int default = 1000",
    "summary.cache.allowvisitcaching bool default=true",
    "summary.cache.initialentries long default=0 restart",
    "summary.log.chunk.skipcrconread bool default=false",
    "indexing.threads int default=1 restart",
    "index.cache.size long default=0 restart",
    "index.cache.postinglist.maxbytes long default=0 restart",
    "index.cache.bitvector.maxbytes long default=0 restart",
    "index.cache.postinglist.slru_protected_segment_ratio double default=0.0 restart",
    "index.cache.bitvector.slru_protected_segment_ratio double default=0.0 restart",
    "index.cache.postinglist.lfu_sketch_max_element_count long default=0 restart",
    "index.cache.bitvector.lfu_sketch_max_element_count long default=0 restart",
    "tensor_implementation enum {TENSOR_ENGINE, FAST_VALUE} default = FAST_VALUE",
    "forward_issues bool default = true"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private String basedir = null;
    private Integer rpcport = null;
    private Integer httpport = null;
    private String clustername = null;
    private Integer distributionkey = null;
    public Rpc.Builder rpc = new Rpc.Builder();
    public Search.Builder search = new Search.Builder();
    public Docsum.Builder docsum = new Docsum.Builder();
    private Integer numsearcherthreads = null;
    private Integer numthreadspersearch = null;
    private Integer numsummarythreads = null;
    private Validate_and_sanitize_docstore.Enum validate_and_sanitize_docstore = null;
    public Flush.Builder flush = new Flush.Builder();
    public Indexing.Builder indexing = new Indexing.Builder();
    public Index.Builder index = new Index.Builder();
    public Attribute.Builder attribute = new Attribute.Builder();
    public Grouping.Builder grouping = new Grouping.Builder();
    public Distribution.Builder distribution = new Distribution.Builder();
    public Summary.Builder summary = new Summary.Builder();
    public List<Documentdb.Builder> documentdb = new ArrayList<>();
    public Periodic.Builder periodic = new Periodic.Builder();
    private String tlsspec = null;
    private String tlsconfigid = null;
    private String slobrokconfigid = null;
    private String routingconfigid = null;
    public Filedistributor.Builder filedistributor = new Filedistributor.Builder();
    private Double pruneremoveddocumentsinterval = null;
    private Double pruneremoveddocumentsage = null;
    private Integer packetcompresslimit = null;
    private Integer packetcompresslevel = null;
    private Packetcompresstype.Enum packetcompresstype = null;
    public Lidspacecompaction.Builder lidspacecompaction = new Lidspacecompaction.Builder();
    public Bucketmove.Builder bucketmove = new Bucketmove.Builder();
    private Double maxvisibilitydelay = null;
    public Visit.Builder visit = new Visit.Builder();
    public Initialize.Builder initialize = new Initialize.Builder();
    public Writefilter.Builder writefilter = new Writefilter.Builder();
    public Hwinfo.Builder hwinfo = new Hwinfo.Builder();
    public Feeding.Builder feeding = new Feeding.Builder();
    public Maintenancejobs.Builder maintenancejobs = new Maintenancejobs.Builder();
    public Bucketdb.Builder bucketdb = new Bucketdb.Builder();
    public Replay_throttling_policy.Builder replay_throttling_policy = new Replay_throttling_policy.Builder();
    private Tensor_implementation.Enum tensor_implementation = null;
    private Boolean forward_issues = null;

    public Builder() { }

    public Builder(ProtonConfig config) {
      basedir(config.basedir());
      rpcport(config.rpcport());
      httpport(config.httpport());
      clustername(config.clustername());
      distributionkey(config.distributionkey());
      rpc(new Rpc.Builder(config.rpc()));
      search(new Search.Builder(config.search()));
      docsum(new Docsum.Builder(config.docsum()));
      numsearcherthreads(config.numsearcherthreads());
      numthreadspersearch(config.numthreadspersearch());
      numsummarythreads(config.numsummarythreads());
      validate_and_sanitize_docstore(config.validate_and_sanitize_docstore());
      flush(new Flush.Builder(config.flush()));
      indexing(new Indexing.Builder(config.indexing()));
      index(new Index.Builder(config.index()));
      attribute(new Attribute.Builder(config.attribute()));
      grouping(new Grouping.Builder(config.grouping()));
      distribution(new Distribution.Builder(config.distribution()));
      summary(new Summary.Builder(config.summary()));
      for (Documentdb d : config.documentdb()) {
        documentdb(new Documentdb.Builder(d));
      }
      periodic(new Periodic.Builder(config.periodic()));
      tlsspec(config.tlsspec());
      tlsconfigid(config.tlsconfigid());
      slobrokconfigid(config.slobrokconfigid());
      routingconfigid(config.routingconfigid());
      filedistributor(new Filedistributor.Builder(config.filedistributor()));
      pruneremoveddocumentsinterval(config.pruneremoveddocumentsinterval());
      pruneremoveddocumentsage(config.pruneremoveddocumentsage());
      packetcompresslimit(config.packetcompresslimit());
      packetcompresslevel(config.packetcompresslevel());
      packetcompresstype(config.packetcompresstype());
      lidspacecompaction(new Lidspacecompaction.Builder(config.lidspacecompaction()));
      bucketmove(new Bucketmove.Builder(config.bucketmove()));
      maxvisibilitydelay(config.maxvisibilitydelay());
      visit(new Visit.Builder(config.visit()));
      initialize(new Initialize.Builder(config.initialize()));
      writefilter(new Writefilter.Builder(config.writefilter()));
      hwinfo(new Hwinfo.Builder(config.hwinfo()));
      feeding(new Feeding.Builder(config.feeding()));
      maintenancejobs(new Maintenancejobs.Builder(config.maintenancejobs()));
      bucketdb(new Bucketdb.Builder(config.bucketdb()));
      replay_throttling_policy(new Replay_throttling_policy.Builder(config.replay_throttling_policy()));
      tensor_implementation(config.tensor_implementation());
      forward_issues(config.forward_issues());
    }

    private Builder override(Builder __superior) {
      if (__superior.basedir != null)
        basedir(__superior.basedir);
      if (__superior.rpcport != null)
        rpcport(__superior.rpcport);
      if (__superior.httpport != null)
        httpport(__superior.httpport);
      if (__superior.clustername != null)
        clustername(__superior.clustername);
      if (__superior.distributionkey != null)
        distributionkey(__superior.distributionkey);
      rpc(rpc.override(__superior.rpc));
      search(search.override(__superior.search));
      docsum(docsum.override(__superior.docsum));
      if (__superior.numsearcherthreads != null)
        numsearcherthreads(__superior.numsearcherthreads);
      if (__superior.numthreadspersearch != null)
        numthreadspersearch(__superior.numthreadspersearch);
      if (__superior.numsummarythreads != null)
        numsummarythreads(__superior.numsummarythreads);
      if (__superior.validate_and_sanitize_docstore != null)
        validate_and_sanitize_docstore(__superior.validate_and_sanitize_docstore);
      flush(flush.override(__superior.flush));
      indexing(indexing.override(__superior.indexing));
      index(index.override(__superior.index));
      attribute(attribute.override(__superior.attribute));
      grouping(grouping.override(__superior.grouping));
      distribution(distribution.override(__superior.distribution));
      summary(summary.override(__superior.summary));
      if (!__superior.documentdb.isEmpty())
        documentdb.addAll(__superior.documentdb);
      periodic(periodic.override(__superior.periodic));
      if (__superior.tlsspec != null)
        tlsspec(__superior.tlsspec);
      if (__superior.tlsconfigid != null)
        tlsconfigid(__superior.tlsconfigid);
      if (__superior.slobrokconfigid != null)
        slobrokconfigid(__superior.slobrokconfigid);
      if (__superior.routingconfigid != null)
        routingconfigid(__superior.routingconfigid);
      filedistributor(filedistributor.override(__superior.filedistributor));
      if (__superior.pruneremoveddocumentsinterval != null)
        pruneremoveddocumentsinterval(__superior.pruneremoveddocumentsinterval);
      if (__superior.pruneremoveddocumentsage != null)
        pruneremoveddocumentsage(__superior.pruneremoveddocumentsage);
      if (__superior.packetcompresslimit != null)
        packetcompresslimit(__superior.packetcompresslimit);
      if (__superior.packetcompresslevel != null)
        packetcompresslevel(__superior.packetcompresslevel);
      if (__superior.packetcompresstype != null)
        packetcompresstype(__superior.packetcompresstype);
      lidspacecompaction(lidspacecompaction.override(__superior.lidspacecompaction));
      bucketmove(bucketmove.override(__superior.bucketmove));
      if (__superior.maxvisibilitydelay != null)
        maxvisibilitydelay(__superior.maxvisibilitydelay);
      visit(visit.override(__superior.visit));
      initialize(initialize.override(__superior.initialize));
      writefilter(writefilter.override(__superior.writefilter));
      hwinfo(hwinfo.override(__superior.hwinfo));
      feeding(feeding.override(__superior.feeding));
      maintenancejobs(maintenancejobs.override(__superior.maintenancejobs));
      bucketdb(bucketdb.override(__superior.bucketdb));
      replay_throttling_policy(replay_throttling_policy.override(__superior.replay_throttling_policy));
      if (__superior.tensor_implementation != null)
        tensor_implementation(__superior.tensor_implementation);
      if (__superior.forward_issues != null)
        forward_issues(__superior.forward_issues);
      return this;
    }

    public Builder basedir(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      basedir = __value;
      return this;
    }


    public Builder rpcport(int __value) {
      rpcport = __value;
      return this;
    }

    private Builder rpcport(String __value) {
      return rpcport(Integer.valueOf(__value));
    }

    public Builder httpport(int __value) {
      httpport = __value;
      return this;
    }

    private Builder httpport(String __value) {
      return httpport(Integer.valueOf(__value));
    }

    public Builder clustername(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      clustername = __value;
      return this;
    }


    public Builder distributionkey(int __value) {
      distributionkey = __value;
      return this;
    }

    private Builder distributionkey(String __value) {
      return distributionkey(Integer.valueOf(__value));
    }

    public Builder rpc(Rpc.Builder __builder) {
      rpc = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder rpc(java.util.function.Consumer<Rpc.Builder> __func) {
      Rpc.Builder __inner = new Rpc.Builder();
      __func.accept(__inner);
      rpc = __inner;
      return this;
    }

    public Builder search(Search.Builder __builder) {
      search = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder search(java.util.function.Consumer<Search.Builder> __func) {
      Search.Builder __inner = new Search.Builder();
      __func.accept(__inner);
      search = __inner;
      return this;
    }

    public Builder docsum(Docsum.Builder __builder) {
      docsum = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder docsum(java.util.function.Consumer<Docsum.Builder> __func) {
      Docsum.Builder __inner = new Docsum.Builder();
      __func.accept(__inner);
      docsum = __inner;
      return this;
    }

    public Builder numsearcherthreads(int __value) {
      numsearcherthreads = __value;
      return this;
    }

    private Builder numsearcherthreads(String __value) {
      return numsearcherthreads(Integer.valueOf(__value));
    }

    public Builder numthreadspersearch(int __value) {
      numthreadspersearch = __value;
      return this;
    }

    private Builder numthreadspersearch(String __value) {
      return numthreadspersearch(Integer.valueOf(__value));
    }

    public Builder numsummarythreads(int __value) {
      numsummarythreads = __value;
      return this;
    }

    private Builder numsummarythreads(String __value) {
      return numsummarythreads(Integer.valueOf(__value));
    }

    public Builder validate_and_sanitize_docstore(Validate_and_sanitize_docstore.Enum __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      validate_and_sanitize_docstore = __value;
      return this;
    }

    private Builder validate_and_sanitize_docstore(String __value) {
      return validate_and_sanitize_docstore(Validate_and_sanitize_docstore.Enum.valueOf(__value));
    }

    public Builder flush(Flush.Builder __builder) {
      flush = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder flush(java.util.function.Consumer<Flush.Builder> __func) {
      Flush.Builder __inner = new Flush.Builder();
      __func.accept(__inner);
      flush = __inner;
      return this;
    }

    public Builder indexing(Indexing.Builder __builder) {
      indexing = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder indexing(java.util.function.Consumer<Indexing.Builder> __func) {
      Indexing.Builder __inner = new Indexing.Builder();
      __func.accept(__inner);
      indexing = __inner;
      return this;
    }

    public Builder index(Index.Builder __builder) {
      index = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder index(java.util.function.Consumer<Index.Builder> __func) {
      Index.Builder __inner = new Index.Builder();
      __func.accept(__inner);
      index = __inner;
      return this;
    }

    public Builder attribute(Attribute.Builder __builder) {
      attribute = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder attribute(java.util.function.Consumer<Attribute.Builder> __func) {
      Attribute.Builder __inner = new Attribute.Builder();
      __func.accept(__inner);
      attribute = __inner;
      return this;
    }

    public Builder grouping(Grouping.Builder __builder) {
      grouping = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder grouping(java.util.function.Consumer<Grouping.Builder> __func) {
      Grouping.Builder __inner = new Grouping.Builder();
      __func.accept(__inner);
      grouping = __inner;
      return this;
    }

    public Builder distribution(Distribution.Builder __builder) {
      distribution = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder distribution(java.util.function.Consumer<Distribution.Builder> __func) {
      Distribution.Builder __inner = new Distribution.Builder();
      __func.accept(__inner);
      distribution = __inner;
      return this;
    }

    public Builder summary(Summary.Builder __builder) {
      summary = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder summary(java.util.function.Consumer<Summary.Builder> __func) {
      Summary.Builder __inner = new Summary.Builder();
      __func.accept(__inner);
      summary = __inner;
      return this;
    }

    /**
     * Add the given builder to this builder's list of Documentdb builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder documentdb(Documentdb.Builder __builder) {
      documentdb.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder documentdb(java.util.function.Consumer<Documentdb.Builder> __func) {
      Documentdb.Builder __inner = new Documentdb.Builder();
      __func.accept(__inner);
      documentdb.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Documentdb builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder documentdb(List<Documentdb.Builder> __builders) {
      documentdb = __builders;
      return this;
    }

    public Builder periodic(Periodic.Builder __builder) {
      periodic = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder periodic(java.util.function.Consumer<Periodic.Builder> __func) {
      Periodic.Builder __inner = new Periodic.Builder();
      __func.accept(__inner);
      periodic = __inner;
      return this;
    }

    public Builder tlsspec(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      tlsspec = __value;
      return this;
    }


    public Builder tlsconfigid(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      tlsconfigid = __value;
      return this;
    }


    public Builder slobrokconfigid(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      slobrokconfigid = __value;
      return this;
    }


    public Builder routingconfigid(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      routingconfigid = __value;
      return this;
    }


    public Builder filedistributor(Filedistributor.Builder __builder) {
      filedistributor = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder filedistributor(java.util.function.Consumer<Filedistributor.Builder> __func) {
      Filedistributor.Builder __inner = new Filedistributor.Builder();
      __func.accept(__inner);
      filedistributor = __inner;
      return this;
    }

    public Builder pruneremoveddocumentsinterval(double __value) {
      pruneremoveddocumentsinterval = __value;
      return this;
    }

    private Builder pruneremoveddocumentsinterval(String __value) {
      return pruneremoveddocumentsinterval(Double.valueOf(__value));
    }

    public Builder pruneremoveddocumentsage(double __value) {
      pruneremoveddocumentsage = __value;
      return this;
    }

    private Builder pruneremoveddocumentsage(String __value) {
      return pruneremoveddocumentsage(Double.valueOf(__value));
    }

    public Builder packetcompresslimit(int __value) {
      packetcompresslimit = __value;
      return this;
    }

    private Builder packetcompresslimit(String __value) {
      return packetcompresslimit(Integer.valueOf(__value));
    }

    public Builder packetcompresslevel(int __value) {
      packetcompresslevel = __value;
      return this;
    }

    private Builder packetcompresslevel(String __value) {
      return packetcompresslevel(Integer.valueOf(__value));
    }

    public Builder packetcompresstype(Packetcompresstype.Enum __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      packetcompresstype = __value;
      return this;
    }

    private Builder packetcompresstype(String __value) {
      return packetcompresstype(Packetcompresstype.Enum.valueOf(__value));
    }

    public Builder lidspacecompaction(Lidspacecompaction.Builder __builder) {
      lidspacecompaction = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder lidspacecompaction(java.util.function.Consumer<Lidspacecompaction.Builder> __func) {
      Lidspacecompaction.Builder __inner = new Lidspacecompaction.Builder();
      __func.accept(__inner);
      lidspacecompaction = __inner;
      return this;
    }

    public Builder bucketmove(Bucketmove.Builder __builder) {
      bucketmove = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder bucketmove(java.util.function.Consumer<Bucketmove.Builder> __func) {
      Bucketmove.Builder __inner = new Bucketmove.Builder();
      __func.accept(__inner);
      bucketmove = __inner;
      return this;
    }

    public Builder maxvisibilitydelay(double __value) {
      maxvisibilitydelay = __value;
      return this;
    }

    private Builder maxvisibilitydelay(String __value) {
      return maxvisibilitydelay(Double.valueOf(__value));
    }

    public Builder visit(Visit.Builder __builder) {
      visit = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder visit(java.util.function.Consumer<Visit.Builder> __func) {
      Visit.Builder __inner = new Visit.Builder();
      __func.accept(__inner);
      visit = __inner;
      return this;
    }

    public Builder initialize(Initialize.Builder __builder) {
      initialize = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder initialize(java.util.function.Consumer<Initialize.Builder> __func) {
      Initialize.Builder __inner = new Initialize.Builder();
      __func.accept(__inner);
      initialize = __inner;
      return this;
    }

    public Builder writefilter(Writefilter.Builder __builder) {
      writefilter = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder writefilter(java.util.function.Consumer<Writefilter.Builder> __func) {
      Writefilter.Builder __inner = new Writefilter.Builder();
      __func.accept(__inner);
      writefilter = __inner;
      return this;
    }

    public Builder hwinfo(Hwinfo.Builder __builder) {
      hwinfo = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder hwinfo(java.util.function.Consumer<Hwinfo.Builder> __func) {
      Hwinfo.Builder __inner = new Hwinfo.Builder();
      __func.accept(__inner);
      hwinfo = __inner;
      return this;
    }

    public Builder feeding(Feeding.Builder __builder) {
      feeding = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder feeding(java.util.function.Consumer<Feeding.Builder> __func) {
      Feeding.Builder __inner = new Feeding.Builder();
      __func.accept(__inner);
      feeding = __inner;
      return this;
    }

    public Builder maintenancejobs(Maintenancejobs.Builder __builder) {
      maintenancejobs = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder maintenancejobs(java.util.function.Consumer<Maintenancejobs.Builder> __func) {
      Maintenancejobs.Builder __inner = new Maintenancejobs.Builder();
      __func.accept(__inner);
      maintenancejobs = __inner;
      return this;
    }

    public Builder bucketdb(Bucketdb.Builder __builder) {
      bucketdb = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder bucketdb(java.util.function.Consumer<Bucketdb.Builder> __func) {
      Bucketdb.Builder __inner = new Bucketdb.Builder();
      __func.accept(__inner);
      bucketdb = __inner;
      return this;
    }

    public Builder replay_throttling_policy(Replay_throttling_policy.Builder __builder) {
      replay_throttling_policy = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder replay_throttling_policy(java.util.function.Consumer<Replay_throttling_policy.Builder> __func) {
      Replay_throttling_policy.Builder __inner = new Replay_throttling_policy.Builder();
      __func.accept(__inner);
      replay_throttling_policy = __inner;
      return this;
    }

    public Builder tensor_implementation(Tensor_implementation.Enum __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      tensor_implementation = __value;
      return this;
    }

    private Builder tensor_implementation(String __value) {
      return tensor_implementation(Tensor_implementation.Enum.valueOf(__value));
    }

    public Builder forward_issues(boolean __value) {
      forward_issues = __value;
      return this;
    }

    private Builder forward_issues(String __value) {
      return forward_issues(Boolean.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ProtonConfig build() {
      return new ProtonConfig(this);
    }

  }

  // Base directory. The default is ignored as it is assigned by the model
  private final StringNode basedir;
  // Port to use for the rpcserver.
  private final IntegerNode rpcport;
  // Port to use for the web server
  private final IntegerNode httpport;
  // Cluster name
  private final StringNode clustername;
  // Distribution key
  private final IntegerNode distributionkey;
  private final Rpc rpc;
  private final Search search;
  private final Docsum docsum;
  // Num searcher threads
  private final IntegerNode numsearcherthreads;
  // Number of threads used per search
  private final IntegerNode numthreadspersearch;
  // Num summary threads
  private final IntegerNode numsummarythreads;
  // Perform extra validation of stored data on startup
  // It requires a restart to enable, but no restart to disable.
  // Hence it must always be followed by a manual restart when enabled.
  private final Validate_and_sanitize_docstore validate_and_sanitize_docstore;
  private final Flush flush;
  private final Indexing indexing;
  private final Index index;
  private final Attribute attribute;
  private final Grouping grouping;
  private final Distribution distribution;
  private final Summary summary;
  private final InnerNodeVector<Documentdb> documentdb;
  private final Periodic periodic;
  // Connect spec for transactionlog server.
  // TODO Consider not using RPC at all
  private final StringNode tlsspec;
  // ConfigId for transactionlogserver
  private final StringNode tlsconfigid;
  // Slobrok configid
  private final StringNode slobrokconfigid;
  // Routing configid
  private final StringNode routingconfigid;
  private final Filedistributor filedistributor;
  // Interval between pruning of old removed documents.
  //  
  // If set to 0 (default) the value is calculated as (pruneremoveddocumentsage / 100) (default 3.36 hours).
  private final DoubleNode pruneremoveddocumentsinterval;
  // Age of removed document before it can be pruned.
  //  
  // Default value is 2 weeks (1209600 seconds).
  private final DoubleNode pruneremoveddocumentsage;
  // Minimum size of packets to compress (0 means no compression)
  //  
  private final IntegerNode packetcompresslimit;
  // Compression level for packets
  //  
  // Default value is 3
  private final IntegerNode packetcompresslevel;
  // Compression type for packets
  //  
  // Default is LZ4
  private final Packetcompresstype packetcompresstype;
  private final Lidspacecompaction lidspacecompaction;
  private final Bucketmove bucketmove;
  // This is the maximum value visibilitydelay you can have.
  // A to higher value here will cost more memory while not improving too much.
  private final DoubleNode maxvisibilitydelay;
  private final Visit visit;
  private final Initialize initialize;
  private final Writefilter writefilter;
  private final Hwinfo hwinfo;
  private final Feeding feeding;
  private final Maintenancejobs maintenancejobs;
  private final Bucketdb bucketdb;
  private final Replay_throttling_policy replay_throttling_policy;
  // Specifies which tensor implementation to use for all backend code.
  //  
  // TENSOR_ENGINE (default) uses DefaultTensorEngine, which has been the production implementation for years.
  // FAST_VALUE uses the new and optimized FastValueBuilderFactory instead.
  // TODO: Remove when default has been switched to FAST_VALUE.
  private final Tensor_implementation tensor_implementation;
  // Whether to report issues back to the container via protobuf field
  // TODO Remove always on
  private final BooleanNode forward_issues;

  public ProtonConfig(Builder builder) {
    this(builder, true);
  }

  private ProtonConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "proton must be initialized: " + builder.__uninitialized);

    basedir = (builder.basedir == null) ?
        new StringNode(".") : new StringNode(builder.basedir);
    rpcport = (builder.rpcport == null) ?
        new IntegerNode(8004) : new IntegerNode(builder.rpcport);
    httpport = (builder.httpport == null) ?
        new IntegerNode(0) : new IntegerNode(builder.httpport);
    clustername = (builder.clustername == null) ?
        new StringNode("") : new StringNode(builder.clustername);
    distributionkey = (builder.distributionkey == null) ?
        new IntegerNode(-1) : new IntegerNode(builder.distributionkey);
    rpc = new Rpc(builder.rpc, throwIfUninitialized);
    search = new Search(builder.search, throwIfUninitialized);
    docsum = new Docsum(builder.docsum, throwIfUninitialized);
    numsearcherthreads = (builder.numsearcherthreads == null) ?
        new IntegerNode(64) : new IntegerNode(builder.numsearcherthreads);
    numthreadspersearch = (builder.numthreadspersearch == null) ?
        new IntegerNode(1) : new IntegerNode(builder.numthreadspersearch);
    numsummarythreads = (builder.numsummarythreads == null) ?
        new IntegerNode(16) : new IntegerNode(builder.numsummarythreads);
    validate_and_sanitize_docstore = (builder.validate_and_sanitize_docstore == null) ?
        new Validate_and_sanitize_docstore(Validate_and_sanitize_docstore.NO) : new Validate_and_sanitize_docstore(builder.validate_and_sanitize_docstore);
    flush = new Flush(builder.flush, throwIfUninitialized);
    indexing = new Indexing(builder.indexing, throwIfUninitialized);
    index = new Index(builder.index, throwIfUninitialized);
    attribute = new Attribute(builder.attribute, throwIfUninitialized);
    grouping = new Grouping(builder.grouping, throwIfUninitialized);
    distribution = new Distribution(builder.distribution, throwIfUninitialized);
    summary = new Summary(builder.summary, throwIfUninitialized);
    documentdb = Documentdb.createVector(builder.documentdb);
    periodic = new Periodic(builder.periodic, throwIfUninitialized);
    tlsspec = (builder.tlsspec == null) ?
        new StringNode("tcp/localhost:13700") : new StringNode(builder.tlsspec);
    tlsconfigid = (builder.tlsconfigid == null) ?
        new StringNode("") : new StringNode(builder.tlsconfigid);
    slobrokconfigid = (builder.slobrokconfigid == null) ?
        new StringNode("") : new StringNode(builder.slobrokconfigid);
    routingconfigid = (builder.routingconfigid == null) ?
        new StringNode("") : new StringNode(builder.routingconfigid);
    filedistributor = new Filedistributor(builder.filedistributor, throwIfUninitialized);
    pruneremoveddocumentsinterval = (builder.pruneremoveddocumentsinterval == null) ?
        new DoubleNode(0.0D) : new DoubleNode(builder.pruneremoveddocumentsinterval);
    pruneremoveddocumentsage = (builder.pruneremoveddocumentsage == null) ?
        new DoubleNode(1209600.0D) : new DoubleNode(builder.pruneremoveddocumentsage);
    packetcompresslimit = (builder.packetcompresslimit == null) ?
        new IntegerNode(1024) : new IntegerNode(builder.packetcompresslimit);
    packetcompresslevel = (builder.packetcompresslevel == null) ?
        new IntegerNode(3) : new IntegerNode(builder.packetcompresslevel);
    packetcompresstype = (builder.packetcompresstype == null) ?
        new Packetcompresstype(Packetcompresstype.LZ4) : new Packetcompresstype(builder.packetcompresstype);
    lidspacecompaction = new Lidspacecompaction(builder.lidspacecompaction, throwIfUninitialized);
    bucketmove = new Bucketmove(builder.bucketmove, throwIfUninitialized);
    maxvisibilitydelay = (builder.maxvisibilitydelay == null) ?
        new DoubleNode(1.0D) : new DoubleNode(builder.maxvisibilitydelay);
    visit = new Visit(builder.visit, throwIfUninitialized);
    initialize = new Initialize(builder.initialize, throwIfUninitialized);
    writefilter = new Writefilter(builder.writefilter, throwIfUninitialized);
    hwinfo = new Hwinfo(builder.hwinfo, throwIfUninitialized);
    feeding = new Feeding(builder.feeding, throwIfUninitialized);
    maintenancejobs = new Maintenancejobs(builder.maintenancejobs, throwIfUninitialized);
    bucketdb = new Bucketdb(builder.bucketdb, throwIfUninitialized);
    replay_throttling_policy = new Replay_throttling_policy(builder.replay_throttling_policy, throwIfUninitialized);
    tensor_implementation = (builder.tensor_implementation == null) ?
        new Tensor_implementation(Tensor_implementation.FAST_VALUE) : new Tensor_implementation(builder.tensor_implementation);
    forward_issues = (builder.forward_issues == null) ?
        new BooleanNode(true) : new BooleanNode(builder.forward_issues);
  }

  /**
   * @return proton.basedir
   */
  public String basedir() {
    return basedir.value();
  }

  /**
   * @return proton.rpcport
   */
  public int rpcport() {
    return rpcport.value();
  }

  /**
   * @return proton.httpport
   */
  public int httpport() {
    return httpport.value();
  }

  /**
   * @return proton.clustername
   */
  public String clustername() {
    return clustername.value();
  }

  /**
   * @return proton.distributionkey
   */
  public int distributionkey() {
    return distributionkey.value();
  }

  /**
   * @return proton.rpc
   */
  public Rpc rpc() {
    return rpc;
  }

  /**
   * @return proton.search
   */
  public Search search() {
    return search;
  }

  /**
   * @return proton.docsum
   */
  public Docsum docsum() {
    return docsum;
  }

  /**
   * @return proton.numsearcherthreads
   */
  public int numsearcherthreads() {
    return numsearcherthreads.value();
  }

  /**
   * @return proton.numthreadspersearch
   */
  public int numthreadspersearch() {
    return numthreadspersearch.value();
  }

  /**
   * @return proton.numsummarythreads
   */
  public int numsummarythreads() {
    return numsummarythreads.value();
  }

  /**
   * @return proton.validate_and_sanitize_docstore
   */
  public Validate_and_sanitize_docstore.Enum validate_and_sanitize_docstore() {
    return validate_and_sanitize_docstore.value();
  }

  /**
   * @return proton.flush
   */
  public Flush flush() {
    return flush;
  }

  /**
   * @return proton.indexing
   */
  public Indexing indexing() {
    return indexing;
  }

  /**
   * @return proton.index
   */
  public Index index() {
    return index;
  }

  /**
   * @return proton.attribute
   */
  public Attribute attribute() {
    return attribute;
  }

  /**
   * @return proton.grouping
   */
  public Grouping grouping() {
    return grouping;
  }

  /**
   * @return proton.distribution
   */
  public Distribution distribution() {
    return distribution;
  }

  /**
   * @return proton.summary
   */
  public Summary summary() {
    return summary;
  }

  /**
   * @return proton.documentdb[]
   */
  public List<Documentdb> documentdb() {
    return documentdb;
  }

  /**
   * @param i the index of the value to return
   * @return proton.documentdb[]
   */
  public Documentdb documentdb(int i) {
    return documentdb.get(i);
  }

  /**
   * @return proton.periodic
   */
  public Periodic periodic() {
    return periodic;
  }

  /**
   * @return proton.tlsspec
   */
  public String tlsspec() {
    return tlsspec.value();
  }

  /**
   * @return proton.tlsconfigid
   */
  public String tlsconfigid() {
    return tlsconfigid.value();
  }

  /**
   * @return proton.slobrokconfigid
   */
  public String slobrokconfigid() {
    return slobrokconfigid.value();
  }

  /**
   * @return proton.routingconfigid
   */
  public String routingconfigid() {
    return routingconfigid.value();
  }

  /**
   * @return proton.filedistributor
   */
  public Filedistributor filedistributor() {
    return filedistributor;
  }

  /**
   * @return proton.pruneremoveddocumentsinterval
   */
  public double pruneremoveddocumentsinterval() {
    return pruneremoveddocumentsinterval.value();
  }

  /**
   * @return proton.pruneremoveddocumentsage
   */
  public double pruneremoveddocumentsage() {
    return pruneremoveddocumentsage.value();
  }

  /**
   * @return proton.packetcompresslimit
   */
  public int packetcompresslimit() {
    return packetcompresslimit.value();
  }

  /**
   * @return proton.packetcompresslevel
   */
  public int packetcompresslevel() {
    return packetcompresslevel.value();
  }

  /**
   * @return proton.packetcompresstype
   */
  public Packetcompresstype.Enum packetcompresstype() {
    return packetcompresstype.value();
  }

  /**
   * @return proton.lidspacecompaction
   */
  public Lidspacecompaction lidspacecompaction() {
    return lidspacecompaction;
  }

  /**
   * @return proton.bucketmove
   */
  public Bucketmove bucketmove() {
    return bucketmove;
  }

  /**
   * @return proton.maxvisibilitydelay
   */
  public double maxvisibilitydelay() {
    return maxvisibilitydelay.value();
  }

  /**
   * @return proton.visit
   */
  public Visit visit() {
    return visit;
  }

  /**
   * @return proton.initialize
   */
  public Initialize initialize() {
    return initialize;
  }

  /**
   * @return proton.writefilter
   */
  public Writefilter writefilter() {
    return writefilter;
  }

  /**
   * @return proton.hwinfo
   */
  public Hwinfo hwinfo() {
    return hwinfo;
  }

  /**
   * @return proton.feeding
   */
  public Feeding feeding() {
    return feeding;
  }

  /**
   * @return proton.maintenancejobs
   */
  public Maintenancejobs maintenancejobs() {
    return maintenancejobs;
  }

  /**
   * @return proton.bucketdb
   */
  public Bucketdb bucketdb() {
    return bucketdb;
  }

  /**
   * @return proton.replay_throttling_policy
   */
  public Replay_throttling_policy replay_throttling_policy() {
    return replay_throttling_policy;
  }

  /**
   * @return proton.tensor_implementation
   */
  public Tensor_implementation.Enum tensor_implementation() {
    return tensor_implementation.value();
  }

  /**
   * @return proton.forward_issues
   */
  public boolean forward_issues() {
    return forward_issues.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ProtonConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("proton");
      changes.compare(this.basedir, newConfig.basedir, "basedir", "Base directory. The default is ignored as it is assigned by the model");
      changes.compare(this.rpcport, newConfig.rpcport, "rpcport", "Port to use for the rpcserver.");
      changes.compare(this.httpport, newConfig.httpport, "httpport", "Port to use for the web server");
      changes.compare(this.clustername, newConfig.clustername, "clustername", "Cluster name");
      changes.mergeChanges("rpc", this.rpc.getChangesRequiringRestart(newConfig.rpc));
      changes.mergeChanges("search", this.search.getChangesRequiringRestart(newConfig.search));
      changes.compare(this.numsearcherthreads, newConfig.numsearcherthreads, "numsearcherthreads", "Num searcher threads");
      changes.compare(this.numthreadspersearch, newConfig.numthreadspersearch, "numthreadspersearch", "Number of threads used per search");
      changes.compare(this.numsummarythreads, newConfig.numsummarythreads, "numsummarythreads", "Num summary threads");
      changes.mergeChanges("flush", this.flush.getChangesRequiringRestart(newConfig.flush));
      changes.mergeChanges("indexing", this.indexing.getChangesRequiringRestart(newConfig.indexing));
      changes.mergeChanges("index", this.index.getChangesRequiringRestart(newConfig.index));
      changes.mergeChanges("attribute", this.attribute.getChangesRequiringRestart(newConfig.attribute));
      changes.mergeChanges("grouping", this.grouping.getChangesRequiringRestart(newConfig.grouping));
      changes.mergeChanges("summary", this.summary.getChangesRequiringRestart(newConfig.summary));
      changes.compare(this.tlsspec, newConfig.tlsspec, "tlsspec", "Connect spec for transactionlog server.\nTODO Consider not using RPC at all");
      changes.compare(this.tlsconfigid, newConfig.tlsconfigid, "tlsconfigid", "ConfigId for transactionlogserver");
      changes.compare(this.slobrokconfigid, newConfig.slobrokconfigid, "slobrokconfigid", "Slobrok configid");
      changes.compare(this.routingconfigid, newConfig.routingconfigid, "routingconfigid", "Routing configid");
      changes.mergeChanges("filedistributor", this.filedistributor.getChangesRequiringRestart(newConfig.filedistributor));
      changes.mergeChanges("hwinfo", this.hwinfo.getChangesRequiringRestart(newConfig.hwinfo));
      changes.mergeChanges("feeding", this.feeding.getChangesRequiringRestart(newConfig.feeding));
      changes.mergeChanges("bucketdb", this.bucketdb.getChangesRequiringRestart(newConfig.bucketdb));
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return true;
  }

  /**
   * This class represents proton.rpc
   */
  public final static class Rpc extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Integer transportthreads = null;

      public Builder() { }

      public Builder(Rpc config) {
        transportthreads(config.transportthreads());
      }

      private Builder override(Builder __superior) {
        if (__superior.transportthreads != null)
          transportthreads(__superior.transportthreads);
        return this;
      }

      public Builder transportthreads(int __value) {
        transportthreads = __value;
        return this;
      }

      private Builder transportthreads(String __value) {
        return transportthreads(Integer.valueOf(__value));
      }

      public Rpc build() {
        return new Rpc(this);
      }

    }

    // Number of threads used for rpc transport threads
    // A zero value will make the backend smart about the number.
    private final IntegerNode transportthreads;

    public Rpc(Builder builder) {
      this(builder, true);
    }

    private Rpc(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "proton.rpc must be initialized: " + builder.__uninitialized);

      transportthreads = (builder.transportthreads == null) ?
          new IntegerNode(0) : new IntegerNode(builder.transportthreads);
    }

    /**
     * @return proton.rpc.transportthreads
     */
    public int transportthreads() {
      return transportthreads.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Rpc newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("rpc");
        changes.compare(this.transportthreads, newConfig.transportthreads, "transportthreads", "Number of threads used for rpc transport threads\nA zero value will make the backend smart about the number.");
      return changes;
    }
  }

  /**
   * This class represents proton.search
   */
  public final static class Search extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Boolean async = null;
      private Io.Enum io = null;
      public Mmap.Builder mmap = new Mmap.Builder();
      public Memory.Builder memory = new Memory.Builder();

      public Builder() { }

      public Builder(Search config) {
        async(config.async());
        io(config.io());
        mmap(new Mmap.Builder(config.mmap()));
        memory(new Memory.Builder(config.memory()));
      }

      private Builder override(Builder __superior) {
        if (__superior.async != null)
          async(__superior.async);
        if (__superior.io != null)
          io(__superior.io);
        mmap(mmap.override(__superior.mmap));
        memory(memory.override(__superior.memory));
        return this;
      }

      public Builder async(boolean __value) {
        async = __value;
        return this;
      }

      private Builder async(String __value) {
        return async(Boolean.valueOf(__value));
      }

      public Builder io(Io.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        io = __value;
        return this;
      }

      private Builder io(String __value) {
        return io(Io.Enum.valueOf(__value));
      }

      public Builder mmap(Mmap.Builder __builder) {
        mmap = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder mmap(java.util.function.Consumer<Mmap.Builder> __func) {
        Mmap.Builder __inner = new Mmap.Builder();
        __func.accept(__inner);
        mmap = __inner;
        return this;
      }

      public Builder memory(Memory.Builder __builder) {
        memory = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder memory(java.util.function.Consumer<Memory.Builder> __func) {
        Memory.Builder __inner = new Memory.Builder();
        __func.accept(__inner);
        memory = __inner;
        return this;
      }

      public Search build() {
        return new Search(this);
      }

    }

    // Dispatch search requests to threadpool
    private final BooleanNode async;
    // Control options for io during search.
    // Dictionary is always MMAP.
    private final Io io;
    private final Mmap mmap;
    private final Memory memory;

    public Search(Builder builder) {
      this(builder, true);
    }

    private Search(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "proton.search must be initialized: " + builder.__uninitialized);

      async = (builder.async == null) ?
          new BooleanNode(true) : new BooleanNode(builder.async);
      io = (builder.io == null) ?
          new Io(Io.MMAP) : new Io(builder.io);
      mmap = new Mmap(builder.mmap, throwIfUninitialized);
      memory = new Memory(builder.memory, throwIfUninitialized);
    }

    /**
     * @return proton.search.async
     */
    public boolean async() {
      return async.value();
    }

    /**
     * @return proton.search.io
     */
    public Io.Enum io() {
      return io.value();
    }

    /**
     * @return proton.search.mmap
     */
    public Mmap mmap() {
      return mmap;
    }

    /**
     * @return proton.search.memory
     */
    public Memory memory() {
      return memory;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Search newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("search");
        changes.compare(this.io, newConfig.io, "io", "Control options for io during search.\nDictionary is always MMAP.");
        changes.mergeChanges("mmap", this.mmap.getChangesRequiringRestart(newConfig.mmap));
      return changes;
    }

    /**
     * This class represents proton.search.io
     * 
     * Control options for io during search.
     * Dictionary is always MMAP.
     */
    public final static class Io extends EnumNode<Io.Enum> {

      public Io(){
        this.value = null;
      }

      public Io(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {NORMAL, DIRECTIO, MMAP}
      public final static Enum NORMAL = Enum.NORMAL;
      public final static Enum DIRECTIO = Enum.DIRECTIO;
      public final static Enum MMAP = Enum.MMAP;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }

    /**
     * This class represents proton.search.mmap
     */
    public final static class Mmap extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        public List<Options.Enum> options = new ArrayList<>();
        private Advise.Enum advise = null;

        public Builder() { }

        public Builder(Mmap config) {
          options(config.options());
          advise(config.advise());
        }

        private Builder override(Builder __superior) {
          if (!__superior.options.isEmpty())
            options.addAll(__superior.options);
          if (__superior.advise != null)
            advise(__superior.advise);
          return this;
        }

        public Builder options(Options.Enum __value) {
          options.add(__value);
          return this;
        }

        public Builder options(Collection<Options.Enum> __values) {
          options.addAll(__values);
          return this;
        }

        private Builder options(String __value) {
          return options(Options.Enum.valueOf(__value));
        }

        public Builder advise(Advise.Enum __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          advise = __value;
          return this;
        }

        private Builder advise(String __value) {
          return advise(Advise.Enum.valueOf(__value));
        }

        public Mmap build() {
          return new Mmap(this);
        }

      }

      // Multiple optional options for use with mmap
      private final LeafNodeVector<Options.Enum, Options> options;
      // Advise to give to os when memory mapping disk index posting list files used for search.
      private final Advise advise;

      public Mmap(Builder builder) {
        this(builder, true);
      }

      private Mmap(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "proton.search.mmap must be initialized: " + builder.__uninitialized);

        options = new LeafNodeVector<>(builder.options, new Options());
        advise = (builder.advise == null) ?
            new Advise(Advise.SEQUENTIAL) : new Advise(builder.advise);
      }

      /**
       * @return proton.search.mmap.options[]
       */
      public List<Options.Enum> options() {
        return options.asList();
      }

      /**
       * @param i the index of the value to return
       * @return proton.search.mmap.options[]
       */
      public Options.Enum options(int i) {
        return options.get(i).value();
      }

      /**
       * @return proton.search.mmap.advise
       */
      public Advise.Enum advise() {
        return advise.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Mmap newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("mmap");
          changes.compareArray(this.options, newConfig.options, "options", "Multiple optional options for use with mmap",
                            (a,b) -> new ChangesRequiringRestart("options").compare(a,b,"","Multiple optional options for use with mmap"));
          changes.compare(this.advise, newConfig.advise, "advise", "Advise to give to os when memory mapping disk index posting list files used for search.");
        return changes;
      }

      /**
       * This class represents proton.search.mmap.options[]
       * 
       * Multiple optional options for use with mmap
       */
      public final static class Options extends EnumNode<Options.Enum> {

        public Options(){
          this.value = null;
        }

        public Options(Enum enumValue) {
          super(enumValue != null);
          this.value = enumValue;
        }

        public enum Enum {POPULATE, HUGETLB}
        public final static Enum POPULATE = Enum.POPULATE;
        public final static Enum HUGETLB = Enum.HUGETLB;

        @Override
        protected boolean doSetValue(String name) {
          try {
            value = Enum.valueOf(name);
            return true;
          } catch (IllegalArgumentException e) {
          }
          return false;
        }
      }

      /**
       * This class represents proton.search.mmap.advise
       * 
       * Advise to give to os when memory mapping disk index posting list files used for search.
       */
      public final static class Advise extends EnumNode<Advise.Enum> {

        public Advise(){
          this.value = null;
        }

        public Advise(Enum enumValue) {
          super(enumValue != null);
          this.value = enumValue;
        }

        public enum Enum {NORMAL, RANDOM, SEQUENTIAL}
        public final static Enum NORMAL = Enum.NORMAL;
        public final static Enum RANDOM = Enum.RANDOM;
        public final static Enum SEQUENTIAL = Enum.SEQUENTIAL;

        @Override
        protected boolean doSetValue(String name) {
          try {
            value = Enum.valueOf(name);
            return true;
          } catch (IllegalArgumentException e) {
          }
          return false;
        }
      }
    }

    /**
     * This class represents proton.search.memory
     */
    public final static class Memory extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        public Limiter.Builder limiter = new Limiter.Builder();

        public Builder() { }

        public Builder(Memory config) {
          limiter(new Limiter.Builder(config.limiter()));
        }

        private Builder override(Builder __superior) {
          limiter(limiter.override(__superior.limiter));
          return this;
        }

        public Builder limiter(Limiter.Builder __builder) {
          limiter = __builder;
          return this;
        }
        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder limiter(java.util.function.Consumer<Limiter.Builder> __func) {
          Limiter.Builder __inner = new Limiter.Builder();
          __func.accept(__inner);
          limiter = __inner;
          return this;
        }

        public Memory build() {
          return new Memory(this);
        }

      }

      private final Limiter limiter;

      public Memory(Builder builder) {
        this(builder, true);
      }

      private Memory(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "proton.search.memory must be initialized: " + builder.__uninitialized);

        limiter = new Limiter(builder.limiter, throwIfUninitialized);
      }

      /**
       * @return proton.search.memory.limiter
       */
      public Limiter limiter() {
        return limiter;
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Memory newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("memory");
        return changes;
      }

      /**
       * This class represents proton.search.memory.limiter
       */
      public final static class Limiter extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>();

          private Integer maxthreads = null;
          private Double mincoverage = null;
          private Integer minhits = null;

          public Builder() { }

          public Builder(Limiter config) {
            maxthreads(config.maxthreads());
            mincoverage(config.mincoverage());
            minhits(config.minhits());
          }

          private Builder override(Builder __superior) {
            if (__superior.maxthreads != null)
              maxthreads(__superior.maxthreads);
            if (__superior.mincoverage != null)
              mincoverage(__superior.mincoverage);
            if (__superior.minhits != null)
              minhits(__superior.minhits);
            return this;
          }

          public Builder maxthreads(int __value) {
            maxthreads = __value;
            return this;
          }

          private Builder maxthreads(String __value) {
            return maxthreads(Integer.valueOf(__value));
          }

          public Builder mincoverage(double __value) {
            mincoverage = __value;
            return this;
          }

          private Builder mincoverage(String __value) {
            return mincoverage(Double.valueOf(__value));
          }

          public Builder minhits(int __value) {
            minhits = __value;
            return this;
          }

          private Builder minhits(String __value) {
            return minhits(Integer.valueOf(__value));
          }

          public Limiter build() {
            return new Limiter(this);
          }

        }

        // Max number of threads allowed to handle large queries concurrently
        // Positive number means there is a limit, 0 or negative means no limit.
        // TODO Check if ever used in config.
        private final IntegerNode maxthreads;
        // Minimum coverage of corpus to postprocess before applying above concurrency limit.
        private final DoubleNode mincoverage;
        // Minimum number of hits to postprocess before applying above concurrency limit.
        // Both must be covered before applying limiter.
        private final IntegerNode minhits;

        public Limiter(Builder builder) {
          this(builder, true);
        }

        private Limiter(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "proton.search.memory.limiter must be initialized: " + builder.__uninitialized);

          maxthreads = (builder.maxthreads == null) ?
              new IntegerNode(0) : new IntegerNode(builder.maxthreads);
          mincoverage = (builder.mincoverage == null) ?
              new DoubleNode(1.0D) : new DoubleNode(builder.mincoverage);
          minhits = (builder.minhits == null) ?
              new IntegerNode(1000000) : new IntegerNode(builder.minhits);
        }

        /**
         * @return proton.search.memory.limiter.maxthreads
         */
        public int maxthreads() {
          return maxthreads.value();
        }

        /**
         * @return proton.search.memory.limiter.mincoverage
         */
        public double mincoverage() {
          return mincoverage.value();
        }

        /**
         * @return proton.search.memory.limiter.minhits
         */
        public int minhits() {
          return minhits.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Limiter newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("limiter");
          return changes;
        }
      }
    }
  }

  /**
   * This class represents proton.docsum
   */
  public final static class Docsum extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Boolean async = null;

      public Builder() { }

      public Builder(Docsum config) {
        async(config.async());
      }

      private Builder override(Builder __superior) {
        if (__superior.async != null)
          async(__superior.async);
        return this;
      }

      public Builder async(boolean __value) {
        async = __value;
        return this;
      }

      private Builder async(String __value) {
        return async(Boolean.valueOf(__value));
      }

      public Docsum build() {
        return new Docsum(this);
      }

    }

    // Dispatch docsum requests to threadpool
    private final BooleanNode async;

    public Docsum(Builder builder) {
      this(builder, true);
    }

    private Docsum(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "proton.docsum must be initialized: " + builder.__uninitialized);

      async = (builder.async == null) ?
          new BooleanNode(true) : new BooleanNode(builder.async);
    }

    /**
     * @return proton.docsum.async
     */
    public boolean async() {
      return async.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Docsum newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("docsum");
      return changes;
    }
  }

  /**
   * This class represents proton.validate_and_sanitize_docstore
   * 
   * Perform extra validation of stored data on startup
   * It requires a restart to enable, but no restart to disable.
   * Hence it must always be followed by a manual restart when enabled.
   */
  public final static class Validate_and_sanitize_docstore extends EnumNode<Validate_and_sanitize_docstore.Enum> {

    public Validate_and_sanitize_docstore(){
      this.value = null;
    }

    public Validate_and_sanitize_docstore(Enum enumValue) {
      super(enumValue != null);
      this.value = enumValue;
    }

    public enum Enum {NO, YES}
    public final static Enum NO = Enum.NO;
    public final static Enum YES = Enum.YES;

    @Override
    protected boolean doSetValue(String name) {
      try {
        value = Enum.valueOf(name);
        return true;
      } catch (IllegalArgumentException e) {
      }
      return false;
    }
  }

  /**
   * This class represents proton.flush
   */
  public final static class Flush extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Integer maxconcurrent = null;
      private Double idleinterval = null;
      private Strategy.Enum strategy = null;
      public Memory.Builder memory = new Memory.Builder();
      public Preparerestart.Builder preparerestart = new Preparerestart.Builder();

      public Builder() { }

      public Builder(Flush config) {
        maxconcurrent(config.maxconcurrent());
        idleinterval(config.idleinterval());
        strategy(config.strategy());
        memory(new Memory.Builder(config.memory()));
        preparerestart(new Preparerestart.Builder(config.preparerestart()));
      }

      private Builder override(Builder __superior) {
        if (__superior.maxconcurrent != null)
          maxconcurrent(__superior.maxconcurrent);
        if (__superior.idleinterval != null)
          idleinterval(__superior.idleinterval);
        if (__superior.strategy != null)
          strategy(__superior.strategy);
        memory(memory.override(__superior.memory));
        preparerestart(preparerestart.override(__superior.preparerestart));
        return this;
      }

      public Builder maxconcurrent(int __value) {
        maxconcurrent = __value;
        return this;
      }

      private Builder maxconcurrent(String __value) {
        return maxconcurrent(Integer.valueOf(__value));
      }

      public Builder idleinterval(double __value) {
        idleinterval = __value;
        return this;
      }

      private Builder idleinterval(String __value) {
        return idleinterval(Double.valueOf(__value));
      }

      public Builder strategy(Strategy.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        strategy = __value;
        return this;
      }

      private Builder strategy(String __value) {
        return strategy(Strategy.Enum.valueOf(__value));
      }

      public Builder memory(Memory.Builder __builder) {
        memory = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder memory(java.util.function.Consumer<Memory.Builder> __func) {
        Memory.Builder __inner = new Memory.Builder();
        __func.accept(__inner);
        memory = __inner;
        return this;
      }

      public Builder preparerestart(Preparerestart.Builder __builder) {
        preparerestart = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder preparerestart(java.util.function.Consumer<Preparerestart.Builder> __func) {
        Preparerestart.Builder __inner = new Preparerestart.Builder();
        __func.accept(__inner);
        preparerestart = __inner;
        return this;
      }

      public Flush build() {
        return new Flush(this);
      }

    }

    // Maximum number of concurrent flushes outstanding.
    private final IntegerNode maxconcurrent;
    // Number of seconds between checking for stuff to flush when the system is idling.
    private final DoubleNode idleinterval;
    // Which flushstrategy to use.
    private final Strategy strategy;
    private final Memory memory;
    private final Preparerestart preparerestart;

    public Flush(Builder builder) {
      this(builder, true);
    }

    private Flush(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "proton.flush must be initialized: " + builder.__uninitialized);

      maxconcurrent = (builder.maxconcurrent == null) ?
          new IntegerNode(2) : new IntegerNode(builder.maxconcurrent);
      idleinterval = (builder.idleinterval == null) ?
          new DoubleNode(10.0D) : new DoubleNode(builder.idleinterval);
      strategy = (builder.strategy == null) ?
          new Strategy(Strategy.MEMORY) : new Strategy(builder.strategy);
      memory = new Memory(builder.memory, throwIfUninitialized);
      preparerestart = new Preparerestart(builder.preparerestart, throwIfUninitialized);
    }

    /**
     * @return proton.flush.maxconcurrent
     */
    public int maxconcurrent() {
      return maxconcurrent.value();
    }

    /**
     * @return proton.flush.idleinterval
     */
    public double idleinterval() {
      return idleinterval.value();
    }

    /**
     * @return proton.flush.strategy
     */
    public Strategy.Enum strategy() {
      return strategy.value();
    }

    /**
     * @return proton.flush.memory
     */
    public Memory memory() {
      return memory;
    }

    /**
     * @return proton.flush.preparerestart
     */
    public Preparerestart preparerestart() {
      return preparerestart;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Flush newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("flush");
        changes.compare(this.maxconcurrent, newConfig.maxconcurrent, "maxconcurrent", "Maximum number of concurrent flushes outstanding.");
        changes.compare(this.idleinterval, newConfig.idleinterval, "idleinterval", "Number of seconds between checking for stuff to flush when the system is idling.");
        changes.compare(this.strategy, newConfig.strategy, "strategy", "Which flushstrategy to use.");
      return changes;
    }

    /**
     * This class represents proton.flush.strategy
     * 
     * Which flushstrategy to use.
     */
    public final static class Strategy extends EnumNode<Strategy.Enum> {

      public Strategy(){
        this.value = null;
      }

      public Strategy(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {SIMPLE, MEMORY}
      public final static Enum SIMPLE = Enum.SIMPLE;
      public final static Enum MEMORY = Enum.MEMORY;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }

    /**
     * This class represents proton.flush.memory
     */
    public final static class Memory extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Long maxmemory = null;
        private Double diskbloatfactor = null;
        private Long maxtlssize = null;
        public Each.Builder each = new Each.Builder();
        public Maxage.Builder maxage = new Maxage.Builder();
        public Conservative.Builder conservative = new Conservative.Builder();

        public Builder() { }

        public Builder(Memory config) {
          maxmemory(config.maxmemory());
          diskbloatfactor(config.diskbloatfactor());
          maxtlssize(config.maxtlssize());
          each(new Each.Builder(config.each()));
          maxage(new Maxage.Builder(config.maxage()));
          conservative(new Conservative.Builder(config.conservative()));
        }

        private Builder override(Builder __superior) {
          if (__superior.maxmemory != null)
            maxmemory(__superior.maxmemory);
          if (__superior.diskbloatfactor != null)
            diskbloatfactor(__superior.diskbloatfactor);
          if (__superior.maxtlssize != null)
            maxtlssize(__superior.maxtlssize);
          each(each.override(__superior.each));
          maxage(maxage.override(__superior.maxage));
          conservative(conservative.override(__superior.conservative));
          return this;
        }

        public Builder maxmemory(long __value) {
          maxmemory = __value;
          return this;
        }

        private Builder maxmemory(String __value) {
          return maxmemory(Long.valueOf(__value));
        }

        public Builder diskbloatfactor(double __value) {
          diskbloatfactor = __value;
          return this;
        }

        private Builder diskbloatfactor(String __value) {
          return diskbloatfactor(Double.valueOf(__value));
        }

        public Builder maxtlssize(long __value) {
          maxtlssize = __value;
          return this;
        }

        private Builder maxtlssize(String __value) {
          return maxtlssize(Long.valueOf(__value));
        }

        public Builder each(Each.Builder __builder) {
          each = __builder;
          return this;
        }
        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder each(java.util.function.Consumer<Each.Builder> __func) {
          Each.Builder __inner = new Each.Builder();
          __func.accept(__inner);
          each = __inner;
          return this;
        }

        public Builder maxage(Maxage.Builder __builder) {
          maxage = __builder;
          return this;
        }
        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder maxage(java.util.function.Consumer<Maxage.Builder> __func) {
          Maxage.Builder __inner = new Maxage.Builder();
          __func.accept(__inner);
          maxage = __inner;
          return this;
        }

        public Builder conservative(Conservative.Builder __builder) {
          conservative = __builder;
          return this;
        }
        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder conservative(java.util.function.Consumer<Conservative.Builder> __func) {
          Conservative.Builder __inner = new Conservative.Builder();
          __func.accept(__inner);
          conservative = __inner;
          return this;
        }

        public Memory build() {
          return new Memory(this);
        }

      }

      // The total maximum memory (in bytes) used by FLUSH components before running flush.
      // A FLUSH component will free memory when flushed (e.g. memory index).
      private final LongNode maxmemory;
      // Maximum total disk bloat factor before forcing flush.
      private final DoubleNode diskbloatfactor;
      // Max disk usage (in bytes) for all transaction logs before running flush.
      // In this case the oldest component is flushed such that transaction log can be pruned and disk freed.
      private final LongNode maxtlssize;
      private final Each each;
      private final Maxage maxage;
      private final Conservative conservative;

      public Memory(Builder builder) {
        this(builder, true);
      }

      private Memory(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "proton.flush.memory must be initialized: " + builder.__uninitialized);

        maxmemory = (builder.maxmemory == null) ?
            new LongNode(4294967296L) : new LongNode(builder.maxmemory);
        diskbloatfactor = (builder.diskbloatfactor == null) ?
            new DoubleNode(0.25D) : new DoubleNode(builder.diskbloatfactor);
        maxtlssize = (builder.maxtlssize == null) ?
            new LongNode(21474836480L) : new LongNode(builder.maxtlssize);
        each = new Each(builder.each, throwIfUninitialized);
        maxage = new Maxage(builder.maxage, throwIfUninitialized);
        conservative = new Conservative(builder.conservative, throwIfUninitialized);
      }

      /**
       * @return proton.flush.memory.maxmemory
       */
      public long maxmemory() {
        return maxmemory.value();
      }

      /**
       * @return proton.flush.memory.diskbloatfactor
       */
      public double diskbloatfactor() {
        return diskbloatfactor.value();
      }

      /**
       * @return proton.flush.memory.maxtlssize
       */
      public long maxtlssize() {
        return maxtlssize.value();
      }

      /**
       * @return proton.flush.memory.each
       */
      public Each each() {
        return each;
      }

      /**
       * @return proton.flush.memory.maxage
       */
      public Maxage maxage() {
        return maxage;
      }

      /**
       * @return proton.flush.memory.conservative
       */
      public Conservative conservative() {
        return conservative;
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Memory newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("memory");
        return changes;
      }

      /**
       * This class represents proton.flush.memory.each
       */
      public final static class Each extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>();

          private Long maxmemory = null;
          private Double diskbloatfactor = null;

          public Builder() { }

          public Builder(Each config) {
            maxmemory(config.maxmemory());
            diskbloatfactor(config.diskbloatfactor());
          }

          private Builder override(Builder __superior) {
            if (__superior.maxmemory != null)
              maxmemory(__superior.maxmemory);
            if (__superior.diskbloatfactor != null)
              diskbloatfactor(__superior.diskbloatfactor);
            return this;
          }

          public Builder maxmemory(long __value) {
            maxmemory = __value;
            return this;
          }

          private Builder maxmemory(String __value) {
            return maxmemory(Long.valueOf(__value));
          }

          public Builder diskbloatfactor(double __value) {
            diskbloatfactor = __value;
            return this;
          }

          private Builder diskbloatfactor(String __value) {
            return diskbloatfactor(Double.valueOf(__value));
          }

          public Each build() {
            return new Each(this);
          }

        }

        // The maximum memory (in bytes) used by a single FLUSH component before running flush.
        // A FLUSH component will free memory when flushed (e.g. memory index).
        private final LongNode maxmemory;
        // Maximum disk bloat factor per component before forcing flush.
        private final DoubleNode diskbloatfactor;

        public Each(Builder builder) {
          this(builder, true);
        }

        private Each(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "proton.flush.memory.each must be initialized: " + builder.__uninitialized);

          maxmemory = (builder.maxmemory == null) ?
              new LongNode(1073741824L) : new LongNode(builder.maxmemory);
          diskbloatfactor = (builder.diskbloatfactor == null) ?
              new DoubleNode(0.25D) : new DoubleNode(builder.diskbloatfactor);
        }

        /**
         * @return proton.flush.memory.each.maxmemory
         */
        public long maxmemory() {
          return maxmemory.value();
        }

        /**
         * @return proton.flush.memory.each.diskbloatfactor
         */
        public double diskbloatfactor() {
          return diskbloatfactor.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Each newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("each");
          return changes;
        }
      }

      /**
       * This class represents proton.flush.memory.maxage
       */
      public final static class Maxage extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>();

          private Double time = null;

          public Builder() { }

          public Builder(Maxage config) {
            time(config.time());
          }

          private Builder override(Builder __superior) {
            if (__superior.time != null)
              time(__superior.time);
            return this;
          }

          public Builder time(double __value) {
            time = __value;
            return this;
          }

          private Builder time(String __value) {
            return time(Double.valueOf(__value));
          }

          public Maxage build() {
            return new Maxage(this);
          }

        }

        // Age of unflushed content before forcing age prioritization.
        // Unit is seconds with 31 hours being the default.
        // 31 is selected as it is both a prime and (31-24=7) is a prime and hence it will
        // not be closer to a multiple of a day for a month, and it will be at least one hour away.
        private final DoubleNode time;

        public Maxage(Builder builder) {
          this(builder, true);
        }

        private Maxage(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "proton.flush.memory.maxage must be initialized: " + builder.__uninitialized);

          time = (builder.time == null) ?
              new DoubleNode(111600.0D) : new DoubleNode(builder.time);
        }

        /**
         * @return proton.flush.memory.maxage.time
         */
        public double time() {
          return time.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Maxage newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("maxage");
          return changes;
        }
      }

      /**
       * This class represents proton.flush.memory.conservative
       */
      public final static class Conservative extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>();

          private Double memorylimitfactor = null;
          private Double disklimitfactor = null;
          private Double highwatermarkfactor = null;
          private Double lowwatermarkfactor = null;

          public Builder() { }

          public Builder(Conservative config) {
            memorylimitfactor(config.memorylimitfactor());
            disklimitfactor(config.disklimitfactor());
            highwatermarkfactor(config.highwatermarkfactor());
            lowwatermarkfactor(config.lowwatermarkfactor());
          }

          private Builder override(Builder __superior) {
            if (__superior.memorylimitfactor != null)
              memorylimitfactor(__superior.memorylimitfactor);
            if (__superior.disklimitfactor != null)
              disklimitfactor(__superior.disklimitfactor);
            if (__superior.highwatermarkfactor != null)
              highwatermarkfactor(__superior.highwatermarkfactor);
            if (__superior.lowwatermarkfactor != null)
              lowwatermarkfactor(__superior.lowwatermarkfactor);
            return this;
          }

          public Builder memorylimitfactor(double __value) {
            memorylimitfactor = __value;
            return this;
          }

          private Builder memorylimitfactor(String __value) {
            return memorylimitfactor(Double.valueOf(__value));
          }

          public Builder disklimitfactor(double __value) {
            disklimitfactor = __value;
            return this;
          }

          private Builder disklimitfactor(String __value) {
            return disklimitfactor(Double.valueOf(__value));
          }

          public Builder highwatermarkfactor(double __value) {
            highwatermarkfactor = __value;
            return this;
          }

          private Builder highwatermarkfactor(String __value) {
            return highwatermarkfactor(Double.valueOf(__value));
          }

          public Builder lowwatermarkfactor(double __value) {
            lowwatermarkfactor = __value;
            return this;
          }

          private Builder lowwatermarkfactor(String __value) {
            return lowwatermarkfactor(Double.valueOf(__value));
          }

          public Conservative build() {
            return new Conservative(this);
          }

        }

        // When resource limit for memory is reached we choose a conservative mode for the flush strategy.
        // In this case this factor is multiplied with 'maxmemory' and 'each.maxmemory' to calculate conservative values to use instead.
        private final DoubleNode memorylimitfactor;
        // When resource limit for disk is reached we choose a conservative mode for the flush strategy.
        // In this case this factor is multiplied with 'maxtlssize' to calculate a conservative value to use instead.
        private final DoubleNode disklimitfactor;
        // The factor used to multiply with the resource limits for disk / memory to find the high
        // watermark indicating when to from normal into conservative mode for the flush strategy.
        private final DoubleNode highwatermarkfactor;
        // The factor used to multiply with the resource limits for disk / memory to find the low
        // watermark indicating when to go back from conservative to normal mode for the flush strategy.
        private final DoubleNode lowwatermarkfactor;

        public Conservative(Builder builder) {
          this(builder, true);
        }

        private Conservative(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "proton.flush.memory.conservative must be initialized: " + builder.__uninitialized);

          memorylimitfactor = (builder.memorylimitfactor == null) ?
              new DoubleNode(0.5D) : new DoubleNode(builder.memorylimitfactor);
          disklimitfactor = (builder.disklimitfactor == null) ?
              new DoubleNode(0.5D) : new DoubleNode(builder.disklimitfactor);
          highwatermarkfactor = (builder.highwatermarkfactor == null) ?
              new DoubleNode(0.95D) : new DoubleNode(builder.highwatermarkfactor);
          lowwatermarkfactor = (builder.lowwatermarkfactor == null) ?
              new DoubleNode(0.9D) : new DoubleNode(builder.lowwatermarkfactor);
        }

        /**
         * @return proton.flush.memory.conservative.memorylimitfactor
         */
        public double memorylimitfactor() {
          return memorylimitfactor.value();
        }

        /**
         * @return proton.flush.memory.conservative.disklimitfactor
         */
        public double disklimitfactor() {
          return disklimitfactor.value();
        }

        /**
         * @return proton.flush.memory.conservative.highwatermarkfactor
         */
        public double highwatermarkfactor() {
          return highwatermarkfactor.value();
        }

        /**
         * @return proton.flush.memory.conservative.lowwatermarkfactor
         */
        public double lowwatermarkfactor() {
          return lowwatermarkfactor.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Conservative newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("conservative");
          return changes;
        }
      }
    }

    /**
     * This class represents proton.flush.preparerestart
     */
    public final static class Preparerestart extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Double replaycost = null;
        private Double replayoperationcost = null;
        private Double writecost = null;
        private Double readcost = null;

        public Builder() { }

        public Builder(Preparerestart config) {
          replaycost(config.replaycost());
          replayoperationcost(config.replayoperationcost());
          writecost(config.writecost());
          readcost(config.readcost());
        }

        private Builder override(Builder __superior) {
          if (__superior.replaycost != null)
            replaycost(__superior.replaycost);
          if (__superior.replayoperationcost != null)
            replayoperationcost(__superior.replayoperationcost);
          if (__superior.writecost != null)
            writecost(__superior.writecost);
          if (__superior.readcost != null)
            readcost(__superior.readcost);
          return this;
        }

        public Builder replaycost(double __value) {
          replaycost = __value;
          return this;
        }

        private Builder replaycost(String __value) {
          return replaycost(Double.valueOf(__value));
        }

        public Builder replayoperationcost(double __value) {
          replayoperationcost = __value;
          return this;
        }

        private Builder replayoperationcost(String __value) {
          return replayoperationcost(Double.valueOf(__value));
        }

        public Builder writecost(double __value) {
          writecost = __value;
          return this;
        }

        private Builder writecost(String __value) {
          return writecost(Double.valueOf(__value));
        }

        public Builder readcost(double __value) {
          readcost = __value;
          return this;
        }

        private Builder readcost(String __value) {
          return readcost(Double.valueOf(__value));
        }

        public Preparerestart build() {
          return new Preparerestart(this);
        }

      }

      // The cost of replaying a byte when replaying the transaction log.
      //  
      // The estimate of the total cost of replaying the transaction log:
      // (number of bytes to replay) * replaycost + (number of operations to replay) * replayoperationcost
      //  
      // The prepare for restart flush strategy will choose a set of components to flush
      // such that the cost of flushing these + the cost of replaying the transaction log
      // is as low as possible.
      private final DoubleNode replaycost;
      // The cost of replaying an operation when replaying the transaction log.
      //  
      // The estimate of the total cost of replaying the transaction log:
      // (number of bytes to replay) * replaycost + (number of operations to replay) * replayoperationcost
      //  
      // The default value is chosen based on the following example:
      // Assume we can replay 9 MB/s and this corresponds to 24000 ops/s.
      // replayoperationcost = (bytes to replay) * replaycost / (operations to replay) = 9 MB * 8.0 / 24000 = 3000
      //  
      // The prepare for restart flush strategy will choose a set of components to flush
      // such that the cost of flushing these + the cost of replaying the transaction log
      // is as low as possible.
      private final DoubleNode replayoperationcost;
      // The cost of writing a byte when flushing components to disk.
      //  
      // The number of bytes to write (for a set of flushed components) * writecost
      // gives an estimate of the write cost of flushing this set of components.
      //  
      // The prepare for restart flush strategy will choose a set of components to flush
      // such that the cost of flushing these + the cost of replaying the transaction log
      // is as low as possible.
      private final DoubleNode writecost;
      // The cost of reading a byte when flushing components to disk.
      //  
      // The number of bytes to read (for a set of flushed components) * readcost
      // gives an estimate of the read cost of flushing this set of components.
      //  
      // Components that only read from memory will return 0 for the number of
      // bytes to read, currently only paged attributes will have a nonzero
      // read cost.
      private final DoubleNode readcost;

      public Preparerestart(Builder builder) {
        this(builder, true);
      }

      private Preparerestart(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "proton.flush.preparerestart must be initialized: " + builder.__uninitialized);

        replaycost = (builder.replaycost == null) ?
            new DoubleNode(8.0D) : new DoubleNode(builder.replaycost);
        replayoperationcost = (builder.replayoperationcost == null) ?
            new DoubleNode(3000.0D) : new DoubleNode(builder.replayoperationcost);
        writecost = (builder.writecost == null) ?
            new DoubleNode(1.0D) : new DoubleNode(builder.writecost);
        readcost = (builder.readcost == null) ?
            new DoubleNode(1.0D) : new DoubleNode(builder.readcost);
      }

      /**
       * @return proton.flush.preparerestart.replaycost
       */
      public double replaycost() {
        return replaycost.value();
      }

      /**
       * @return proton.flush.preparerestart.replayoperationcost
       */
      public double replayoperationcost() {
        return replayoperationcost.value();
      }

      /**
       * @return proton.flush.preparerestart.writecost
       */
      public double writecost() {
        return writecost.value();
      }

      /**
       * @return proton.flush.preparerestart.readcost
       */
      public double readcost() {
        return readcost.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Preparerestart newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("preparerestart");
        return changes;
      }
    }
  }

  /**
   * This class represents proton.indexing
   */
  public final static class Indexing extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      public Write.Builder write = new Write.Builder();
      public Read.Builder read = new Read.Builder();
      private Optimize.Enum optimize = null;
      private Integer tasklimit = null;
      private Integer kind_of_watermark = null;
      private Double reactiontime = null;
      private Integer semiunboundtasklimit = null;
      private Integer threads = null;

      public Builder() { }

      public Builder(Indexing config) {
        write(new Write.Builder(config.write()));
        read(new Read.Builder(config.read()));
        optimize(config.optimize());
        tasklimit(config.tasklimit());
        kind_of_watermark(config.kind_of_watermark());
        reactiontime(config.reactiontime());
        semiunboundtasklimit(config.semiunboundtasklimit());
        threads(config.threads());
      }

      private Builder override(Builder __superior) {
        write(write.override(__superior.write));
        read(read.override(__superior.read));
        if (__superior.optimize != null)
          optimize(__superior.optimize);
        if (__superior.tasklimit != null)
          tasklimit(__superior.tasklimit);
        if (__superior.kind_of_watermark != null)
          kind_of_watermark(__superior.kind_of_watermark);
        if (__superior.reactiontime != null)
          reactiontime(__superior.reactiontime);
        if (__superior.semiunboundtasklimit != null)
          semiunboundtasklimit(__superior.semiunboundtasklimit);
        if (__superior.threads != null)
          threads(__superior.threads);
        return this;
      }

      public Builder write(Write.Builder __builder) {
        write = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder write(java.util.function.Consumer<Write.Builder> __func) {
        Write.Builder __inner = new Write.Builder();
        __func.accept(__inner);
        write = __inner;
        return this;
      }

      public Builder read(Read.Builder __builder) {
        read = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder read(java.util.function.Consumer<Read.Builder> __func) {
        Read.Builder __inner = new Read.Builder();
        __func.accept(__inner);
        read = __inner;
        return this;
      }

      public Builder optimize(Optimize.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        optimize = __value;
        return this;
      }

      private Builder optimize(String __value) {
        return optimize(Optimize.Enum.valueOf(__value));
      }

      public Builder tasklimit(int __value) {
        tasklimit = __value;
        return this;
      }

      private Builder tasklimit(String __value) {
        return tasklimit(Integer.valueOf(__value));
      }

      public Builder kind_of_watermark(int __value) {
        kind_of_watermark = __value;
        return this;
      }

      private Builder kind_of_watermark(String __value) {
        return kind_of_watermark(Integer.valueOf(__value));
      }

      public Builder reactiontime(double __value) {
        reactiontime = __value;
        return this;
      }

      private Builder reactiontime(String __value) {
        return reactiontime(Double.valueOf(__value));
      }

      public Builder semiunboundtasklimit(int __value) {
        semiunboundtasklimit = __value;
        return this;
      }

      private Builder semiunboundtasklimit(String __value) {
        return semiunboundtasklimit(Integer.valueOf(__value));
      }

      public Builder threads(int __value) {
        threads = __value;
        return this;
      }

      private Builder threads(String __value) {
        return threads(Integer.valueOf(__value));
      }

      public Indexing build() {
        return new Indexing(this);
      }

    }

    private final Write write;
    private final Read read;
    // Option to specify what is most important during indexing.
    // This is experimental and will most likely be temporary.
    private final Optimize optimize;
    // Maximum number of pending operations for each of the internal
    // indexing threads. Only used when visibility delay is zero.
    private final IntegerNode tasklimit;
    // Kind of watermark for when to activate extra manpower
    // Utilized if optimize is set to either THROUGHPUT or ADAPTIVE
    private final IntegerNode kind_of_watermark;
    // Controls minimum reaction time in seconds if using THROUGHPUT
    private final DoubleNode reactiontime;
    // Everything below are deprecated and ignored. Will go away at any time.
    // Deprecated and ignored, will soon go away
    private final IntegerNode semiunboundtasklimit;
    // Overrides the number of threads used for writing fields across all document dbs.
    // See feeding.concurrency for details.
    // DEPRECATED - Remove usage
    private final IntegerNode threads;

    public Indexing(Builder builder) {
      this(builder, true);
    }

    private Indexing(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "proton.indexing must be initialized: " + builder.__uninitialized);

      write = new Write(builder.write, throwIfUninitialized);
      read = new Read(builder.read, throwIfUninitialized);
      optimize = (builder.optimize == null) ?
          new Optimize(Optimize.THROUGHPUT) : new Optimize(builder.optimize);
      tasklimit = (builder.tasklimit == null) ?
          new IntegerNode(-1000) : new IntegerNode(builder.tasklimit);
      kind_of_watermark = (builder.kind_of_watermark == null) ?
          new IntegerNode(0) : new IntegerNode(builder.kind_of_watermark);
      reactiontime = (builder.reactiontime == null) ?
          new DoubleNode(0.001D) : new DoubleNode(builder.reactiontime);
      semiunboundtasklimit = (builder.semiunboundtasklimit == null) ?
          new IntegerNode(1000) : new IntegerNode(builder.semiunboundtasklimit);
      threads = (builder.threads == null) ?
          new IntegerNode(1) : new IntegerNode(builder.threads);
    }

    /**
     * @return proton.indexing.write
     */
    public Write write() {
      return write;
    }

    /**
     * @return proton.indexing.read
     */
    public Read read() {
      return read;
    }

    /**
     * @return proton.indexing.optimize
     */
    public Optimize.Enum optimize() {
      return optimize.value();
    }

    /**
     * @return proton.indexing.tasklimit
     */
    public int tasklimit() {
      return tasklimit.value();
    }

    /**
     * @return proton.indexing.kind_of_watermark
     */
    public int kind_of_watermark() {
      return kind_of_watermark.value();
    }

    /**
     * @return proton.indexing.reactiontime
     */
    public double reactiontime() {
      return reactiontime.value();
    }

    /**
     * @return proton.indexing.semiunboundtasklimit
     */
    public int semiunboundtasklimit() {
      return semiunboundtasklimit.value();
    }

    /**
     * @return proton.indexing.threads
     */
    public int threads() {
      return threads.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Indexing newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("indexing");
        changes.mergeChanges("write", this.write.getChangesRequiringRestart(newConfig.write));
        changes.mergeChanges("read", this.read.getChangesRequiringRestart(newConfig.read));
        changes.compare(this.optimize, newConfig.optimize, "optimize", "Option to specify what is most important during indexing.\nThis is experimental and will most likely be temporary.");
        changes.compare(this.kind_of_watermark, newConfig.kind_of_watermark, "kind_of_watermark", "Kind of watermark for when to activate extra manpower\nUtilized if optimize is set to either THROUGHPUT or ADAPTIVE");
        changes.compare(this.reactiontime, newConfig.reactiontime, "reactiontime", "Controls minimum reaction time in seconds if using THROUGHPUT");
        changes.compare(this.threads, newConfig.threads, "threads", "Overrides the number of threads used for writing fields across all document dbs.\nSee feeding.concurrency for details.\nDEPRECATED - Remove usage");
      return changes;
    }

    /**
     * This class represents proton.indexing.write
     */
    public final static class Write extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Io.Enum io = null;

        public Builder() { }

        public Builder(Write config) {
          io(config.io());
        }

        private Builder override(Builder __superior) {
          if (__superior.io != null)
            io(__superior.io);
          return this;
        }

        public Builder io(Io.Enum __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          io = __value;
          return this;
        }

        private Builder io(String __value) {
          return io(Io.Enum.valueOf(__value));
        }

        public Write build() {
          return new Write(this);
        }

      }

      // Control io options during write both under dump and fusion.
      private final Io io;

      public Write(Builder builder) {
        this(builder, true);
      }

      private Write(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "proton.indexing.write must be initialized: " + builder.__uninitialized);

        io = (builder.io == null) ?
            new Io(Io.DIRECTIO) : new Io(builder.io);
      }

      /**
       * @return proton.indexing.write.io
       */
      public Io.Enum io() {
        return io.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Write newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("write");
          changes.compare(this.io, newConfig.io, "io", "Control io options during write both under dump and fusion.");
        return changes;
      }

      /**
       * This class represents proton.indexing.write.io
       * 
       * Control io options during write both under dump and fusion.
       */
      public final static class Io extends EnumNode<Io.Enum> {

        public Io(){
          this.value = null;
        }

        public Io(Enum enumValue) {
          super(enumValue != null);
          this.value = enumValue;
        }

        public enum Enum {NORMAL, OSYNC, DIRECTIO}
        public final static Enum NORMAL = Enum.NORMAL;
        public final static Enum OSYNC = Enum.OSYNC;
        public final static Enum DIRECTIO = Enum.DIRECTIO;

        @Override
        protected boolean doSetValue(String name) {
          try {
            value = Enum.valueOf(name);
            return true;
          } catch (IllegalArgumentException e) {
          }
          return false;
        }
      }
    }

    /**
     * This class represents proton.indexing.read
     */
    public final static class Read extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Io.Enum io = null;

        public Builder() { }

        public Builder(Read config) {
          io(config.io());
        }

        private Builder override(Builder __superior) {
          if (__superior.io != null)
            io(__superior.io);
          return this;
        }

        public Builder io(Io.Enum __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          io = __value;
          return this;
        }

        private Builder io(String __value) {
          return io(Io.Enum.valueOf(__value));
        }

        public Read build() {
          return new Read(this);
        }

      }

      // Control io options during read both under dump and fusion.
      private final Io io;

      public Read(Builder builder) {
        this(builder, true);
      }

      private Read(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "proton.indexing.read must be initialized: " + builder.__uninitialized);

        io = (builder.io == null) ?
            new Io(Io.DIRECTIO) : new Io(builder.io);
      }

      /**
       * @return proton.indexing.read.io
       */
      public Io.Enum io() {
        return io.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Read newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("read");
          changes.compare(this.io, newConfig.io, "io", "Control io options during read both under dump and fusion.");
        return changes;
      }

      /**
       * This class represents proton.indexing.read.io
       * 
       * Control io options during read both under dump and fusion.
       */
      public final static class Io extends EnumNode<Io.Enum> {

        public Io(){
          this.value = null;
        }

        public Io(Enum enumValue) {
          super(enumValue != null);
          this.value = enumValue;
        }

        public enum Enum {NORMAL, DIRECTIO}
        public final static Enum NORMAL = Enum.NORMAL;
        public final static Enum DIRECTIO = Enum.DIRECTIO;

        @Override
        protected boolean doSetValue(String name) {
          try {
            value = Enum.valueOf(name);
            return true;
          } catch (IllegalArgumentException e) {
          }
          return false;
        }
      }
    }

    /**
     * This class represents proton.indexing.optimize
     * 
     * Option to specify what is most important during indexing.
     * This is experimental and will most likely be temporary.
     */
    public final static class Optimize extends EnumNode<Optimize.Enum> {

      public Optimize(){
        this.value = null;
      }

      public Optimize(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {LATENCY, THROUGHPUT, ADAPTIVE}
      public final static Enum LATENCY = Enum.LATENCY;
      public final static Enum THROUGHPUT = Enum.THROUGHPUT;
      public final static Enum ADAPTIVE = Enum.ADAPTIVE;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }
  }

  /**
   * This class represents proton.index
   */
  public final static class Index extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      public Warmup.Builder warmup = new Warmup.Builder();
      private Integer maxflushed = null;
      private Integer maxflushedretired = null;
      public Cache.Builder cache = new Cache.Builder();

      public Builder() { }

      public Builder(Index config) {
        warmup(new Warmup.Builder(config.warmup()));
        maxflushed(config.maxflushed());
        maxflushedretired(config.maxflushedretired());
        cache(new Cache.Builder(config.cache()));
      }

      private Builder override(Builder __superior) {
        warmup(warmup.override(__superior.warmup));
        if (__superior.maxflushed != null)
          maxflushed(__superior.maxflushed);
        if (__superior.maxflushedretired != null)
          maxflushedretired(__superior.maxflushedretired);
        cache(cache.override(__superior.cache));
        return this;
      }

      public Builder warmup(Warmup.Builder __builder) {
        warmup = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder warmup(java.util.function.Consumer<Warmup.Builder> __func) {
        Warmup.Builder __inner = new Warmup.Builder();
        __func.accept(__inner);
        warmup = __inner;
        return this;
      }

      public Builder maxflushed(int __value) {
        maxflushed = __value;
        return this;
      }

      private Builder maxflushed(String __value) {
        return maxflushed(Integer.valueOf(__value));
      }

      public Builder maxflushedretired(int __value) {
        maxflushedretired = __value;
        return this;
      }

      private Builder maxflushedretired(String __value) {
        return maxflushedretired(Integer.valueOf(__value));
      }

      public Builder cache(Cache.Builder __builder) {
        cache = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder cache(java.util.function.Consumer<Cache.Builder> __func) {
        Cache.Builder __inner = new Cache.Builder();
        __func.accept(__inner);
        cache = __inner;
        return this;
      }

      public Index build() {
        return new Index(this);
      }

    }

    private final Warmup warmup;
    // How many flushed indexes there can be before fusion is forced while node is
    // not in retired state.
    // Setting to 1 will force an immediate fusion.
    private final IntegerNode maxflushed;
    // How many flushed indexes there can be before fusion is forced while node is
    // in retired state.
    // Setting to 1 will force an immediate fusion.
    private final IntegerNode maxflushedretired;
    private final Cache cache;

    public Index(Builder builder) {
      this(builder, true);
    }

    private Index(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "proton.index must be initialized: " + builder.__uninitialized);

      warmup = new Warmup(builder.warmup, throwIfUninitialized);
      maxflushed = (builder.maxflushed == null) ?
          new IntegerNode(2) : new IntegerNode(builder.maxflushed);
      maxflushedretired = (builder.maxflushedretired == null) ?
          new IntegerNode(20) : new IntegerNode(builder.maxflushedretired);
      cache = new Cache(builder.cache, throwIfUninitialized);
    }

    /**
     * @return proton.index.warmup
     */
    public Warmup warmup() {
      return warmup;
    }

    /**
     * @return proton.index.maxflushed
     */
    public int maxflushed() {
      return maxflushed.value();
    }

    /**
     * @return proton.index.maxflushedretired
     */
    public int maxflushedretired() {
      return maxflushedretired.value();
    }

    /**
     * @return proton.index.cache
     */
    public Cache cache() {
      return cache;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Index newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("index");
        changes.mergeChanges("warmup", this.warmup.getChangesRequiringRestart(newConfig.warmup));
        changes.mergeChanges("cache", this.cache.getChangesRequiringRestart(newConfig.cache));
      return changes;
    }

    /**
     * This class represents proton.index.warmup
     */
    public final static class Warmup extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Double time = null;
        private Boolean unpack = null;

        public Builder() { }

        public Builder(Warmup config) {
          time(config.time());
          unpack(config.unpack());
        }

        private Builder override(Builder __superior) {
          if (__superior.time != null)
            time(__superior.time);
          if (__superior.unpack != null)
            unpack(__superior.unpack);
          return this;
        }

        public Builder time(double __value) {
          time = __value;
          return this;
        }

        private Builder time(String __value) {
          return time(Double.valueOf(__value));
        }

        public Builder unpack(boolean __value) {
          unpack = __value;
          return this;
        }

        private Builder unpack(String __value) {
          return unpack(Boolean.valueOf(__value));
        }

        public Warmup build() {
          return new Warmup(this);
        }

      }

      // How long a freshly loaded index shall be warmed up
      // before being used for serving
      private final DoubleNode time;
      // Indicate if we also want warm up with full unpack, instead of only cheaper seek.
      private final BooleanNode unpack;

      public Warmup(Builder builder) {
        this(builder, true);
      }

      private Warmup(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "proton.index.warmup must be initialized: " + builder.__uninitialized);

        time = (builder.time == null) ?
            new DoubleNode(0.0D) : new DoubleNode(builder.time);
        unpack = (builder.unpack == null) ?
            new BooleanNode(false) : new BooleanNode(builder.unpack);
      }

      /**
       * @return proton.index.warmup.time
       */
      public double time() {
        return time.value();
      }

      /**
       * @return proton.index.warmup.unpack
       */
      public boolean unpack() {
        return unpack.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Warmup newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("warmup");
          changes.compare(this.time, newConfig.time, "time", "How long a freshly loaded index shall be warmed up\nbefore being used for serving");
          changes.compare(this.unpack, newConfig.unpack, "unpack", "Indicate if we also want warm up with full unpack, instead of only cheaper seek.");
        return changes;
      }
    }

    /**
     * This class represents proton.index.cache
     */
    public final static class Cache extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Long size = null;
        public Postinglist.Builder postinglist = new Postinglist.Builder();
        public Bitvector.Builder bitvector = new Bitvector.Builder();

        public Builder() { }

        public Builder(Cache config) {
          size(config.size());
          postinglist(new Postinglist.Builder(config.postinglist()));
          bitvector(new Bitvector.Builder(config.bitvector()));
        }

        private Builder override(Builder __superior) {
          if (__superior.size != null)
            size(__superior.size);
          postinglist(postinglist.override(__superior.postinglist));
          bitvector(bitvector.override(__superior.bitvector));
          return this;
        }

        public Builder size(long __value) {
          size = __value;
          return this;
        }

        private Builder size(String __value) {
          return size(Long.valueOf(__value));
        }

        public Builder postinglist(Postinglist.Builder __builder) {
          postinglist = __builder;
          return this;
        }
        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder postinglist(java.util.function.Consumer<Postinglist.Builder> __func) {
          Postinglist.Builder __inner = new Postinglist.Builder();
          __func.accept(__inner);
          postinglist = __inner;
          return this;
        }

        public Builder bitvector(Bitvector.Builder __builder) {
          bitvector = __builder;
          return this;
        }
        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder bitvector(java.util.function.Consumer<Bitvector.Builder> __func) {
          Bitvector.Builder __inner = new Bitvector.Builder();
          __func.accept(__inner);
          bitvector = __inner;
          return this;
        }

        public Cache build() {
          return new Cache(this);
        }

      }

      // How much memory is set aside for caching.
      // Now only used for caching of dictionary lookups.
      // DEPRECATED - Not used.
      private final LongNode size;
      private final Postinglist postinglist;
      private final Bitvector bitvector;

      public Cache(Builder builder) {
        this(builder, true);
      }

      private Cache(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "proton.index.cache must be initialized: " + builder.__uninitialized);

        size = (builder.size == null) ?
            new LongNode(0L) : new LongNode(builder.size);
        postinglist = new Postinglist(builder.postinglist, throwIfUninitialized);
        bitvector = new Bitvector(builder.bitvector, throwIfUninitialized);
      }

      /**
       * @return proton.index.cache.size
       */
      public long size() {
        return size.value();
      }

      /**
       * @return proton.index.cache.postinglist
       */
      public Postinglist postinglist() {
        return postinglist;
      }

      /**
       * @return proton.index.cache.bitvector
       */
      public Bitvector bitvector() {
        return bitvector;
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Cache newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("cache");
          changes.compare(this.size, newConfig.size, "size", "How much memory is set aside for caching.\nNow only used for caching of dictionary lookups.\nDEPRECATED - Not used.");
          changes.mergeChanges("postinglist", this.postinglist.getChangesRequiringRestart(newConfig.postinglist));
          changes.mergeChanges("bitvector", this.bitvector.getChangesRequiringRestart(newConfig.bitvector));
        return changes;
      }

      /**
       * This class represents proton.index.cache.postinglist
       */
      public final static class Postinglist extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>();

          private Long maxbytes = null;
          private Double slru_protected_segment_ratio = null;
          private Long lfu_sketch_max_element_count = null;

          public Builder() { }

          public Builder(Postinglist config) {
            maxbytes(config.maxbytes());
            slru_protected_segment_ratio(config.slru_protected_segment_ratio());
            lfu_sketch_max_element_count(config.lfu_sketch_max_element_count());
          }

          private Builder override(Builder __superior) {
            if (__superior.maxbytes != null)
              maxbytes(__superior.maxbytes);
            if (__superior.slru_protected_segment_ratio != null)
              slru_protected_segment_ratio(__superior.slru_protected_segment_ratio);
            if (__superior.lfu_sketch_max_element_count != null)
              lfu_sketch_max_element_count(__superior.lfu_sketch_max_element_count);
            return this;
          }

          public Builder maxbytes(long __value) {
            maxbytes = __value;
            return this;
          }

          private Builder maxbytes(String __value) {
            return maxbytes(Long.valueOf(__value));
          }

          public Builder slru_protected_segment_ratio(double __value) {
            slru_protected_segment_ratio = __value;
            return this;
          }

          private Builder slru_protected_segment_ratio(String __value) {
            return slru_protected_segment_ratio(Double.valueOf(__value));
          }

          public Builder lfu_sketch_max_element_count(long __value) {
            lfu_sketch_max_element_count = __value;
            return this;
          }

          private Builder lfu_sketch_max_element_count(String __value) {
            return lfu_sketch_max_element_count(Long.valueOf(__value));
          }

          public Postinglist build() {
            return new Postinglist(this);
          }

        }

        // Configure a shared disk index posting list cache across all document dbs.
        //  
        // Is by default turned off (maxbytes == 0).
        // The cache will not be used if search.io == MMAP.
        // A positive number specifies the max size of the cache in bytes.
        // A negative number specifies the max size of the cache as a percentage of total memory.
        private final LongNode maxbytes;
        // Configure a size ratio between the probationary and protected segment in
        // the posting list and bitvector caches. A value of zero means that segmented
        // (SLRU) behavior is entirely disabled, and the cache works as a regular
        // LRU. Any other value (0, 1] will scale the cache so that the protected
        // segment will receive `maxbytes` * ratio bytes, and the probationary segment
        // will receive `maxbytes` * (1 - ratio) bytes.
        //  
        // Note that it never makes sense with a ratio of 1, as elements must be able
        // to first enter the probationary segment before being allowed a promotion into
        // the protected segment.
        private final DoubleNode slru_protected_segment_ratio;
        // Configures the cache to use a LFU frequency sketch to estimate the frequency
        // of cacheable elements and to prevent less frequently accessed elements from
        // displacing more frequent ones.
        // The specified element count should be at least as high as the expected number
        // of elements the cache could contain (_not_ its size in bytes), as this has
        // direct impact on how accurate the (inherently probabilistic) frequency
        // estimates are.
        //  
        // Any value greater than 0 enables LFU semantics, 0 disables LFU (default).
        private final LongNode lfu_sketch_max_element_count;

        public Postinglist(Builder builder) {
          this(builder, true);
        }

        private Postinglist(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "proton.index.cache.postinglist must be initialized: " + builder.__uninitialized);

          maxbytes = (builder.maxbytes == null) ?
              new LongNode(0L) : new LongNode(builder.maxbytes);
          slru_protected_segment_ratio = (builder.slru_protected_segment_ratio == null) ?
              new DoubleNode(0.0D) : new DoubleNode(builder.slru_protected_segment_ratio);
          lfu_sketch_max_element_count = (builder.lfu_sketch_max_element_count == null) ?
              new LongNode(0L) : new LongNode(builder.lfu_sketch_max_element_count);
        }

        /**
         * @return proton.index.cache.postinglist.maxbytes
         */
        public long maxbytes() {
          return maxbytes.value();
        }

        /**
         * @return proton.index.cache.postinglist.slru_protected_segment_ratio
         */
        public double slru_protected_segment_ratio() {
          return slru_protected_segment_ratio.value();
        }

        /**
         * @return proton.index.cache.postinglist.lfu_sketch_max_element_count
         */
        public long lfu_sketch_max_element_count() {
          return lfu_sketch_max_element_count.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Postinglist newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("postinglist");
            changes.compare(this.maxbytes, newConfig.maxbytes, "maxbytes", "Configure a shared disk index posting list cache across all document dbs.\n \nIs by default turned off (maxbytes == 0).\nThe cache will not be used if search.io == MMAP.\nA positive number specifies the max size of the cache in bytes.\nA negative number specifies the max size of the cache as a percentage of total memory.");
            changes.compare(this.slru_protected_segment_ratio, newConfig.slru_protected_segment_ratio, "slru_protected_segment_ratio", "Configure a size ratio between the probationary and protected segment in\nthe posting list and bitvector caches. A value of zero means that segmented\n(SLRU) behavior is entirely disabled, and the cache works as a regular\nLRU. Any other value (0, 1] will scale the cache so that the protected\nsegment will receive `maxbytes` * ratio bytes, and the probationary segment\nwill receive `maxbytes` * (1 - ratio) bytes.\n \nNote that it never makes sense with a ratio of 1, as elements must be able\nto first enter the probationary segment before being allowed a promotion into\nthe protected segment.");
            changes.compare(this.lfu_sketch_max_element_count, newConfig.lfu_sketch_max_element_count, "lfu_sketch_max_element_count", "Configures the cache to use a LFU frequency sketch to estimate the frequency\nof cacheable elements and to prevent less frequently accessed elements from\ndisplacing more frequent ones.\nThe specified element count should be at least as high as the expected number\nof elements the cache could contain (_not_ its size in bytes), as this has\ndirect impact on how accurate the (inherently probabilistic) frequency\nestimates are.\n \nAny value greater than 0 enables LFU semantics, 0 disables LFU (default).");
          return changes;
        }
      }

      /**
       * This class represents proton.index.cache.bitvector
       */
      public final static class Bitvector extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>();

          private Long maxbytes = null;
          private Double slru_protected_segment_ratio = null;
          private Long lfu_sketch_max_element_count = null;

          public Builder() { }

          public Builder(Bitvector config) {
            maxbytes(config.maxbytes());
            slru_protected_segment_ratio(config.slru_protected_segment_ratio());
            lfu_sketch_max_element_count(config.lfu_sketch_max_element_count());
          }

          private Builder override(Builder __superior) {
            if (__superior.maxbytes != null)
              maxbytes(__superior.maxbytes);
            if (__superior.slru_protected_segment_ratio != null)
              slru_protected_segment_ratio(__superior.slru_protected_segment_ratio);
            if (__superior.lfu_sketch_max_element_count != null)
              lfu_sketch_max_element_count(__superior.lfu_sketch_max_element_count);
            return this;
          }

          public Builder maxbytes(long __value) {
            maxbytes = __value;
            return this;
          }

          private Builder maxbytes(String __value) {
            return maxbytes(Long.valueOf(__value));
          }

          public Builder slru_protected_segment_ratio(double __value) {
            slru_protected_segment_ratio = __value;
            return this;
          }

          private Builder slru_protected_segment_ratio(String __value) {
            return slru_protected_segment_ratio(Double.valueOf(__value));
          }

          public Builder lfu_sketch_max_element_count(long __value) {
            lfu_sketch_max_element_count = __value;
            return this;
          }

          private Builder lfu_sketch_max_element_count(String __value) {
            return lfu_sketch_max_element_count(Long.valueOf(__value));
          }

          public Bitvector build() {
            return new Bitvector(this);
          }

        }

        private final LongNode maxbytes;
        private final DoubleNode slru_protected_segment_ratio;
        private final LongNode lfu_sketch_max_element_count;

        public Bitvector(Builder builder) {
          this(builder, true);
        }

        private Bitvector(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "proton.index.cache.bitvector must be initialized: " + builder.__uninitialized);

          maxbytes = (builder.maxbytes == null) ?
              new LongNode(0L) : new LongNode(builder.maxbytes);
          slru_protected_segment_ratio = (builder.slru_protected_segment_ratio == null) ?
              new DoubleNode(0.0D) : new DoubleNode(builder.slru_protected_segment_ratio);
          lfu_sketch_max_element_count = (builder.lfu_sketch_max_element_count == null) ?
              new LongNode(0L) : new LongNode(builder.lfu_sketch_max_element_count);
        }

        /**
         * @return proton.index.cache.bitvector.maxbytes
         */
        public long maxbytes() {
          return maxbytes.value();
        }

        /**
         * @return proton.index.cache.bitvector.slru_protected_segment_ratio
         */
        public double slru_protected_segment_ratio() {
          return slru_protected_segment_ratio.value();
        }

        /**
         * @return proton.index.cache.bitvector.lfu_sketch_max_element_count
         */
        public long lfu_sketch_max_element_count() {
          return lfu_sketch_max_element_count.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Bitvector newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("bitvector");
            changes.compare(this.maxbytes, newConfig.maxbytes, "maxbytes", "");
            changes.compare(this.slru_protected_segment_ratio, newConfig.slru_protected_segment_ratio, "slru_protected_segment_ratio", "");
            changes.compare(this.lfu_sketch_max_element_count, newConfig.lfu_sketch_max_element_count, "lfu_sketch_max_element_count", "");
          return changes;
        }
      }
    }
  }

  /**
   * This class represents proton.attribute
   */
  public final static class Attribute extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      public Write.Builder write = new Write.Builder();

      public Builder() { }

      public Builder(Attribute config) {
        write(new Write.Builder(config.write()));
      }

      private Builder override(Builder __superior) {
        write(write.override(__superior.write));
        return this;
      }

      public Builder write(Write.Builder __builder) {
        write = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder write(java.util.function.Consumer<Write.Builder> __func) {
        Write.Builder __inner = new Write.Builder();
        __func.accept(__inner);
        write = __inner;
        return this;
      }

      public Attribute build() {
        return new Attribute(this);
      }

    }

    private final Write write;

    public Attribute(Builder builder) {
      this(builder, true);
    }

    private Attribute(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "proton.attribute must be initialized: " + builder.__uninitialized);

      write = new Write(builder.write, throwIfUninitialized);
    }

    /**
     * @return proton.attribute.write
     */
    public Write write() {
      return write;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Attribute newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("attribute");
        changes.mergeChanges("write", this.write.getChangesRequiringRestart(newConfig.write));
      return changes;
    }

    /**
     * This class represents proton.attribute.write
     */
    public final static class Write extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Io.Enum io = null;

        public Builder() { }

        public Builder(Write config) {
          io(config.io());
        }

        private Builder override(Builder __superior) {
          if (__superior.io != null)
            io(__superior.io);
          return this;
        }

        public Builder io(Io.Enum __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          io = __value;
          return this;
        }

        private Builder io(String __value) {
          return io(Io.Enum.valueOf(__value));
        }

        public Write build() {
          return new Write(this);
        }

      }

      // Control io options during flushing of attributes.
      private final Io io;

      public Write(Builder builder) {
        this(builder, true);
      }

      private Write(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "proton.attribute.write must be initialized: " + builder.__uninitialized);

        io = (builder.io == null) ?
            new Io(Io.DIRECTIO) : new Io(builder.io);
      }

      /**
       * @return proton.attribute.write.io
       */
      public Io.Enum io() {
        return io.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Write newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("write");
          changes.compare(this.io, newConfig.io, "io", "Control io options during flushing of attributes.");
        return changes;
      }

      /**
       * This class represents proton.attribute.write.io
       * 
       * Control io options during flushing of attributes.
       */
      public final static class Io extends EnumNode<Io.Enum> {

        public Io(){
          this.value = null;
        }

        public Io(Enum enumValue) {
          super(enumValue != null);
          this.value = enumValue;
        }

        public enum Enum {NORMAL, OSYNC, DIRECTIO}
        public final static Enum NORMAL = Enum.NORMAL;
        public final static Enum OSYNC = Enum.OSYNC;
        public final static Enum DIRECTIO = Enum.DIRECTIO;

        @Override
        protected boolean doSetValue(String name) {
          try {
            value = Enum.valueOf(name);
            return true;
          } catch (IllegalArgumentException e) {
          }
          return false;
        }
      }
    }
  }

  /**
   * This class represents proton.grouping
   */
  public final static class Grouping extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      public Sessionmanager.Builder sessionmanager = new Sessionmanager.Builder();

      public Builder() { }

      public Builder(Grouping config) {
        sessionmanager(new Sessionmanager.Builder(config.sessionmanager()));
      }

      private Builder override(Builder __superior) {
        sessionmanager(sessionmanager.override(__superior.sessionmanager));
        return this;
      }

      public Builder sessionmanager(Sessionmanager.Builder __builder) {
        sessionmanager = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder sessionmanager(java.util.function.Consumer<Sessionmanager.Builder> __func) {
        Sessionmanager.Builder __inner = new Sessionmanager.Builder();
        __func.accept(__inner);
        sessionmanager = __inner;
        return this;
      }

      public Grouping build() {
        return new Grouping(this);
      }

    }

    private final Sessionmanager sessionmanager;

    public Grouping(Builder builder) {
      this(builder, true);
    }

    private Grouping(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "proton.grouping must be initialized: " + builder.__uninitialized);

      sessionmanager = new Sessionmanager(builder.sessionmanager, throwIfUninitialized);
    }

    /**
     * @return proton.grouping.sessionmanager
     */
    public Sessionmanager sessionmanager() {
      return sessionmanager;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Grouping newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("grouping");
        changes.mergeChanges("sessionmanager", this.sessionmanager.getChangesRequiringRestart(newConfig.sessionmanager));
      return changes;
    }

    /**
     * This class represents proton.grouping.sessionmanager
     */
    public final static class Sessionmanager extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Integer maxentries = null;
        public Pruning.Builder pruning = new Pruning.Builder();

        public Builder() { }

        public Builder(Sessionmanager config) {
          maxentries(config.maxentries());
          pruning(new Pruning.Builder(config.pruning()));
        }

        private Builder override(Builder __superior) {
          if (__superior.maxentries != null)
            maxentries(__superior.maxentries);
          pruning(pruning.override(__superior.pruning));
          return this;
        }

        public Builder maxentries(int __value) {
          maxentries = __value;
          return this;
        }

        private Builder maxentries(String __value) {
          return maxentries(Integer.valueOf(__value));
        }

        public Builder pruning(Pruning.Builder __builder) {
          pruning = __builder;
          return this;
        }
        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder pruning(java.util.function.Consumer<Pruning.Builder> __func) {
          Pruning.Builder __inner = new Pruning.Builder();
          __func.accept(__inner);
          pruning = __inner;
          return this;
        }

        public Sessionmanager build() {
          return new Sessionmanager(this);
        }

      }

      // Control of grouping session manager entries
      private final IntegerNode maxentries;
      private final Pruning pruning;

      public Sessionmanager(Builder builder) {
        this(builder, true);
      }

      private Sessionmanager(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "proton.grouping.sessionmanager must be initialized: " + builder.__uninitialized);

        maxentries = (builder.maxentries == null) ?
            new IntegerNode(500) : new IntegerNode(builder.maxentries);
        pruning = new Pruning(builder.pruning, throwIfUninitialized);
      }

      /**
       * @return proton.grouping.sessionmanager.maxentries
       */
      public int maxentries() {
        return maxentries.value();
      }

      /**
       * @return proton.grouping.sessionmanager.pruning
       */
      public Pruning pruning() {
        return pruning;
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Sessionmanager newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("sessionmanager");
          changes.compare(this.maxentries, newConfig.maxentries, "maxentries", "Control of grouping session manager entries");
        return changes;
      }

      /**
       * This class represents proton.grouping.sessionmanager.pruning
       */
      public final static class Pruning extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>();

          private Double interval = null;

          public Builder() { }

          public Builder(Pruning config) {
            interval(config.interval());
          }

          private Builder override(Builder __superior) {
            if (__superior.interval != null)
              interval(__superior.interval);
            return this;
          }

          public Builder interval(double __value) {
            interval = __value;
            return this;
          }

          private Builder interval(String __value) {
            return interval(Double.valueOf(__value));
          }

          public Pruning build() {
            return new Pruning(this);
          }

        }

        // Control of pruning interval to remove sessions that have timed out
        private final DoubleNode interval;

        public Pruning(Builder builder) {
          this(builder, true);
        }

        private Pruning(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "proton.grouping.sessionmanager.pruning must be initialized: " + builder.__uninitialized);

          interval = (builder.interval == null) ?
              new DoubleNode(1.0D) : new DoubleNode(builder.interval);
        }

        /**
         * @return proton.grouping.sessionmanager.pruning.interval
         */
        public double interval() {
          return interval.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Pruning newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("pruning");
          return changes;
        }
      }
    }
  }

  /**
   * This class represents proton.distribution
   */
  public final static class Distribution extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Long redundancy = null;
      private Long searchablecopies = null;

      public Builder() { }

      public Builder(Distribution config) {
        redundancy(config.redundancy());
        searchablecopies(config.searchablecopies());
      }

      private Builder override(Builder __superior) {
        if (__superior.redundancy != null)
          redundancy(__superior.redundancy);
        if (__superior.searchablecopies != null)
          searchablecopies(__superior.searchablecopies);
        return this;
      }

      public Builder redundancy(long __value) {
        redundancy = __value;
        return this;
      }

      private Builder redundancy(String __value) {
        return redundancy(Long.valueOf(__value));
      }

      public Builder searchablecopies(long __value) {
        searchablecopies = __value;
        return this;
      }

      private Builder searchablecopies(String __value) {
        return searchablecopies(Long.valueOf(__value));
      }

      public Distribution build() {
        return new Distribution(this);
      }

    }

    // Redundancy of documents.
    private final LongNode redundancy;
    // Searchable copies of the documents.
    private final LongNode searchablecopies;

    public Distribution(Builder builder) {
      this(builder, true);
    }

    private Distribution(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "proton.distribution must be initialized: " + builder.__uninitialized);

      redundancy = (builder.redundancy == null) ?
          new LongNode(1L) : new LongNode(builder.redundancy);
      searchablecopies = (builder.searchablecopies == null) ?
          new LongNode(1L) : new LongNode(builder.searchablecopies);
    }

    /**
     * @return proton.distribution.redundancy
     */
    public long redundancy() {
      return redundancy.value();
    }

    /**
     * @return proton.distribution.searchablecopies
     */
    public long searchablecopies() {
      return searchablecopies.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Distribution newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("distribution");
      return changes;
    }
  }

  /**
   * This class represents proton.summary
   */
  public final static class Summary extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      public Cache.Builder cache = new Cache.Builder();
      public Log.Builder log = new Log.Builder();
      public Write.Builder write = new Write.Builder();
      public Read.Builder read = new Read.Builder();

      public Builder() { }

      public Builder(Summary config) {
        cache(new Cache.Builder(config.cache()));
        log(new Log.Builder(config.log()));
        write(new Write.Builder(config.write()));
        read(new Read.Builder(config.read()));
      }

      private Builder override(Builder __superior) {
        cache(cache.override(__superior.cache));
        log(log.override(__superior.log));
        write(write.override(__superior.write));
        read(read.override(__superior.read));
        return this;
      }

      public Builder cache(Cache.Builder __builder) {
        cache = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder cache(java.util.function.Consumer<Cache.Builder> __func) {
        Cache.Builder __inner = new Cache.Builder();
        __func.accept(__inner);
        cache = __inner;
        return this;
      }

      public Builder log(Log.Builder __builder) {
        log = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder log(java.util.function.Consumer<Log.Builder> __func) {
        Log.Builder __inner = new Log.Builder();
        __func.accept(__inner);
        log = __inner;
        return this;
      }

      public Builder write(Write.Builder __builder) {
        write = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder write(java.util.function.Consumer<Write.Builder> __func) {
        Write.Builder __inner = new Write.Builder();
        __func.accept(__inner);
        write = __inner;
        return this;
      }

      public Builder read(Read.Builder __builder) {
        read = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder read(java.util.function.Consumer<Read.Builder> __func) {
        Read.Builder __inner = new Read.Builder();
        __func.accept(__inner);
        read = __inner;
        return this;
      }

      public Summary build() {
        return new Summary(this);
      }

    }

    private final Cache cache;
    private final Log log;
    private final Write write;
    private final Read read;

    public Summary(Builder builder) {
      this(builder, true);
    }

    private Summary(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "proton.summary must be initialized: " + builder.__uninitialized);

      cache = new Cache(builder.cache, throwIfUninitialized);
      log = new Log(builder.log, throwIfUninitialized);
      write = new Write(builder.write, throwIfUninitialized);
      read = new Read(builder.read, throwIfUninitialized);
    }

    /**
     * @return proton.summary.cache
     */
    public Cache cache() {
      return cache;
    }

    /**
     * @return proton.summary.log
     */
    public Log log() {
      return log;
    }

    /**
     * @return proton.summary.write
     */
    public Write write() {
      return write;
    }

    /**
     * @return proton.summary.read
     */
    public Read read() {
      return read;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Summary newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("summary");
        changes.mergeChanges("cache", this.cache.getChangesRequiringRestart(newConfig.cache));
        changes.mergeChanges("read", this.read.getChangesRequiringRestart(newConfig.read));
      return changes;
    }

    /**
     * This class represents proton.summary.cache
     */
    public final static class Cache extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Long maxbytes = null;
        public Compression.Builder compression = new Compression.Builder();
        private Update_strategy.Enum update_strategy = null;
        private Boolean allowvisitcaching = null;
        private Long initialentries = null;

        public Builder() { }

        public Builder(Cache config) {
          maxbytes(config.maxbytes());
          compression(new Compression.Builder(config.compression()));
          update_strategy(config.update_strategy());
          allowvisitcaching(config.allowvisitcaching());
          initialentries(config.initialentries());
        }

        private Builder override(Builder __superior) {
          if (__superior.maxbytes != null)
            maxbytes(__superior.maxbytes);
          compression(compression.override(__superior.compression));
          if (__superior.update_strategy != null)
            update_strategy(__superior.update_strategy);
          if (__superior.allowvisitcaching != null)
            allowvisitcaching(__superior.allowvisitcaching);
          if (__superior.initialentries != null)
            initialentries(__superior.initialentries);
          return this;
        }

        public Builder maxbytes(long __value) {
          maxbytes = __value;
          return this;
        }

        private Builder maxbytes(String __value) {
          return maxbytes(Long.valueOf(__value));
        }

        public Builder compression(Compression.Builder __builder) {
          compression = __builder;
          return this;
        }
        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder compression(java.util.function.Consumer<Compression.Builder> __func) {
          Compression.Builder __inner = new Compression.Builder();
          __func.accept(__inner);
          compression = __inner;
          return this;
        }

        public Builder update_strategy(Update_strategy.Enum __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          update_strategy = __value;
          return this;
        }

        private Builder update_strategy(String __value) {
          return update_strategy(Update_strategy.Enum.valueOf(__value));
        }

        public Builder allowvisitcaching(boolean __value) {
          allowvisitcaching = __value;
          return this;
        }

        private Builder allowvisitcaching(String __value) {
          return allowvisitcaching(Boolean.valueOf(__value));
        }

        public Builder initialentries(long __value) {
          initialentries = __value;
          return this;
        }

        private Builder initialentries(String __value) {
          return initialentries(Long.valueOf(__value));
        }

        public Cache build() {
          return new Cache(this);
        }

      }

      // Control cache size in bytes.
      // Postive numbers are absolute in bytes.
      // Negative numbers are a percentage of memory.
      private final LongNode maxbytes;
      private final Compression compression;
      // Control if cache entry is updated or ivalidated when changed.
      private final Update_strategy update_strategy;
      // Include visits in the cache, if the visitoperation allows it.
      // This will enable another separate cache of summary.cache.maxbytes size.
      // IGNORED and DEPRECATED Will go away soon
      private final BooleanNode allowvisitcaching;
      // Control number of cache entries preallocated.
      // Default is no preallocation.
      // Can be set to a higher number to avoid resizing.
      // IGNORED and DEPRECATED Will go away soon
      private final LongNode initialentries;

      public Cache(Builder builder) {
        this(builder, true);
      }

      private Cache(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "proton.summary.cache must be initialized: " + builder.__uninitialized);

        maxbytes = (builder.maxbytes == null) ?
            new LongNode(-4L) : new LongNode(builder.maxbytes);
        compression = new Compression(builder.compression, throwIfUninitialized);
        update_strategy = (builder.update_strategy == null) ?
            new Update_strategy(Update_strategy.INVALIDATE) : new Update_strategy(builder.update_strategy);
        allowvisitcaching = (builder.allowvisitcaching == null) ?
            new BooleanNode(true) : new BooleanNode(builder.allowvisitcaching);
        initialentries = (builder.initialentries == null) ?
            new LongNode(0L) : new LongNode(builder.initialentries);
      }

      /**
       * @return proton.summary.cache.maxbytes
       */
      public long maxbytes() {
        return maxbytes.value();
      }

      /**
       * @return proton.summary.cache.compression
       */
      public Compression compression() {
        return compression;
      }

      /**
       * @return proton.summary.cache.update_strategy
       */
      public Update_strategy.Enum update_strategy() {
        return update_strategy.value();
      }

      /**
       * @return proton.summary.cache.allowvisitcaching
       */
      public boolean allowvisitcaching() {
        return allowvisitcaching.value();
      }

      /**
       * @return proton.summary.cache.initialentries
       */
      public long initialentries() {
        return initialentries.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Cache newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("cache");
          changes.compare(this.initialentries, newConfig.initialentries, "initialentries", "Control number of cache entries preallocated.\nDefault is no preallocation.\nCan be set to a higher number to avoid resizing.\nIGNORED and DEPRECATED Will go away soon");
        return changes;
      }

      /**
       * This class represents proton.summary.cache.compression
       */
      public final static class Compression extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>();

          private Type.Enum type = null;
          private Integer level = null;

          public Builder() { }

          public Builder(Compression config) {
            type(config.type());
            level(config.level());
          }

          private Builder override(Builder __superior) {
            if (__superior.type != null)
              type(__superior.type);
            if (__superior.level != null)
              level(__superior.level);
            return this;
          }

          public Builder type(Type.Enum __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            type = __value;
            return this;
          }

          private Builder type(String __value) {
            return type(Type.Enum.valueOf(__value));
          }

          public Builder level(int __value) {
            level = __value;
            return this;
          }

          private Builder level(String __value) {
            return level(Integer.valueOf(__value));
          }

          public Compression build() {
            return new Compression(this);
          }

        }

        // Control compression type of the summary while in the cache.
        private final Type type;
        // Control compression level of the summary while in cache.
        // LZ4 has normal range 1..9 while ZSTD has range 1..19
        // 6 is a default for lz4 to prioritize speed.
        private final IntegerNode level;

        public Compression(Builder builder) {
          this(builder, true);
        }

        private Compression(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "proton.summary.cache.compression must be initialized: " + builder.__uninitialized);

          type = (builder.type == null) ?
              new Type(Type.LZ4) : new Type(builder.type);
          level = (builder.level == null) ?
              new IntegerNode(6) : new IntegerNode(builder.level);
        }

        /**
         * @return proton.summary.cache.compression.type
         */
        public Type.Enum type() {
          return type.value();
        }

        /**
         * @return proton.summary.cache.compression.level
         */
        public int level() {
          return level.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Compression newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("compression");
          return changes;
        }

        /**
         * This class represents proton.summary.cache.compression.type
         * 
         * Control compression type of the summary while in the cache.
         */
        public final static class Type extends EnumNode<Type.Enum> {

          public Type(){
            this.value = null;
          }

          public Type(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
          }

          public enum Enum {NONE, LZ4, ZSTD}
          public final static Enum NONE = Enum.NONE;
          public final static Enum LZ4 = Enum.LZ4;
          public final static Enum ZSTD = Enum.ZSTD;

          @Override
          protected boolean doSetValue(String name) {
            try {
              value = Enum.valueOf(name);
              return true;
            } catch (IllegalArgumentException e) {
            }
            return false;
          }
        }
      }

      /**
       * This class represents proton.summary.cache.update_strategy
       * 
       * Control if cache entry is updated or ivalidated when changed.
       */
      public final static class Update_strategy extends EnumNode<Update_strategy.Enum> {

        public Update_strategy(){
          this.value = null;
        }

        public Update_strategy(Enum enumValue) {
          super(enumValue != null);
          this.value = enumValue;
        }

        public enum Enum {INVALIDATE, UPDATE}
        public final static Enum INVALIDATE = Enum.INVALIDATE;
        public final static Enum UPDATE = Enum.UPDATE;

        @Override
        protected boolean doSetValue(String name) {
          try {
            value = Enum.valueOf(name);
            return true;
          } catch (IllegalArgumentException e) {
          }
          return false;
        }
      }
    }

    /**
     * This class represents proton.summary.log
     */
    public final static class Log extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        public Compact.Builder compact = new Compact.Builder();
        public Chunk.Builder chunk = new Chunk.Builder();
        private Long maxfilesize = null;
        private Integer maxnumlids = null;
        private Double maxdiskbloatfactor = null;
        private Double maxbucketspread = null;
        private Double minfilesizefactor = null;

        public Builder() { }

        public Builder(Log config) {
          compact(new Compact.Builder(config.compact()));
          chunk(new Chunk.Builder(config.chunk()));
          maxfilesize(config.maxfilesize());
          maxnumlids(config.maxnumlids());
          maxdiskbloatfactor(config.maxdiskbloatfactor());
          maxbucketspread(config.maxbucketspread());
          minfilesizefactor(config.minfilesizefactor());
        }

        private Builder override(Builder __superior) {
          compact(compact.override(__superior.compact));
          chunk(chunk.override(__superior.chunk));
          if (__superior.maxfilesize != null)
            maxfilesize(__superior.maxfilesize);
          if (__superior.maxnumlids != null)
            maxnumlids(__superior.maxnumlids);
          if (__superior.maxdiskbloatfactor != null)
            maxdiskbloatfactor(__superior.maxdiskbloatfactor);
          if (__superior.maxbucketspread != null)
            maxbucketspread(__superior.maxbucketspread);
          if (__superior.minfilesizefactor != null)
            minfilesizefactor(__superior.minfilesizefactor);
          return this;
        }

        public Builder compact(Compact.Builder __builder) {
          compact = __builder;
          return this;
        }
        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder compact(java.util.function.Consumer<Compact.Builder> __func) {
          Compact.Builder __inner = new Compact.Builder();
          __func.accept(__inner);
          compact = __inner;
          return this;
        }

        public Builder chunk(Chunk.Builder __builder) {
          chunk = __builder;
          return this;
        }
        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder chunk(java.util.function.Consumer<Chunk.Builder> __func) {
          Chunk.Builder __inner = new Chunk.Builder();
          __func.accept(__inner);
          chunk = __inner;
          return this;
        }

        public Builder maxfilesize(long __value) {
          maxfilesize = __value;
          return this;
        }

        private Builder maxfilesize(String __value) {
          return maxfilesize(Long.valueOf(__value));
        }

        public Builder maxnumlids(int __value) {
          maxnumlids = __value;
          return this;
        }

        private Builder maxnumlids(String __value) {
          return maxnumlids(Integer.valueOf(__value));
        }

        public Builder maxdiskbloatfactor(double __value) {
          maxdiskbloatfactor = __value;
          return this;
        }

        private Builder maxdiskbloatfactor(String __value) {
          return maxdiskbloatfactor(Double.valueOf(__value));
        }

        public Builder maxbucketspread(double __value) {
          maxbucketspread = __value;
          return this;
        }

        private Builder maxbucketspread(String __value) {
          return maxbucketspread(Double.valueOf(__value));
        }

        public Builder minfilesizefactor(double __value) {
          minfilesizefactor = __value;
          return this;
        }

        private Builder minfilesizefactor(String __value) {
          return minfilesizefactor(Double.valueOf(__value));
        }

        public Log build() {
          return new Log(this);
        }

      }

      private final Compact compact;
      private final Chunk chunk;
      // Max size per summary file.
      private final LongNode maxfilesize;
      // Max number of lid entries per file
      // TODO Decide based on memory on node.
      private final IntegerNode maxnumlids;
      // Max disk bloat factor. This will trigger compacting.
      private final DoubleNode maxdiskbloatfactor;
      // Max bucket spread within a single summary file. This will trigger bucket order compacting.
      private final DoubleNode maxbucketspread;
      // If a file goes below this ratio compared to allowed max size it will be joined to the front.
      // Value in the range [0.0, 1.0]
      private final DoubleNode minfilesizefactor;

      public Log(Builder builder) {
        this(builder, true);
      }

      private Log(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "proton.summary.log must be initialized: " + builder.__uninitialized);

        compact = new Compact(builder.compact, throwIfUninitialized);
        chunk = new Chunk(builder.chunk, throwIfUninitialized);
        maxfilesize = (builder.maxfilesize == null) ?
            new LongNode(1000000000L) : new LongNode(builder.maxfilesize);
        maxnumlids = (builder.maxnumlids == null) ?
            new IntegerNode(8388608) : new IntegerNode(builder.maxnumlids);
        maxdiskbloatfactor = (builder.maxdiskbloatfactor == null) ?
            new DoubleNode(0.1D) : new DoubleNode(builder.maxdiskbloatfactor);
        maxbucketspread = (builder.maxbucketspread == null) ?
            new DoubleNode(2.5D) : new DoubleNode(builder.maxbucketspread);
        minfilesizefactor = (builder.minfilesizefactor == null) ?
            new DoubleNode(0.2D) : new DoubleNode(builder.minfilesizefactor);
      }

      /**
       * @return proton.summary.log.compact
       */
      public Compact compact() {
        return compact;
      }

      /**
       * @return proton.summary.log.chunk
       */
      public Chunk chunk() {
        return chunk;
      }

      /**
       * @return proton.summary.log.maxfilesize
       */
      public long maxfilesize() {
        return maxfilesize.value();
      }

      /**
       * @return proton.summary.log.maxnumlids
       */
      public int maxnumlids() {
        return maxnumlids.value();
      }

      /**
       * @return proton.summary.log.maxdiskbloatfactor
       */
      public double maxdiskbloatfactor() {
        return maxdiskbloatfactor.value();
      }

      /**
       * @return proton.summary.log.maxbucketspread
       */
      public double maxbucketspread() {
        return maxbucketspread.value();
      }

      /**
       * @return proton.summary.log.minfilesizefactor
       */
      public double minfilesizefactor() {
        return minfilesizefactor.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Log newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("log");
        return changes;
      }

      /**
       * This class represents proton.summary.log.compact
       */
      public final static class Compact extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>();

          public Compression.Builder compression = new Compression.Builder();

          public Builder() { }

          public Builder(Compact config) {
            compression(new Compression.Builder(config.compression()));
          }

          private Builder override(Builder __superior) {
            compression(compression.override(__superior.compression));
            return this;
          }

          public Builder compression(Compression.Builder __builder) {
            compression = __builder;
            return this;
          }
          /**
           * Make a new builder and run the supplied function on it before adding it to the list
           * @param __func lambda that modifies the given builder
           * @return this builder
           */
          public Builder compression(java.util.function.Consumer<Compression.Builder> __func) {
            Compression.Builder __inner = new Compression.Builder();
            __func.accept(__inner);
            compression = __inner;
            return this;
          }

          public Compact build() {
            return new Compact(this);
          }

        }

        private final Compression compression;

        public Compact(Builder builder) {
          this(builder, true);
        }

        private Compact(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "proton.summary.log.compact must be initialized: " + builder.__uninitialized);

          compression = new Compression(builder.compression, throwIfUninitialized);
        }

        /**
         * @return proton.summary.log.compact.compression
         */
        public Compression compression() {
          return compression;
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Compact newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("compact");
          return changes;
        }

        /**
         * This class represents proton.summary.log.compact.compression
         */
        public final static class Compression extends InnerNode { 

          public static final class Builder implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();

            private Type.Enum type = null;
            private Integer level = null;

            public Builder() { }

            public Builder(Compression config) {
              type(config.type());
              level(config.level());
            }

            private Builder override(Builder __superior) {
              if (__superior.type != null)
                type(__superior.type);
              if (__superior.level != null)
                level(__superior.level);
              return this;
            }

            public Builder type(Type.Enum __value) {
            if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
              type = __value;
              return this;
            }

            private Builder type(String __value) {
              return type(Type.Enum.valueOf(__value));
            }

            public Builder level(int __value) {
              level = __value;
              return this;
            }

            private Builder level(String __value) {
              return level(Integer.valueOf(__value));
            }

            public Compression build() {
              return new Compression(this);
            }

          }

          // Control compression type of the summary while in memory during compaction
          // NB So far only stragey=LOG honours it.
          // TODO Use same as for store (chunk.compression).
          private final Type type;
          // Control compression level of the summary while in memory during compaction
          // LZ4 has normal range 1..9 while ZSTD has range 1..19
          // 9 is a reasonable default for both
          private final IntegerNode level;

          public Compression(Builder builder) {
            this(builder, true);
          }

          private Compression(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
              throw new IllegalArgumentException("The following builder parameters for " +
                  "proton.summary.log.compact.compression must be initialized: " + builder.__uninitialized);

            type = (builder.type == null) ?
                new Type(Type.ZSTD) : new Type(builder.type);
            level = (builder.level == null) ?
                new IntegerNode(9) : new IntegerNode(builder.level);
          }

          /**
           * @return proton.summary.log.compact.compression.type
           */
          public Type.Enum type() {
            return type.value();
          }

          /**
           * @return proton.summary.log.compact.compression.level
           */
          public int level() {
            return level.value();
          }

          private ChangesRequiringRestart getChangesRequiringRestart(Compression newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("compression");
            return changes;
          }

          /**
           * This class represents proton.summary.log.compact.compression.type
           * 
           * Control compression type of the summary while in memory during compaction
           * NB So far only stragey=LOG honours it.
           * TODO Use same as for store (chunk.compression).
           */
          public final static class Type extends EnumNode<Type.Enum> {

            public Type(){
              this.value = null;
            }

            public Type(Enum enumValue) {
              super(enumValue != null);
              this.value = enumValue;
            }

            public enum Enum {NONE, LZ4, ZSTD}
            public final static Enum NONE = Enum.NONE;
            public final static Enum LZ4 = Enum.LZ4;
            public final static Enum ZSTD = Enum.ZSTD;

            @Override
            protected boolean doSetValue(String name) {
              try {
                value = Enum.valueOf(name);
                return true;
              } catch (IllegalArgumentException e) {
              }
              return false;
            }
          }
        }
      }

      /**
       * This class represents proton.summary.log.chunk
       */
      public final static class Chunk extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>();

          public Compression.Builder compression = new Compression.Builder();
          private Integer maxbytes = null;
          private Boolean skipcrconread = null;

          public Builder() { }

          public Builder(Chunk config) {
            compression(new Compression.Builder(config.compression()));
            maxbytes(config.maxbytes());
            skipcrconread(config.skipcrconread());
          }

          private Builder override(Builder __superior) {
            compression(compression.override(__superior.compression));
            if (__superior.maxbytes != null)
              maxbytes(__superior.maxbytes);
            if (__superior.skipcrconread != null)
              skipcrconread(__superior.skipcrconread);
            return this;
          }

          public Builder compression(Compression.Builder __builder) {
            compression = __builder;
            return this;
          }
          /**
           * Make a new builder and run the supplied function on it before adding it to the list
           * @param __func lambda that modifies the given builder
           * @return this builder
           */
          public Builder compression(java.util.function.Consumer<Compression.Builder> __func) {
            Compression.Builder __inner = new Compression.Builder();
            __func.accept(__inner);
            compression = __inner;
            return this;
          }

          public Builder maxbytes(int __value) {
            maxbytes = __value;
            return this;
          }

          private Builder maxbytes(String __value) {
            return maxbytes(Integer.valueOf(__value));
          }

          public Builder skipcrconread(boolean __value) {
            skipcrconread = __value;
            return this;
          }

          private Builder skipcrconread(String __value) {
            return skipcrconread(Boolean.valueOf(__value));
          }

          public Chunk build() {
            return new Chunk(this);
          }

        }

        private final Compression compression;
        // Max size in bytes per chunk.
        private final IntegerNode maxbytes;
        // Skip crc32 check on read.
        // IGNORED and DEPRECATED Will go away soon
        private final BooleanNode skipcrconread;

        public Chunk(Builder builder) {
          this(builder, true);
        }

        private Chunk(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "proton.summary.log.chunk must be initialized: " + builder.__uninitialized);

          compression = new Compression(builder.compression, throwIfUninitialized);
          maxbytes = (builder.maxbytes == null) ?
              new IntegerNode(65536) : new IntegerNode(builder.maxbytes);
          skipcrconread = (builder.skipcrconread == null) ?
              new BooleanNode(false) : new BooleanNode(builder.skipcrconread);
        }

        /**
         * @return proton.summary.log.chunk.compression
         */
        public Compression compression() {
          return compression;
        }

        /**
         * @return proton.summary.log.chunk.maxbytes
         */
        public int maxbytes() {
          return maxbytes.value();
        }

        /**
         * @return proton.summary.log.chunk.skipcrconread
         */
        public boolean skipcrconread() {
          return skipcrconread.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Chunk newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("chunk");
          return changes;
        }

        /**
         * This class represents proton.summary.log.chunk.compression
         */
        public final static class Compression extends InnerNode { 

          public static final class Builder implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();

            private Type.Enum type = null;
            private Integer level = null;

            public Builder() { }

            public Builder(Compression config) {
              type(config.type());
              level(config.level());
            }

            private Builder override(Builder __superior) {
              if (__superior.type != null)
                type(__superior.type);
              if (__superior.level != null)
                level(__superior.level);
              return this;
            }

            public Builder type(Type.Enum __value) {
            if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
              type = __value;
              return this;
            }

            private Builder type(String __value) {
              return type(Type.Enum.valueOf(__value));
            }

            public Builder level(int __value) {
              level = __value;
              return this;
            }

            private Builder level(String __value) {
              return level(Integer.valueOf(__value));
            }

            public Compression build() {
              return new Compression(this);
            }

          }

          // Control compression type of the summary
          private final Type type;
          // Control compression level of the summary
          // LZ4 has normal range 1..9 while ZSTD has range 1..19
          // 9 is a reasonable default for both. Going above for ZSTD can give an improvement,
          // but is better done in conjunction with increasing chunk size.
          private final IntegerNode level;

          public Compression(Builder builder) {
            this(builder, true);
          }

          private Compression(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
              throw new IllegalArgumentException("The following builder parameters for " +
                  "proton.summary.log.chunk.compression must be initialized: " + builder.__uninitialized);

            type = (builder.type == null) ?
                new Type(Type.ZSTD) : new Type(builder.type);
            level = (builder.level == null) ?
                new IntegerNode(9) : new IntegerNode(builder.level);
          }

          /**
           * @return proton.summary.log.chunk.compression.type
           */
          public Type.Enum type() {
            return type.value();
          }

          /**
           * @return proton.summary.log.chunk.compression.level
           */
          public int level() {
            return level.value();
          }

          private ChangesRequiringRestart getChangesRequiringRestart(Compression newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("compression");
            return changes;
          }

          /**
           * This class represents proton.summary.log.chunk.compression.type
           * 
           * Control compression type of the summary
           */
          public final static class Type extends EnumNode<Type.Enum> {

            public Type(){
              this.value = null;
            }

            public Type(Enum enumValue) {
              super(enumValue != null);
              this.value = enumValue;
            }

            public enum Enum {NONE, LZ4, ZSTD}
            public final static Enum NONE = Enum.NONE;
            public final static Enum LZ4 = Enum.LZ4;
            public final static Enum ZSTD = Enum.ZSTD;

            @Override
            protected boolean doSetValue(String name) {
              try {
                value = Enum.valueOf(name);
                return true;
              } catch (IllegalArgumentException e) {
              }
              return false;
            }
          }
        }
      }
    }

    /**
     * This class represents proton.summary.write
     */
    public final static class Write extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Io.Enum io = null;

        public Builder() { }

        public Builder(Write config) {
          io(config.io());
        }

        private Builder override(Builder __superior) {
          if (__superior.io != null)
            io(__superior.io);
          return this;
        }

        public Builder io(Io.Enum __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          io = __value;
          return this;
        }

        private Builder io(String __value) {
          return io(Io.Enum.valueOf(__value));
        }

        public Write build() {
          return new Write(this);
        }

      }

      // Control io options during flush of stored documents.
      private final Io io;

      public Write(Builder builder) {
        this(builder, true);
      }

      private Write(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "proton.summary.write must be initialized: " + builder.__uninitialized);

        io = (builder.io == null) ?
            new Io(Io.DIRECTIO) : new Io(builder.io);
      }

      /**
       * @return proton.summary.write.io
       */
      public Io.Enum io() {
        return io.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Write newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("write");
        return changes;
      }

      /**
       * This class represents proton.summary.write.io
       * 
       * Control io options during flush of stored documents.
       */
      public final static class Io extends EnumNode<Io.Enum> {

        public Io(){
          this.value = null;
        }

        public Io(Enum enumValue) {
          super(enumValue != null);
          this.value = enumValue;
        }

        public enum Enum {NORMAL, OSYNC, DIRECTIO}
        public final static Enum NORMAL = Enum.NORMAL;
        public final static Enum OSYNC = Enum.OSYNC;
        public final static Enum DIRECTIO = Enum.DIRECTIO;

        @Override
        protected boolean doSetValue(String name) {
          try {
            value = Enum.valueOf(name);
            return true;
          } catch (IllegalArgumentException e) {
          }
          return false;
        }
      }
    }

    /**
     * This class represents proton.summary.read
     */
    public final static class Read extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Io.Enum io = null;
        public Mmap.Builder mmap = new Mmap.Builder();

        public Builder() { }

        public Builder(Read config) {
          io(config.io());
          mmap(new Mmap.Builder(config.mmap()));
        }

        private Builder override(Builder __superior) {
          if (__superior.io != null)
            io(__superior.io);
          mmap(mmap.override(__superior.mmap));
          return this;
        }

        public Builder io(Io.Enum __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          io = __value;
          return this;
        }

        private Builder io(String __value) {
          return io(Io.Enum.valueOf(__value));
        }

        public Builder mmap(Mmap.Builder __builder) {
          mmap = __builder;
          return this;
        }
        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder mmap(java.util.function.Consumer<Mmap.Builder> __func) {
          Mmap.Builder __inner = new Mmap.Builder();
          __func.accept(__inner);
          mmap = __inner;
          return this;
        }

        public Read build() {
          return new Read(this);
        }

      }

      // Control io options during read of stored documents.
      // All summary.read options will take effect immediately on new files written.
      // On old files it will take effect either upon compact or on restart.
      // TODO Default is probably DIRECTIO
      private final Io io;
      private final Mmap mmap;

      public Read(Builder builder) {
        this(builder, true);
      }

      private Read(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "proton.summary.read must be initialized: " + builder.__uninitialized);

        io = (builder.io == null) ?
            new Io(Io.MMAP) : new Io(builder.io);
        mmap = new Mmap(builder.mmap, throwIfUninitialized);
      }

      /**
       * @return proton.summary.read.io
       */
      public Io.Enum io() {
        return io.value();
      }

      /**
       * @return proton.summary.read.mmap
       */
      public Mmap mmap() {
        return mmap;
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Read newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("read");
          changes.compare(this.io, newConfig.io, "io", "Control io options during read of stored documents.\nAll summary.read options will take effect immediately on new files written.\nOn old files it will take effect either upon compact or on restart.\nTODO Default is probably DIRECTIO");
          changes.mergeChanges("mmap", this.mmap.getChangesRequiringRestart(newConfig.mmap));
        return changes;
      }

      /**
       * This class represents proton.summary.read.io
       * 
       * Control io options during read of stored documents.
       * All summary.read options will take effect immediately on new files written.
       * On old files it will take effect either upon compact or on restart.
       * TODO Default is probably DIRECTIO
       */
      public final static class Io extends EnumNode<Io.Enum> {

        public Io(){
          this.value = null;
        }

        public Io(Enum enumValue) {
          super(enumValue != null);
          this.value = enumValue;
        }

        public enum Enum {NORMAL, DIRECTIO, MMAP}
        public final static Enum NORMAL = Enum.NORMAL;
        public final static Enum DIRECTIO = Enum.DIRECTIO;
        public final static Enum MMAP = Enum.MMAP;

        @Override
        protected boolean doSetValue(String name) {
          try {
            value = Enum.valueOf(name);
            return true;
          } catch (IllegalArgumentException e) {
          }
          return false;
        }
      }

      /**
       * This class represents proton.summary.read.mmap
       */
      public final static class Mmap extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>();

          public List<Options.Enum> options = new ArrayList<>();
          private Advise.Enum advise = null;

          public Builder() { }

          public Builder(Mmap config) {
            options(config.options());
            advise(config.advise());
          }

          private Builder override(Builder __superior) {
            if (!__superior.options.isEmpty())
              options.addAll(__superior.options);
            if (__superior.advise != null)
              advise(__superior.advise);
            return this;
          }

          public Builder options(Options.Enum __value) {
            options.add(__value);
            return this;
          }

          public Builder options(Collection<Options.Enum> __values) {
            options.addAll(__values);
            return this;
          }

          private Builder options(String __value) {
            return options(Options.Enum.valueOf(__value));
          }

          public Builder advise(Advise.Enum __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            advise = __value;
            return this;
          }

          private Builder advise(String __value) {
            return advise(Advise.Enum.valueOf(__value));
          }

          public Mmap build() {
            return new Mmap(this);
          }

        }

        // Multiple optional options for use with mmap
        private final LeafNodeVector<Options.Enum, Options> options;
        // Advise to give to os when mapping memory.
        private final Advise advise;

        public Mmap(Builder builder) {
          this(builder, true);
        }

        private Mmap(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "proton.summary.read.mmap must be initialized: " + builder.__uninitialized);

          options = new LeafNodeVector<>(builder.options, new Options());
          advise = (builder.advise == null) ?
              new Advise(Advise.NORMAL) : new Advise(builder.advise);
        }

        /**
         * @return proton.summary.read.mmap.options[]
         */
        public List<Options.Enum> options() {
          return options.asList();
        }

        /**
         * @param i the index of the value to return
         * @return proton.summary.read.mmap.options[]
         */
        public Options.Enum options(int i) {
          return options.get(i).value();
        }

        /**
         * @return proton.summary.read.mmap.advise
         */
        public Advise.Enum advise() {
          return advise.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Mmap newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("mmap");
            changes.compareArray(this.options, newConfig.options, "options", "Multiple optional options for use with mmap",
                              (a,b) -> new ChangesRequiringRestart("options").compare(a,b,"","Multiple optional options for use with mmap"));
            changes.compare(this.advise, newConfig.advise, "advise", "Advise to give to os when mapping memory.");
          return changes;
        }

        /**
         * This class represents proton.summary.read.mmap.options[]
         * 
         * Multiple optional options for use with mmap
         */
        public final static class Options extends EnumNode<Options.Enum> {

          public Options(){
            this.value = null;
          }

          public Options(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
          }

          public enum Enum {POPULATE, HUGETLB}
          public final static Enum POPULATE = Enum.POPULATE;
          public final static Enum HUGETLB = Enum.HUGETLB;

          @Override
          protected boolean doSetValue(String name) {
            try {
              value = Enum.valueOf(name);
              return true;
            } catch (IllegalArgumentException e) {
            }
            return false;
          }
        }

        /**
         * This class represents proton.summary.read.mmap.advise
         * 
         * Advise to give to os when mapping memory.
         */
        public final static class Advise extends EnumNode<Advise.Enum> {

          public Advise(){
            this.value = null;
          }

          public Advise(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
          }

          public enum Enum {NORMAL, RANDOM, SEQUENTIAL}
          public final static Enum NORMAL = Enum.NORMAL;
          public final static Enum RANDOM = Enum.RANDOM;
          public final static Enum SEQUENTIAL = Enum.SEQUENTIAL;

          @Override
          protected boolean doSetValue(String name) {
            try {
              value = Enum.valueOf(name);
              return true;
            } catch (IllegalArgumentException e) {
            }
            return false;
          }
        }
      }
    }
  }

  /**
   * This class represents proton.documentdb[]
   */
  public final static class Documentdb extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "inputdoctypename",
        "configid"
        ));

      private String inputdoctypename = null;
      private Mode.Enum mode = null;
      private String configid = null;
      private Double visibilitydelay = null;
      private Boolean global = null;
      public Allocation.Builder allocation = new Allocation.Builder();

      public Builder() { }

      public Builder(Documentdb config) {
        inputdoctypename(config.inputdoctypename());
        mode(config.mode());
        configid(config.configid());
        visibilitydelay(config.visibilitydelay());
        global(config.global());
        allocation(new Allocation.Builder(config.allocation()));
      }

      private Builder override(Builder __superior) {
        if (__superior.inputdoctypename != null)
          inputdoctypename(__superior.inputdoctypename);
        if (__superior.mode != null)
          mode(__superior.mode);
        if (__superior.configid != null)
          configid(__superior.configid);
        if (__superior.visibilitydelay != null)
          visibilitydelay(__superior.visibilitydelay);
        if (__superior.global != null)
          global(__superior.global);
        allocation(allocation.override(__superior.allocation));
        return this;
      }

      public Builder inputdoctypename(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        inputdoctypename = __value;
        __uninitialized.remove("inputdoctypename");
        return this;
      }


      public Builder mode(Mode.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        mode = __value;
        return this;
      }

      private Builder mode(String __value) {
        return mode(Mode.Enum.valueOf(__value));
      }

      public Builder configid(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        configid = __value;
        __uninitialized.remove("configid");
        return this;
      }


      public Builder visibilitydelay(double __value) {
        visibilitydelay = __value;
        return this;
      }

      private Builder visibilitydelay(String __value) {
        return visibilitydelay(Double.valueOf(__value));
      }

      public Builder global(boolean __value) {
        global = __value;
        return this;
      }

      private Builder global(String __value) {
        return global(Boolean.valueOf(__value));
      }

      public Builder allocation(Allocation.Builder __builder) {
        allocation = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder allocation(java.util.function.Consumer<Allocation.Builder> __func) {
        Allocation.Builder __inner = new Allocation.Builder();
        __func.accept(__inner);
        allocation = __inner;
        return this;
      }

      public Documentdb build() {
        return new Documentdb(this);
      }

    }

    // The name of the input document type
    private final StringNode inputdoctypename;
    // The type of the documentdb
    private final Mode mode;
    // The configid used to subscribe to config for this database.
    private final StringNode configid;
    // How many seconds is allowed from document is received to it is visible in the index.
    private final DoubleNode visibilitydelay;
    // Whether this document type is globally distributed or not.
    private final BooleanNode global;
    private final Allocation allocation;

    public Documentdb(Builder builder) {
      this(builder, true);
    }

    private Documentdb(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "proton.documentdb[] must be initialized: " + builder.__uninitialized);

      inputdoctypename = (builder.inputdoctypename == null) ?
          new StringNode() : new StringNode(builder.inputdoctypename);
      mode = (builder.mode == null) ?
          new Mode(Mode.INDEX) : new Mode(builder.mode);
      configid = (builder.configid == null) ?
          new StringNode() : new StringNode(builder.configid);
      visibilitydelay = (builder.visibilitydelay == null) ?
          new DoubleNode(0.0D) : new DoubleNode(builder.visibilitydelay);
      global = (builder.global == null) ?
          new BooleanNode(false) : new BooleanNode(builder.global);
      allocation = new Allocation(builder.allocation, throwIfUninitialized);
    }

    /**
     * @return proton.documentdb[].inputdoctypename
     */
    public String inputdoctypename() {
      return inputdoctypename.value();
    }

    /**
     * @return proton.documentdb[].mode
     */
    public Mode.Enum mode() {
      return mode.value();
    }

    /**
     * @return proton.documentdb[].configid
     */
    public String configid() {
      return configid.value();
    }

    /**
     * @return proton.documentdb[].visibilitydelay
     */
    public double visibilitydelay() {
      return visibilitydelay.value();
    }

    /**
     * @return proton.documentdb[].global
     */
    public boolean global() {
      return global.value();
    }

    /**
     * @return proton.documentdb[].allocation
     */
    public Allocation allocation() {
      return allocation;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Documentdb newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("documentdb");
      return changes;
    }

    private static InnerNodeVector<Documentdb> createVector(List<Builder> builders) {
        List<Documentdb> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Documentdb(b));
        }
        return new InnerNodeVector<Documentdb>(elems);
    }

    /**
     * This class represents proton.documentdb[].mode
     * 
     * The type of the documentdb
     */
    public final static class Mode extends EnumNode<Mode.Enum> {

      public Mode(){
        this.value = null;
      }

      public Mode(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {INDEX, STREAMING, STORE_ONLY}
      public final static Enum INDEX = Enum.INDEX;
      public final static Enum STREAMING = Enum.STREAMING;
      public final static Enum STORE_ONLY = Enum.STORE_ONLY;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }

    /**
     * This class represents proton.documentdb[].allocation
     */
    public final static class Allocation extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Long initialnumdocs = null;
        private Double growfactor = null;
        private Integer growbias = null;
        private Integer amortizecount = null;
        private Double multivaluegrowfactor = null;
        private Double max_dead_bytes_ratio = null;
        private Double max_dead_address_space_ratio = null;
        private Integer max_compact_buffers = null;
        private Double active_buffers_ratio = null;

        public Builder() { }

        public Builder(Allocation config) {
          initialnumdocs(config.initialnumdocs());
          growfactor(config.growfactor());
          growbias(config.growbias());
          amortizecount(config.amortizecount());
          multivaluegrowfactor(config.multivaluegrowfactor());
          max_dead_bytes_ratio(config.max_dead_bytes_ratio());
          max_dead_address_space_ratio(config.max_dead_address_space_ratio());
          max_compact_buffers(config.max_compact_buffers());
          active_buffers_ratio(config.active_buffers_ratio());
        }

        private Builder override(Builder __superior) {
          if (__superior.initialnumdocs != null)
            initialnumdocs(__superior.initialnumdocs);
          if (__superior.growfactor != null)
            growfactor(__superior.growfactor);
          if (__superior.growbias != null)
            growbias(__superior.growbias);
          if (__superior.amortizecount != null)
            amortizecount(__superior.amortizecount);
          if (__superior.multivaluegrowfactor != null)
            multivaluegrowfactor(__superior.multivaluegrowfactor);
          if (__superior.max_dead_bytes_ratio != null)
            max_dead_bytes_ratio(__superior.max_dead_bytes_ratio);
          if (__superior.max_dead_address_space_ratio != null)
            max_dead_address_space_ratio(__superior.max_dead_address_space_ratio);
          if (__superior.max_compact_buffers != null)
            max_compact_buffers(__superior.max_compact_buffers);
          if (__superior.active_buffers_ratio != null)
            active_buffers_ratio(__superior.active_buffers_ratio);
          return this;
        }

        public Builder initialnumdocs(long __value) {
          initialnumdocs = __value;
          return this;
        }

        private Builder initialnumdocs(String __value) {
          return initialnumdocs(Long.valueOf(__value));
        }

        public Builder growfactor(double __value) {
          growfactor = __value;
          return this;
        }

        private Builder growfactor(String __value) {
          return growfactor(Double.valueOf(__value));
        }

        public Builder growbias(int __value) {
          growbias = __value;
          return this;
        }

        private Builder growbias(String __value) {
          return growbias(Integer.valueOf(__value));
        }

        public Builder amortizecount(int __value) {
          amortizecount = __value;
          return this;
        }

        private Builder amortizecount(String __value) {
          return amortizecount(Integer.valueOf(__value));
        }

        public Builder multivaluegrowfactor(double __value) {
          multivaluegrowfactor = __value;
          return this;
        }

        private Builder multivaluegrowfactor(String __value) {
          return multivaluegrowfactor(Double.valueOf(__value));
        }

        public Builder max_dead_bytes_ratio(double __value) {
          max_dead_bytes_ratio = __value;
          return this;
        }

        private Builder max_dead_bytes_ratio(String __value) {
          return max_dead_bytes_ratio(Double.valueOf(__value));
        }

        public Builder max_dead_address_space_ratio(double __value) {
          max_dead_address_space_ratio = __value;
          return this;
        }

        private Builder max_dead_address_space_ratio(String __value) {
          return max_dead_address_space_ratio(Double.valueOf(__value));
        }

        public Builder max_compact_buffers(int __value) {
          max_compact_buffers = __value;
          return this;
        }

        private Builder max_compact_buffers(String __value) {
          return max_compact_buffers(Integer.valueOf(__value));
        }

        public Builder active_buffers_ratio(double __value) {
          active_buffers_ratio = __value;
          return this;
        }

        private Builder active_buffers_ratio(String __value) {
          return active_buffers_ratio(Double.valueOf(__value));
        }

        public Allocation build() {
          return new Allocation(this);
        }

      }

      // Minimum initial size for any per document tables.
      private final LongNode initialnumdocs;
      // Grow factor for any per document tables.
      private final DoubleNode growfactor;
      // Constant added when growing any per document tables.
      private final IntegerNode growbias;
      // The number of documents to amortize memory spike cost over
      private final IntegerNode amortizecount;
      // The grow factor used when allocating buffers in the array store
      // used in multi-value attribute vectors to store underlying values.
      private final DoubleNode multivaluegrowfactor;
      // The ratio of used bytes that can be dead before attempting to perform compaction.
      private final DoubleNode max_dead_bytes_ratio;
      // The ratio of used address space that can be dead before attempting to perform compaction.
      private final DoubleNode max_dead_address_space_ratio;
      // Upper bound for number of buffers that can be compacted at the same time in
      // a data store for a specific reason (e.g. memory used, address space used).
      private final IntegerNode max_compact_buffers;
      // Ratio of active buffers that can be compacted at the same time in a data
      // store for a specific reason (e.g. memory used, address space used).
      // Effective limit is ceil(active_buffers * active_buffers_ratio).
      private final DoubleNode active_buffers_ratio;

      public Allocation(Builder builder) {
        this(builder, true);
      }

      private Allocation(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "proton.documentdb[].allocation must be initialized: " + builder.__uninitialized);

        initialnumdocs = (builder.initialnumdocs == null) ?
            new LongNode(1024L) : new LongNode(builder.initialnumdocs);
        growfactor = (builder.growfactor == null) ?
            new DoubleNode(0.2D) : new DoubleNode(builder.growfactor);
        growbias = (builder.growbias == null) ?
            new IntegerNode(1) : new IntegerNode(builder.growbias);
        amortizecount = (builder.amortizecount == null) ?
            new IntegerNode(10000) : new IntegerNode(builder.amortizecount);
        multivaluegrowfactor = (builder.multivaluegrowfactor == null) ?
            new DoubleNode(0.2D) : new DoubleNode(builder.multivaluegrowfactor);
        max_dead_bytes_ratio = (builder.max_dead_bytes_ratio == null) ?
            new DoubleNode(0.05D) : new DoubleNode(builder.max_dead_bytes_ratio);
        max_dead_address_space_ratio = (builder.max_dead_address_space_ratio == null) ?
            new DoubleNode(0.2D) : new DoubleNode(builder.max_dead_address_space_ratio);
        max_compact_buffers = (builder.max_compact_buffers == null) ?
            new IntegerNode(1) : new IntegerNode(builder.max_compact_buffers);
        active_buffers_ratio = (builder.active_buffers_ratio == null) ?
            new DoubleNode(0.1D) : new DoubleNode(builder.active_buffers_ratio);
      }

      /**
       * @return proton.documentdb[].allocation.initialnumdocs
       */
      public long initialnumdocs() {
        return initialnumdocs.value();
      }

      /**
       * @return proton.documentdb[].allocation.growfactor
       */
      public double growfactor() {
        return growfactor.value();
      }

      /**
       * @return proton.documentdb[].allocation.growbias
       */
      public int growbias() {
        return growbias.value();
      }

      /**
       * @return proton.documentdb[].allocation.amortizecount
       */
      public int amortizecount() {
        return amortizecount.value();
      }

      /**
       * @return proton.documentdb[].allocation.multivaluegrowfactor
       */
      public double multivaluegrowfactor() {
        return multivaluegrowfactor.value();
      }

      /**
       * @return proton.documentdb[].allocation.max_dead_bytes_ratio
       */
      public double max_dead_bytes_ratio() {
        return max_dead_bytes_ratio.value();
      }

      /**
       * @return proton.documentdb[].allocation.max_dead_address_space_ratio
       */
      public double max_dead_address_space_ratio() {
        return max_dead_address_space_ratio.value();
      }

      /**
       * @return proton.documentdb[].allocation.max_compact_buffers
       */
      public int max_compact_buffers() {
        return max_compact_buffers.value();
      }

      /**
       * @return proton.documentdb[].allocation.active_buffers_ratio
       */
      public double active_buffers_ratio() {
        return active_buffers_ratio.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Allocation newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("allocation");
        return changes;
      }
    }
  }

  /**
   * This class represents proton.periodic
   */
  public final static class Periodic extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Double interval = null;

      public Builder() { }

      public Builder(Periodic config) {
        interval(config.interval());
      }

      private Builder override(Builder __superior) {
        if (__superior.interval != null)
          interval(__superior.interval);
        return this;
      }

      public Builder interval(double __value) {
        interval = __value;
        return this;
      }

      private Builder interval(String __value) {
        return interval(Double.valueOf(__value));
      }

      public Periodic build() {
        return new Periodic(this);
      }

    }

    // The interval of when periodic tasks should be run
    private final DoubleNode interval;

    public Periodic(Builder builder) {
      this(builder, true);
    }

    private Periodic(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "proton.periodic must be initialized: " + builder.__uninitialized);

      interval = (builder.interval == null) ?
          new DoubleNode(3600.0D) : new DoubleNode(builder.interval);
    }

    /**
     * @return proton.periodic.interval
     */
    public double interval() {
      return interval.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Periodic newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("periodic");
      return changes;
    }
  }

  /**
   * This class represents proton.filedistributor
   */
  public final static class Filedistributor extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private String configid = null;

      public Builder() { }

      public Builder(Filedistributor config) {
        configid(config.configid());
      }

      private Builder override(Builder __superior) {
        if (__superior.configid != null)
          configid(__superior.configid);
        return this;
      }

      public Builder configid(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        configid = __value;
        return this;
      }


      public Filedistributor build() {
        return new Filedistributor(this);
      }

    }

    // filedistributor rpc configuration
    private final ReferenceNode configid;

    public Filedistributor(Builder builder) {
      this(builder, true);
    }

    private Filedistributor(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "proton.filedistributor must be initialized: " + builder.__uninitialized);

      configid = (builder.configid == null) ?
          new ReferenceNode("") : new ReferenceNode(builder.configid);
    }

    /**
     * @return proton.filedistributor.configid
     */
    public String configid() {
      return configid.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Filedistributor newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("filedistributor");
        changes.compare(this.configid, newConfig.configid, "configid", "filedistributor rpc configuration");
      return changes;
    }
  }

  /**
   * This class represents proton.packetcompresstype
   * 
   * Compression type for packets
   *  
   * Default is LZ4
   */
  public final static class Packetcompresstype extends EnumNode<Packetcompresstype.Enum> {

    public Packetcompresstype(){
      this.value = null;
    }

    public Packetcompresstype(Enum enumValue) {
      super(enumValue != null);
      this.value = enumValue;
    }

    public enum Enum {NONE, LZ4}
    public final static Enum NONE = Enum.NONE;
    public final static Enum LZ4 = Enum.LZ4;

    @Override
    protected boolean doSetValue(String name) {
      try {
        value = Enum.valueOf(name);
        return true;
      } catch (IllegalArgumentException e) {
      }
      return false;
    }
  }

  /**
   * This class represents proton.lidspacecompaction
   */
  public final static class Lidspacecompaction extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Double interval = null;
      private Integer allowedlidbloat = null;
      private Double allowedlidbloatfactor = null;
      private Double removebatchblockrate = null;
      private Double removeblockrate = null;

      public Builder() { }

      public Builder(Lidspacecompaction config) {
        interval(config.interval());
        allowedlidbloat(config.allowedlidbloat());
        allowedlidbloatfactor(config.allowedlidbloatfactor());
        removebatchblockrate(config.removebatchblockrate());
        removeblockrate(config.removeblockrate());
      }

      private Builder override(Builder __superior) {
        if (__superior.interval != null)
          interval(__superior.interval);
        if (__superior.allowedlidbloat != null)
          allowedlidbloat(__superior.allowedlidbloat);
        if (__superior.allowedlidbloatfactor != null)
          allowedlidbloatfactor(__superior.allowedlidbloatfactor);
        if (__superior.removebatchblockrate != null)
          removebatchblockrate(__superior.removebatchblockrate);
        if (__superior.removeblockrate != null)
          removeblockrate(__superior.removeblockrate);
        return this;
      }

      public Builder interval(double __value) {
        interval = __value;
        return this;
      }

      private Builder interval(String __value) {
        return interval(Double.valueOf(__value));
      }

      public Builder allowedlidbloat(int __value) {
        allowedlidbloat = __value;
        return this;
      }

      private Builder allowedlidbloat(String __value) {
        return allowedlidbloat(Integer.valueOf(__value));
      }

      public Builder allowedlidbloatfactor(double __value) {
        allowedlidbloatfactor = __value;
        return this;
      }

      private Builder allowedlidbloatfactor(String __value) {
        return allowedlidbloatfactor(Double.valueOf(__value));
      }

      public Builder removebatchblockrate(double __value) {
        removebatchblockrate = __value;
        return this;
      }

      private Builder removebatchblockrate(String __value) {
        return removebatchblockrate(Double.valueOf(__value));
      }

      public Builder removeblockrate(double __value) {
        removeblockrate = __value;
        return this;
      }

      private Builder removeblockrate(String __value) {
        return removeblockrate(Double.valueOf(__value));
      }

      public Lidspacecompaction build() {
        return new Lidspacecompaction(this);
      }

    }

    // Interval between considering if lid space compaction should be done (in seconds).
    //  
    // Default value is 10 seconds.
    private final DoubleNode interval;
    // The allowed lid bloat (in docs) before considering lid space compaction.
    //  
    // When considering compaction the lid bloat is calculated as (docIdLimit - numDocs).
    // The lid bloat must be >= allowedlidbloat before considering compaction.
    private final IntegerNode allowedlidbloat;
    // The allowed lid bloat factor (relative) before considering lid space compaction.
    //  
    // When considering compaction the lid bloat factor is calculated as (docIdLimit - numDocs)/docIdLimit.
    // The lid bloat factor must be >= allowedlidbloatfactor before considering compaction.
    private final DoubleNode allowedlidbloatfactor;
    // The rate (ops / second) of remove batch operations for when to block lid space compaction.
    //  
    // When considering compaction, if the current observed rate of remove batch operations
    // is higher than the given block rate, the lid space compaction job is blocked.
    // It is considered again at the next regular interval (see above).
    //  
    // Remove batch operations are used when deleting buckets on a content node.
    // This functionality ensures that during massive deleting of buckets (e.g. as part of redistribution of data to a new node),
    // lid space compaction do not interfere, but instead is applied after deleting of buckets is complete.
    private final DoubleNode removebatchblockrate;
    // The rate (ops / second) of remove operations for when to block lid space compaction.
    //  
    // When considering compaction, if the current observed rate of remove operations
    // is higher than the given block rate, the lid space compaction job is blocked.
    // It is considered again at the next regular interval (see above).
    private final DoubleNode removeblockrate;

    public Lidspacecompaction(Builder builder) {
      this(builder, true);
    }

    private Lidspacecompaction(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "proton.lidspacecompaction must be initialized: " + builder.__uninitialized);

      interval = (builder.interval == null) ?
          new DoubleNode(10.0D) : new DoubleNode(builder.interval);
      allowedlidbloat = (builder.allowedlidbloat == null) ?
          new IntegerNode(1) : new IntegerNode(builder.allowedlidbloat);
      allowedlidbloatfactor = (builder.allowedlidbloatfactor == null) ?
          new DoubleNode(0.01D) : new DoubleNode(builder.allowedlidbloatfactor);
      removebatchblockrate = (builder.removebatchblockrate == null) ?
          new DoubleNode(0.5D) : new DoubleNode(builder.removebatchblockrate);
      removeblockrate = (builder.removeblockrate == null) ?
          new DoubleNode(100.0D) : new DoubleNode(builder.removeblockrate);
    }

    /**
     * @return proton.lidspacecompaction.interval
     */
    public double interval() {
      return interval.value();
    }

    /**
     * @return proton.lidspacecompaction.allowedlidbloat
     */
    public int allowedlidbloat() {
      return allowedlidbloat.value();
    }

    /**
     * @return proton.lidspacecompaction.allowedlidbloatfactor
     */
    public double allowedlidbloatfactor() {
      return allowedlidbloatfactor.value();
    }

    /**
     * @return proton.lidspacecompaction.removebatchblockrate
     */
    public double removebatchblockrate() {
      return removebatchblockrate.value();
    }

    /**
     * @return proton.lidspacecompaction.removeblockrate
     */
    public double removeblockrate() {
      return removeblockrate.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Lidspacecompaction newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("lidspacecompaction");
      return changes;
    }
  }

  /**
   * This class represents proton.bucketmove
   */
  public final static class Bucketmove extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Integer maxdocstomoveperbucket = null;

      public Builder() { }

      public Builder(Bucketmove config) {
        maxdocstomoveperbucket(config.maxdocstomoveperbucket());
      }

      private Builder override(Builder __superior) {
        if (__superior.maxdocstomoveperbucket != null)
          maxdocstomoveperbucket(__superior.maxdocstomoveperbucket);
        return this;
      }

      public Builder maxdocstomoveperbucket(int __value) {
        maxdocstomoveperbucket = __value;
        return this;
      }

      private Builder maxdocstomoveperbucket(String __value) {
        return maxdocstomoveperbucket(Integer.valueOf(__value));
      }

      public Bucketmove build() {
        return new Bucketmove(this);
      }

    }

    // Maximum docs to move in single operation per bucket
    private final IntegerNode maxdocstomoveperbucket;

    public Bucketmove(Builder builder) {
      this(builder, true);
    }

    private Bucketmove(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "proton.bucketmove must be initialized: " + builder.__uninitialized);

      maxdocstomoveperbucket = (builder.maxdocstomoveperbucket == null) ?
          new IntegerNode(1) : new IntegerNode(builder.maxdocstomoveperbucket);
    }

    /**
     * @return proton.bucketmove.maxdocstomoveperbucket
     */
    public int maxdocstomoveperbucket() {
      return maxdocstomoveperbucket.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Bucketmove newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("bucketmove");
      return changes;
    }
  }

  /**
   * This class represents proton.visit
   */
  public final static class Visit extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Long defaultserializedsize = null;
      private Boolean ignoremaxbytes = null;

      public Builder() { }

      public Builder(Visit config) {
        defaultserializedsize(config.defaultserializedsize());
        ignoremaxbytes(config.ignoremaxbytes());
      }

      private Builder override(Builder __superior) {
        if (__superior.defaultserializedsize != null)
          defaultserializedsize(__superior.defaultserializedsize);
        if (__superior.ignoremaxbytes != null)
          ignoremaxbytes(__superior.ignoremaxbytes);
        return this;
      }

      public Builder defaultserializedsize(long __value) {
        defaultserializedsize = __value;
        return this;
      }

      private Builder defaultserializedsize(String __value) {
        return defaultserializedsize(Long.valueOf(__value));
      }

      public Builder ignoremaxbytes(boolean __value) {
        ignoremaxbytes = __value;
        return this;
      }

      private Builder ignoremaxbytes(String __value) {
        return ignoremaxbytes(Boolean.valueOf(__value));
      }

      public Visit build() {
        return new Visit(this);
      }

    }

    // You can set this to a number above zero for visit to shortcut expensive serialize size computation.
    // This value will be provided instead.
    // negative number will compute it accurately.
    // This is only used for weakly consistent visiting, like streaming search.
    private final LongNode defaultserializedsize;
    // This will ignore the maxbytes limit advised from above.
    // This is only used for weakly consistent visiting, like streaming search.
    private final BooleanNode ignoremaxbytes;

    public Visit(Builder builder) {
      this(builder, true);
    }

    private Visit(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "proton.visit must be initialized: " + builder.__uninitialized);

      defaultserializedsize = (builder.defaultserializedsize == null) ?
          new LongNode(1L) : new LongNode(builder.defaultserializedsize);
      ignoremaxbytes = (builder.ignoremaxbytes == null) ?
          new BooleanNode(true) : new BooleanNode(builder.ignoremaxbytes);
    }

    /**
     * @return proton.visit.defaultserializedsize
     */
    public long defaultserializedsize() {
      return defaultserializedsize.value();
    }

    /**
     * @return proton.visit.ignoremaxbytes
     */
    public boolean ignoremaxbytes() {
      return ignoremaxbytes.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Visit newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("visit");
      return changes;
    }
  }

  /**
   * This class represents proton.initialize
   */
  public final static class Initialize extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Integer threads = null;

      public Builder() { }

      public Builder(Initialize config) {
        threads(config.threads());
      }

      private Builder override(Builder __superior) {
        if (__superior.threads != null)
          threads(__superior.threads);
        return this;
      }

      public Builder threads(int __value) {
        threads = __value;
        return this;
      }

      private Builder threads(String __value) {
        return threads(Integer.valueOf(__value));
      }

      public Initialize build() {
        return new Initialize(this);
      }

    }

    // Number of initializer threads used for loading structures from disk at proton startup.
    // The threads are shared between document databases when value is larger than 0.
    // When set to 0 (default) we use 1 separate thread per document database.
    // TODO Consider if really necessary, could be automatic.
    private final IntegerNode threads;

    public Initialize(Builder builder) {
      this(builder, true);
    }

    private Initialize(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "proton.initialize must be initialized: " + builder.__uninitialized);

      threads = (builder.threads == null) ?
          new IntegerNode(0) : new IntegerNode(builder.threads);
    }

    /**
     * @return proton.initialize.threads
     */
    public int threads() {
      return threads.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Initialize newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("initialize");
      return changes;
    }
  }

  /**
   * This class represents proton.writefilter
   */
  public final static class Writefilter extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      public Attribute.Builder attribute = new Attribute.Builder();
      private Double memorylimit = null;
      private Double disklimit = null;
      private Double sampleinterval = null;

      public Builder() { }

      public Builder(Writefilter config) {
        attribute(new Attribute.Builder(config.attribute()));
        memorylimit(config.memorylimit());
        disklimit(config.disklimit());
        sampleinterval(config.sampleinterval());
      }

      private Builder override(Builder __superior) {
        attribute(attribute.override(__superior.attribute));
        if (__superior.memorylimit != null)
          memorylimit(__superior.memorylimit);
        if (__superior.disklimit != null)
          disklimit(__superior.disklimit);
        if (__superior.sampleinterval != null)
          sampleinterval(__superior.sampleinterval);
        return this;
      }

      public Builder attribute(Attribute.Builder __builder) {
        attribute = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder attribute(java.util.function.Consumer<Attribute.Builder> __func) {
        Attribute.Builder __inner = new Attribute.Builder();
        __func.accept(__inner);
        attribute = __inner;
        return this;
      }

      public Builder memorylimit(double __value) {
        memorylimit = __value;
        return this;
      }

      private Builder memorylimit(String __value) {
        return memorylimit(Double.valueOf(__value));
      }

      public Builder disklimit(double __value) {
        disklimit = __value;
        return this;
      }

      private Builder disklimit(String __value) {
        return disklimit(Double.valueOf(__value));
      }

      public Builder sampleinterval(double __value) {
        sampleinterval = __value;
        return this;
      }

      private Builder sampleinterval(String __value) {
        return sampleinterval(Double.valueOf(__value));
      }

      public Writefilter build() {
        return new Writefilter(this);
      }

    }

    private final Attribute attribute;
    // Portion of physical memory that can be resident memory in anonymous mapping
    // by the proton process before put and update portion of feed is blocked.
    private final DoubleNode memorylimit;
    // Portion of space on disk partition that can be used or reserved before
    // put and update portion of feed is blocked.
    private final DoubleNode disklimit;
    // Interval between sampling of disk and memory usage. Default is 60 seconds.
    private final DoubleNode sampleinterval;

    public Writefilter(Builder builder) {
      this(builder, true);
    }

    private Writefilter(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "proton.writefilter must be initialized: " + builder.__uninitialized);

      attribute = new Attribute(builder.attribute, throwIfUninitialized);
      memorylimit = (builder.memorylimit == null) ?
          new DoubleNode(0.8D) : new DoubleNode(builder.memorylimit);
      disklimit = (builder.disklimit == null) ?
          new DoubleNode(0.8D) : new DoubleNode(builder.disklimit);
      sampleinterval = (builder.sampleinterval == null) ?
          new DoubleNode(60.0D) : new DoubleNode(builder.sampleinterval);
    }

    /**
     * @return proton.writefilter.attribute
     */
    public Attribute attribute() {
      return attribute;
    }

    /**
     * @return proton.writefilter.memorylimit
     */
    public double memorylimit() {
      return memorylimit.value();
    }

    /**
     * @return proton.writefilter.disklimit
     */
    public double disklimit() {
      return disklimit.value();
    }

    /**
     * @return proton.writefilter.sampleinterval
     */
    public double sampleinterval() {
      return sampleinterval.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Writefilter newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("writefilter");
      return changes;
    }

    /**
     * This class represents proton.writefilter.attribute
     */
    public final static class Attribute extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Double address_space_limit = null;

        public Builder() { }

        public Builder(Attribute config) {
          address_space_limit(config.address_space_limit());
        }

        private Builder override(Builder __superior) {
          if (__superior.address_space_limit != null)
            address_space_limit(__superior.address_space_limit);
          return this;
        }

        public Builder address_space_limit(double __value) {
          address_space_limit = __value;
          return this;
        }

        private Builder address_space_limit(String __value) {
          return address_space_limit(Double.valueOf(__value));
        }

        public Attribute build() {
          return new Attribute(this);
        }

      }

      // Portion of max address space used in components in attribute vectors
      // before put and update operations in feed is blocked.
      private final DoubleNode address_space_limit;

      public Attribute(Builder builder) {
        this(builder, true);
      }

      private Attribute(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "proton.writefilter.attribute must be initialized: " + builder.__uninitialized);

        address_space_limit = (builder.address_space_limit == null) ?
            new DoubleNode(0.91D) : new DoubleNode(builder.address_space_limit);
      }

      /**
       * @return proton.writefilter.attribute.address_space_limit
       */
      public double address_space_limit() {
        return address_space_limit.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Attribute newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("attribute");
        return changes;
      }
    }
  }

  /**
   * This class represents proton.hwinfo
   */
  public final static class Hwinfo extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      public Disk.Builder disk = new Disk.Builder();
      public Memory.Builder memory = new Memory.Builder();
      public Cpu.Builder cpu = new Cpu.Builder();

      public Builder() { }

      public Builder(Hwinfo config) {
        disk(new Disk.Builder(config.disk()));
        memory(new Memory.Builder(config.memory()));
        cpu(new Cpu.Builder(config.cpu()));
      }

      private Builder override(Builder __superior) {
        disk(disk.override(__superior.disk));
        memory(memory.override(__superior.memory));
        cpu(cpu.override(__superior.cpu));
        return this;
      }

      public Builder disk(Disk.Builder __builder) {
        disk = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder disk(java.util.function.Consumer<Disk.Builder> __func) {
        Disk.Builder __inner = new Disk.Builder();
        __func.accept(__inner);
        disk = __inner;
        return this;
      }

      public Builder memory(Memory.Builder __builder) {
        memory = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder memory(java.util.function.Consumer<Memory.Builder> __func) {
        Memory.Builder __inner = new Memory.Builder();
        __func.accept(__inner);
        memory = __inner;
        return this;
      }

      public Builder cpu(Cpu.Builder __builder) {
        cpu = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder cpu(java.util.function.Consumer<Cpu.Builder> __func) {
        Cpu.Builder __inner = new Cpu.Builder();
        __func.accept(__inner);
        cpu = __inner;
        return this;
      }

      public Hwinfo build() {
        return new Hwinfo(this);
      }

    }

    private final Disk disk;
    private final Memory memory;
    private final Cpu cpu;

    public Hwinfo(Builder builder) {
      this(builder, true);
    }

    private Hwinfo(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "proton.hwinfo must be initialized: " + builder.__uninitialized);

      disk = new Disk(builder.disk, throwIfUninitialized);
      memory = new Memory(builder.memory, throwIfUninitialized);
      cpu = new Cpu(builder.cpu, throwIfUninitialized);
    }

    /**
     * @return proton.hwinfo.disk
     */
    public Disk disk() {
      return disk;
    }

    /**
     * @return proton.hwinfo.memory
     */
    public Memory memory() {
      return memory;
    }

    /**
     * @return proton.hwinfo.cpu
     */
    public Cpu cpu() {
      return cpu;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Hwinfo newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("hwinfo");
        changes.mergeChanges("disk", this.disk.getChangesRequiringRestart(newConfig.disk));
        changes.mergeChanges("memory", this.memory.getChangesRequiringRestart(newConfig.memory));
        changes.mergeChanges("cpu", this.cpu.getChangesRequiringRestart(newConfig.cpu));
      return changes;
    }

    /**
     * This class represents proton.hwinfo.disk
     */
    public final static class Disk extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Long size = null;
        private Boolean shared = null;
        private Double writespeed = null;
        private Long samplewritesize = null;
        private Double slowwritespeedlimit = null;

        public Builder() { }

        public Builder(Disk config) {
          size(config.size());
          shared(config.shared());
          writespeed(config.writespeed());
          samplewritesize(config.samplewritesize());
          slowwritespeedlimit(config.slowwritespeedlimit());
        }

        private Builder override(Builder __superior) {
          if (__superior.size != null)
            size(__superior.size);
          if (__superior.shared != null)
            shared(__superior.shared);
          if (__superior.writespeed != null)
            writespeed(__superior.writespeed);
          if (__superior.samplewritesize != null)
            samplewritesize(__superior.samplewritesize);
          if (__superior.slowwritespeedlimit != null)
            slowwritespeedlimit(__superior.slowwritespeedlimit);
          return this;
        }

        public Builder size(long __value) {
          size = __value;
          return this;
        }

        private Builder size(String __value) {
          return size(Long.valueOf(__value));
        }

        public Builder shared(boolean __value) {
          shared = __value;
          return this;
        }

        private Builder shared(String __value) {
          return shared(Boolean.valueOf(__value));
        }

        public Builder writespeed(double __value) {
          writespeed = __value;
          return this;
        }

        private Builder writespeed(String __value) {
          return writespeed(Double.valueOf(__value));
        }

        public Builder samplewritesize(long __value) {
          samplewritesize = __value;
          return this;
        }

        private Builder samplewritesize(String __value) {
          return samplewritesize(Long.valueOf(__value));
        }

        public Builder slowwritespeedlimit(double __value) {
          slowwritespeedlimit = __value;
          return this;
        }

        private Builder slowwritespeedlimit(String __value) {
          return slowwritespeedlimit(Double.valueOf(__value));
        }

        public Disk build() {
          return new Disk(this);
        }

      }

      // The size of the disk partition (in bytes) on which proton basedir is located.
      // If set to 0, the disk size is sampled by looking at the filesystem space info.
      // The disk size is used when determining if feed should be blocked in writefilter.
      private final LongNode size;
      // Whether the disk partition is shared among several instances of proton (e.g. when using docker).
      // If shared, disk usage is sampled by doing a recursive directory scan in proton basedir.
      // If not, disk usage is sampled by looking at the filesystem space info.
      private final BooleanNode shared;
      // Override for disk write speed, measured in MiB/s. When zero, the
      // actual disk write speed is sampled by writing data to a temporary file.
      private final DoubleNode writespeed;
      // Amount of data to write to temporary file when sampling disk write speed.
      // Default is 1 GiB.
      // TODO Check if still in use
      private final LongNode samplewritesize;
      // Minimum write speed needed to avoid disk being considered slow.
      // Unit is MiB/s, default is 100.0 MiB/s.
      // TODO Check if still in use
      private final DoubleNode slowwritespeedlimit;

      public Disk(Builder builder) {
        this(builder, true);
      }

      private Disk(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "proton.hwinfo.disk must be initialized: " + builder.__uninitialized);

        size = (builder.size == null) ?
            new LongNode(0L) : new LongNode(builder.size);
        shared = (builder.shared == null) ?
            new BooleanNode(false) : new BooleanNode(builder.shared);
        writespeed = (builder.writespeed == null) ?
            new DoubleNode(200.0D) : new DoubleNode(builder.writespeed);
        samplewritesize = (builder.samplewritesize == null) ?
            new LongNode(1073741824L) : new LongNode(builder.samplewritesize);
        slowwritespeedlimit = (builder.slowwritespeedlimit == null) ?
            new DoubleNode(100.0D) : new DoubleNode(builder.slowwritespeedlimit);
      }

      /**
       * @return proton.hwinfo.disk.size
       */
      public long size() {
        return size.value();
      }

      /**
       * @return proton.hwinfo.disk.shared
       */
      public boolean shared() {
        return shared.value();
      }

      /**
       * @return proton.hwinfo.disk.writespeed
       */
      public double writespeed() {
        return writespeed.value();
      }

      /**
       * @return proton.hwinfo.disk.samplewritesize
       */
      public long samplewritesize() {
        return samplewritesize.value();
      }

      /**
       * @return proton.hwinfo.disk.slowwritespeedlimit
       */
      public double slowwritespeedlimit() {
        return slowwritespeedlimit.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Disk newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("disk");
          changes.compare(this.size, newConfig.size, "size", "The size of the disk partition (in bytes) on which proton basedir is located.\nIf set to 0, the disk size is sampled by looking at the filesystem space info.\nThe disk size is used when determining if feed should be blocked in writefilter.");
          changes.compare(this.shared, newConfig.shared, "shared", "Whether the disk partition is shared among several instances of proton (e.g. when using docker).\nIf shared, disk usage is sampled by doing a recursive directory scan in proton basedir.\nIf not, disk usage is sampled by looking at the filesystem space info.");
          changes.compare(this.writespeed, newConfig.writespeed, "writespeed", "Override for disk write speed, measured in MiB/s. When zero, the\nactual disk write speed is sampled by writing data to a temporary file.");
          changes.compare(this.samplewritesize, newConfig.samplewritesize, "samplewritesize", "Amount of data to write to temporary file when sampling disk write speed.\nDefault is 1 GiB.\nTODO Check if still in use");
          changes.compare(this.slowwritespeedlimit, newConfig.slowwritespeedlimit, "slowwritespeedlimit", "Minimum write speed needed to avoid disk being considered slow.\nUnit is MiB/s, default is 100.0 MiB/s.\nTODO Check if still in use");
        return changes;
      }
    }

    /**
     * This class represents proton.hwinfo.memory
     */
    public final static class Memory extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Long size = null;

        public Builder() { }

        public Builder(Memory config) {
          size(config.size());
        }

        private Builder override(Builder __superior) {
          if (__superior.size != null)
            size(__superior.size);
          return this;
        }

        public Builder size(long __value) {
          size = __value;
          return this;
        }

        private Builder size(String __value) {
          return size(Long.valueOf(__value));
        }

        public Memory build() {
          return new Memory(this);
        }

      }

      // The size of physical memory (in bytes) available to proton.
      // If set to 0, the memory size is sampled as _SC_PHYS_PAGES * _SC_PAGESIZE by using sysconf to do the lookup.
      // The memory size is used when determining if feed should be blocked in writefilter.
      private final LongNode size;

      public Memory(Builder builder) {
        this(builder, true);
      }

      private Memory(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "proton.hwinfo.memory must be initialized: " + builder.__uninitialized);

        size = (builder.size == null) ?
            new LongNode(0L) : new LongNode(builder.size);
      }

      /**
       * @return proton.hwinfo.memory.size
       */
      public long size() {
        return size.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Memory newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("memory");
          changes.compare(this.size, newConfig.size, "size", "The size of physical memory (in bytes) available to proton.\nIf set to 0, the memory size is sampled as _SC_PHYS_PAGES * _SC_PAGESIZE by using sysconf to do the lookup.\nThe memory size is used when determining if feed should be blocked in writefilter.");
        return changes;
      }
    }

    /**
     * This class represents proton.hwinfo.cpu
     */
    public final static class Cpu extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Integer cores = null;

        public Builder() { }

        public Builder(Cpu config) {
          cores(config.cores());
        }

        private Builder override(Builder __superior) {
          if (__superior.cores != null)
            cores(__superior.cores);
          return this;
        }

        public Builder cores(int __value) {
          cores = __value;
          return this;
        }

        private Builder cores(String __value) {
          return cores(Integer.valueOf(__value));
        }

        public Cpu build() {
          return new Cpu(this);
        }

      }

      // The number of cores on the cpu.
      // If set to 0, this is sampled by using std::thread::hardware_concurrency().
      private final IntegerNode cores;

      public Cpu(Builder builder) {
        this(builder, true);
      }

      private Cpu(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "proton.hwinfo.cpu must be initialized: " + builder.__uninitialized);

        cores = (builder.cores == null) ?
            new IntegerNode(0) : new IntegerNode(builder.cores);
      }

      /**
       * @return proton.hwinfo.cpu.cores
       */
      public int cores() {
        return cores.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Cpu newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("cpu");
          changes.compare(this.cores, newConfig.cores, "cores", "The number of cores on the cpu.\nIf set to 0, this is sampled by using std::thread::hardware_concurrency().");
        return changes;
      }
    }
  }

  /**
   * This class represents proton.feeding
   */
  public final static class Feeding extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Double concurrency = null;
      private Double niceness = null;
      private Integer master_task_limit = null;

      public Builder() { }

      public Builder(Feeding config) {
        concurrency(config.concurrency());
        niceness(config.niceness());
        master_task_limit(config.master_task_limit());
      }

      private Builder override(Builder __superior) {
        if (__superior.concurrency != null)
          concurrency(__superior.concurrency);
        if (__superior.niceness != null)
          niceness(__superior.niceness);
        if (__superior.master_task_limit != null)
          master_task_limit(__superior.master_task_limit);
        return this;
      }

      public Builder concurrency(double __value) {
        concurrency = __value;
        return this;
      }

      private Builder concurrency(String __value) {
        return concurrency(Double.valueOf(__value));
      }

      public Builder niceness(double __value) {
        niceness = __value;
        return this;
      }

      private Builder niceness(String __value) {
        return niceness(Double.valueOf(__value));
      }

      public Builder master_task_limit(int __value) {
        master_task_limit = __value;
        return this;
      }

      private Builder master_task_limit(String __value) {
        return master_task_limit(Integer.valueOf(__value));
      }

      public Feeding build() {
        return new Feeding(this);
      }

    }

    // A number between 0.0 and 1.0 that specifies the concurrency when handling feed operations.
    // When set to 1.0 all cores on the cpu is utilized.
    //  
    // 3 thread pools used for various aspect of feeding are configured based on this setting:
    // 1) Basic shared thread pool. E.g. used for compressing and compacting documents.
    // 2) Warmup thread pool. Used for disk index warmup.
    // 3) Field writer thread pool. Used for writing data to document fields:
    // - Inverting index fields
    // - Writing changes to index fields
    // - Writing changes to attribute fields
    //  
    // See shared_threading_service_config.cpp for details on how the thread pool sizes are calculated.
    private final DoubleNode concurrency;
    // A number between 0.0 and 1.0 telling how nice the feed and background threads shall be.
    // A value of 0.0, which is default, means 'not any nicer than anyone else'.
    // The scale from 0.0 to 1.0 is not linear. It is OS specific.
    private final DoubleNode niceness;
    // Maximum number of pending tasks for the master thread in each document db.
    //  
    // This limit is only considered when executing tasks for handling external feed operations.
    // In that case the calling thread (persistence thread) is blocked until the master thread has capacity to handle more tasks.
    // When this limit is set to 0 it is ignored.
    // TODO Check if still in use
    private final IntegerNode master_task_limit;

    public Feeding(Builder builder) {
      this(builder, true);
    }

    private Feeding(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "proton.feeding must be initialized: " + builder.__uninitialized);

      concurrency = (builder.concurrency == null) ?
          new DoubleNode(0.2D) : new DoubleNode(builder.concurrency);
      niceness = (builder.niceness == null) ?
          new DoubleNode(0.0D) : new DoubleNode(builder.niceness);
      master_task_limit = (builder.master_task_limit == null) ?
          new IntegerNode(0) : new IntegerNode(builder.master_task_limit);
    }

    /**
     * @return proton.feeding.concurrency
     */
    public double concurrency() {
      return concurrency.value();
    }

    /**
     * @return proton.feeding.niceness
     */
    public double niceness() {
      return niceness.value();
    }

    /**
     * @return proton.feeding.master_task_limit
     */
    public int master_task_limit() {
      return master_task_limit.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Feeding newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("feeding");
        changes.compare(this.concurrency, newConfig.concurrency, "concurrency", "A number between 0.0 and 1.0 that specifies the concurrency when handling feed operations.\nWhen set to 1.0 all cores on the cpu is utilized.\n \n3 thread pools used for various aspect of feeding are configured based on this setting:\n1) Basic shared thread pool. E.g. used for compressing and compacting documents.\n2) Warmup thread pool. Used for disk index warmup.\n3) Field writer thread pool. Used for writing data to document fields:\n- Inverting index fields\n- Writing changes to index fields\n- Writing changes to attribute fields\n \nSee shared_threading_service_config.cpp for details on how the thread pool sizes are calculated.");
        changes.compare(this.niceness, newConfig.niceness, "niceness", "A number between 0.0 and 1.0 telling how nice the feed and background threads shall be.\nA value of 0.0, which is default, means 'not any nicer than anyone else'.\nThe scale from 0.0 to 1.0 is not linear. It is OS specific.");
      return changes;
    }
  }

  /**
   * This class represents proton.maintenancejobs
   */
  public final static class Maintenancejobs extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Double resourcelimitfactor = null;
      private Integer maxoutstandingmoveops = null;

      public Builder() { }

      public Builder(Maintenancejobs config) {
        resourcelimitfactor(config.resourcelimitfactor());
        maxoutstandingmoveops(config.maxoutstandingmoveops());
      }

      private Builder override(Builder __superior) {
        if (__superior.resourcelimitfactor != null)
          resourcelimitfactor(__superior.resourcelimitfactor);
        if (__superior.maxoutstandingmoveops != null)
          maxoutstandingmoveops(__superior.maxoutstandingmoveops);
        return this;
      }

      public Builder resourcelimitfactor(double __value) {
        resourcelimitfactor = __value;
        return this;
      }

      private Builder resourcelimitfactor(String __value) {
        return resourcelimitfactor(Double.valueOf(__value));
      }

      public Builder maxoutstandingmoveops(int __value) {
        maxoutstandingmoveops = __value;
        return this;
      }

      private Builder maxoutstandingmoveops(String __value) {
        return maxoutstandingmoveops(Integer.valueOf(__value));
      }

      public Maintenancejobs build() {
        return new Maintenancejobs(this);
      }

    }

    // Adjustment to resource limit when determining if maintenance jobs can run.
    //  
    // Currently used by 'lid_space_compaction' and 'move_buckets' jobs.
    private final DoubleNode resourcelimitfactor;
    // The max outstanding move operations a maintenance job can have before being blocked.
    //  
    // The job is unblocked (and executed again) when this goes under the limit again.
    // Currently used by 'lid_space_compaction' job.
    private final IntegerNode maxoutstandingmoveops;

    public Maintenancejobs(Builder builder) {
      this(builder, true);
    }

    private Maintenancejobs(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "proton.maintenancejobs must be initialized: " + builder.__uninitialized);

      resourcelimitfactor = (builder.resourcelimitfactor == null) ?
          new DoubleNode(1.05D) : new DoubleNode(builder.resourcelimitfactor);
      maxoutstandingmoveops = (builder.maxoutstandingmoveops == null) ?
          new IntegerNode(100) : new IntegerNode(builder.maxoutstandingmoveops);
    }

    /**
     * @return proton.maintenancejobs.resourcelimitfactor
     */
    public double resourcelimitfactor() {
      return resourcelimitfactor.value();
    }

    /**
     * @return proton.maintenancejobs.maxoutstandingmoveops
     */
    public int maxoutstandingmoveops() {
      return maxoutstandingmoveops.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Maintenancejobs newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("maintenancejobs");
      return changes;
    }
  }

  /**
   * This class represents proton.bucketdb
   */
  public final static class Bucketdb extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Checksumtype.Enum checksumtype = null;

      public Builder() { }

      public Builder(Bucketdb config) {
        checksumtype(config.checksumtype());
      }

      private Builder override(Builder __superior) {
        if (__superior.checksumtype != null)
          checksumtype(__superior.checksumtype);
        return this;
      }

      public Builder checksumtype(Checksumtype.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        checksumtype = __value;
        return this;
      }

      private Builder checksumtype(String __value) {
        return checksumtype(Checksumtype.Enum.valueOf(__value));
      }

      public Bucketdb build() {
        return new Bucketdb(this);
      }

    }

    // Controls the type of bucket checksum used. Do not change unless
    // in depth understanding is present.
    private final Checksumtype checksumtype;

    public Bucketdb(Builder builder) {
      this(builder, true);
    }

    private Bucketdb(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "proton.bucketdb must be initialized: " + builder.__uninitialized);

      checksumtype = (builder.checksumtype == null) ?
          new Checksumtype(Checksumtype.LEGACY) : new Checksumtype(builder.checksumtype);
    }

    /**
     * @return proton.bucketdb.checksumtype
     */
    public Checksumtype.Enum checksumtype() {
      return checksumtype.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Bucketdb newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("bucketdb");
        changes.compare(this.checksumtype, newConfig.checksumtype, "checksumtype", "Controls the type of bucket checksum used. Do not change unless\nin depth understanding is present.");
      return changes;
    }

    /**
     * This class represents proton.bucketdb.checksumtype
     * 
     * Controls the type of bucket checksum used. Do not change unless
     * in depth understanding is present.
     */
    public final static class Checksumtype extends EnumNode<Checksumtype.Enum> {

      public Checksumtype(){
        this.value = null;
      }

      public Checksumtype(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {LEGACY, XXHASH64}
      public final static Enum LEGACY = Enum.LEGACY;
      public final static Enum XXHASH64 = Enum.XXHASH64;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }
  }

  /**
   * This class represents proton.replay_throttling_policy
   */
  public final static class Replay_throttling_policy extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Type.Enum type = null;
      private Integer min_window_size = null;
      private Integer max_window_size = null;
      private Integer window_size_increment = null;
      private Long memory_usage_soft_limit_bytes = null;

      public Builder() { }

      public Builder(Replay_throttling_policy config) {
        type(config.type());
        min_window_size(config.min_window_size());
        max_window_size(config.max_window_size());
        window_size_increment(config.window_size_increment());
        memory_usage_soft_limit_bytes(config.memory_usage_soft_limit_bytes());
      }

      private Builder override(Builder __superior) {
        if (__superior.type != null)
          type(__superior.type);
        if (__superior.min_window_size != null)
          min_window_size(__superior.min_window_size);
        if (__superior.max_window_size != null)
          max_window_size(__superior.max_window_size);
        if (__superior.window_size_increment != null)
          window_size_increment(__superior.window_size_increment);
        if (__superior.memory_usage_soft_limit_bytes != null)
          memory_usage_soft_limit_bytes(__superior.memory_usage_soft_limit_bytes);
        return this;
      }

      public Builder type(Type.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        type = __value;
        return this;
      }

      private Builder type(String __value) {
        return type(Type.Enum.valueOf(__value));
      }

      public Builder min_window_size(int __value) {
        min_window_size = __value;
        return this;
      }

      private Builder min_window_size(String __value) {
        return min_window_size(Integer.valueOf(__value));
      }

      public Builder max_window_size(int __value) {
        max_window_size = __value;
        return this;
      }

      private Builder max_window_size(String __value) {
        return max_window_size(Integer.valueOf(__value));
      }

      public Builder window_size_increment(int __value) {
        window_size_increment = __value;
        return this;
      }

      private Builder window_size_increment(String __value) {
        return window_size_increment(Integer.valueOf(__value));
      }

      public Builder memory_usage_soft_limit_bytes(long __value) {
        memory_usage_soft_limit_bytes = __value;
        return this;
      }

      private Builder memory_usage_soft_limit_bytes(String __value) {
        return memory_usage_soft_limit_bytes(Long.valueOf(__value));
      }

      public Replay_throttling_policy build() {
        return new Replay_throttling_policy(this);
      }

    }

    // Chooses the throttling policy used to control the window size
    // of the SharedOperationThrottler component used by the transaction log replay feed state.
    private final Type type;
    // Only used if replay_throttling_policy.type == DYNAMIC:
    // TODO consider just hardcoding values as they have never been tuned.
    private final IntegerNode min_window_size;
    private final IntegerNode max_window_size;
    private final IntegerNode window_size_increment;
    // Iff nonzero, sets a soft limit for the amount of memory that can be concurrently
    // used during transaction log replaying. The limit is soft in that it must always
    // be possible to schedule at least one operation, even if this operation exceeds
    // the configured limit. For an operation to be replayed it must fit into the active
    // window size of the dynamic throttling policy _and_ not cause the max replay memory
    // usage limit to be violated.
    //  
    // Note that memory usage is only an estimate; the usage of any given operation uses
    // the serialized operation size as a proxy of the true memory cost of said operation.
    //  
    // A positive number specifies max memory usage in bytes.
    // A negative number specifies memory usage as a percentage of total memory.
    // A value of zero implies no enforced memory limit.
    private final LongNode memory_usage_soft_limit_bytes;

    public Replay_throttling_policy(Builder builder) {
      this(builder, true);
    }

    private Replay_throttling_policy(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "proton.replay_throttling_policy must be initialized: " + builder.__uninitialized);

      type = (builder.type == null) ?
          new Type(Type.DYNAMIC) : new Type(builder.type);
      min_window_size = (builder.min_window_size == null) ?
          new IntegerNode(100) : new IntegerNode(builder.min_window_size);
      max_window_size = (builder.max_window_size == null) ?
          new IntegerNode(10000) : new IntegerNode(builder.max_window_size);
      window_size_increment = (builder.window_size_increment == null) ?
          new IntegerNode(20) : new IntegerNode(builder.window_size_increment);
      memory_usage_soft_limit_bytes = (builder.memory_usage_soft_limit_bytes == null) ?
          new LongNode(-3L) : new LongNode(builder.memory_usage_soft_limit_bytes);
    }

    /**
     * @return proton.replay_throttling_policy.type
     */
    public Type.Enum type() {
      return type.value();
    }

    /**
     * @return proton.replay_throttling_policy.min_window_size
     */
    public int min_window_size() {
      return min_window_size.value();
    }

    /**
     * @return proton.replay_throttling_policy.max_window_size
     */
    public int max_window_size() {
      return max_window_size.value();
    }

    /**
     * @return proton.replay_throttling_policy.window_size_increment
     */
    public int window_size_increment() {
      return window_size_increment.value();
    }

    /**
     * @return proton.replay_throttling_policy.memory_usage_soft_limit_bytes
     */
    public long memory_usage_soft_limit_bytes() {
      return memory_usage_soft_limit_bytes.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Replay_throttling_policy newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("replay_throttling_policy");
      return changes;
    }

    /**
     * This class represents proton.replay_throttling_policy.type
     * 
     * Chooses the throttling policy used to control the window size
     * of the SharedOperationThrottler component used by the transaction log replay feed state.
     */
    public final static class Type extends EnumNode<Type.Enum> {

      public Type(){
        this.value = null;
      }

      public Type(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {UNLIMITED, DYNAMIC}
      public final static Enum UNLIMITED = Enum.UNLIMITED;
      public final static Enum DYNAMIC = Enum.DYNAMIC;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }
  }

  /**
   * This class represents proton.tensor_implementation
   * 
   * Specifies which tensor implementation to use for all backend code.
   *  
   * TENSOR_ENGINE (default) uses DefaultTensorEngine, which has been the production implementation for years.
   * FAST_VALUE uses the new and optimized FastValueBuilderFactory instead.
   * TODO: Remove when default has been switched to FAST_VALUE.
   */
  public final static class Tensor_implementation extends EnumNode<Tensor_implementation.Enum> {

    public Tensor_implementation(){
      this.value = null;
    }

    public Tensor_implementation(Enum enumValue) {
      super(enumValue != null);
      this.value = enumValue;
    }

    public enum Enum {TENSOR_ENGINE, FAST_VALUE}
    public final static Enum TENSOR_ENGINE = Enum.TENSOR_ENGINE;
    public final static Enum FAST_VALUE = Enum.FAST_VALUE;

    @Override
    protected boolean doSetValue(String name) {
      try {
        value = Enum.valueOf(name);
        return true;
      } catch (IllegalArgumentException e) {
      }
      return false;
    }
  }

}
