// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.search.core;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of onnx-models
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class OnnxModelsConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "9913a57d64b34a429d24117926c02b1e";
  public final static String CONFIG_DEF_NAME = "onnx-models";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.search.core";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.search.core",
    "gpu.count int default=-1",
    "model[].name string",
    "model[].fileref file",
    "model[].input[].name string",
    "model[].input[].source string",
    "model[].output[].name string",
    "model[].output[].as string",
    "model[].dry_run_on_setup bool default=false",
    "model[].stateless_execution_mode string default=\"\"",
    "model[].stateless_interop_threads int default=-1",
    "model[].stateless_intraop_threads int default=-1",
    "model[].gpu_device int default=-1",
    "model[].gpu_device_required bool default=false"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public Gpu.Builder gpu = new Gpu.Builder();
    public List<Model.Builder> model = new ArrayList<>();

    public Builder() { }

    public Builder(OnnxModelsConfig config) {
      gpu(new Gpu.Builder(config.gpu()));
      for (Model m : config.model()) {
        model(new Model.Builder(m));
      }
    }

    private Builder override(Builder __superior) {
      gpu(gpu.override(__superior.gpu));
      if (!__superior.model.isEmpty())
        model.addAll(__superior.model);
      return this;
    }

    public Builder gpu(Gpu.Builder __builder) {
      gpu = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder gpu(java.util.function.Consumer<Gpu.Builder> __func) {
      Gpu.Builder __inner = new Gpu.Builder();
      __func.accept(__inner);
      gpu = __inner;
      return this;
    }

    /**
     * Add the given builder to this builder's list of Model builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder model(Model.Builder __builder) {
      model.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder model(java.util.function.Consumer<Model.Builder> __func) {
      Model.Builder __inner = new Model.Builder();
      __func.accept(__inner);
      model.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Model builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder model(List<Model.Builder> __builders) {
      model = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public OnnxModelsConfig build() {
      return new OnnxModelsConfig(this);
    }

  }

  private final Gpu gpu;
  private final InnerNodeVector<Model> model;

  public OnnxModelsConfig(Builder builder) {
    this(builder, true);
  }

  private OnnxModelsConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "onnx-models must be initialized: " + builder.__uninitialized);

    gpu = new Gpu(builder.gpu, throwIfUninitialized);
    model = Model.createVector(builder.model);
  }

  /**
   * @return onnx-models.gpu
   */
  public Gpu gpu() {
    return gpu;
  }

  /**
   * @return onnx-models.model[]
   */
  public List<Model> model() {
    return model;
  }

  /**
   * @param i the index of the value to return
   * @return onnx-models.model[]
   */
  public Model model(int i) {
    return model.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(OnnxModelsConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("onnx-models");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents onnx-models.gpu
   */
  public final static class Gpu extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Integer count = null;

      public Builder() { }

      public Builder(Gpu config) {
        count(config.count());
      }

      private Builder override(Builder __superior) {
        if (__superior.count != null)
          count(__superior.count);
        return this;
      }

      public Builder count(int __value) {
        count = __value;
        return this;
      }

      private Builder count(String __value) {
        return count(Integer.valueOf(__value));
      }

      public Gpu build() {
        return new Gpu(this);
      }

    }

    // Number of GPUs available for ONNX evaluation, or -1 if unknown.
    private final IntegerNode count;

    public Gpu(Builder builder) {
      this(builder, true);
    }

    private Gpu(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "onnx-models.gpu must be initialized: " + builder.__uninitialized);

      count = (builder.count == null) ?
          new IntegerNode(-1) : new IntegerNode(builder.count);
    }

    /**
     * @return onnx-models.gpu.count
     */
    public int count() {
      return count.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Gpu newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("gpu");
      return changes;
    }
  }

  /**
   * This class represents onnx-models.model[]
   */
  public final static class Model extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name",
        "fileref"
        ));

      private String name = null;
      private String fileref = null;
      public List<Input.Builder> input = new ArrayList<>();
      public List<Output.Builder> output = new ArrayList<>();
      private Boolean dry_run_on_setup = null;
      private String stateless_execution_mode = null;
      private Integer stateless_interop_threads = null;
      private Integer stateless_intraop_threads = null;
      private Integer gpu_device = null;
      private Boolean gpu_device_required = null;

      public Builder() { }

      public Builder(Model config) {
        name(config.name());
        fileref(config.fileref().value());
        for (Input i : config.input()) {
          input(new Input.Builder(i));
        }
        for (Output o : config.output()) {
          output(new Output.Builder(o));
        }
        dry_run_on_setup(config.dry_run_on_setup());
        stateless_execution_mode(config.stateless_execution_mode());
        stateless_interop_threads(config.stateless_interop_threads());
        stateless_intraop_threads(config.stateless_intraop_threads());
        gpu_device(config.gpu_device());
        gpu_device_required(config.gpu_device_required());
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.fileref != null)
          fileref(__superior.fileref);
        if (!__superior.input.isEmpty())
          input.addAll(__superior.input);
        if (!__superior.output.isEmpty())
          output.addAll(__superior.output);
        if (__superior.dry_run_on_setup != null)
          dry_run_on_setup(__superior.dry_run_on_setup);
        if (__superior.stateless_execution_mode != null)
          stateless_execution_mode(__superior.stateless_execution_mode);
        if (__superior.stateless_interop_threads != null)
          stateless_interop_threads(__superior.stateless_interop_threads);
        if (__superior.stateless_intraop_threads != null)
          stateless_intraop_threads(__superior.stateless_intraop_threads);
        if (__superior.gpu_device != null)
          gpu_device(__superior.gpu_device);
        if (__superior.gpu_device_required != null)
          gpu_device_required(__superior.gpu_device_required);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder fileref(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        fileref = __value;
        __uninitialized.remove("fileref");
        return this;
      }


      /**
       * Add the given builder to this builder's list of Input builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder input(Input.Builder __builder) {
        input.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder input(java.util.function.Consumer<Input.Builder> __func) {
        Input.Builder __inner = new Input.Builder();
        __func.accept(__inner);
        input.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Input builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder input(List<Input.Builder> __builders) {
        input = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Output builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder output(Output.Builder __builder) {
        output.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder output(java.util.function.Consumer<Output.Builder> __func) {
        Output.Builder __inner = new Output.Builder();
        __func.accept(__inner);
        output.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Output builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder output(List<Output.Builder> __builders) {
        output = __builders;
        return this;
      }

      public Builder dry_run_on_setup(boolean __value) {
        dry_run_on_setup = __value;
        return this;
      }

      private Builder dry_run_on_setup(String __value) {
        return dry_run_on_setup(Boolean.valueOf(__value));
      }

      public Builder stateless_execution_mode(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        stateless_execution_mode = __value;
        return this;
      }


      public Builder stateless_interop_threads(int __value) {
        stateless_interop_threads = __value;
        return this;
      }

      private Builder stateless_interop_threads(String __value) {
        return stateless_interop_threads(Integer.valueOf(__value));
      }

      public Builder stateless_intraop_threads(int __value) {
        stateless_intraop_threads = __value;
        return this;
      }

      private Builder stateless_intraop_threads(String __value) {
        return stateless_intraop_threads(Integer.valueOf(__value));
      }

      public Builder gpu_device(int __value) {
        gpu_device = __value;
        return this;
      }

      private Builder gpu_device(String __value) {
        return gpu_device(Integer.valueOf(__value));
      }

      public Builder gpu_device_required(boolean __value) {
        gpu_device_required = __value;
        return this;
      }

      private Builder gpu_device_required(String __value) {
        return gpu_device_required(Boolean.valueOf(__value));
      }

      public Model build() {
        return new Model(this);
      }

    }

    private final StringNode name;
    private final FileNode fileref;
    private final InnerNodeVector<Input> input;
    private final InnerNodeVector<Output> output;
    private final BooleanNode dry_run_on_setup;
    private final StringNode stateless_execution_mode;
    private final IntegerNode stateless_interop_threads;
    private final IntegerNode stateless_intraop_threads;
    private final IntegerNode gpu_device;
    private final BooleanNode gpu_device_required;

    public Model(Builder builder) {
      this(builder, true);
    }

    private Model(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "onnx-models.model[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      fileref = (builder.fileref == null) ?
          new FileNode() : new FileNode(builder.fileref);
      input = Input.createVector(builder.input);
      output = Output.createVector(builder.output);
      dry_run_on_setup = (builder.dry_run_on_setup == null) ?
          new BooleanNode(false) : new BooleanNode(builder.dry_run_on_setup);
      stateless_execution_mode = (builder.stateless_execution_mode == null) ?
          new StringNode("") : new StringNode(builder.stateless_execution_mode);
      stateless_interop_threads = (builder.stateless_interop_threads == null) ?
          new IntegerNode(-1) : new IntegerNode(builder.stateless_interop_threads);
      stateless_intraop_threads = (builder.stateless_intraop_threads == null) ?
          new IntegerNode(-1) : new IntegerNode(builder.stateless_intraop_threads);
      gpu_device = (builder.gpu_device == null) ?
          new IntegerNode(-1) : new IntegerNode(builder.gpu_device);
      gpu_device_required = (builder.gpu_device_required == null) ?
          new BooleanNode(false) : new BooleanNode(builder.gpu_device_required);
    }

    /**
     * @return onnx-models.model[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return onnx-models.model[].fileref
     */
    public FileReference fileref() {
      return fileref.value();
    }

    /**
     * @return onnx-models.model[].input[]
     */
    public List<Input> input() {
      return input;
    }

    /**
     * @param i the index of the value to return
     * @return onnx-models.model[].input[]
     */
    public Input input(int i) {
      return input.get(i);
    }

    /**
     * @return onnx-models.model[].output[]
     */
    public List<Output> output() {
      return output;
    }

    /**
     * @param i the index of the value to return
     * @return onnx-models.model[].output[]
     */
    public Output output(int i) {
      return output.get(i);
    }

    /**
     * @return onnx-models.model[].dry_run_on_setup
     */
    public boolean dry_run_on_setup() {
      return dry_run_on_setup.value();
    }

    /**
     * @return onnx-models.model[].stateless_execution_mode
     */
    public String stateless_execution_mode() {
      return stateless_execution_mode.value();
    }

    /**
     * @return onnx-models.model[].stateless_interop_threads
     */
    public int stateless_interop_threads() {
      return stateless_interop_threads.value();
    }

    /**
     * @return onnx-models.model[].stateless_intraop_threads
     */
    public int stateless_intraop_threads() {
      return stateless_intraop_threads.value();
    }

    /**
     * @return onnx-models.model[].gpu_device
     */
    public int gpu_device() {
      return gpu_device.value();
    }

    /**
     * @return onnx-models.model[].gpu_device_required
     */
    public boolean gpu_device_required() {
      return gpu_device_required.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Model newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("model");
      return changes;
    }

    private static InnerNodeVector<Model> createVector(List<Builder> builders) {
        List<Model> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Model(b));
        }
        return new InnerNodeVector<Model>(elems);
    }

    /**
     * This class represents onnx-models.model[].input[]
     */
    public final static class Input extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name",
          "source"
          ));

        private String name = null;
        private String source = null;

        public Builder() { }

        public Builder(Input config) {
          name(config.name());
          source(config.source());
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          if (__superior.source != null)
            source(__superior.source);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Builder source(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          source = __value;
          __uninitialized.remove("source");
          return this;
        }


        public Input build() {
          return new Input(this);
        }

      }

      private final StringNode name;
      private final StringNode source;

      public Input(Builder builder) {
        this(builder, true);
      }

      private Input(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "onnx-models.model[].input[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        source = (builder.source == null) ?
            new StringNode() : new StringNode(builder.source);
      }

      /**
       * @return onnx-models.model[].input[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return onnx-models.model[].input[].source
       */
      public String source() {
        return source.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Input newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("input");
        return changes;
      }

      private static InnerNodeVector<Input> createVector(List<Builder> builders) {
          List<Input> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Input(b));
          }
          return new InnerNodeVector<Input>(elems);
      }
    }

    /**
     * This class represents onnx-models.model[].output[]
     */
    public final static class Output extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name",
          "as"
          ));

        private String name = null;
        private String as = null;

        public Builder() { }

        public Builder(Output config) {
          name(config.name());
          as(config.as());
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          if (__superior.as != null)
            as(__superior.as);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Builder as(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          as = __value;
          __uninitialized.remove("as");
          return this;
        }


        public Output build() {
          return new Output(this);
        }

      }

      private final StringNode name;
      private final StringNode as;

      public Output(Builder builder) {
        this(builder, true);
      }

      private Output(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "onnx-models.model[].output[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        as = (builder.as == null) ?
            new StringNode() : new StringNode(builder.as);
      }

      /**
       * @return onnx-models.model[].output[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return onnx-models.model[].output[].as
       */
      public String as() {
        return as.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Output newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("output");
        return changes;
      }

      private static InnerNodeVector<Output> createVector(List<Builder> builders) {
          List<Output> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Output(b));
          }
          return new InnerNodeVector<Output>(elems);
      }
    }
  }

}
