// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.search.core;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of hwinfo
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class HwinfoConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "5549a24b7fba7a1233af3b6f426c2d00";
  public final static String CONFIG_DEF_NAME = "hwinfo";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.search.core";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.search.core",
    "disk.writespeed double default = 0.0",
    "disk.sampletime long default = 0"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public Disk.Builder disk = new Disk.Builder();

    public Builder() { }

    public Builder(HwinfoConfig config) {
      disk(new Disk.Builder(config.disk()));
    }

    private Builder override(Builder __superior) {
      disk(disk.override(__superior.disk));
      return this;
    }

    public Builder disk(Disk.Builder __builder) {
      disk = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder disk(java.util.function.Consumer<Disk.Builder> __func) {
      Disk.Builder __inner = new Disk.Builder();
      __func.accept(__inner);
      disk = __inner;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public HwinfoConfig build() {
      return new HwinfoConfig(this);
    }

  }

  private final Disk disk;

  public HwinfoConfig(Builder builder) {
    this(builder, true);
  }

  private HwinfoConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "hwinfo must be initialized: " + builder.__uninitialized);

    disk = new Disk(builder.disk, throwIfUninitialized);
  }

  /**
   * @return hwinfo.disk
   */
  public Disk disk() {
    return disk;
  }

  private ChangesRequiringRestart getChangesRequiringRestart(HwinfoConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("hwinfo");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents hwinfo.disk
   */
  public final static class Disk extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Double writespeed = null;
      private Long sampletime = null;

      public Builder() { }

      public Builder(Disk config) {
        writespeed(config.writespeed());
        sampletime(config.sampletime());
      }

      private Builder override(Builder __superior) {
        if (__superior.writespeed != null)
          writespeed(__superior.writespeed);
        if (__superior.sampletime != null)
          sampletime(__superior.sampletime);
        return this;
      }

      public Builder writespeed(double __value) {
        writespeed = __value;
        return this;
      }

      private Builder writespeed(String __value) {
        return writespeed(Double.valueOf(__value));
      }

      public Builder sampletime(long __value) {
        sampletime = __value;
        return this;
      }

      private Builder sampletime(String __value) {
        return sampletime(Long.valueOf(__value));
      }

      public Disk build() {
        return new Disk(this);
      }

    }

    // Write speed, MiB/s, typically measured by writing 1 GiB data to disk.
    private final DoubleNode writespeed;
    // Sample time, in seconds since epoch
    private final LongNode sampletime;

    public Disk(Builder builder) {
      this(builder, true);
    }

    private Disk(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "hwinfo.disk must be initialized: " + builder.__uninitialized);

      writespeed = (builder.writespeed == null) ?
          new DoubleNode(0.0D) : new DoubleNode(builder.writespeed);
      sampletime = (builder.sampletime == null) ?
          new LongNode(0L) : new LongNode(builder.sampletime);
    }

    /**
     * @return hwinfo.disk.writespeed
     */
    public double writespeed() {
      return writespeed.value();
    }

    /**
     * @return hwinfo.disk.sampletime
     */
    public long sampletime() {
      return sampletime.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Disk newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("disk");
      return changes;
    }
  }

}
