// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.search;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of summary
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class SummaryConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "50b4b5e9c6a944cc3bf54be8a21ac67e";
  public final static String CONFIG_DEF_NAME = "summary";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.search";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.search",
    "defaultsummaryid int default=-1",
    "usev8geopositions bool default=false",
    "classes[].id int",
    "classes[].name string",
    "classes[].omitsummaryfeatures bool default=false",
    "classes[].fields[].name string",
    "classes[].fields[].command string default=\"\"",
    "classes[].fields[].source string default=\"\"",
    "classes[].fields[].elements.select enum { ALL, BY_MATCH, BY_SUMMARY_FEATURE } default=ALL",
    "classes[].fields[].elements.summary_feature string default=\"\""
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer defaultsummaryid = null;
    private Boolean usev8geopositions = null;
    public List<Classes.Builder> classes = new ArrayList<>();

    public Builder() { }

    public Builder(SummaryConfig config) {
      defaultsummaryid(config.defaultsummaryid());
      usev8geopositions(config.usev8geopositions());
      for (Classes c : config.classes()) {
        classes(new Classes.Builder(c));
      }
    }

    private Builder override(Builder __superior) {
      if (__superior.defaultsummaryid != null)
        defaultsummaryid(__superior.defaultsummaryid);
      if (__superior.usev8geopositions != null)
        usev8geopositions(__superior.usev8geopositions);
      if (!__superior.classes.isEmpty())
        classes.addAll(__superior.classes);
      return this;
    }

    public Builder defaultsummaryid(int __value) {
      defaultsummaryid = __value;
      return this;
    }

    private Builder defaultsummaryid(String __value) {
      return defaultsummaryid(Integer.valueOf(__value));
    }

    public Builder usev8geopositions(boolean __value) {
      usev8geopositions = __value;
      return this;
    }

    private Builder usev8geopositions(String __value) {
      return usev8geopositions(Boolean.valueOf(__value));
    }

    /**
     * Add the given builder to this builder's list of Classes builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder classes(Classes.Builder __builder) {
      classes.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder classes(java.util.function.Consumer<Classes.Builder> __func) {
      Classes.Builder __inner = new Classes.Builder();
      __func.accept(__inner);
      classes.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Classes builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder classes(List<Classes.Builder> __builders) {
      classes = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public SummaryConfig build() {
      return new SummaryConfig(this);
    }

  }

  private final IntegerNode defaultsummaryid;
  private final BooleanNode usev8geopositions;
  private final InnerNodeVector<Classes> classes;

  public SummaryConfig(Builder builder) {
    this(builder, true);
  }

  private SummaryConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "summary must be initialized: " + builder.__uninitialized);

    defaultsummaryid = (builder.defaultsummaryid == null) ?
        new IntegerNode(-1) : new IntegerNode(builder.defaultsummaryid);
    usev8geopositions = (builder.usev8geopositions == null) ?
        new BooleanNode(false) : new BooleanNode(builder.usev8geopositions);
    classes = Classes.createVector(builder.classes);
  }

  /**
   * @return summary.defaultsummaryid
   */
  public int defaultsummaryid() {
    return defaultsummaryid.value();
  }

  /**
   * @return summary.usev8geopositions
   */
  public boolean usev8geopositions() {
    return usev8geopositions.value();
  }

  /**
   * @return summary.classes[]
   */
  public List<Classes> classes() {
    return classes;
  }

  /**
   * @param i the index of the value to return
   * @return summary.classes[]
   */
  public Classes classes(int i) {
    return classes.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(SummaryConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("summary");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents summary.classes[]
   */
  public final static class Classes extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "id",
        "name"
        ));

      private Integer id = null;
      private String name = null;
      private Boolean omitsummaryfeatures = null;
      public List<Fields.Builder> fields = new ArrayList<>();

      public Builder() { }

      public Builder(Classes config) {
        id(config.id());
        name(config.name());
        omitsummaryfeatures(config.omitsummaryfeatures());
        for (Fields f : config.fields()) {
          fields(new Fields.Builder(f));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.id != null)
          id(__superior.id);
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.omitsummaryfeatures != null)
          omitsummaryfeatures(__superior.omitsummaryfeatures);
        if (!__superior.fields.isEmpty())
          fields.addAll(__superior.fields);
        return this;
      }

      public Builder id(int __value) {
        id = __value;
        __uninitialized.remove("id");
        return this;
      }

      private Builder id(String __value) {
        return id(Integer.valueOf(__value));
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder omitsummaryfeatures(boolean __value) {
        omitsummaryfeatures = __value;
        return this;
      }

      private Builder omitsummaryfeatures(String __value) {
        return omitsummaryfeatures(Boolean.valueOf(__value));
      }

      /**
       * Add the given builder to this builder's list of Fields builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder fields(Fields.Builder __builder) {
        fields.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder fields(java.util.function.Consumer<Fields.Builder> __func) {
        Fields.Builder __inner = new Fields.Builder();
        __func.accept(__inner);
        fields.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Fields builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder fields(List<Fields.Builder> __builders) {
        fields = __builders;
        return this;
      }

      public Classes build() {
        return new Classes(this);
      }

    }

    private final IntegerNode id;
    private final StringNode name;
    private final BooleanNode omitsummaryfeatures;
    private final InnerNodeVector<Fields> fields;

    public Classes(Builder builder) {
      this(builder, true);
    }

    private Classes(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "summary.classes[] must be initialized: " + builder.__uninitialized);

      id = (builder.id == null) ?
          new IntegerNode() : new IntegerNode(builder.id);
      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      omitsummaryfeatures = (builder.omitsummaryfeatures == null) ?
          new BooleanNode(false) : new BooleanNode(builder.omitsummaryfeatures);
      fields = Fields.createVector(builder.fields);
    }

    /**
     * @return summary.classes[].id
     */
    public int id() {
      return id.value();
    }

    /**
     * @return summary.classes[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return summary.classes[].omitsummaryfeatures
     */
    public boolean omitsummaryfeatures() {
      return omitsummaryfeatures.value();
    }

    /**
     * @return summary.classes[].fields[]
     */
    public List<Fields> fields() {
      return fields;
    }

    /**
     * @param i the index of the value to return
     * @return summary.classes[].fields[]
     */
    public Fields fields(int i) {
      return fields.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Classes newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("classes");
      return changes;
    }

    private static InnerNodeVector<Classes> createVector(List<Builder> builders) {
        List<Classes> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Classes(b));
        }
        return new InnerNodeVector<Classes>(elems);
    }

    /**
     * This class represents summary.classes[].fields[]
     */
    public final static class Fields extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name"
          ));

        private String name = null;
        private String command = null;
        private String source = null;
        public Elements.Builder elements = new Elements.Builder();

        public Builder() { }

        public Builder(Fields config) {
          name(config.name());
          command(config.command());
          source(config.source());
          elements(new Elements.Builder(config.elements()));
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          if (__superior.command != null)
            command(__superior.command);
          if (__superior.source != null)
            source(__superior.source);
          elements(elements.override(__superior.elements));
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Builder command(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          command = __value;
          return this;
        }


        public Builder source(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          source = __value;
          return this;
        }


        public Builder elements(Elements.Builder __builder) {
          elements = __builder;
          return this;
        }
        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder elements(java.util.function.Consumer<Elements.Builder> __func) {
          Elements.Builder __inner = new Elements.Builder();
          __func.accept(__inner);
          elements = __inner;
          return this;
        }

        public Fields build() {
          return new Fields(this);
        }

      }

      private final StringNode name;
      // The name of the command that is writing this field.
      // See docsumconfig.cpp for all supported commands (DocsumFieldWriter implementations).
      private final StringNode command;
      // The name of the source field used by the command.
      private final StringNode source;
      private final Elements elements;

      public Fields(Builder builder) {
        this(builder, true);
      }

      private Fields(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "summary.classes[].fields[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        command = (builder.command == null) ?
            new StringNode("") : new StringNode(builder.command);
        source = (builder.source == null) ?
            new StringNode("") : new StringNode(builder.source);
        elements = new Elements(builder.elements, throwIfUninitialized);
      }

      /**
       * @return summary.classes[].fields[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return summary.classes[].fields[].command
       */
      public String command() {
        return command.value();
      }

      /**
       * @return summary.classes[].fields[].source
       */
      public String source() {
        return source.value();
      }

      /**
       * @return summary.classes[].fields[].elements
       */
      public Elements elements() {
        return elements;
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Fields newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("fields");
        return changes;
      }

      private static InnerNodeVector<Fields> createVector(List<Builder> builders) {
          List<Fields> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Fields(b));
          }
          return new InnerNodeVector<Fields>(elems);
      }

      /**
       * This class represents summary.classes[].fields[].elements
       */
      public final static class Elements extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>();

          private Select.Enum select = null;
          private String summary_feature = null;

          public Builder() { }

          public Builder(Elements config) {
            select(config.select());
            summary_feature(config.summary_feature());
          }

          private Builder override(Builder __superior) {
            if (__superior.select != null)
              select(__superior.select);
            if (__superior.summary_feature != null)
              summary_feature(__superior.summary_feature);
            return this;
          }

          public Builder select(Select.Enum __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            select = __value;
            return this;
          }

          private Builder select(String __value) {
            return select(Select.Enum.valueOf(__value));
          }

          public Builder summary_feature(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            summary_feature = __value;
            return this;
          }


          public Elements build() {
            return new Elements(this);
          }

        }

        private final Select select;
        private final StringNode summary_feature;

        public Elements(Builder builder) {
          this(builder, true);
        }

        private Elements(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "summary.classes[].fields[].elements must be initialized: " + builder.__uninitialized);

          select = (builder.select == null) ?
              new Select(Select.ALL) : new Select(builder.select);
          summary_feature = (builder.summary_feature == null) ?
              new StringNode("") : new StringNode(builder.summary_feature);
        }

        /**
         * @return summary.classes[].fields[].elements.select
         */
        public Select.Enum select() {
          return select.value();
        }

        /**
         * @return summary.classes[].fields[].elements.summary_feature
         */
        public String summary_feature() {
          return summary_feature.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Elements newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("elements");
          return changes;
        }

        /**
         * This class represents summary.classes[].fields[].elements.select
         */
        public final static class Select extends EnumNode<Select.Enum> {

          public Select(){
            this.value = null;
          }

          public Select(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
          }

          public enum Enum {ALL, BY_MATCH, BY_SUMMARY_FEATURE}
          public final static Enum ALL = Enum.ALL;
          public final static Enum BY_MATCH = Enum.BY_MATCH;
          public final static Enum BY_SUMMARY_FEATURE = Enum.BY_SUMMARY_FEATURE;

          @Override
          protected boolean doSetValue(String name) {
            try {
              value = Enum.valueOf(name);
              return true;
            } catch (IllegalArgumentException e) {
            }
            return false;
          }
        }
      }
    }
  }

}
