// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.search;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of rank-profiles
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class RankProfilesConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "0fdf364a07547ac907946467ad09ef82";
  public final static String CONFIG_DEF_NAME = "rank-profiles";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.search";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.search",
    "rankprofile[].name string",
    "rankprofile[].fef.property[].name string",
    "rankprofile[].fef.property[].value string",
    "rankprofile[].normalizer[].name string",
    "rankprofile[].normalizer[].input string",
    "rankprofile[].normalizer[].algo enum { LINEAR, RRANK } default=LINEAR",
    "rankprofile[].normalizer[].kparam double default=60.0"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Rankprofile.Builder> rankprofile = new ArrayList<>();

    public Builder() { }

    public Builder(RankProfilesConfig config) {
      for (Rankprofile r : config.rankprofile()) {
        rankprofile(new Rankprofile.Builder(r));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.rankprofile.isEmpty())
        rankprofile.addAll(__superior.rankprofile);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Rankprofile builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder rankprofile(Rankprofile.Builder __builder) {
      rankprofile.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder rankprofile(java.util.function.Consumer<Rankprofile.Builder> __func) {
      Rankprofile.Builder __inner = new Rankprofile.Builder();
      __func.accept(__inner);
      rankprofile.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Rankprofile builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder rankprofile(List<Rankprofile.Builder> __builders) {
      rankprofile = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public RankProfilesConfig build() {
      return new RankProfilesConfig(this);
    }

  }

  private final InnerNodeVector<Rankprofile> rankprofile;

  public RankProfilesConfig(Builder builder) {
    this(builder, true);
  }

  private RankProfilesConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "rank-profiles must be initialized: " + builder.__uninitialized);

    rankprofile = Rankprofile.createVector(builder.rankprofile);
  }

  /**
   * @return rank-profiles.rankprofile[]
   */
  public List<Rankprofile> rankprofile() {
    return rankprofile;
  }

  /**
   * @param i the index of the value to return
   * @return rank-profiles.rankprofile[]
   */
  public Rankprofile rankprofile(int i) {
    return rankprofile.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(RankProfilesConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("rank-profiles");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents rank-profiles.rankprofile[]
   */
  public final static class Rankprofile extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name"
        ));

      private String name = null;
      public Fef.Builder fef = new Fef.Builder();
      public List<Normalizer.Builder> normalizer = new ArrayList<>();

      public Builder() { }

      public Builder(Rankprofile config) {
        name(config.name());
        fef(new Fef.Builder(config.fef()));
        for (Normalizer n : config.normalizer()) {
          normalizer(new Normalizer.Builder(n));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        fef(fef.override(__superior.fef));
        if (!__superior.normalizer.isEmpty())
          normalizer.addAll(__superior.normalizer);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder fef(Fef.Builder __builder) {
        fef = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder fef(java.util.function.Consumer<Fef.Builder> __func) {
        Fef.Builder __inner = new Fef.Builder();
        __func.accept(__inner);
        fef = __inner;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Normalizer builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder normalizer(Normalizer.Builder __builder) {
        normalizer.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder normalizer(java.util.function.Consumer<Normalizer.Builder> __func) {
        Normalizer.Builder __inner = new Normalizer.Builder();
        __func.accept(__inner);
        normalizer.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Normalizer builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder normalizer(List<Normalizer.Builder> __builders) {
        normalizer = __builders;
        return this;
      }

      public Rankprofile build() {
        return new Rankprofile(this);
      }

    }

    // name of this rank profile. maps to table index for internal use.
    private final StringNode name;
    private final Fef fef;
    private final InnerNodeVector<Normalizer> normalizer;

    public Rankprofile(Builder builder) {
      this(builder, true);
    }

    private Rankprofile(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "rank-profiles.rankprofile[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      fef = new Fef(builder.fef, throwIfUninitialized);
      normalizer = Normalizer.createVector(builder.normalizer);
    }

    /**
     * @return rank-profiles.rankprofile[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return rank-profiles.rankprofile[].fef
     */
    public Fef fef() {
      return fef;
    }

    /**
     * @return rank-profiles.rankprofile[].normalizer[]
     */
    public List<Normalizer> normalizer() {
      return normalizer;
    }

    /**
     * @param i the index of the value to return
     * @return rank-profiles.rankprofile[].normalizer[]
     */
    public Normalizer normalizer(int i) {
      return normalizer.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Rankprofile newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("rankprofile");
      return changes;
    }

    private static InnerNodeVector<Rankprofile> createVector(List<Builder> builders) {
        List<Rankprofile> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Rankprofile(b));
        }
        return new InnerNodeVector<Rankprofile>(elems);
    }

    /**
     * This class represents rank-profiles.rankprofile[].fef
     */
    public final static class Fef extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        public List<Property.Builder> property = new ArrayList<>();

        public Builder() { }

        public Builder(Fef config) {
          for (Property p : config.property()) {
            property(new Property.Builder(p));
          }
        }

        private Builder override(Builder __superior) {
          if (!__superior.property.isEmpty())
            property.addAll(__superior.property);
          return this;
        }

        /**
         * Add the given builder to this builder's list of Property builders
         * @param __builder a builder
         * @return this builder
         */
        public Builder property(Property.Builder __builder) {
          property.add(__builder);
          return this;
        }

        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder property(java.util.function.Consumer<Property.Builder> __func) {
          Property.Builder __inner = new Property.Builder();
          __func.accept(__inner);
          property.add(__inner);
          return this;
        }

        /**
         * Set the given list as this builder's list of Property builders
         * @param __builders a list of builders
         * @return this builder
         */
        public Builder property(List<Property.Builder> __builders) {
          property = __builders;
          return this;
        }

        public Fef build() {
          return new Fef(this);
        }

      }

      private final InnerNodeVector<Property> property;

      public Fef(Builder builder) {
        this(builder, true);
      }

      private Fef(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "rank-profiles.rankprofile[].fef must be initialized: " + builder.__uninitialized);

        property = Property.createVector(builder.property);
      }

      /**
       * @return rank-profiles.rankprofile[].fef.property[]
       */
      public List<Property> property() {
        return property;
      }

      /**
       * @param i the index of the value to return
       * @return rank-profiles.rankprofile[].fef.property[]
       */
      public Property property(int i) {
        return property.get(i);
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Fef newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("fef");
        return changes;
      }

      /**
       * This class represents rank-profiles.rankprofile[].fef.property[]
       */
      public final static class Property extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>(List.of(
            "name",
            "value"
            ));

          private String name = null;
          private String value = null;

          public Builder() { }

          public Builder(Property config) {
            name(config.name());
            value(config.value());
          }

          private Builder override(Builder __superior) {
            if (__superior.name != null)
              name(__superior.name);
            if (__superior.value != null)
              value(__superior.value);
            return this;
          }

          public Builder name(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            name = __value;
            __uninitialized.remove("name");
            return this;
          }


          public Builder value(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            value = __value;
            __uninitialized.remove("value");
            return this;
          }


          public Property build() {
            return new Property(this);
          }

        }

        // the name of a generic property available to the feature execution framework and feature plugins
        private final StringNode name;
        // the value of a generic property available to feature plugins
        private final StringNode value;

        public Property(Builder builder) {
          this(builder, true);
        }

        private Property(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "rank-profiles.rankprofile[].fef.property[] must be initialized: " + builder.__uninitialized);

          name = (builder.name == null) ?
              new StringNode() : new StringNode(builder.name);
          value = (builder.value == null) ?
              new StringNode() : new StringNode(builder.value);
        }

        /**
         * @return rank-profiles.rankprofile[].fef.property[].name
         */
        public String name() {
          return name.value();
        }

        /**
         * @return rank-profiles.rankprofile[].fef.property[].value
         */
        public String value() {
          return value.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Property newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("property");
          return changes;
        }

        private static InnerNodeVector<Property> createVector(List<Builder> builders) {
            List<Property> elems = new ArrayList<>();
            for (Builder b : builders) {
                elems.add(new Property(b));
            }
            return new InnerNodeVector<Property>(elems);
        }
      }
    }

    /**
     * This class represents rank-profiles.rankprofile[].normalizer[]
     */
    public final static class Normalizer extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name",
          "input"
          ));

        private String name = null;
        private String input = null;
        private Algo.Enum algo = null;
        private Double kparam = null;

        public Builder() { }

        public Builder(Normalizer config) {
          name(config.name());
          input(config.input());
          algo(config.algo());
          kparam(config.kparam());
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          if (__superior.input != null)
            input(__superior.input);
          if (__superior.algo != null)
            algo(__superior.algo);
          if (__superior.kparam != null)
            kparam(__superior.kparam);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Builder input(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          input = __value;
          __uninitialized.remove("input");
          return this;
        }


        public Builder algo(Algo.Enum __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          algo = __value;
          return this;
        }

        private Builder algo(String __value) {
          return algo(Algo.Enum.valueOf(__value));
        }

        public Builder kparam(double __value) {
          kparam = __value;
          return this;
        }

        private Builder kparam(String __value) {
          return kparam(Double.valueOf(__value));
        }

        public Normalizer build() {
          return new Normalizer(this);
        }

      }

      // output from cross-hits normalizing function
      private final StringNode name;
      // input to cross-hits normalizing function
      private final StringNode input;
      // type of cross-hits normalizing function
      private final Algo algo;
      // extra "k" param (if applicable)
      private final DoubleNode kparam;

      public Normalizer(Builder builder) {
        this(builder, true);
      }

      private Normalizer(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "rank-profiles.rankprofile[].normalizer[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        input = (builder.input == null) ?
            new StringNode() : new StringNode(builder.input);
        algo = (builder.algo == null) ?
            new Algo(Algo.LINEAR) : new Algo(builder.algo);
        kparam = (builder.kparam == null) ?
            new DoubleNode(60.0D) : new DoubleNode(builder.kparam);
      }

      /**
       * @return rank-profiles.rankprofile[].normalizer[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return rank-profiles.rankprofile[].normalizer[].input
       */
      public String input() {
        return input.value();
      }

      /**
       * @return rank-profiles.rankprofile[].normalizer[].algo
       */
      public Algo.Enum algo() {
        return algo.value();
      }

      /**
       * @return rank-profiles.rankprofile[].normalizer[].kparam
       */
      public double kparam() {
        return kparam.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Normalizer newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("normalizer");
        return changes;
      }

      private static InnerNodeVector<Normalizer> createVector(List<Builder> builders) {
          List<Normalizer> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Normalizer(b));
          }
          return new InnerNodeVector<Normalizer>(elems);
      }

      /**
       * This class represents rank-profiles.rankprofile[].normalizer[].algo
       * 
       * type of cross-hits normalizing function
       */
      public final static class Algo extends EnumNode<Algo.Enum> {

        public Algo(){
          this.value = null;
        }

        public Algo(Enum enumValue) {
          super(enumValue != null);
          this.value = enumValue;
        }

        public enum Enum {LINEAR, RRANK}
        public final static Enum LINEAR = Enum.LINEAR;
        public final static Enum RRANK = Enum.RRANK;

        @Override
        protected boolean doSetValue(String name) {
          try {
            value = Enum.valueOf(name);
            return true;
          } catch (IllegalArgumentException e) {
          }
          return false;
        }
      }
    }
  }

}
