// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.search;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of indexschema
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 * Config specifying the index fields and field collections that are part of an index schema.
 */
public final class IndexschemaConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "3f4a875b74c4ef2e4ffe929c7172fdeb";
  public final static String CONFIG_DEF_NAME = "indexschema";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.search";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.search",
    "indexfield[].name string",
    "indexfield[].datatype enum { STRING, INT64 } default=STRING",
    "indexfield[].collectiontype enum { SINGLE, ARRAY, WEIGHTEDSET } default=SINGLE",
    "indexfield[].prefix bool default=false",
    "indexfield[].phrases bool default=false",
    "indexfield[].positions bool default=true",
    "indexfield[].averageelementlen int default=512",
    "indexfield[].interleavedfeatures bool default=false",
    "fieldset[].name string",
    "fieldset[].field[].name string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Indexfield.Builder> indexfield = new ArrayList<>();
    public List<Fieldset.Builder> fieldset = new ArrayList<>();

    public Builder() { }

    public Builder(IndexschemaConfig config) {
      for (Indexfield i : config.indexfield()) {
        indexfield(new Indexfield.Builder(i));
      }
      for (Fieldset f : config.fieldset()) {
        fieldset(new Fieldset.Builder(f));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.indexfield.isEmpty())
        indexfield.addAll(__superior.indexfield);
      if (!__superior.fieldset.isEmpty())
        fieldset.addAll(__superior.fieldset);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Indexfield builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder indexfield(Indexfield.Builder __builder) {
      indexfield.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder indexfield(java.util.function.Consumer<Indexfield.Builder> __func) {
      Indexfield.Builder __inner = new Indexfield.Builder();
      __func.accept(__inner);
      indexfield.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Indexfield builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder indexfield(List<Indexfield.Builder> __builders) {
      indexfield = __builders;
      return this;
    }

    /**
     * Add the given builder to this builder's list of Fieldset builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder fieldset(Fieldset.Builder __builder) {
      fieldset.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder fieldset(java.util.function.Consumer<Fieldset.Builder> __func) {
      Fieldset.Builder __inner = new Fieldset.Builder();
      __func.accept(__inner);
      fieldset.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Fieldset builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder fieldset(List<Fieldset.Builder> __builders) {
      fieldset = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public IndexschemaConfig build() {
      return new IndexschemaConfig(this);
    }

  }

  private final InnerNodeVector<Indexfield> indexfield;
  private final InnerNodeVector<Fieldset> fieldset;

  public IndexschemaConfig(Builder builder) {
    this(builder, true);
  }

  private IndexschemaConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "indexschema must be initialized: " + builder.__uninitialized);

    indexfield = Indexfield.createVector(builder.indexfield);
    fieldset = Fieldset.createVector(builder.fieldset);
  }

  /**
   * @return indexschema.indexfield[]
   */
  public List<Indexfield> indexfield() {
    return indexfield;
  }

  /**
   * @param i the index of the value to return
   * @return indexschema.indexfield[]
   */
  public Indexfield indexfield(int i) {
    return indexfield.get(i);
  }

  /**
   * @return indexschema.fieldset[]
   */
  public List<Fieldset> fieldset() {
    return fieldset;
  }

  /**
   * @param i the index of the value to return
   * @return indexschema.fieldset[]
   */
  public Fieldset fieldset(int i) {
    return fieldset.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(IndexschemaConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("indexschema");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents indexschema.indexfield[]
   */
  public final static class Indexfield extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name"
        ));

      private String name = null;
      private Datatype.Enum datatype = null;
      private Collectiontype.Enum collectiontype = null;
      private Boolean prefix = null;
      private Boolean phrases = null;
      private Boolean positions = null;
      private Integer averageelementlen = null;
      private Boolean interleavedfeatures = null;

      public Builder() { }

      public Builder(Indexfield config) {
        name(config.name());
        datatype(config.datatype());
        collectiontype(config.collectiontype());
        prefix(config.prefix());
        phrases(config.phrases());
        positions(config.positions());
        averageelementlen(config.averageelementlen());
        interleavedfeatures(config.interleavedfeatures());
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.datatype != null)
          datatype(__superior.datatype);
        if (__superior.collectiontype != null)
          collectiontype(__superior.collectiontype);
        if (__superior.prefix != null)
          prefix(__superior.prefix);
        if (__superior.phrases != null)
          phrases(__superior.phrases);
        if (__superior.positions != null)
          positions(__superior.positions);
        if (__superior.averageelementlen != null)
          averageelementlen(__superior.averageelementlen);
        if (__superior.interleavedfeatures != null)
          interleavedfeatures(__superior.interleavedfeatures);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder datatype(Datatype.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        datatype = __value;
        return this;
      }

      private Builder datatype(String __value) {
        return datatype(Datatype.Enum.valueOf(__value));
      }

      public Builder collectiontype(Collectiontype.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        collectiontype = __value;
        return this;
      }

      private Builder collectiontype(String __value) {
        return collectiontype(Collectiontype.Enum.valueOf(__value));
      }

      public Builder prefix(boolean __value) {
        prefix = __value;
        return this;
      }

      private Builder prefix(String __value) {
        return prefix(Boolean.valueOf(__value));
      }

      public Builder phrases(boolean __value) {
        phrases = __value;
        return this;
      }

      private Builder phrases(String __value) {
        return phrases(Boolean.valueOf(__value));
      }

      public Builder positions(boolean __value) {
        positions = __value;
        return this;
      }

      private Builder positions(String __value) {
        return positions(Boolean.valueOf(__value));
      }

      public Builder averageelementlen(int __value) {
        averageelementlen = __value;
        return this;
      }

      private Builder averageelementlen(String __value) {
        return averageelementlen(Integer.valueOf(__value));
      }

      public Builder interleavedfeatures(boolean __value) {
        interleavedfeatures = __value;
        return this;
      }

      private Builder interleavedfeatures(String __value) {
        return interleavedfeatures(Boolean.valueOf(__value));
      }

      public Indexfield build() {
        return new Indexfield(this);
      }

    }

    // The name of the index field.
    private final StringNode name;
    // The data type of the index field.
    private final Datatype datatype;
    // The collection type of the index field.
    private final Collectiontype collectiontype;
    // Whether the index should support prefix searches.
    private final BooleanNode prefix;
    // Whether the index should support phrase searches.
    private final BooleanNode phrases;
    // Whether the index should have posting lists with word positions.
    private final BooleanNode positions;
    // Average element length
    private final IntegerNode averageelementlen;
    // Whether the index field should use posting lists with interleaved features or not.
    private final BooleanNode interleavedfeatures;

    public Indexfield(Builder builder) {
      this(builder, true);
    }

    private Indexfield(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "indexschema.indexfield[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      datatype = (builder.datatype == null) ?
          new Datatype(Datatype.STRING) : new Datatype(builder.datatype);
      collectiontype = (builder.collectiontype == null) ?
          new Collectiontype(Collectiontype.SINGLE) : new Collectiontype(builder.collectiontype);
      prefix = (builder.prefix == null) ?
          new BooleanNode(false) : new BooleanNode(builder.prefix);
      phrases = (builder.phrases == null) ?
          new BooleanNode(false) : new BooleanNode(builder.phrases);
      positions = (builder.positions == null) ?
          new BooleanNode(true) : new BooleanNode(builder.positions);
      averageelementlen = (builder.averageelementlen == null) ?
          new IntegerNode(512) : new IntegerNode(builder.averageelementlen);
      interleavedfeatures = (builder.interleavedfeatures == null) ?
          new BooleanNode(false) : new BooleanNode(builder.interleavedfeatures);
    }

    /**
     * @return indexschema.indexfield[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return indexschema.indexfield[].datatype
     */
    public Datatype.Enum datatype() {
      return datatype.value();
    }

    /**
     * @return indexschema.indexfield[].collectiontype
     */
    public Collectiontype.Enum collectiontype() {
      return collectiontype.value();
    }

    /**
     * @return indexschema.indexfield[].prefix
     */
    public boolean prefix() {
      return prefix.value();
    }

    /**
     * @return indexschema.indexfield[].phrases
     */
    public boolean phrases() {
      return phrases.value();
    }

    /**
     * @return indexschema.indexfield[].positions
     */
    public boolean positions() {
      return positions.value();
    }

    /**
     * @return indexschema.indexfield[].averageelementlen
     */
    public int averageelementlen() {
      return averageelementlen.value();
    }

    /**
     * @return indexschema.indexfield[].interleavedfeatures
     */
    public boolean interleavedfeatures() {
      return interleavedfeatures.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Indexfield newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("indexfield");
      return changes;
    }

    private static InnerNodeVector<Indexfield> createVector(List<Builder> builders) {
        List<Indexfield> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Indexfield(b));
        }
        return new InnerNodeVector<Indexfield>(elems);
    }

    /**
     * This class represents indexschema.indexfield[].datatype
     * 
     * The data type of the index field.
     */
    public final static class Datatype extends EnumNode<Datatype.Enum> {

      public Datatype(){
        this.value = null;
      }

      public Datatype(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {STRING, INT64}
      public final static Enum STRING = Enum.STRING;
      public final static Enum INT64 = Enum.INT64;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }

    /**
     * This class represents indexschema.indexfield[].collectiontype
     * 
     * The collection type of the index field.
     */
    public final static class Collectiontype extends EnumNode<Collectiontype.Enum> {

      public Collectiontype(){
        this.value = null;
      }

      public Collectiontype(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {SINGLE, ARRAY, WEIGHTEDSET}
      public final static Enum SINGLE = Enum.SINGLE;
      public final static Enum ARRAY = Enum.ARRAY;
      public final static Enum WEIGHTEDSET = Enum.WEIGHTEDSET;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }
  }

  /**
   * This class represents indexschema.fieldset[]
   */
  public final static class Fieldset extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name"
        ));

      private String name = null;
      public List<Field.Builder> field = new ArrayList<>();

      public Builder() { }

      public Builder(Fieldset config) {
        name(config.name());
        for (Field f : config.field()) {
          field(new Field.Builder(f));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (!__superior.field.isEmpty())
          field.addAll(__superior.field);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      /**
       * Add the given builder to this builder's list of Field builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder field(Field.Builder __builder) {
        field.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder field(java.util.function.Consumer<Field.Builder> __func) {
        Field.Builder __inner = new Field.Builder();
        __func.accept(__inner);
        field.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Field builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder field(List<Field.Builder> __builders) {
        field = __builders;
        return this;
      }

      public Fieldset build() {
        return new Fieldset(this);
      }

    }

    // The name of the field collection (aka logical view).
    private final StringNode name;
    private final InnerNodeVector<Field> field;

    public Fieldset(Builder builder) {
      this(builder, true);
    }

    private Fieldset(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "indexschema.fieldset[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      field = Field.createVector(builder.field);
    }

    /**
     * @return indexschema.fieldset[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return indexschema.fieldset[].field[]
     */
    public List<Field> field() {
      return field;
    }

    /**
     * @param i the index of the value to return
     * @return indexschema.fieldset[].field[]
     */
    public Field field(int i) {
      return field.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Fieldset newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("fieldset");
      return changes;
    }

    private static InnerNodeVector<Fieldset> createVector(List<Builder> builders) {
        List<Fieldset> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Fieldset(b));
        }
        return new InnerNodeVector<Fieldset>(elems);
    }

    /**
     * This class represents indexschema.fieldset[].field[]
     */
    public final static class Field extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name"
          ));

        private String name = null;

        public Builder() { }

        public Builder(Field config) {
          name(config.name());
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Field build() {
          return new Field(this);
        }

      }

      // The name of the index field that are part of this collection.
      private final StringNode name;

      public Field(Builder builder) {
        this(builder, true);
      }

      private Field(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "indexschema.fieldset[].field[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
      }

      /**
       * @return indexschema.fieldset[].field[].name
       */
      public String name() {
        return name.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Field newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("field");
        return changes;
      }

      private static InnerNodeVector<Field> createVector(List<Builder> builders) {
          List<Field> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Field(b));
          }
          return new InnerNodeVector<Field>(elems);
      }
    }
  }

}
