// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.search;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of imported-fields
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class ImportedFieldsConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "baa648b23e7f979b8c809e5a5f2cd42b";
  public final static String CONFIG_DEF_NAME = "imported-fields";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.search";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.search",
    "attribute[].name string",
    "attribute[].referencefield string",
    "attribute[].targetfield string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Attribute.Builder> attribute = new ArrayList<>();

    public Builder() { }

    public Builder(ImportedFieldsConfig config) {
      for (Attribute a : config.attribute()) {
        attribute(new Attribute.Builder(a));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.attribute.isEmpty())
        attribute.addAll(__superior.attribute);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Attribute builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder attribute(Attribute.Builder __builder) {
      attribute.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder attribute(java.util.function.Consumer<Attribute.Builder> __func) {
      Attribute.Builder __inner = new Attribute.Builder();
      __func.accept(__inner);
      attribute.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Attribute builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder attribute(List<Attribute.Builder> __builders) {
      attribute = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ImportedFieldsConfig build() {
      return new ImportedFieldsConfig(this);
    }

  }

  private final InnerNodeVector<Attribute> attribute;

  public ImportedFieldsConfig(Builder builder) {
    this(builder, true);
  }

  private ImportedFieldsConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "imported-fields must be initialized: " + builder.__uninitialized);

    attribute = Attribute.createVector(builder.attribute);
  }

  /**
   * @return imported-fields.attribute[]
   */
  public List<Attribute> attribute() {
    return attribute;
  }

  /**
   * @param i the index of the value to return
   * @return imported-fields.attribute[]
   */
  public Attribute attribute(int i) {
    return attribute.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ImportedFieldsConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("imported-fields");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents imported-fields.attribute[]
   */
  public final static class Attribute extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name",
        "referencefield",
        "targetfield"
        ));

      private String name = null;
      private String referencefield = null;
      private String targetfield = null;

      public Builder() { }

      public Builder(Attribute config) {
        name(config.name());
        referencefield(config.referencefield());
        targetfield(config.targetfield());
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.referencefield != null)
          referencefield(__superior.referencefield);
        if (__superior.targetfield != null)
          targetfield(__superior.targetfield);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder referencefield(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        referencefield = __value;
        __uninitialized.remove("referencefield");
        return this;
      }


      public Builder targetfield(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        targetfield = __value;
        __uninitialized.remove("targetfield");
        return this;
      }


      public Attribute build() {
        return new Attribute(this);
      }

    }

    // The name of an imported attribute field in context of this document type.
    private final StringNode name;
    // The name of the field (in this document type) that refers to a parent document type.
    private final StringNode referencefield;
    // The name of the target attribute field in the parent document type that is imported into this document type.
    private final StringNode targetfield;

    public Attribute(Builder builder) {
      this(builder, true);
    }

    private Attribute(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "imported-fields.attribute[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      referencefield = (builder.referencefield == null) ?
          new StringNode() : new StringNode(builder.referencefield);
      targetfield = (builder.targetfield == null) ?
          new StringNode() : new StringNode(builder.targetfield);
    }

    /**
     * @return imported-fields.attribute[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return imported-fields.attribute[].referencefield
     */
    public String referencefield() {
      return referencefield.value();
    }

    /**
     * @return imported-fields.attribute[].targetfield
     */
    public String targetfield() {
      return targetfield.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Attribute newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("attribute");
      return changes;
    }

    private static InnerNodeVector<Attribute> createVector(List<Builder> builders) {
        List<Attribute> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Attribute(b));
        }
        return new InnerNodeVector<Attribute>(elems);
    }
  }

}
