// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.search;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of dispatch-nodes
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 * List of nodes in a search cluster to dispatch to.
 */
public final class DispatchNodesConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "de348ed663f532c8bfb79fa82ab85566";
  public final static String CONFIG_DEF_NAME = "dispatch-nodes";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.search";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.search",
    "node[].key int",
    "node[].group int default=0",
    "node[].host string",
    "node[].port int"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Node.Builder> node = new ArrayList<>();

    public Builder() { }

    public Builder(DispatchNodesConfig config) {
      for (Node n : config.node()) {
        node(new Node.Builder(n));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.node.isEmpty())
        node.addAll(__superior.node);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Node builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder node(Node.Builder __builder) {
      node.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder node(java.util.function.Consumer<Node.Builder> __func) {
      Node.Builder __inner = new Node.Builder();
      __func.accept(__inner);
      node.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Node builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder node(List<Node.Builder> __builders) {
      node = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public DispatchNodesConfig build() {
      return new DispatchNodesConfig(this);
    }

  }

  private final InnerNodeVector<Node> node;

  public DispatchNodesConfig(Builder builder) {
    this(builder, true);
  }

  private DispatchNodesConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "dispatch-nodes must be initialized: " + builder.__uninitialized);

    node = Node.createVector(builder.node);
  }

  /**
   * @return dispatch-nodes.node[]
   */
  public List<Node> node() {
    return node;
  }

  /**
   * @param i the index of the value to return
   * @return dispatch-nodes.node[]
   */
  public Node node(int i) {
    return node.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(DispatchNodesConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("dispatch-nodes");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents dispatch-nodes.node[]
   */
  public final static class Node extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "key",
        "host",
        "port"
        ));

      private Integer key = null;
      private Integer group = null;
      private String host = null;
      private Integer port = null;

      public Builder() { }

      public Builder(Node config) {
        key(config.key());
        group(config.group());
        host(config.host());
        port(config.port());
      }

      private Builder override(Builder __superior) {
        if (__superior.key != null)
          key(__superior.key);
        if (__superior.group != null)
          group(__superior.group);
        if (__superior.host != null)
          host(__superior.host);
        if (__superior.port != null)
          port(__superior.port);
        return this;
      }

      public Builder key(int __value) {
        key = __value;
        __uninitialized.remove("key");
        return this;
      }

      private Builder key(String __value) {
        return key(Integer.valueOf(__value));
      }

      public Builder group(int __value) {
        group = __value;
        return this;
      }

      private Builder group(String __value) {
        return group(Integer.valueOf(__value));
      }

      public Builder host(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        host = __value;
        __uninitialized.remove("host");
        return this;
      }


      public Builder port(int __value) {
        port = __value;
        __uninitialized.remove("port");
        return this;
      }

      private Builder port(String __value) {
        return port(Integer.valueOf(__value));
      }

      public Node build() {
        return new Node(this);
      }

    }

    // The unique key of a search node
    private final IntegerNode key;
    // The index of the group this search node belongs to
    private final IntegerNode group;
    // The host name of this search node
    private final StringNode host;
    // The rpc port of this search node
    private final IntegerNode port;

    public Node(Builder builder) {
      this(builder, true);
    }

    private Node(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "dispatch-nodes.node[] must be initialized: " + builder.__uninitialized);

      key = (builder.key == null) ?
          new IntegerNode() : new IntegerNode(builder.key);
      group = (builder.group == null) ?
          new IntegerNode(0) : new IntegerNode(builder.group);
      host = (builder.host == null) ?
          new StringNode() : new StringNode(builder.host);
      port = (builder.port == null) ?
          new IntegerNode() : new IntegerNode(builder.port);
    }

    /**
     * @return dispatch-nodes.node[].key
     */
    public int key() {
      return key.value();
    }

    /**
     * @return dispatch-nodes.node[].group
     */
    public int group() {
      return group.value();
    }

    /**
     * @return dispatch-nodes.node[].host
     */
    public String host() {
      return host.value();
    }

    /**
     * @return dispatch-nodes.node[].port
     */
    public int port() {
      return port.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Node newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("node");
      return changes;
    }

    private static InnerNodeVector<Node> createVector(List<Builder> builders) {
        List<Node> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Node(b));
        }
        return new InnerNodeVector<Node>(elems);
    }
  }

}
