// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.search;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of dispatch
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 * Configuration of dispatch from container nodes to search clusters
 */
public final class DispatchConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "f96bcd0a6eeac76df18b64691494969e";
  public final static String CONFIG_DEF_NAME = "dispatch";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.search";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.search",
    "prioritizeAvailability bool default=true",
    "minActivedocsPercentage double default=97.0",
    "distributionPolicy enum { ROUNDROBIN, BEST_OF_RANDOM_2, LATENCY_AMORTIZED_OVER_REQUESTS, LATENCY_AMORTIZED_OVER_TIME, ADAPTIVE } default=ADAPTIVE",
    "maxHitsPerNode int default=2147483647",
    "topKProbability double default=0.9999",
    "redundancy long default=1",
    "minSearchCoverage double default=100",
    "minWaitAfterCoverageFactor double default=0",
    "maxWaitAfterCoverageFactor double default=1",
    "numJrtTransportThreads int default=8",
    "numJrtConnectionsPerNode int default=8",
    "warmuptime double default=0.1",
    "summaryDecodePolicy enum {EAGER, ONDEMAND} default=ONDEMAND"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Boolean prioritizeAvailability = null;
    private Double minActivedocsPercentage = null;
    private DistributionPolicy.Enum distributionPolicy = null;
    private Integer maxHitsPerNode = null;
    private Double topKProbability = null;
    private Long redundancy = null;
    private Double minSearchCoverage = null;
    private Double minWaitAfterCoverageFactor = null;
    private Double maxWaitAfterCoverageFactor = null;
    private Integer numJrtTransportThreads = null;
    private Integer numJrtConnectionsPerNode = null;
    private Double warmuptime = null;
    private SummaryDecodePolicy.Enum summaryDecodePolicy = null;

    public Builder() { }

    public Builder(DispatchConfig config) {
      prioritizeAvailability(config.prioritizeAvailability());
      minActivedocsPercentage(config.minActivedocsPercentage());
      distributionPolicy(config.distributionPolicy());
      maxHitsPerNode(config.maxHitsPerNode());
      topKProbability(config.topKProbability());
      redundancy(config.redundancy());
      minSearchCoverage(config.minSearchCoverage());
      minWaitAfterCoverageFactor(config.minWaitAfterCoverageFactor());
      maxWaitAfterCoverageFactor(config.maxWaitAfterCoverageFactor());
      numJrtTransportThreads(config.numJrtTransportThreads());
      numJrtConnectionsPerNode(config.numJrtConnectionsPerNode());
      warmuptime(config.warmuptime());
      summaryDecodePolicy(config.summaryDecodePolicy());
    }

    private Builder override(Builder __superior) {
      if (__superior.prioritizeAvailability != null)
        prioritizeAvailability(__superior.prioritizeAvailability);
      if (__superior.minActivedocsPercentage != null)
        minActivedocsPercentage(__superior.minActivedocsPercentage);
      if (__superior.distributionPolicy != null)
        distributionPolicy(__superior.distributionPolicy);
      if (__superior.maxHitsPerNode != null)
        maxHitsPerNode(__superior.maxHitsPerNode);
      if (__superior.topKProbability != null)
        topKProbability(__superior.topKProbability);
      if (__superior.redundancy != null)
        redundancy(__superior.redundancy);
      if (__superior.minSearchCoverage != null)
        minSearchCoverage(__superior.minSearchCoverage);
      if (__superior.minWaitAfterCoverageFactor != null)
        minWaitAfterCoverageFactor(__superior.minWaitAfterCoverageFactor);
      if (__superior.maxWaitAfterCoverageFactor != null)
        maxWaitAfterCoverageFactor(__superior.maxWaitAfterCoverageFactor);
      if (__superior.numJrtTransportThreads != null)
        numJrtTransportThreads(__superior.numJrtTransportThreads);
      if (__superior.numJrtConnectionsPerNode != null)
        numJrtConnectionsPerNode(__superior.numJrtConnectionsPerNode);
      if (__superior.warmuptime != null)
        warmuptime(__superior.warmuptime);
      if (__superior.summaryDecodePolicy != null)
        summaryDecodePolicy(__superior.summaryDecodePolicy);
      return this;
    }

    public Builder prioritizeAvailability(boolean __value) {
      prioritizeAvailability = __value;
      return this;
    }

    private Builder prioritizeAvailability(String __value) {
      return prioritizeAvailability(Boolean.valueOf(__value));
    }

    public Builder minActivedocsPercentage(double __value) {
      minActivedocsPercentage = __value;
      return this;
    }

    private Builder minActivedocsPercentage(String __value) {
      return minActivedocsPercentage(Double.valueOf(__value));
    }

    public Builder distributionPolicy(DistributionPolicy.Enum __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      distributionPolicy = __value;
      return this;
    }

    private Builder distributionPolicy(String __value) {
      return distributionPolicy(DistributionPolicy.Enum.valueOf(__value));
    }

    public Builder maxHitsPerNode(int __value) {
      maxHitsPerNode = __value;
      return this;
    }

    private Builder maxHitsPerNode(String __value) {
      return maxHitsPerNode(Integer.valueOf(__value));
    }

    public Builder topKProbability(double __value) {
      topKProbability = __value;
      return this;
    }

    private Builder topKProbability(String __value) {
      return topKProbability(Double.valueOf(__value));
    }

    public Builder redundancy(long __value) {
      redundancy = __value;
      return this;
    }

    private Builder redundancy(String __value) {
      return redundancy(Long.valueOf(__value));
    }

    public Builder minSearchCoverage(double __value) {
      minSearchCoverage = __value;
      return this;
    }

    private Builder minSearchCoverage(String __value) {
      return minSearchCoverage(Double.valueOf(__value));
    }

    public Builder minWaitAfterCoverageFactor(double __value) {
      minWaitAfterCoverageFactor = __value;
      return this;
    }

    private Builder minWaitAfterCoverageFactor(String __value) {
      return minWaitAfterCoverageFactor(Double.valueOf(__value));
    }

    public Builder maxWaitAfterCoverageFactor(double __value) {
      maxWaitAfterCoverageFactor = __value;
      return this;
    }

    private Builder maxWaitAfterCoverageFactor(String __value) {
      return maxWaitAfterCoverageFactor(Double.valueOf(__value));
    }

    public Builder numJrtTransportThreads(int __value) {
      numJrtTransportThreads = __value;
      return this;
    }

    private Builder numJrtTransportThreads(String __value) {
      return numJrtTransportThreads(Integer.valueOf(__value));
    }

    public Builder numJrtConnectionsPerNode(int __value) {
      numJrtConnectionsPerNode = __value;
      return this;
    }

    private Builder numJrtConnectionsPerNode(String __value) {
      return numJrtConnectionsPerNode(Integer.valueOf(__value));
    }

    public Builder warmuptime(double __value) {
      warmuptime = __value;
      return this;
    }

    private Builder warmuptime(String __value) {
      return warmuptime(Double.valueOf(__value));
    }

    public Builder summaryDecodePolicy(SummaryDecodePolicy.Enum __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      summaryDecodePolicy = __value;
      return this;
    }

    private Builder summaryDecodePolicy(String __value) {
      return summaryDecodePolicy(SummaryDecodePolicy.Enum.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public DispatchConfig build() {
      return new DispatchConfig(this);
    }

  }

  // Whether to prioritize availability (default), or maximal coverage when choosing
  // which content groups requests should be dispatched to.
  // If true, all groups that are observed to have at least minActivedocsPercentage of the *median* number of documents
  // over the other groups will receive queries.
  // If set to false, only groups that have at least minActivedocsPercentage of the *maximal* observed number
  // of documents will receive requests, with the consequence that queries will fail due to overload rather
  // that return from a group with too few documents, when more than one group has too few documents available.
  private final BooleanNode prioritizeAvailability;
  // The active docs a group must have as a % of the average active docs of all other groups,
  // for that group to be included in queries
  private final DoubleNode minActivedocsPercentage;
  // Distribution policy for group selection
  private final DistributionPolicy distributionPolicy;
  // Maximum number of hits that will be requested from a single node
  // in this dataset. If not set, there is no limit. Using this option
  // may help reduce network traffic when searching in datasets with big
  // fan-out, but it will also result in incorrect and incomplete results;
  // don't use it if you don't (really) mean it.
  private final IntegerNode maxHitsPerNode;
  // Probability for getting the K best hits (topK).
  // A value of 1.0 will ask all N partitions for K hits.
  // Any value between <0, 1> will use a Student T with 30 degrees freedom and compute a value Q that
  // will give you the globally K best hits according to this formula with the desired probability.
  // q = k/n + qT (p',30) x √(k × (1/n) × (1 − 1/n))
  // With a probability of 0.999 and K=200 and N=10 will give a Q of 38, meaning that you only need to fetch 19% compared to
  // a setting of 1.0. This is a significant optimisation with with very little loss in presicion.
  private final DoubleNode topKProbability;
  // Number of document replicas _per group_ that will be present in a stable cluster.
  // Should always be >= searchableCopies.
  private final LongNode redundancy;
  // Minimum search coverage required before returning the results of a query
  private final DoubleNode minSearchCoverage;
  // Minimum wait time for full coverage after minimum coverage is achieved, factored based on time left at minimum coverage
  private final DoubleNode minWaitAfterCoverageFactor;
  // Maximum wait time for full coverage after minimum coverage is achieved, factored based on time left at minimum coverage
  private final DoubleNode maxWaitAfterCoverageFactor;
  // Number of JRT transport threads
  private final IntegerNode numJrtTransportThreads;
  // Number of JRT connections per backend node
  private final IntegerNode numJrtConnectionsPerNode;
  // Number of seconds to spend warming up code to prevent JIT cold start issues.
  private final DoubleNode warmuptime;
  // Specifies how summary data are decoded
  // Eager will build java objects immediately, while ONDEMAND will do so when it is needed
  private final SummaryDecodePolicy summaryDecodePolicy;

  public DispatchConfig(Builder builder) {
    this(builder, true);
  }

  private DispatchConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "dispatch must be initialized: " + builder.__uninitialized);

    prioritizeAvailability = (builder.prioritizeAvailability == null) ?
        new BooleanNode(true) : new BooleanNode(builder.prioritizeAvailability);
    minActivedocsPercentage = (builder.minActivedocsPercentage == null) ?
        new DoubleNode(97.0D) : new DoubleNode(builder.minActivedocsPercentage);
    distributionPolicy = (builder.distributionPolicy == null) ?
        new DistributionPolicy(DistributionPolicy.ADAPTIVE) : new DistributionPolicy(builder.distributionPolicy);
    maxHitsPerNode = (builder.maxHitsPerNode == null) ?
        new IntegerNode(2147483647) : new IntegerNode(builder.maxHitsPerNode);
    topKProbability = (builder.topKProbability == null) ?
        new DoubleNode(0.9999D) : new DoubleNode(builder.topKProbability);
    redundancy = (builder.redundancy == null) ?
        new LongNode(1L) : new LongNode(builder.redundancy);
    minSearchCoverage = (builder.minSearchCoverage == null) ?
        new DoubleNode(100D) : new DoubleNode(builder.minSearchCoverage);
    minWaitAfterCoverageFactor = (builder.minWaitAfterCoverageFactor == null) ?
        new DoubleNode(0D) : new DoubleNode(builder.minWaitAfterCoverageFactor);
    maxWaitAfterCoverageFactor = (builder.maxWaitAfterCoverageFactor == null) ?
        new DoubleNode(1D) : new DoubleNode(builder.maxWaitAfterCoverageFactor);
    numJrtTransportThreads = (builder.numJrtTransportThreads == null) ?
        new IntegerNode(8) : new IntegerNode(builder.numJrtTransportThreads);
    numJrtConnectionsPerNode = (builder.numJrtConnectionsPerNode == null) ?
        new IntegerNode(8) : new IntegerNode(builder.numJrtConnectionsPerNode);
    warmuptime = (builder.warmuptime == null) ?
        new DoubleNode(0.1D) : new DoubleNode(builder.warmuptime);
    summaryDecodePolicy = (builder.summaryDecodePolicy == null) ?
        new SummaryDecodePolicy(SummaryDecodePolicy.ONDEMAND) : new SummaryDecodePolicy(builder.summaryDecodePolicy);
  }

  /**
   * @return dispatch.prioritizeAvailability
   */
  public boolean prioritizeAvailability() {
    return prioritizeAvailability.value();
  }

  /**
   * @return dispatch.minActivedocsPercentage
   */
  public double minActivedocsPercentage() {
    return minActivedocsPercentage.value();
  }

  /**
   * @return dispatch.distributionPolicy
   */
  public DistributionPolicy.Enum distributionPolicy() {
    return distributionPolicy.value();
  }

  /**
   * @return dispatch.maxHitsPerNode
   */
  public int maxHitsPerNode() {
    return maxHitsPerNode.value();
  }

  /**
   * @return dispatch.topKProbability
   */
  public double topKProbability() {
    return topKProbability.value();
  }

  /**
   * @return dispatch.redundancy
   */
  public long redundancy() {
    return redundancy.value();
  }

  /**
   * @return dispatch.minSearchCoverage
   */
  public double minSearchCoverage() {
    return minSearchCoverage.value();
  }

  /**
   * @return dispatch.minWaitAfterCoverageFactor
   */
  public double minWaitAfterCoverageFactor() {
    return minWaitAfterCoverageFactor.value();
  }

  /**
   * @return dispatch.maxWaitAfterCoverageFactor
   */
  public double maxWaitAfterCoverageFactor() {
    return maxWaitAfterCoverageFactor.value();
  }

  /**
   * @return dispatch.numJrtTransportThreads
   */
  public int numJrtTransportThreads() {
    return numJrtTransportThreads.value();
  }

  /**
   * @return dispatch.numJrtConnectionsPerNode
   */
  public int numJrtConnectionsPerNode() {
    return numJrtConnectionsPerNode.value();
  }

  /**
   * @return dispatch.warmuptime
   */
  public double warmuptime() {
    return warmuptime.value();
  }

  /**
   * @return dispatch.summaryDecodePolicy
   */
  public SummaryDecodePolicy.Enum summaryDecodePolicy() {
    return summaryDecodePolicy.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(DispatchConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("dispatch");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents dispatch.distributionPolicy
   * 
   * Distribution policy for group selection
   */
  public final static class DistributionPolicy extends EnumNode<DistributionPolicy.Enum> {

    public DistributionPolicy(){
      this.value = null;
    }

    public DistributionPolicy(Enum enumValue) {
      super(enumValue != null);
      this.value = enumValue;
    }

    public enum Enum {ROUNDROBIN, BEST_OF_RANDOM_2, LATENCY_AMORTIZED_OVER_REQUESTS, LATENCY_AMORTIZED_OVER_TIME, ADAPTIVE}
    public final static Enum ROUNDROBIN = Enum.ROUNDROBIN;
    public final static Enum BEST_OF_RANDOM_2 = Enum.BEST_OF_RANDOM_2;
    public final static Enum LATENCY_AMORTIZED_OVER_REQUESTS = Enum.LATENCY_AMORTIZED_OVER_REQUESTS;
    public final static Enum LATENCY_AMORTIZED_OVER_TIME = Enum.LATENCY_AMORTIZED_OVER_TIME;
    public final static Enum ADAPTIVE = Enum.ADAPTIVE;

    @Override
    protected boolean doSetValue(String name) {
      try {
        value = Enum.valueOf(name);
        return true;
      } catch (IllegalArgumentException e) {
      }
      return false;
    }
  }

  /**
   * This class represents dispatch.summaryDecodePolicy
   * 
   * Specifies how summary data are decoded
   * Eager will build java objects immediately, while ONDEMAND will do so when it is needed
   */
  public final static class SummaryDecodePolicy extends EnumNode<SummaryDecodePolicy.Enum> {

    public SummaryDecodePolicy(){
      this.value = null;
    }

    public SummaryDecodePolicy(Enum enumValue) {
      super(enumValue != null);
      this.value = enumValue;
    }

    public enum Enum {EAGER, ONDEMAND}
    public final static Enum EAGER = Enum.EAGER;
    public final static Enum ONDEMAND = Enum.ONDEMAND;

    @Override
    protected boolean doSetValue(String name) {
      try {
        value = Enum.valueOf(name);
        return true;
      } catch (IllegalArgumentException e) {
      }
      return false;
    }
  }

}
