// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.search;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of attributes
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class AttributesConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "2f1fe4e3cf48edc1514b4e1fa9f70e34";
  public final static String CONFIG_DEF_NAME = "attributes";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.search";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.search",
    "attribute[].name string",
    "attribute[].datatype enum { STRING, BOOL, UINT2, UINT4, INT8, INT16, INT32, INT64, FLOAT16, FLOAT, DOUBLE, PREDICATE, TENSOR, REFERENCE, RAW, NONE } default=NONE",
    "attribute[].collectiontype enum { SINGLE, ARRAY, WEIGHTEDSET } default=SINGLE",
    "attribute[].dictionary.type enum { BTREE, HASH, BTREE_AND_HASH } default = BTREE",
    "attribute[].dictionary.match enum { CASE_SENSITIVE, CASE_INSENSITIVE, CASED, UNCASED } default=UNCASED",
    "attribute[].match enum { CASED, UNCASED } default=UNCASED",
    "attribute[].removeifzero bool default=false",
    "attribute[].createifnonexistent bool default=false",
    "attribute[].fastsearch bool default=false",
    "attribute[].paged bool default=false",
    "attribute[].ismutable bool default=false",
    "attribute[].sortascending bool default=true",
    "attribute[].sortfunction enum { RAW, LOWERCASE, UCA } default=UCA",
    "attribute[].sortstrength enum { PRIMARY, SECONDARY, TERTIARY, QUATERNARY, IDENTICAL } default=PRIMARY",
    "attribute[].sortlocale string default=\"\"",
    "attribute[].enableonlybitvector bool default=false",
    "attribute[].fastaccess bool default=false",
    "attribute[].arity int default=8",
    "attribute[].lowerbound long default=-9223372036854775808",
    "attribute[].upperbound long default=9223372036854775807",
    "attribute[].densepostinglistthreshold double default=0.40",
    "attribute[].tensortype string default=\"\"",
    "attribute[].imported bool default=false",
    "attribute[].maxuncommittedmemory long default=130000",
    "attribute[].distancemetric enum { EUCLIDEAN, ANGULAR, GEODEGREES, INNERPRODUCT, HAMMING, PRENORMALIZED_ANGULAR, DOTPRODUCT } default=EUCLIDEAN",
    "attribute[].index.hnsw.enabled bool default=false",
    "attribute[].index.hnsw.maxlinkspernode int default=16",
    "attribute[].index.hnsw.neighborstoexploreatinsert int default=200",
    "attribute[].index.hnsw.multithreadedindexing bool default=true"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Attribute.Builder> attribute = new ArrayList<>();

    public Builder() { }

    public Builder(AttributesConfig config) {
      for (Attribute a : config.attribute()) {
        attribute(new Attribute.Builder(a));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.attribute.isEmpty())
        attribute.addAll(__superior.attribute);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Attribute builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder attribute(Attribute.Builder __builder) {
      attribute.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder attribute(java.util.function.Consumer<Attribute.Builder> __func) {
      Attribute.Builder __inner = new Attribute.Builder();
      __func.accept(__inner);
      attribute.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Attribute builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder attribute(List<Attribute.Builder> __builders) {
      attribute = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public AttributesConfig build() {
      return new AttributesConfig(this);
    }

  }

  private final InnerNodeVector<Attribute> attribute;

  public AttributesConfig(Builder builder) {
    this(builder, true);
  }

  private AttributesConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "attributes must be initialized: " + builder.__uninitialized);

    attribute = Attribute.createVector(builder.attribute);
  }

  /**
   * @return attributes.attribute[]
   */
  public List<Attribute> attribute() {
    return attribute;
  }

  /**
   * @param i the index of the value to return
   * @return attributes.attribute[]
   */
  public Attribute attribute(int i) {
    return attribute.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(AttributesConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("attributes");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents attributes.attribute[]
   */
  public final static class Attribute extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name"
        ));

      private String name = null;
      private Datatype.Enum datatype = null;
      private Collectiontype.Enum collectiontype = null;
      public Dictionary.Builder dictionary = new Dictionary.Builder();
      private Match.Enum match = null;
      private Boolean removeifzero = null;
      private Boolean createifnonexistent = null;
      private Boolean fastsearch = null;
      private Boolean paged = null;
      private Boolean ismutable = null;
      private Boolean sortascending = null;
      private Sortfunction.Enum sortfunction = null;
      private Sortstrength.Enum sortstrength = null;
      private String sortlocale = null;
      private Boolean enableonlybitvector = null;
      private Boolean fastaccess = null;
      private Integer arity = null;
      private Long lowerbound = null;
      private Long upperbound = null;
      private Double densepostinglistthreshold = null;
      private String tensortype = null;
      private Boolean imported = null;
      private Long maxuncommittedmemory = null;
      private Distancemetric.Enum distancemetric = null;
      public Index.Builder index = new Index.Builder();

      public Builder() { }

      public Builder(Attribute config) {
        name(config.name());
        datatype(config.datatype());
        collectiontype(config.collectiontype());
        dictionary(new Dictionary.Builder(config.dictionary()));
        match(config.match());
        removeifzero(config.removeifzero());
        createifnonexistent(config.createifnonexistent());
        fastsearch(config.fastsearch());
        paged(config.paged());
        ismutable(config.ismutable());
        sortascending(config.sortascending());
        sortfunction(config.sortfunction());
        sortstrength(config.sortstrength());
        sortlocale(config.sortlocale());
        enableonlybitvector(config.enableonlybitvector());
        fastaccess(config.fastaccess());
        arity(config.arity());
        lowerbound(config.lowerbound());
        upperbound(config.upperbound());
        densepostinglistthreshold(config.densepostinglistthreshold());
        tensortype(config.tensortype());
        imported(config.imported());
        maxuncommittedmemory(config.maxuncommittedmemory());
        distancemetric(config.distancemetric());
        index(new Index.Builder(config.index()));
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.datatype != null)
          datatype(__superior.datatype);
        if (__superior.collectiontype != null)
          collectiontype(__superior.collectiontype);
        dictionary(dictionary.override(__superior.dictionary));
        if (__superior.match != null)
          match(__superior.match);
        if (__superior.removeifzero != null)
          removeifzero(__superior.removeifzero);
        if (__superior.createifnonexistent != null)
          createifnonexistent(__superior.createifnonexistent);
        if (__superior.fastsearch != null)
          fastsearch(__superior.fastsearch);
        if (__superior.paged != null)
          paged(__superior.paged);
        if (__superior.ismutable != null)
          ismutable(__superior.ismutable);
        if (__superior.sortascending != null)
          sortascending(__superior.sortascending);
        if (__superior.sortfunction != null)
          sortfunction(__superior.sortfunction);
        if (__superior.sortstrength != null)
          sortstrength(__superior.sortstrength);
        if (__superior.sortlocale != null)
          sortlocale(__superior.sortlocale);
        if (__superior.enableonlybitvector != null)
          enableonlybitvector(__superior.enableonlybitvector);
        if (__superior.fastaccess != null)
          fastaccess(__superior.fastaccess);
        if (__superior.arity != null)
          arity(__superior.arity);
        if (__superior.lowerbound != null)
          lowerbound(__superior.lowerbound);
        if (__superior.upperbound != null)
          upperbound(__superior.upperbound);
        if (__superior.densepostinglistthreshold != null)
          densepostinglistthreshold(__superior.densepostinglistthreshold);
        if (__superior.tensortype != null)
          tensortype(__superior.tensortype);
        if (__superior.imported != null)
          imported(__superior.imported);
        if (__superior.maxuncommittedmemory != null)
          maxuncommittedmemory(__superior.maxuncommittedmemory);
        if (__superior.distancemetric != null)
          distancemetric(__superior.distancemetric);
        index(index.override(__superior.index));
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder datatype(Datatype.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        datatype = __value;
        return this;
      }

      private Builder datatype(String __value) {
        return datatype(Datatype.Enum.valueOf(__value));
      }

      public Builder collectiontype(Collectiontype.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        collectiontype = __value;
        return this;
      }

      private Builder collectiontype(String __value) {
        return collectiontype(Collectiontype.Enum.valueOf(__value));
      }

      public Builder dictionary(Dictionary.Builder __builder) {
        dictionary = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder dictionary(java.util.function.Consumer<Dictionary.Builder> __func) {
        Dictionary.Builder __inner = new Dictionary.Builder();
        __func.accept(__inner);
        dictionary = __inner;
        return this;
      }

      public Builder match(Match.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        match = __value;
        return this;
      }

      private Builder match(String __value) {
        return match(Match.Enum.valueOf(__value));
      }

      public Builder removeifzero(boolean __value) {
        removeifzero = __value;
        return this;
      }

      private Builder removeifzero(String __value) {
        return removeifzero(Boolean.valueOf(__value));
      }

      public Builder createifnonexistent(boolean __value) {
        createifnonexistent = __value;
        return this;
      }

      private Builder createifnonexistent(String __value) {
        return createifnonexistent(Boolean.valueOf(__value));
      }

      public Builder fastsearch(boolean __value) {
        fastsearch = __value;
        return this;
      }

      private Builder fastsearch(String __value) {
        return fastsearch(Boolean.valueOf(__value));
      }

      public Builder paged(boolean __value) {
        paged = __value;
        return this;
      }

      private Builder paged(String __value) {
        return paged(Boolean.valueOf(__value));
      }

      public Builder ismutable(boolean __value) {
        ismutable = __value;
        return this;
      }

      private Builder ismutable(String __value) {
        return ismutable(Boolean.valueOf(__value));
      }

      public Builder sortascending(boolean __value) {
        sortascending = __value;
        return this;
      }

      private Builder sortascending(String __value) {
        return sortascending(Boolean.valueOf(__value));
      }

      public Builder sortfunction(Sortfunction.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        sortfunction = __value;
        return this;
      }

      private Builder sortfunction(String __value) {
        return sortfunction(Sortfunction.Enum.valueOf(__value));
      }

      public Builder sortstrength(Sortstrength.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        sortstrength = __value;
        return this;
      }

      private Builder sortstrength(String __value) {
        return sortstrength(Sortstrength.Enum.valueOf(__value));
      }

      public Builder sortlocale(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        sortlocale = __value;
        return this;
      }


      public Builder enableonlybitvector(boolean __value) {
        enableonlybitvector = __value;
        return this;
      }

      private Builder enableonlybitvector(String __value) {
        return enableonlybitvector(Boolean.valueOf(__value));
      }

      public Builder fastaccess(boolean __value) {
        fastaccess = __value;
        return this;
      }

      private Builder fastaccess(String __value) {
        return fastaccess(Boolean.valueOf(__value));
      }

      public Builder arity(int __value) {
        arity = __value;
        return this;
      }

      private Builder arity(String __value) {
        return arity(Integer.valueOf(__value));
      }

      public Builder lowerbound(long __value) {
        lowerbound = __value;
        return this;
      }

      private Builder lowerbound(String __value) {
        return lowerbound(Long.valueOf(__value));
      }

      public Builder upperbound(long __value) {
        upperbound = __value;
        return this;
      }

      private Builder upperbound(String __value) {
        return upperbound(Long.valueOf(__value));
      }

      public Builder densepostinglistthreshold(double __value) {
        densepostinglistthreshold = __value;
        return this;
      }

      private Builder densepostinglistthreshold(String __value) {
        return densepostinglistthreshold(Double.valueOf(__value));
      }

      public Builder tensortype(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        tensortype = __value;
        return this;
      }


      public Builder imported(boolean __value) {
        imported = __value;
        return this;
      }

      private Builder imported(String __value) {
        return imported(Boolean.valueOf(__value));
      }

      public Builder maxuncommittedmemory(long __value) {
        maxuncommittedmemory = __value;
        return this;
      }

      private Builder maxuncommittedmemory(String __value) {
        return maxuncommittedmemory(Long.valueOf(__value));
      }

      public Builder distancemetric(Distancemetric.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        distancemetric = __value;
        return this;
      }

      private Builder distancemetric(String __value) {
        return distancemetric(Distancemetric.Enum.valueOf(__value));
      }

      public Builder index(Index.Builder __builder) {
        index = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder index(java.util.function.Consumer<Index.Builder> __func) {
        Index.Builder __inner = new Index.Builder();
        __func.accept(__inner);
        index = __inner;
        return this;
      }

      public Attribute build() {
        return new Attribute(this);
      }

    }

    private final StringNode name;
    private final Datatype datatype;
    private final Collectiontype collectiontype;
    private final Dictionary dictionary;
    private final Match match;
    private final BooleanNode removeifzero;
    private final BooleanNode createifnonexistent;
    private final BooleanNode fastsearch;
    private final BooleanNode paged;
    // An attribute marked mutable can be updated by a query.
    private final BooleanNode ismutable;
    private final BooleanNode sortascending;
    private final Sortfunction sortfunction;
    private final Sortstrength sortstrength;
    private final StringNode sortlocale;
    // Allow only bitvector postings, i.e. drop btree postings to save memory.?
    private final BooleanNode enableonlybitvector;
    // Allow fast access to this attribute at all times.
    // If so, attribute is kept in memory also for non-searchable documents.
    private final BooleanNode fastaccess;
    private final IntegerNode arity;
    private final LongNode lowerbound;
    private final LongNode upperbound;
    // The threshold is given as a ratio of the corpus size
    private final DoubleNode densepostinglistthreshold;
    // Specification of tensor type if this attribute is of type TENSOR.
    private final StringNode tensortype;
    // Whether this is an imported attribute (from parent document db) or not.
    private final BooleanNode imported;
    // Max amount of uncommitted memory during feed. (Default just shy of 128k)
    private final LongNode maxuncommittedmemory;
    // The distance metric to use for nearest neighbor search.
    // Is only used when the attribute is a 1-dimensional indexed tensor.
    private final Distancemetric distancemetric;
    private final Index index;

    public Attribute(Builder builder) {
      this(builder, true);
    }

    private Attribute(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "attributes.attribute[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      datatype = (builder.datatype == null) ?
          new Datatype(Datatype.NONE) : new Datatype(builder.datatype);
      collectiontype = (builder.collectiontype == null) ?
          new Collectiontype(Collectiontype.SINGLE) : new Collectiontype(builder.collectiontype);
      dictionary = new Dictionary(builder.dictionary, throwIfUninitialized);
      match = (builder.match == null) ?
          new Match(Match.UNCASED) : new Match(builder.match);
      removeifzero = (builder.removeifzero == null) ?
          new BooleanNode(false) : new BooleanNode(builder.removeifzero);
      createifnonexistent = (builder.createifnonexistent == null) ?
          new BooleanNode(false) : new BooleanNode(builder.createifnonexistent);
      fastsearch = (builder.fastsearch == null) ?
          new BooleanNode(false) : new BooleanNode(builder.fastsearch);
      paged = (builder.paged == null) ?
          new BooleanNode(false) : new BooleanNode(builder.paged);
      ismutable = (builder.ismutable == null) ?
          new BooleanNode(false) : new BooleanNode(builder.ismutable);
      sortascending = (builder.sortascending == null) ?
          new BooleanNode(true) : new BooleanNode(builder.sortascending);
      sortfunction = (builder.sortfunction == null) ?
          new Sortfunction(Sortfunction.UCA) : new Sortfunction(builder.sortfunction);
      sortstrength = (builder.sortstrength == null) ?
          new Sortstrength(Sortstrength.PRIMARY) : new Sortstrength(builder.sortstrength);
      sortlocale = (builder.sortlocale == null) ?
          new StringNode("") : new StringNode(builder.sortlocale);
      enableonlybitvector = (builder.enableonlybitvector == null) ?
          new BooleanNode(false) : new BooleanNode(builder.enableonlybitvector);
      fastaccess = (builder.fastaccess == null) ?
          new BooleanNode(false) : new BooleanNode(builder.fastaccess);
      arity = (builder.arity == null) ?
          new IntegerNode(8) : new IntegerNode(builder.arity);
      lowerbound = (builder.lowerbound == null) ?
          new LongNode(-9223372036854775808L) : new LongNode(builder.lowerbound);
      upperbound = (builder.upperbound == null) ?
          new LongNode(9223372036854775807L) : new LongNode(builder.upperbound);
      densepostinglistthreshold = (builder.densepostinglistthreshold == null) ?
          new DoubleNode(0.40D) : new DoubleNode(builder.densepostinglistthreshold);
      tensortype = (builder.tensortype == null) ?
          new StringNode("") : new StringNode(builder.tensortype);
      imported = (builder.imported == null) ?
          new BooleanNode(false) : new BooleanNode(builder.imported);
      maxuncommittedmemory = (builder.maxuncommittedmemory == null) ?
          new LongNode(130000L) : new LongNode(builder.maxuncommittedmemory);
      distancemetric = (builder.distancemetric == null) ?
          new Distancemetric(Distancemetric.EUCLIDEAN) : new Distancemetric(builder.distancemetric);
      index = new Index(builder.index, throwIfUninitialized);
    }

    /**
     * @return attributes.attribute[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return attributes.attribute[].datatype
     */
    public Datatype.Enum datatype() {
      return datatype.value();
    }

    /**
     * @return attributes.attribute[].collectiontype
     */
    public Collectiontype.Enum collectiontype() {
      return collectiontype.value();
    }

    /**
     * @return attributes.attribute[].dictionary
     */
    public Dictionary dictionary() {
      return dictionary;
    }

    /**
     * @return attributes.attribute[].match
     */
    public Match.Enum match() {
      return match.value();
    }

    /**
     * @return attributes.attribute[].removeifzero
     */
    public boolean removeifzero() {
      return removeifzero.value();
    }

    /**
     * @return attributes.attribute[].createifnonexistent
     */
    public boolean createifnonexistent() {
      return createifnonexistent.value();
    }

    /**
     * @return attributes.attribute[].fastsearch
     */
    public boolean fastsearch() {
      return fastsearch.value();
    }

    /**
     * @return attributes.attribute[].paged
     */
    public boolean paged() {
      return paged.value();
    }

    /**
     * @return attributes.attribute[].ismutable
     */
    public boolean ismutable() {
      return ismutable.value();
    }

    /**
     * @return attributes.attribute[].sortascending
     */
    public boolean sortascending() {
      return sortascending.value();
    }

    /**
     * @return attributes.attribute[].sortfunction
     */
    public Sortfunction.Enum sortfunction() {
      return sortfunction.value();
    }

    /**
     * @return attributes.attribute[].sortstrength
     */
    public Sortstrength.Enum sortstrength() {
      return sortstrength.value();
    }

    /**
     * @return attributes.attribute[].sortlocale
     */
    public String sortlocale() {
      return sortlocale.value();
    }

    /**
     * @return attributes.attribute[].enableonlybitvector
     */
    public boolean enableonlybitvector() {
      return enableonlybitvector.value();
    }

    /**
     * @return attributes.attribute[].fastaccess
     */
    public boolean fastaccess() {
      return fastaccess.value();
    }

    /**
     * @return attributes.attribute[].arity
     */
    public int arity() {
      return arity.value();
    }

    /**
     * @return attributes.attribute[].lowerbound
     */
    public long lowerbound() {
      return lowerbound.value();
    }

    /**
     * @return attributes.attribute[].upperbound
     */
    public long upperbound() {
      return upperbound.value();
    }

    /**
     * @return attributes.attribute[].densepostinglistthreshold
     */
    public double densepostinglistthreshold() {
      return densepostinglistthreshold.value();
    }

    /**
     * @return attributes.attribute[].tensortype
     */
    public String tensortype() {
      return tensortype.value();
    }

    /**
     * @return attributes.attribute[].imported
     */
    public boolean imported() {
      return imported.value();
    }

    /**
     * @return attributes.attribute[].maxuncommittedmemory
     */
    public long maxuncommittedmemory() {
      return maxuncommittedmemory.value();
    }

    /**
     * @return attributes.attribute[].distancemetric
     */
    public Distancemetric.Enum distancemetric() {
      return distancemetric.value();
    }

    /**
     * @return attributes.attribute[].index
     */
    public Index index() {
      return index;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Attribute newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("attribute");
      return changes;
    }

    private static InnerNodeVector<Attribute> createVector(List<Builder> builders) {
        List<Attribute> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Attribute(b));
        }
        return new InnerNodeVector<Attribute>(elems);
    }

    /**
     * This class represents attributes.attribute[].datatype
     */
    public final static class Datatype extends EnumNode<Datatype.Enum> {

      public Datatype(){
        this.value = null;
      }

      public Datatype(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {STRING, BOOL, UINT2, UINT4, INT8, INT16, INT32, INT64, FLOAT16, FLOAT, DOUBLE, PREDICATE, TENSOR, REFERENCE, RAW, NONE}
      public final static Enum STRING = Enum.STRING;
      public final static Enum BOOL = Enum.BOOL;
      public final static Enum UINT2 = Enum.UINT2;
      public final static Enum UINT4 = Enum.UINT4;
      public final static Enum INT8 = Enum.INT8;
      public final static Enum INT16 = Enum.INT16;
      public final static Enum INT32 = Enum.INT32;
      public final static Enum INT64 = Enum.INT64;
      public final static Enum FLOAT16 = Enum.FLOAT16;
      public final static Enum FLOAT = Enum.FLOAT;
      public final static Enum DOUBLE = Enum.DOUBLE;
      public final static Enum PREDICATE = Enum.PREDICATE;
      public final static Enum TENSOR = Enum.TENSOR;
      public final static Enum REFERENCE = Enum.REFERENCE;
      public final static Enum RAW = Enum.RAW;
      public final static Enum NONE = Enum.NONE;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }

    /**
     * This class represents attributes.attribute[].collectiontype
     */
    public final static class Collectiontype extends EnumNode<Collectiontype.Enum> {

      public Collectiontype(){
        this.value = null;
      }

      public Collectiontype(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {SINGLE, ARRAY, WEIGHTEDSET}
      public final static Enum SINGLE = Enum.SINGLE;
      public final static Enum ARRAY = Enum.ARRAY;
      public final static Enum WEIGHTEDSET = Enum.WEIGHTEDSET;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }

    /**
     * This class represents attributes.attribute[].dictionary
     */
    public final static class Dictionary extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Type.Enum type = null;
        private Match.Enum match = null;

        public Builder() { }

        public Builder(Dictionary config) {
          type(config.type());
          match(config.match());
        }

        private Builder override(Builder __superior) {
          if (__superior.type != null)
            type(__superior.type);
          if (__superior.match != null)
            match(__superior.match);
          return this;
        }

        public Builder type(Type.Enum __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          type = __value;
          return this;
        }

        private Builder type(String __value) {
          return type(Type.Enum.valueOf(__value));
        }

        public Builder match(Match.Enum __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          match = __value;
          return this;
        }

        private Builder match(String __value) {
          return match(Match.Enum.valueOf(__value));
        }

        public Dictionary build() {
          return new Dictionary(this);
        }

      }

      private final Type type;
      private final Match match;

      public Dictionary(Builder builder) {
        this(builder, true);
      }

      private Dictionary(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "attributes.attribute[].dictionary must be initialized: " + builder.__uninitialized);

        type = (builder.type == null) ?
            new Type(Type.BTREE) : new Type(builder.type);
        match = (builder.match == null) ?
            new Match(Match.UNCASED) : new Match(builder.match);
      }

      /**
       * @return attributes.attribute[].dictionary.type
       */
      public Type.Enum type() {
        return type.value();
      }

      /**
       * @return attributes.attribute[].dictionary.match
       */
      public Match.Enum match() {
        return match.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Dictionary newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("dictionary");
        return changes;
      }

      /**
       * This class represents attributes.attribute[].dictionary.type
       */
      public final static class Type extends EnumNode<Type.Enum> {

        public Type(){
          this.value = null;
        }

        public Type(Enum enumValue) {
          super(enumValue != null);
          this.value = enumValue;
        }

        public enum Enum {BTREE, HASH, BTREE_AND_HASH}
        public final static Enum BTREE = Enum.BTREE;
        public final static Enum HASH = Enum.HASH;
        public final static Enum BTREE_AND_HASH = Enum.BTREE_AND_HASH;

        @Override
        protected boolean doSetValue(String name) {
          try {
            value = Enum.valueOf(name);
            return true;
          } catch (IllegalArgumentException e) {
          }
          return false;
        }
      }

      /**
       * This class represents attributes.attribute[].dictionary.match
       */
      public final static class Match extends EnumNode<Match.Enum> {

        public Match(){
          this.value = null;
        }

        public Match(Enum enumValue) {
          super(enumValue != null);
          this.value = enumValue;
        }

        public enum Enum {CASE_SENSITIVE, CASE_INSENSITIVE, CASED, UNCASED}
        public final static Enum CASE_SENSITIVE = Enum.CASE_SENSITIVE;
        public final static Enum CASE_INSENSITIVE = Enum.CASE_INSENSITIVE;
        public final static Enum CASED = Enum.CASED;
        public final static Enum UNCASED = Enum.UNCASED;

        @Override
        protected boolean doSetValue(String name) {
          try {
            value = Enum.valueOf(name);
            return true;
          } catch (IllegalArgumentException e) {
          }
          return false;
        }
      }
    }

    /**
     * This class represents attributes.attribute[].match
     */
    public final static class Match extends EnumNode<Match.Enum> {

      public Match(){
        this.value = null;
      }

      public Match(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {CASED, UNCASED}
      public final static Enum CASED = Enum.CASED;
      public final static Enum UNCASED = Enum.UNCASED;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }

    /**
     * This class represents attributes.attribute[].sortfunction
     */
    public final static class Sortfunction extends EnumNode<Sortfunction.Enum> {

      public Sortfunction(){
        this.value = null;
      }

      public Sortfunction(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {RAW, LOWERCASE, UCA}
      public final static Enum RAW = Enum.RAW;
      public final static Enum LOWERCASE = Enum.LOWERCASE;
      public final static Enum UCA = Enum.UCA;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }

    /**
     * This class represents attributes.attribute[].sortstrength
     */
    public final static class Sortstrength extends EnumNode<Sortstrength.Enum> {

      public Sortstrength(){
        this.value = null;
      }

      public Sortstrength(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {PRIMARY, SECONDARY, TERTIARY, QUATERNARY, IDENTICAL}
      public final static Enum PRIMARY = Enum.PRIMARY;
      public final static Enum SECONDARY = Enum.SECONDARY;
      public final static Enum TERTIARY = Enum.TERTIARY;
      public final static Enum QUATERNARY = Enum.QUATERNARY;
      public final static Enum IDENTICAL = Enum.IDENTICAL;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }

    /**
     * This class represents attributes.attribute[].distancemetric
     * 
     * The distance metric to use for nearest neighbor search.
     * Is only used when the attribute is a 1-dimensional indexed tensor.
     */
    public final static class Distancemetric extends EnumNode<Distancemetric.Enum> {

      public Distancemetric(){
        this.value = null;
      }

      public Distancemetric(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {EUCLIDEAN, ANGULAR, GEODEGREES, INNERPRODUCT, HAMMING, PRENORMALIZED_ANGULAR, DOTPRODUCT}
      public final static Enum EUCLIDEAN = Enum.EUCLIDEAN;
      public final static Enum ANGULAR = Enum.ANGULAR;
      public final static Enum GEODEGREES = Enum.GEODEGREES;
      public final static Enum INNERPRODUCT = Enum.INNERPRODUCT;
      public final static Enum HAMMING = Enum.HAMMING;
      public final static Enum PRENORMALIZED_ANGULAR = Enum.PRENORMALIZED_ANGULAR;
      public final static Enum DOTPRODUCT = Enum.DOTPRODUCT;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }

    /**
     * This class represents attributes.attribute[].index
     */
    public final static class Index extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        public Hnsw.Builder hnsw = new Hnsw.Builder();

        public Builder() { }

        public Builder(Index config) {
          hnsw(new Hnsw.Builder(config.hnsw()));
        }

        private Builder override(Builder __superior) {
          hnsw(hnsw.override(__superior.hnsw));
          return this;
        }

        public Builder hnsw(Hnsw.Builder __builder) {
          hnsw = __builder;
          return this;
        }
        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder hnsw(java.util.function.Consumer<Hnsw.Builder> __func) {
          Hnsw.Builder __inner = new Hnsw.Builder();
          __func.accept(__inner);
          hnsw = __inner;
          return this;
        }

        public Index build() {
          return new Index(this);
        }

      }

      private final Hnsw hnsw;

      public Index(Builder builder) {
        this(builder, true);
      }

      private Index(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "attributes.attribute[].index must be initialized: " + builder.__uninitialized);

        hnsw = new Hnsw(builder.hnsw, throwIfUninitialized);
      }

      /**
       * @return attributes.attribute[].index.hnsw
       */
      public Hnsw hnsw() {
        return hnsw;
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Index newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("index");
        return changes;
      }

      /**
       * This class represents attributes.attribute[].index.hnsw
       */
      public final static class Hnsw extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>();

          private Boolean enabled = null;
          private Integer maxlinkspernode = null;
          private Integer neighborstoexploreatinsert = null;
          private Boolean multithreadedindexing = null;

          public Builder() { }

          public Builder(Hnsw config) {
            enabled(config.enabled());
            maxlinkspernode(config.maxlinkspernode());
            neighborstoexploreatinsert(config.neighborstoexploreatinsert());
            multithreadedindexing(config.multithreadedindexing());
          }

          private Builder override(Builder __superior) {
            if (__superior.enabled != null)
              enabled(__superior.enabled);
            if (__superior.maxlinkspernode != null)
              maxlinkspernode(__superior.maxlinkspernode);
            if (__superior.neighborstoexploreatinsert != null)
              neighborstoexploreatinsert(__superior.neighborstoexploreatinsert);
            if (__superior.multithreadedindexing != null)
              multithreadedindexing(__superior.multithreadedindexing);
            return this;
          }

          public Builder enabled(boolean __value) {
            enabled = __value;
            return this;
          }

          private Builder enabled(String __value) {
            return enabled(Boolean.valueOf(__value));
          }

          public Builder maxlinkspernode(int __value) {
            maxlinkspernode = __value;
            return this;
          }

          private Builder maxlinkspernode(String __value) {
            return maxlinkspernode(Integer.valueOf(__value));
          }

          public Builder neighborstoexploreatinsert(int __value) {
            neighborstoexploreatinsert = __value;
            return this;
          }

          private Builder neighborstoexploreatinsert(String __value) {
            return neighborstoexploreatinsert(Integer.valueOf(__value));
          }

          public Builder multithreadedindexing(boolean __value) {
            multithreadedindexing = __value;
            return this;
          }

          private Builder multithreadedindexing(String __value) {
            return multithreadedindexing(Boolean.valueOf(__value));
          }

          public Hnsw build() {
            return new Hnsw(this);
          }

        }

        // Configuration parameters for a hnsw index used together with a 1-dimensional indexed tensor for approximate nearest neighbor search.
        private final BooleanNode enabled;
        private final IntegerNode maxlinkspernode;
        private final IntegerNode neighborstoexploreatinsert;
        // Whether multi-threaded indexing is enabled for this hnsw index.
        private final BooleanNode multithreadedindexing;

        public Hnsw(Builder builder) {
          this(builder, true);
        }

        private Hnsw(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "attributes.attribute[].index.hnsw must be initialized: " + builder.__uninitialized);

          enabled = (builder.enabled == null) ?
              new BooleanNode(false) : new BooleanNode(builder.enabled);
          maxlinkspernode = (builder.maxlinkspernode == null) ?
              new IntegerNode(16) : new IntegerNode(builder.maxlinkspernode);
          neighborstoexploreatinsert = (builder.neighborstoexploreatinsert == null) ?
              new IntegerNode(200) : new IntegerNode(builder.neighborstoexploreatinsert);
          multithreadedindexing = (builder.multithreadedindexing == null) ?
              new BooleanNode(true) : new BooleanNode(builder.multithreadedindexing);
        }

        /**
         * @return attributes.attribute[].index.hnsw.enabled
         */
        public boolean enabled() {
          return enabled.value();
        }

        /**
         * @return attributes.attribute[].index.hnsw.maxlinkspernode
         */
        public int maxlinkspernode() {
          return maxlinkspernode.value();
        }

        /**
         * @return attributes.attribute[].index.hnsw.neighborstoexploreatinsert
         */
        public int neighborstoexploreatinsert() {
          return neighborstoexploreatinsert.value();
        }

        /**
         * @return attributes.attribute[].index.hnsw.multithreadedindexing
         */
        public boolean multithreadedindexing() {
          return multithreadedindexing.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Hnsw newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("hnsw");
          return changes;
        }
      }
    }
  }

}
