// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.jdisc.http.filter;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of rule-based-filter
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class RuleBasedFilterConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "3f19c877297fd6cd3c0000ae0f3a7180";
  public final static String CONFIG_DEF_NAME = "rule-based-filter";
  public final static String CONFIG_DEF_NAMESPACE = "com.yahoo.vespa.config.jdisc.http.filter";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "package=com.yahoo.vespa.config.jdisc.http.filter",
    "dryrun bool default=false",
    "defaultRule.action enum { ALLOW, BLOCK }",
    "defaultRule.blockResponseCode int default=403",
    "defaultRule.blockResponseMessage string default=\"\"",
    "defaultRule.blockResponseHeaders[].name string",
    "defaultRule.blockResponseHeaders[].value string",
    "rule[].name string",
    "rule[].action enum { ALLOW, BLOCK }",
    "rule[].hostNames[] string",
    "rule[].methods[] enum { GET, POST, PUT, PATCH, DELETE }",
    "rule[].pathExpressions[] string",
    "rule[].blockResponseCode int default=403",
    "rule[].blockResponseMessage string default=\"\"",
    "rule[].blockResponseHeaders[].name string",
    "rule[].blockResponseHeaders[].value string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Boolean dryrun = null;
    public DefaultRule.Builder defaultRule = new DefaultRule.Builder();
    public List<Rule.Builder> rule = new ArrayList<>();

    public Builder() { }

    public Builder(RuleBasedFilterConfig config) {
      dryrun(config.dryrun());
      defaultRule(new DefaultRule.Builder(config.defaultRule()));
      for (Rule r : config.rule()) {
        rule(new Rule.Builder(r));
      }
    }

    private Builder override(Builder __superior) {
      if (__superior.dryrun != null)
        dryrun(__superior.dryrun);
      defaultRule(defaultRule.override(__superior.defaultRule));
      if (!__superior.rule.isEmpty())
        rule.addAll(__superior.rule);
      return this;
    }

    public Builder dryrun(boolean __value) {
      dryrun = __value;
      return this;
    }

    private Builder dryrun(String __value) {
      return dryrun(Boolean.valueOf(__value));
    }

    public Builder defaultRule(DefaultRule.Builder __builder) {
      defaultRule = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder defaultRule(java.util.function.Consumer<DefaultRule.Builder> __func) {
      DefaultRule.Builder __inner = new DefaultRule.Builder();
      __func.accept(__inner);
      defaultRule = __inner;
      return this;
    }

    /**
     * Add the given builder to this builder's list of Rule builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder rule(Rule.Builder __builder) {
      rule.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder rule(java.util.function.Consumer<Rule.Builder> __func) {
      Rule.Builder __inner = new Rule.Builder();
      __func.accept(__inner);
      rule.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Rule builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder rule(List<Rule.Builder> __builders) {
      rule = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public RuleBasedFilterConfig build() {
      return new RuleBasedFilterConfig(this);
    }

  }

  private final BooleanNode dryrun;
  private final DefaultRule defaultRule;
  private final InnerNodeVector<Rule> rule;

  public RuleBasedFilterConfig(Builder builder) {
    this(builder, true);
  }

  private RuleBasedFilterConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "rule-based-filter must be initialized: " + builder.__uninitialized);

    dryrun = (builder.dryrun == null) ?
        new BooleanNode(false) : new BooleanNode(builder.dryrun);
    defaultRule = new DefaultRule(builder.defaultRule, throwIfUninitialized);
    rule = Rule.createVector(builder.rule);
  }

  /**
   * @return rule-based-filter.dryrun
   */
  public boolean dryrun() {
    return dryrun.value();
  }

  /**
   * @return rule-based-filter.defaultRule
   */
  public DefaultRule defaultRule() {
    return defaultRule;
  }

  /**
   * @return rule-based-filter.rule[]
   */
  public List<Rule> rule() {
    return rule;
  }

  /**
   * @param i the index of the value to return
   * @return rule-based-filter.rule[]
   */
  public Rule rule(int i) {
    return rule.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(RuleBasedFilterConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("rule-based-filter");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents rule-based-filter.defaultRule
   */
  public final static class DefaultRule extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "action"
        ));

      private Action.Enum action = null;
      private Integer blockResponseCode = null;
      private String blockResponseMessage = null;
      public List<BlockResponseHeaders.Builder> blockResponseHeaders = new ArrayList<>();

      public Builder() { }

      public Builder(DefaultRule config) {
        action(config.action());
        blockResponseCode(config.blockResponseCode());
        blockResponseMessage(config.blockResponseMessage());
        for (BlockResponseHeaders b : config.blockResponseHeaders()) {
          blockResponseHeaders(new BlockResponseHeaders.Builder(b));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.action != null)
          action(__superior.action);
        if (__superior.blockResponseCode != null)
          blockResponseCode(__superior.blockResponseCode);
        if (__superior.blockResponseMessage != null)
          blockResponseMessage(__superior.blockResponseMessage);
        if (!__superior.blockResponseHeaders.isEmpty())
          blockResponseHeaders.addAll(__superior.blockResponseHeaders);
        return this;
      }

      public Builder action(Action.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        action = __value;
        __uninitialized.remove("action");
        return this;
      }

      private Builder action(String __value) {
        return action(Action.Enum.valueOf(__value));
      }

      public Builder blockResponseCode(int __value) {
        blockResponseCode = __value;
        return this;
      }

      private Builder blockResponseCode(String __value) {
        return blockResponseCode(Integer.valueOf(__value));
      }

      public Builder blockResponseMessage(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        blockResponseMessage = __value;
        return this;
      }


      /**
       * Add the given builder to this builder's list of BlockResponseHeaders builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder blockResponseHeaders(BlockResponseHeaders.Builder __builder) {
        blockResponseHeaders.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder blockResponseHeaders(java.util.function.Consumer<BlockResponseHeaders.Builder> __func) {
        BlockResponseHeaders.Builder __inner = new BlockResponseHeaders.Builder();
        __func.accept(__inner);
        blockResponseHeaders.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of BlockResponseHeaders builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder blockResponseHeaders(List<BlockResponseHeaders.Builder> __builders) {
        blockResponseHeaders = __builders;
        return this;
      }

      public DefaultRule build() {
        return new DefaultRule(this);
      }

    }

    private final Action action;
    private final IntegerNode blockResponseCode;
    private final StringNode blockResponseMessage;
    private final InnerNodeVector<BlockResponseHeaders> blockResponseHeaders;

    public DefaultRule(Builder builder) {
      this(builder, true);
    }

    private DefaultRule(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "rule-based-filter.defaultRule must be initialized: " + builder.__uninitialized);

      action = (builder.action == null) ?
          new Action() : new Action(builder.action);
      blockResponseCode = (builder.blockResponseCode == null) ?
          new IntegerNode(403) : new IntegerNode(builder.blockResponseCode);
      blockResponseMessage = (builder.blockResponseMessage == null) ?
          new StringNode("") : new StringNode(builder.blockResponseMessage);
      blockResponseHeaders = BlockResponseHeaders.createVector(builder.blockResponseHeaders);
    }

    /**
     * @return rule-based-filter.defaultRule.action
     */
    public Action.Enum action() {
      return action.value();
    }

    /**
     * @return rule-based-filter.defaultRule.blockResponseCode
     */
    public int blockResponseCode() {
      return blockResponseCode.value();
    }

    /**
     * @return rule-based-filter.defaultRule.blockResponseMessage
     */
    public String blockResponseMessage() {
      return blockResponseMessage.value();
    }

    /**
     * @return rule-based-filter.defaultRule.blockResponseHeaders[]
     */
    public List<BlockResponseHeaders> blockResponseHeaders() {
      return blockResponseHeaders;
    }

    /**
     * @param i the index of the value to return
     * @return rule-based-filter.defaultRule.blockResponseHeaders[]
     */
    public BlockResponseHeaders blockResponseHeaders(int i) {
      return blockResponseHeaders.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(DefaultRule newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("defaultRule");
      return changes;
    }

    /**
     * This class represents rule-based-filter.defaultRule.action
     */
    public final static class Action extends EnumNode<Action.Enum> {

      public Action(){
        this.value = null;
      }

      public Action(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {ALLOW, BLOCK}
      public final static Enum ALLOW = Enum.ALLOW;
      public final static Enum BLOCK = Enum.BLOCK;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }

    /**
     * This class represents rule-based-filter.defaultRule.blockResponseHeaders[]
     */
    public final static class BlockResponseHeaders extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name",
          "value"
          ));

        private String name = null;
        private String value = null;

        public Builder() { }

        public Builder(BlockResponseHeaders config) {
          name(config.name());
          value(config.value());
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          if (__superior.value != null)
            value(__superior.value);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Builder value(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          value = __value;
          __uninitialized.remove("value");
          return this;
        }


        public BlockResponseHeaders build() {
          return new BlockResponseHeaders(this);
        }

      }

      private final StringNode name;
      private final StringNode value;

      public BlockResponseHeaders(Builder builder) {
        this(builder, true);
      }

      private BlockResponseHeaders(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "rule-based-filter.defaultRule.blockResponseHeaders[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        value = (builder.value == null) ?
            new StringNode() : new StringNode(builder.value);
      }

      /**
       * @return rule-based-filter.defaultRule.blockResponseHeaders[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return rule-based-filter.defaultRule.blockResponseHeaders[].value
       */
      public String value() {
        return value.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(BlockResponseHeaders newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("blockResponseHeaders");
        return changes;
      }

      private static InnerNodeVector<BlockResponseHeaders> createVector(List<Builder> builders) {
          List<BlockResponseHeaders> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new BlockResponseHeaders(b));
          }
          return new InnerNodeVector<BlockResponseHeaders>(elems);
      }
    }
  }

  /**
   * This class represents rule-based-filter.rule[]
   */
  public final static class Rule extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name",
        "action"
        ));

      private String name = null;
      private Action.Enum action = null;
      public List<String> hostNames = new ArrayList<>();
      public List<Methods.Enum> methods = new ArrayList<>();
      public List<String> pathExpressions = new ArrayList<>();
      private Integer blockResponseCode = null;
      private String blockResponseMessage = null;
      public List<BlockResponseHeaders.Builder> blockResponseHeaders = new ArrayList<>();

      public Builder() { }

      public Builder(Rule config) {
        name(config.name());
        action(config.action());
        hostNames(config.hostNames());
        methods(config.methods());
        pathExpressions(config.pathExpressions());
        blockResponseCode(config.blockResponseCode());
        blockResponseMessage(config.blockResponseMessage());
        for (BlockResponseHeaders b : config.blockResponseHeaders()) {
          blockResponseHeaders(new BlockResponseHeaders.Builder(b));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.action != null)
          action(__superior.action);
        if (!__superior.hostNames.isEmpty())
          hostNames.addAll(__superior.hostNames);
        if (!__superior.methods.isEmpty())
          methods.addAll(__superior.methods);
        if (!__superior.pathExpressions.isEmpty())
          pathExpressions.addAll(__superior.pathExpressions);
        if (__superior.blockResponseCode != null)
          blockResponseCode(__superior.blockResponseCode);
        if (__superior.blockResponseMessage != null)
          blockResponseMessage(__superior.blockResponseMessage);
        if (!__superior.blockResponseHeaders.isEmpty())
          blockResponseHeaders.addAll(__superior.blockResponseHeaders);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder action(Action.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        action = __value;
        __uninitialized.remove("action");
        return this;
      }

      private Builder action(String __value) {
        return action(Action.Enum.valueOf(__value));
      }

      public Builder hostNames(String __value) {
        hostNames.add(__value);
        return this;
      }

      public Builder hostNames(Collection<String> __values) {
        hostNames.addAll(__values);
        return this;
      }

      public Builder methods(Methods.Enum __value) {
        methods.add(__value);
        return this;
      }

      public Builder methods(Collection<Methods.Enum> __values) {
        methods.addAll(__values);
        return this;
      }

      private Builder methods(String __value) {
        return methods(Methods.Enum.valueOf(__value));
      }

      public Builder pathExpressions(String __value) {
        pathExpressions.add(__value);
        return this;
      }

      public Builder pathExpressions(Collection<String> __values) {
        pathExpressions.addAll(__values);
        return this;
      }

      public Builder blockResponseCode(int __value) {
        blockResponseCode = __value;
        return this;
      }

      private Builder blockResponseCode(String __value) {
        return blockResponseCode(Integer.valueOf(__value));
      }

      public Builder blockResponseMessage(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        blockResponseMessage = __value;
        return this;
      }


      /**
       * Add the given builder to this builder's list of BlockResponseHeaders builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder blockResponseHeaders(BlockResponseHeaders.Builder __builder) {
        blockResponseHeaders.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder blockResponseHeaders(java.util.function.Consumer<BlockResponseHeaders.Builder> __func) {
        BlockResponseHeaders.Builder __inner = new BlockResponseHeaders.Builder();
        __func.accept(__inner);
        blockResponseHeaders.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of BlockResponseHeaders builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder blockResponseHeaders(List<BlockResponseHeaders.Builder> __builders) {
        blockResponseHeaders = __builders;
        return this;
      }

      public Rule build() {
        return new Rule(this);
      }

    }

    private final StringNode name;
    private final Action action;
    private final LeafNodeVector<String, StringNode> hostNames;
    private final LeafNodeVector<Methods.Enum, Methods> methods;
    private final LeafNodeVector<String, StringNode> pathExpressions;
    private final IntegerNode blockResponseCode;
    private final StringNode blockResponseMessage;
    private final InnerNodeVector<BlockResponseHeaders> blockResponseHeaders;

    public Rule(Builder builder) {
      this(builder, true);
    }

    private Rule(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "rule-based-filter.rule[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      action = (builder.action == null) ?
          new Action() : new Action(builder.action);
      hostNames = new LeafNodeVector<>(builder.hostNames, new StringNode());
      methods = new LeafNodeVector<>(builder.methods, new Methods());
      pathExpressions = new LeafNodeVector<>(builder.pathExpressions, new StringNode());
      blockResponseCode = (builder.blockResponseCode == null) ?
          new IntegerNode(403) : new IntegerNode(builder.blockResponseCode);
      blockResponseMessage = (builder.blockResponseMessage == null) ?
          new StringNode("") : new StringNode(builder.blockResponseMessage);
      blockResponseHeaders = BlockResponseHeaders.createVector(builder.blockResponseHeaders);
    }

    /**
     * @return rule-based-filter.rule[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return rule-based-filter.rule[].action
     */
    public Action.Enum action() {
      return action.value();
    }

    /**
     * @return rule-based-filter.rule[].hostNames[]
     */
    public List<String> hostNames() {
      return hostNames.asList();
    }

    /**
     * @param i the index of the value to return
     * @return rule-based-filter.rule[].hostNames[]
     */
    public String hostNames(int i) {
      return hostNames.get(i).value();
    }

    /**
     * @return rule-based-filter.rule[].methods[]
     */
    public List<Methods.Enum> methods() {
      return methods.asList();
    }

    /**
     * @param i the index of the value to return
     * @return rule-based-filter.rule[].methods[]
     */
    public Methods.Enum methods(int i) {
      return methods.get(i).value();
    }

    /**
     * @return rule-based-filter.rule[].pathExpressions[]
     */
    public List<String> pathExpressions() {
      return pathExpressions.asList();
    }

    /**
     * @param i the index of the value to return
     * @return rule-based-filter.rule[].pathExpressions[]
     */
    public String pathExpressions(int i) {
      return pathExpressions.get(i).value();
    }

    /**
     * @return rule-based-filter.rule[].blockResponseCode
     */
    public int blockResponseCode() {
      return blockResponseCode.value();
    }

    /**
     * @return rule-based-filter.rule[].blockResponseMessage
     */
    public String blockResponseMessage() {
      return blockResponseMessage.value();
    }

    /**
     * @return rule-based-filter.rule[].blockResponseHeaders[]
     */
    public List<BlockResponseHeaders> blockResponseHeaders() {
      return blockResponseHeaders;
    }

    /**
     * @param i the index of the value to return
     * @return rule-based-filter.rule[].blockResponseHeaders[]
     */
    public BlockResponseHeaders blockResponseHeaders(int i) {
      return blockResponseHeaders.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Rule newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("rule");
      return changes;
    }

    private static InnerNodeVector<Rule> createVector(List<Builder> builders) {
        List<Rule> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Rule(b));
        }
        return new InnerNodeVector<Rule>(elems);
    }

    /**
     * This class represents rule-based-filter.rule[].action
     */
    public final static class Action extends EnumNode<Action.Enum> {

      public Action(){
        this.value = null;
      }

      public Action(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {ALLOW, BLOCK}
      public final static Enum ALLOW = Enum.ALLOW;
      public final static Enum BLOCK = Enum.BLOCK;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }

    /**
     * This class represents rule-based-filter.rule[].methods[]
     */
    public final static class Methods extends EnumNode<Methods.Enum> {

      public Methods(){
        this.value = null;
      }

      public Methods(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {GET, POST, PUT, PATCH, DELETE}
      public final static Enum GET = Enum.GET;
      public final static Enum POST = Enum.POST;
      public final static Enum PUT = Enum.PUT;
      public final static Enum PATCH = Enum.PATCH;
      public final static Enum DELETE = Enum.DELETE;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }

    /**
     * This class represents rule-based-filter.rule[].blockResponseHeaders[]
     */
    public final static class BlockResponseHeaders extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name",
          "value"
          ));

        private String name = null;
        private String value = null;

        public Builder() { }

        public Builder(BlockResponseHeaders config) {
          name(config.name());
          value(config.value());
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          if (__superior.value != null)
            value(__superior.value);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Builder value(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          value = __value;
          __uninitialized.remove("value");
          return this;
        }


        public BlockResponseHeaders build() {
          return new BlockResponseHeaders(this);
        }

      }

      private final StringNode name;
      private final StringNode value;

      public BlockResponseHeaders(Builder builder) {
        this(builder, true);
      }

      private BlockResponseHeaders(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "rule-based-filter.rule[].blockResponseHeaders[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        value = (builder.value == null) ?
            new StringNode() : new StringNode(builder.value);
      }

      /**
       * @return rule-based-filter.rule[].blockResponseHeaders[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return rule-based-filter.rule[].blockResponseHeaders[].value
       */
      public String value() {
        return value.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(BlockResponseHeaders newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("blockResponseHeaders");
        return changes;
      }

      private static InnerNodeVector<BlockResponseHeaders> createVector(List<Builder> builders) {
          List<BlockResponseHeaders> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new BlockResponseHeaders(b));
          }
          return new InnerNodeVector<BlockResponseHeaders>(elems);
      }
    }
  }

}
