// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.core;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of stateserver
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class StateserverConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "75d37986bb1dc22067b1f95fbe3ec009";
  public final static String CONFIG_DEF_NAME = "stateserver";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.core";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.core",
    "httpport int default = 0"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer httpport = null;

    public Builder() { }

    public Builder(StateserverConfig config) {
      httpport(config.httpport());
    }

    private Builder override(Builder __superior) {
      if (__superior.httpport != null)
        httpport(__superior.httpport);
      return this;
    }

    public Builder httpport(int __value) {
      httpport = __value;
      return this;
    }

    private Builder httpport(String __value) {
      return httpport(Integer.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public StateserverConfig build() {
      return new StateserverConfig(this);
    }

  }

  // Port used for serving the state/vN api
  private final IntegerNode httpport;

  public StateserverConfig(Builder builder) {
    this(builder, true);
  }

  private StateserverConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "stateserver must be initialized: " + builder.__uninitialized);

    httpport = (builder.httpport == null) ?
        new IntegerNode(0) : new IntegerNode(builder.httpport);
  }

  /**
   * @return stateserver.httpport
   */
  public int httpport() {
    return httpport.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(StateserverConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("stateserver");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
