// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.content.reindexing;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of reindexing
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 * Reindexing status per document type, for a Vespa application
 */
public final class ReindexingConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "163d32a177d2bad9278217cbb6c0d042";
  public final static String CONFIG_DEF_NAME = "reindexing";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.content.reindexing";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.content.reindexing",
    "enabled bool default=false",
    "clusters{}.documentTypes{}.readyAtMillis long",
    "clusters{}.documentTypes{}.speed double default=0.2"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Boolean enabled = null;
    public Map<String, Clusters.Builder> clusters = new LinkedHashMap<>();

    public Builder() { }

    public Builder(ReindexingConfig config) {
      enabled(config.enabled());
      for (Map.Entry<String, Clusters> __entry : config.clusters().entrySet()) {
        clusters(__entry.getKey(), new Clusters.Builder(__entry.getValue()));
      }
    }

    private Builder override(Builder __superior) {
      if (__superior.enabled != null)
        enabled(__superior.enabled);
      clusters(__superior.clusters);
      return this;
    }

    public Builder enabled(boolean __value) {
      enabled = __value;
      return this;
    }

    private Builder enabled(String __value) {
      return enabled(Boolean.valueOf(__value));
    }

    public Builder clusters(String __key, Clusters.Builder __value) {
      clusters.put(__key, __value);
      return this;
    }

    public Builder clusters(Map<String, Clusters.Builder> __values) {
      clusters.putAll(__values);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before using it as the value
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder clusters(String __key, java.util.function.Consumer<Clusters.Builder> __func) {
      Clusters.Builder __inner = new Clusters.Builder();
      __func.accept(__inner);
      clusters.put(__key, __inner);
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ReindexingConfig build() {
      return new ReindexingConfig(this);
    }

  }

  // Whether reindexing should run at all
  private final BooleanNode enabled;
  private final Map<String, Clusters> clusters;

  public ReindexingConfig(Builder builder) {
    this(builder, true);
  }

  private ReindexingConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "reindexing must be initialized: " + builder.__uninitialized);

    enabled = (builder.enabled == null) ?
        new BooleanNode(false) : new BooleanNode(builder.enabled);
    clusters = Clusters.createMap(builder.clusters);
  }

  /**
   * @return reindexing.enabled
   */
  public boolean enabled() {
    return enabled.value();
  }

  /**
   * @return reindexing.clusters{}
   */
  public Map<String, Clusters> clusters() {
    return Collections.unmodifiableMap(clusters);
  }

  /**
   * @param key the key of the value to return
   * @return reindexing.clusters{}
   */
  public Clusters clusters(String key) {
    return clusters.get(key);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ReindexingConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("reindexing");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents reindexing.clusters{}
   */
  public final static class Clusters extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      public Map<String, DocumentTypes.Builder> documentTypes = new LinkedHashMap<>();

      public Builder() { }

      public Builder(Clusters config) {
        for (Map.Entry<String, DocumentTypes> __entry : config.documentTypes().entrySet()) {
          documentTypes(__entry.getKey(), new DocumentTypes.Builder(__entry.getValue()));
        }
      }

      private Builder override(Builder __superior) {
        documentTypes(__superior.documentTypes);
        return this;
      }

      public Builder documentTypes(String __key, DocumentTypes.Builder __value) {
        documentTypes.put(__key, __value);
        return this;
      }

      public Builder documentTypes(Map<String, DocumentTypes.Builder> __values) {
        documentTypes.putAll(__values);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before using it as the value
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder documentTypes(String __key, java.util.function.Consumer<DocumentTypes.Builder> __func) {
        DocumentTypes.Builder __inner = new DocumentTypes.Builder();
        __func.accept(__inner);
        documentTypes.put(__key, __inner);
        return this;
      }

      public Clusters build() {
        return new Clusters(this);
      }

    }

    private final Map<String, DocumentTypes> documentTypes;

    public Clusters(Builder builder) {
      this(builder, true);
    }

    private Clusters(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "reindexing.clusters{} must be initialized: " + builder.__uninitialized);

      documentTypes = DocumentTypes.createMap(builder.documentTypes);
    }

    /**
     * @return reindexing.clusters{}.documentTypes{}
     */
    public Map<String, DocumentTypes> documentTypes() {
      return Collections.unmodifiableMap(documentTypes);
    }

    /**
     * @param key the key of the value to return
     * @return reindexing.clusters{}.documentTypes{}
     */
    public DocumentTypes documentTypes(String key) {
      return documentTypes.get(key);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Clusters newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("clusters");
      return changes;
    }

    private static Map<String, Clusters> createMap(Map<String, Builder> builders) {
      Map<String, Clusters> ret = new LinkedHashMap<>();
      for(String key : builders.keySet()) {
        ret.put(key, new Clusters(builders.get(key)));
      }
      return Collections.unmodifiableMap(ret);
    }

    /**
     * This class represents reindexing.clusters{}.documentTypes{}
     */
    public final static class DocumentTypes extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "readyAtMillis"
          ));

        private Long readyAtMillis = null;
        private Double speed = null;

        public Builder() { }

        public Builder(DocumentTypes config) {
          readyAtMillis(config.readyAtMillis());
          speed(config.speed());
        }

        private Builder override(Builder __superior) {
          if (__superior.readyAtMillis != null)
            readyAtMillis(__superior.readyAtMillis);
          if (__superior.speed != null)
            speed(__superior.speed);
          return this;
        }

        public Builder readyAtMillis(long __value) {
          readyAtMillis = __value;
          __uninitialized.remove("readyAtMillis");
          return this;
        }

        private Builder readyAtMillis(String __value) {
          return readyAtMillis(Long.valueOf(__value));
        }

        public Builder speed(double __value) {
          speed = __value;
          return this;
        }

        private Builder speed(String __value) {
          return speed(Double.valueOf(__value));
        }

        public DocumentTypes build() {
          return new DocumentTypes(this);
        }

      }

      // Epoch millis after which latest reprocessing may begin, per document type, per cluster
      private final LongNode readyAtMillis;
      // Window size increment used for the dynamic throttling policy of the reindexing visitor session for each type
      private final DoubleNode speed;

      public DocumentTypes(Builder builder) {
        this(builder, true);
      }

      private DocumentTypes(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "reindexing.clusters{}.documentTypes{} must be initialized: " + builder.__uninitialized);

        readyAtMillis = (builder.readyAtMillis == null) ?
            new LongNode() : new LongNode(builder.readyAtMillis);
        speed = (builder.speed == null) ?
            new DoubleNode(0.2D) : new DoubleNode(builder.speed);
      }

      /**
       * @return reindexing.clusters{}.documentTypes{}.readyAtMillis
       */
      public long readyAtMillis() {
        return readyAtMillis.value();
      }

      /**
       * @return reindexing.clusters{}.documentTypes{}.speed
       */
      public double speed() {
        return speed.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(DocumentTypes newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("documentTypes");
        return changes;
      }

      private static Map<String, DocumentTypes> createMap(Map<String, Builder> builders) {
        Map<String, DocumentTypes> ret = new LinkedHashMap<>();
        for(String key : builders.keySet()) {
          ret.put(key, new DocumentTypes(builders.get(key)));
        }
        return Collections.unmodifiableMap(ret);
      }
    }
  }

}
