// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.content.core;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of bucketspaces
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class BucketspacesConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "52ea664c409e9f9a0cb0032f0bfe1df8";
  public final static String CONFIG_DEF_NAME = "bucketspaces";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.content.core";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.content.core",
    "documenttype[].name string",
    "documenttype[].bucketspace string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Documenttype.Builder> documenttype = new ArrayList<>();

    public Builder() { }

    public Builder(BucketspacesConfig config) {
      for (Documenttype d : config.documenttype()) {
        documenttype(new Documenttype.Builder(d));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.documenttype.isEmpty())
        documenttype.addAll(__superior.documenttype);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Documenttype builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder documenttype(Documenttype.Builder __builder) {
      documenttype.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder documenttype(java.util.function.Consumer<Documenttype.Builder> __func) {
      Documenttype.Builder __inner = new Documenttype.Builder();
      __func.accept(__inner);
      documenttype.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Documenttype builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder documenttype(List<Documenttype.Builder> __builders) {
      documenttype = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public BucketspacesConfig build() {
      return new BucketspacesConfig(this);
    }

  }

  private final InnerNodeVector<Documenttype> documenttype;

  public BucketspacesConfig(Builder builder) {
    this(builder, true);
  }

  private BucketspacesConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "bucketspaces must be initialized: " + builder.__uninitialized);

    documenttype = Documenttype.createVector(builder.documenttype);
  }

  /**
   * @return bucketspaces.documenttype[]
   */
  public List<Documenttype> documenttype() {
    return documenttype;
  }

  /**
   * @param i the index of the value to return
   * @return bucketspaces.documenttype[]
   */
  public Documenttype documenttype(int i) {
    return documenttype.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(BucketspacesConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("bucketspaces");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents bucketspaces.documenttype[]
   */
  public final static class Documenttype extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name",
        "bucketspace"
        ));

      private String name = null;
      private String bucketspace = null;

      public Builder() { }

      public Builder(Documenttype config) {
        name(config.name());
        bucketspace(config.bucketspace());
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.bucketspace != null)
          bucketspace(__superior.bucketspace);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder bucketspace(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        bucketspace = __value;
        __uninitialized.remove("bucketspace");
        return this;
      }


      public Documenttype build() {
        return new Documenttype(this);
      }

    }

    // This config contains the document types handled by a given content cluster
    // and the bucket space they belong to.
    // The name of a document type.
    private final StringNode name;
    // The bucket space this document type belongs to.
    private final StringNode bucketspace;

    public Documenttype(Builder builder) {
      this(builder, true);
    }

    private Documenttype(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "bucketspaces.documenttype[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      bucketspace = (builder.bucketspace == null) ?
          new StringNode() : new StringNode(builder.bucketspace);
    }

    /**
     * @return bucketspaces.documenttype[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return bucketspaces.documenttype[].bucketspace
     */
    public String bucketspace() {
      return bucketspace.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Documenttype newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("documenttype");
      return changes;
    }

    private static InnerNodeVector<Documenttype> createVector(List<Builder> builders) {
        List<Documenttype> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Documenttype(b));
        }
        return new InnerNodeVector<Documenttype>(elems);
    }
  }

}
