// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.content;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of upgrading
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class UpgradingConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "06b2267e0e1998f0ffeafc53decef552";
  public final static String CONFIG_DEF_NAME = "upgrading";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.content";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.content",
    "upgrading_major_to bool default=false",
    "upgrading_major_from bool default=false",
    "upgrading_minor_to bool default=false",
    "upgrading_minor_from bool default=false"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Boolean upgrading_major_to = null;
    private Boolean upgrading_major_from = null;
    private Boolean upgrading_minor_to = null;
    private Boolean upgrading_minor_from = null;

    public Builder() { }

    public Builder(UpgradingConfig config) {
      upgrading_major_to(config.upgrading_major_to());
      upgrading_major_from(config.upgrading_major_from());
      upgrading_minor_to(config.upgrading_minor_to());
      upgrading_minor_from(config.upgrading_minor_from());
    }

    private Builder override(Builder __superior) {
      if (__superior.upgrading_major_to != null)
        upgrading_major_to(__superior.upgrading_major_to);
      if (__superior.upgrading_major_from != null)
        upgrading_major_from(__superior.upgrading_major_from);
      if (__superior.upgrading_minor_to != null)
        upgrading_minor_to(__superior.upgrading_minor_to);
      if (__superior.upgrading_minor_from != null)
        upgrading_minor_from(__superior.upgrading_minor_from);
      return this;
    }

    public Builder upgrading_major_to(boolean __value) {
      upgrading_major_to = __value;
      return this;
    }

    private Builder upgrading_major_to(String __value) {
      return upgrading_major_to(Boolean.valueOf(__value));
    }

    public Builder upgrading_major_from(boolean __value) {
      upgrading_major_from = __value;
      return this;
    }

    private Builder upgrading_major_from(String __value) {
      return upgrading_major_from(Boolean.valueOf(__value));
    }

    public Builder upgrading_minor_to(boolean __value) {
      upgrading_minor_to = __value;
      return this;
    }

    private Builder upgrading_minor_to(String __value) {
      return upgrading_minor_to(Boolean.valueOf(__value));
    }

    public Builder upgrading_minor_from(boolean __value) {
      upgrading_minor_from = __value;
      return this;
    }

    private Builder upgrading_minor_from(String __value) {
      return upgrading_minor_from(Boolean.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public UpgradingConfig build() {
      return new UpgradingConfig(this);
    }

  }

  // Config specifying cluster global parameters for a storage cluster.
  // Set to true when there exist nodes of previous major version in cluster.
  // This will enable major version backward compability mode in the cluster.
  private final BooleanNode upgrading_major_to;
  // Set to true when there exist nodes of the next major version in the
  // cluster. This will usually not be needed, unless specified in the upgrade
  // docs. Sometimes though, it may be easier to let old version be forward
  // compatable than having new version backwards compatable.
  private final BooleanNode upgrading_major_from;
  // Set to true when there exist nodes of previous minor version in cluster.
  // This should not be needed, but settings exist in case we end up having
  // no other choice than to have a compatability mode between minor versions.
  private final BooleanNode upgrading_minor_to;
  // Set to true when there exist nodes of next minor version in cluster.
  // This should not be needed, but settings exist in case we end up having
  // no other choice than to have a compatability mode between minor versions.
  private final BooleanNode upgrading_minor_from;

  public UpgradingConfig(Builder builder) {
    this(builder, true);
  }

  private UpgradingConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "upgrading must be initialized: " + builder.__uninitialized);

    upgrading_major_to = (builder.upgrading_major_to == null) ?
        new BooleanNode(false) : new BooleanNode(builder.upgrading_major_to);
    upgrading_major_from = (builder.upgrading_major_from == null) ?
        new BooleanNode(false) : new BooleanNode(builder.upgrading_major_from);
    upgrading_minor_to = (builder.upgrading_minor_to == null) ?
        new BooleanNode(false) : new BooleanNode(builder.upgrading_minor_to);
    upgrading_minor_from = (builder.upgrading_minor_from == null) ?
        new BooleanNode(false) : new BooleanNode(builder.upgrading_minor_from);
  }

  /**
   * @return upgrading.upgrading_major_to
   */
  public boolean upgrading_major_to() {
    return upgrading_major_to.value();
  }

  /**
   * @return upgrading.upgrading_major_from
   */
  public boolean upgrading_major_from() {
    return upgrading_major_from.value();
  }

  /**
   * @return upgrading.upgrading_minor_to
   */
  public boolean upgrading_minor_to() {
    return upgrading_minor_to.value();
  }

  /**
   * @return upgrading.upgrading_minor_from
   */
  public boolean upgrading_minor_from() {
    return upgrading_minor_from.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(UpgradingConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("upgrading");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
