// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.content;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of stor-filestor
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class StorFilestorConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "fe0ebeacc10f983e3a3b65fae5778c66";
  public final static String CONFIG_DEF_NAME = "stor-filestor";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.content";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.content",
    "num_threads int default=8 restart",
    "num_response_threads int default=2 restart",
    "num_visitor_threads int default=16 restart",
    "num_network_threads int default=2 restart",
    "response_sequencer_type enum {LATENCY, THROUGHPUT, ADAPTIVE} default=ADAPTIVE restart",
    "bucket_merge_chunk_size int default=16772216 restart",
    "use_async_message_handling_on_schedule bool default=false",
    "resource_usage_reporter_noise_level double default=0.001",
    "async_operation_throttler.type enum { UNLIMITED, DYNAMIC } default=DYNAMIC",
    "async_operation_throttler.window_size_increment int default=20",
    "async_operation_throttler.window_size_decrement_factor double default=1.2",
    "async_operation_throttler.window_size_backoff double default=0.95",
    "async_operation_throttler.min_window_size int default=20",
    "async_operation_throttler.max_window_size int default=-1",
    "async_operation_throttler.resize_rate double default=3.0",
    "max_feed_op_batch_size int default=64",
    "maintenance_operation_throttler.type enum { UNLIMITED, DYNAMIC } default=UNLIMITED",
    "maintenance_operation_throttler.window_size_increment int default=10",
    "maintenance_operation_throttler.window_size_decrement_factor double default=1.2",
    "maintenance_operation_throttler.window_size_backoff double default=0.95",
    "maintenance_operation_throttler.min_window_size int default=10",
    "maintenance_operation_throttler.max_window_size int default=-1",
    "maintenance_operation_throttler.resize_rate double default=2.0"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer num_threads = null;
    private Integer num_response_threads = null;
    private Integer num_visitor_threads = null;
    private Integer num_network_threads = null;
    private Response_sequencer_type.Enum response_sequencer_type = null;
    private Integer bucket_merge_chunk_size = null;
    private Boolean use_async_message_handling_on_schedule = null;
    private Double resource_usage_reporter_noise_level = null;
    public Async_operation_throttler.Builder async_operation_throttler = new Async_operation_throttler.Builder();
    private Integer max_feed_op_batch_size = null;
    public Maintenance_operation_throttler.Builder maintenance_operation_throttler = new Maintenance_operation_throttler.Builder();

    public Builder() { }

    public Builder(StorFilestorConfig config) {
      num_threads(config.num_threads());
      num_response_threads(config.num_response_threads());
      num_visitor_threads(config.num_visitor_threads());
      num_network_threads(config.num_network_threads());
      response_sequencer_type(config.response_sequencer_type());
      bucket_merge_chunk_size(config.bucket_merge_chunk_size());
      use_async_message_handling_on_schedule(config.use_async_message_handling_on_schedule());
      resource_usage_reporter_noise_level(config.resource_usage_reporter_noise_level());
      async_operation_throttler(new Async_operation_throttler.Builder(config.async_operation_throttler()));
      max_feed_op_batch_size(config.max_feed_op_batch_size());
      maintenance_operation_throttler(new Maintenance_operation_throttler.Builder(config.maintenance_operation_throttler()));
    }

    private Builder override(Builder __superior) {
      if (__superior.num_threads != null)
        num_threads(__superior.num_threads);
      if (__superior.num_response_threads != null)
        num_response_threads(__superior.num_response_threads);
      if (__superior.num_visitor_threads != null)
        num_visitor_threads(__superior.num_visitor_threads);
      if (__superior.num_network_threads != null)
        num_network_threads(__superior.num_network_threads);
      if (__superior.response_sequencer_type != null)
        response_sequencer_type(__superior.response_sequencer_type);
      if (__superior.bucket_merge_chunk_size != null)
        bucket_merge_chunk_size(__superior.bucket_merge_chunk_size);
      if (__superior.use_async_message_handling_on_schedule != null)
        use_async_message_handling_on_schedule(__superior.use_async_message_handling_on_schedule);
      if (__superior.resource_usage_reporter_noise_level != null)
        resource_usage_reporter_noise_level(__superior.resource_usage_reporter_noise_level);
      async_operation_throttler(async_operation_throttler.override(__superior.async_operation_throttler));
      if (__superior.max_feed_op_batch_size != null)
        max_feed_op_batch_size(__superior.max_feed_op_batch_size);
      maintenance_operation_throttler(maintenance_operation_throttler.override(__superior.maintenance_operation_throttler));
      return this;
    }

    public Builder num_threads(int __value) {
      num_threads = __value;
      return this;
    }

    private Builder num_threads(String __value) {
      return num_threads(Integer.valueOf(__value));
    }

    public Builder num_response_threads(int __value) {
      num_response_threads = __value;
      return this;
    }

    private Builder num_response_threads(String __value) {
      return num_response_threads(Integer.valueOf(__value));
    }

    public Builder num_visitor_threads(int __value) {
      num_visitor_threads = __value;
      return this;
    }

    private Builder num_visitor_threads(String __value) {
      return num_visitor_threads(Integer.valueOf(__value));
    }

    public Builder num_network_threads(int __value) {
      num_network_threads = __value;
      return this;
    }

    private Builder num_network_threads(String __value) {
      return num_network_threads(Integer.valueOf(__value));
    }

    public Builder response_sequencer_type(Response_sequencer_type.Enum __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      response_sequencer_type = __value;
      return this;
    }

    private Builder response_sequencer_type(String __value) {
      return response_sequencer_type(Response_sequencer_type.Enum.valueOf(__value));
    }

    public Builder bucket_merge_chunk_size(int __value) {
      bucket_merge_chunk_size = __value;
      return this;
    }

    private Builder bucket_merge_chunk_size(String __value) {
      return bucket_merge_chunk_size(Integer.valueOf(__value));
    }

    public Builder use_async_message_handling_on_schedule(boolean __value) {
      use_async_message_handling_on_schedule = __value;
      return this;
    }

    private Builder use_async_message_handling_on_schedule(String __value) {
      return use_async_message_handling_on_schedule(Boolean.valueOf(__value));
    }

    public Builder resource_usage_reporter_noise_level(double __value) {
      resource_usage_reporter_noise_level = __value;
      return this;
    }

    private Builder resource_usage_reporter_noise_level(String __value) {
      return resource_usage_reporter_noise_level(Double.valueOf(__value));
    }

    public Builder async_operation_throttler(Async_operation_throttler.Builder __builder) {
      async_operation_throttler = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder async_operation_throttler(java.util.function.Consumer<Async_operation_throttler.Builder> __func) {
      Async_operation_throttler.Builder __inner = new Async_operation_throttler.Builder();
      __func.accept(__inner);
      async_operation_throttler = __inner;
      return this;
    }

    public Builder max_feed_op_batch_size(int __value) {
      max_feed_op_batch_size = __value;
      return this;
    }

    private Builder max_feed_op_batch_size(String __value) {
      return max_feed_op_batch_size(Integer.valueOf(__value));
    }

    public Builder maintenance_operation_throttler(Maintenance_operation_throttler.Builder __builder) {
      maintenance_operation_throttler = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder maintenance_operation_throttler(java.util.function.Consumer<Maintenance_operation_throttler.Builder> __func) {
      Maintenance_operation_throttler.Builder __inner = new Maintenance_operation_throttler.Builder();
      __func.accept(__inner);
      maintenance_operation_throttler = __inner;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public StorFilestorConfig build() {
      return new StorFilestorConfig(this);
    }

  }

  // PERFORMANCE PARAMETERS
  // Number of threads to use for each mountpoint.
  private final IntegerNode num_threads;
  // Number of threads for response processing and delivery
  // 0 will give legacy sync behavior.
  // Negative number will choose a good number based on # cores.
  private final IntegerNode num_response_threads;
  // Number of handler objects that might be created by visitor threads
  // This is a temporary setting that only skilled vespa developers should modify
  // This must be kept in line with stor-visitor:visitorthreads
  private final IntegerNode num_visitor_threads;
  // Number of handler objects that might be created by network threads
  // This is a temporary setting that only skilled vespa developers should modify
  // This must be kept in line with stor-communicationmanager:rpc.num_network_threads
  private final IntegerNode num_network_threads;
  // Type of sequenced thread executor use for persistence replies.
  private final Response_sequencer_type response_sequencer_type;
  // Chunksize to use while merging buckets between nodes.
  //  
  // Should follow stor-distributormanager:splitsize (16MB).
  private final IntegerNode bucket_merge_chunk_size;
  // Whether to use async message handling when scheduling storage messages from FileStorManager.
  //  
  // When turned on, the calling thread (e.g. FNET network thread when using Storage API RPC)
  // gets the next async message to handle (if any) as part of scheduling a storage message.
  // This async message is then handled by the calling thread immediately,
  // instead of going via a persistence thread.
  private final BooleanNode use_async_message_handling_on_schedule;
  // The noise level used when deciding whether a resource usage sample should be reported to the cluster controller.
  //  
  // If one of the resource categories (e.g. disk or memory) has a usage delta that is larger than the noise level,
  // the entire resource usage sample is immediately reported to the cluster controller (via host info).
  // This config can be live updated (doesn't require restart).
  private final DoubleNode resource_usage_reporter_noise_level;
  private final Async_operation_throttler async_operation_throttler;
  // Maximum number of enqueued put/remove/update operations towards a given bucket
  // that can be dispatched asynchronously as a batch under the same write lock.
  // This prevents pipeline stalls when many write operations are in-flight to the
  // same bucket, as each operation would otherwise have to wait for the completion
  // of all prior writes to the bucket.
  private final IntegerNode max_feed_op_batch_size;
  private final Maintenance_operation_throttler maintenance_operation_throttler;

  public StorFilestorConfig(Builder builder) {
    this(builder, true);
  }

  private StorFilestorConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "stor-filestor must be initialized: " + builder.__uninitialized);

    num_threads = (builder.num_threads == null) ?
        new IntegerNode(8) : new IntegerNode(builder.num_threads);
    num_response_threads = (builder.num_response_threads == null) ?
        new IntegerNode(2) : new IntegerNode(builder.num_response_threads);
    num_visitor_threads = (builder.num_visitor_threads == null) ?
        new IntegerNode(16) : new IntegerNode(builder.num_visitor_threads);
    num_network_threads = (builder.num_network_threads == null) ?
        new IntegerNode(2) : new IntegerNode(builder.num_network_threads);
    response_sequencer_type = (builder.response_sequencer_type == null) ?
        new Response_sequencer_type(Response_sequencer_type.ADAPTIVE) : new Response_sequencer_type(builder.response_sequencer_type);
    bucket_merge_chunk_size = (builder.bucket_merge_chunk_size == null) ?
        new IntegerNode(16772216) : new IntegerNode(builder.bucket_merge_chunk_size);
    use_async_message_handling_on_schedule = (builder.use_async_message_handling_on_schedule == null) ?
        new BooleanNode(false) : new BooleanNode(builder.use_async_message_handling_on_schedule);
    resource_usage_reporter_noise_level = (builder.resource_usage_reporter_noise_level == null) ?
        new DoubleNode(0.001D) : new DoubleNode(builder.resource_usage_reporter_noise_level);
    async_operation_throttler = new Async_operation_throttler(builder.async_operation_throttler, throwIfUninitialized);
    max_feed_op_batch_size = (builder.max_feed_op_batch_size == null) ?
        new IntegerNode(64) : new IntegerNode(builder.max_feed_op_batch_size);
    maintenance_operation_throttler = new Maintenance_operation_throttler(builder.maintenance_operation_throttler, throwIfUninitialized);
  }

  /**
   * @return stor-filestor.num_threads
   */
  public int num_threads() {
    return num_threads.value();
  }

  /**
   * @return stor-filestor.num_response_threads
   */
  public int num_response_threads() {
    return num_response_threads.value();
  }

  /**
   * @return stor-filestor.num_visitor_threads
   */
  public int num_visitor_threads() {
    return num_visitor_threads.value();
  }

  /**
   * @return stor-filestor.num_network_threads
   */
  public int num_network_threads() {
    return num_network_threads.value();
  }

  /**
   * @return stor-filestor.response_sequencer_type
   */
  public Response_sequencer_type.Enum response_sequencer_type() {
    return response_sequencer_type.value();
  }

  /**
   * @return stor-filestor.bucket_merge_chunk_size
   */
  public int bucket_merge_chunk_size() {
    return bucket_merge_chunk_size.value();
  }

  /**
   * @return stor-filestor.use_async_message_handling_on_schedule
   */
  public boolean use_async_message_handling_on_schedule() {
    return use_async_message_handling_on_schedule.value();
  }

  /**
   * @return stor-filestor.resource_usage_reporter_noise_level
   */
  public double resource_usage_reporter_noise_level() {
    return resource_usage_reporter_noise_level.value();
  }

  /**
   * @return stor-filestor.async_operation_throttler
   */
  public Async_operation_throttler async_operation_throttler() {
    return async_operation_throttler;
  }

  /**
   * @return stor-filestor.max_feed_op_batch_size
   */
  public int max_feed_op_batch_size() {
    return max_feed_op_batch_size.value();
  }

  /**
   * @return stor-filestor.maintenance_operation_throttler
   */
  public Maintenance_operation_throttler maintenance_operation_throttler() {
    return maintenance_operation_throttler;
  }

  private ChangesRequiringRestart getChangesRequiringRestart(StorFilestorConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("stor-filestor");
      changes.compare(this.num_threads, newConfig.num_threads, "num_threads", "PERFORMANCE PARAMETERS\n\nNumber of threads to use for each mountpoint.");
      changes.compare(this.num_response_threads, newConfig.num_response_threads, "num_response_threads", "Number of threads for response processing and delivery\n0 will give legacy sync behavior.\nNegative number will choose a good number based on # cores.");
      changes.compare(this.num_visitor_threads, newConfig.num_visitor_threads, "num_visitor_threads", "Number of handler objects that might be created by visitor threads\nThis is a temporary setting that only skilled vespa developers should modify\nThis must be kept in line with stor-visitor:visitorthreads");
      changes.compare(this.num_network_threads, newConfig.num_network_threads, "num_network_threads", "Number of handler objects that might be created by network threads\nThis is a temporary setting that only skilled vespa developers should modify\nThis must be kept in line with stor-communicationmanager:rpc.num_network_threads");
      changes.compare(this.response_sequencer_type, newConfig.response_sequencer_type, "response_sequencer_type", "Type of sequenced thread executor use for persistence replies.");
      changes.compare(this.bucket_merge_chunk_size, newConfig.bucket_merge_chunk_size, "bucket_merge_chunk_size", "Chunksize to use while merging buckets between nodes.\n \nShould follow stor-distributormanager:splitsize (16MB).");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return true;
  }

  /**
   * This class represents stor-filestor.response_sequencer_type
   * 
   * Type of sequenced thread executor use for persistence replies.
   */
  public final static class Response_sequencer_type extends EnumNode<Response_sequencer_type.Enum> {

    public Response_sequencer_type(){
      this.value = null;
    }

    public Response_sequencer_type(Enum enumValue) {
      super(enumValue != null);
      this.value = enumValue;
    }

    public enum Enum {LATENCY, THROUGHPUT, ADAPTIVE}
    public final static Enum LATENCY = Enum.LATENCY;
    public final static Enum THROUGHPUT = Enum.THROUGHPUT;
    public final static Enum ADAPTIVE = Enum.ADAPTIVE;

    @Override
    protected boolean doSetValue(String name) {
      try {
        value = Enum.valueOf(name);
        return true;
      } catch (IllegalArgumentException e) {
      }
      return false;
    }
  }

  /**
   * This class represents stor-filestor.async_operation_throttler
   */
  public final static class Async_operation_throttler extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Type.Enum type = null;
      private Integer window_size_increment = null;
      private Double window_size_decrement_factor = null;
      private Double window_size_backoff = null;
      private Integer min_window_size = null;
      private Integer max_window_size = null;
      private Double resize_rate = null;

      public Builder() { }

      public Builder(Async_operation_throttler config) {
        type(config.type());
        window_size_increment(config.window_size_increment());
        window_size_decrement_factor(config.window_size_decrement_factor());
        window_size_backoff(config.window_size_backoff());
        min_window_size(config.min_window_size());
        max_window_size(config.max_window_size());
        resize_rate(config.resize_rate());
      }

      private Builder override(Builder __superior) {
        if (__superior.type != null)
          type(__superior.type);
        if (__superior.window_size_increment != null)
          window_size_increment(__superior.window_size_increment);
        if (__superior.window_size_decrement_factor != null)
          window_size_decrement_factor(__superior.window_size_decrement_factor);
        if (__superior.window_size_backoff != null)
          window_size_backoff(__superior.window_size_backoff);
        if (__superior.min_window_size != null)
          min_window_size(__superior.min_window_size);
        if (__superior.max_window_size != null)
          max_window_size(__superior.max_window_size);
        if (__superior.resize_rate != null)
          resize_rate(__superior.resize_rate);
        return this;
      }

      public Builder type(Type.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        type = __value;
        return this;
      }

      private Builder type(String __value) {
        return type(Type.Enum.valueOf(__value));
      }

      public Builder window_size_increment(int __value) {
        window_size_increment = __value;
        return this;
      }

      private Builder window_size_increment(String __value) {
        return window_size_increment(Integer.valueOf(__value));
      }

      public Builder window_size_decrement_factor(double __value) {
        window_size_decrement_factor = __value;
        return this;
      }

      private Builder window_size_decrement_factor(String __value) {
        return window_size_decrement_factor(Double.valueOf(__value));
      }

      public Builder window_size_backoff(double __value) {
        window_size_backoff = __value;
        return this;
      }

      private Builder window_size_backoff(String __value) {
        return window_size_backoff(Double.valueOf(__value));
      }

      public Builder min_window_size(int __value) {
        min_window_size = __value;
        return this;
      }

      private Builder min_window_size(String __value) {
        return min_window_size(Integer.valueOf(__value));
      }

      public Builder max_window_size(int __value) {
        max_window_size = __value;
        return this;
      }

      private Builder max_window_size(String __value) {
        return max_window_size(Integer.valueOf(__value));
      }

      public Builder resize_rate(double __value) {
        resize_rate = __value;
        return this;
      }

      private Builder resize_rate(String __value) {
        return resize_rate(Double.valueOf(__value));
      }

      public Async_operation_throttler build() {
        return new Async_operation_throttler(this);
      }

    }

    // Specify throttling used for async persistence operations. This throttling takes place
    // before operations are dispatched to Proton and serves as a limiter for how many
    // operations may be in flight in Proton's internal queues.
    //  
    // - UNLIMITED is, as it says on the tin, unlimited. Offers no actual throttling, but
    // has near zero overhead and never blocks.
    // - DYNAMIC uses DynamicThrottlePolicy under the hood and will block if the window
    // is full (if a blocking throttler API call is invoked).
    //  
    private final Type type;
    // Internal throttler tuning parameters that only apply when type == DYNAMIC:
    private final IntegerNode window_size_increment;
    private final DoubleNode window_size_decrement_factor;
    private final DoubleNode window_size_backoff;
    private final IntegerNode min_window_size;
    private final IntegerNode max_window_size;
    private final DoubleNode resize_rate;

    public Async_operation_throttler(Builder builder) {
      this(builder, true);
    }

    private Async_operation_throttler(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "stor-filestor.async_operation_throttler must be initialized: " + builder.__uninitialized);

      type = (builder.type == null) ?
          new Type(Type.DYNAMIC) : new Type(builder.type);
      window_size_increment = (builder.window_size_increment == null) ?
          new IntegerNode(20) : new IntegerNode(builder.window_size_increment);
      window_size_decrement_factor = (builder.window_size_decrement_factor == null) ?
          new DoubleNode(1.2D) : new DoubleNode(builder.window_size_decrement_factor);
      window_size_backoff = (builder.window_size_backoff == null) ?
          new DoubleNode(0.95D) : new DoubleNode(builder.window_size_backoff);
      min_window_size = (builder.min_window_size == null) ?
          new IntegerNode(20) : new IntegerNode(builder.min_window_size);
      max_window_size = (builder.max_window_size == null) ?
          new IntegerNode(-1) : new IntegerNode(builder.max_window_size);
      resize_rate = (builder.resize_rate == null) ?
          new DoubleNode(3.0D) : new DoubleNode(builder.resize_rate);
    }

    /**
     * @return stor-filestor.async_operation_throttler.type
     */
    public Type.Enum type() {
      return type.value();
    }

    /**
     * @return stor-filestor.async_operation_throttler.window_size_increment
     */
    public int window_size_increment() {
      return window_size_increment.value();
    }

    /**
     * @return stor-filestor.async_operation_throttler.window_size_decrement_factor
     */
    public double window_size_decrement_factor() {
      return window_size_decrement_factor.value();
    }

    /**
     * @return stor-filestor.async_operation_throttler.window_size_backoff
     */
    public double window_size_backoff() {
      return window_size_backoff.value();
    }

    /**
     * @return stor-filestor.async_operation_throttler.min_window_size
     */
    public int min_window_size() {
      return min_window_size.value();
    }

    /**
     * @return stor-filestor.async_operation_throttler.max_window_size
     */
    public int max_window_size() {
      return max_window_size.value();
    }

    /**
     * @return stor-filestor.async_operation_throttler.resize_rate
     */
    public double resize_rate() {
      return resize_rate.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Async_operation_throttler newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("async_operation_throttler");
      return changes;
    }

    /**
     * This class represents stor-filestor.async_operation_throttler.type
     * 
     * Specify throttling used for async persistence operations. This throttling takes place
     * before operations are dispatched to Proton and serves as a limiter for how many
     * operations may be in flight in Proton's internal queues.
     *  
     * - UNLIMITED is, as it says on the tin, unlimited. Offers no actual throttling, but
     * has near zero overhead and never blocks.
     * - DYNAMIC uses DynamicThrottlePolicy under the hood and will block if the window
     * is full (if a blocking throttler API call is invoked).
     *  
     */
    public final static class Type extends EnumNode<Type.Enum> {

      public Type(){
        this.value = null;
      }

      public Type(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {UNLIMITED, DYNAMIC}
      public final static Enum UNLIMITED = Enum.UNLIMITED;
      public final static Enum DYNAMIC = Enum.DYNAMIC;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }
  }

  /**
   * This class represents stor-filestor.maintenance_operation_throttler
   */
  public final static class Maintenance_operation_throttler extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Type.Enum type = null;
      private Integer window_size_increment = null;
      private Double window_size_decrement_factor = null;
      private Double window_size_backoff = null;
      private Integer min_window_size = null;
      private Integer max_window_size = null;
      private Double resize_rate = null;

      public Builder() { }

      public Builder(Maintenance_operation_throttler config) {
        type(config.type());
        window_size_increment(config.window_size_increment());
        window_size_decrement_factor(config.window_size_decrement_factor());
        window_size_backoff(config.window_size_backoff());
        min_window_size(config.min_window_size());
        max_window_size(config.max_window_size());
        resize_rate(config.resize_rate());
      }

      private Builder override(Builder __superior) {
        if (__superior.type != null)
          type(__superior.type);
        if (__superior.window_size_increment != null)
          window_size_increment(__superior.window_size_increment);
        if (__superior.window_size_decrement_factor != null)
          window_size_decrement_factor(__superior.window_size_decrement_factor);
        if (__superior.window_size_backoff != null)
          window_size_backoff(__superior.window_size_backoff);
        if (__superior.min_window_size != null)
          min_window_size(__superior.min_window_size);
        if (__superior.max_window_size != null)
          max_window_size(__superior.max_window_size);
        if (__superior.resize_rate != null)
          resize_rate(__superior.resize_rate);
        return this;
      }

      public Builder type(Type.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        type = __value;
        return this;
      }

      private Builder type(String __value) {
        return type(Type.Enum.valueOf(__value));
      }

      public Builder window_size_increment(int __value) {
        window_size_increment = __value;
        return this;
      }

      private Builder window_size_increment(String __value) {
        return window_size_increment(Integer.valueOf(__value));
      }

      public Builder window_size_decrement_factor(double __value) {
        window_size_decrement_factor = __value;
        return this;
      }

      private Builder window_size_decrement_factor(String __value) {
        return window_size_decrement_factor(Double.valueOf(__value));
      }

      public Builder window_size_backoff(double __value) {
        window_size_backoff = __value;
        return this;
      }

      private Builder window_size_backoff(String __value) {
        return window_size_backoff(Double.valueOf(__value));
      }

      public Builder min_window_size(int __value) {
        min_window_size = __value;
        return this;
      }

      private Builder min_window_size(String __value) {
        return min_window_size(Integer.valueOf(__value));
      }

      public Builder max_window_size(int __value) {
        max_window_size = __value;
        return this;
      }

      private Builder max_window_size(String __value) {
        return max_window_size(Integer.valueOf(__value));
      }

      public Builder resize_rate(double __value) {
        resize_rate = __value;
        return this;
      }

      private Builder resize_rate(String __value) {
        return resize_rate(Double.valueOf(__value));
      }

      public Maintenance_operation_throttler build() {
        return new Maintenance_operation_throttler(this);
      }

    }

    // Specify throttling used for async _maintenance_ operations dispatched to Proton.
    // If enabled (i.e. set to DYNAMIC) this serves as a secondary throttling mechanism
    // for the following operations:
    // - Put/Remove as part of merge apply diffs
    // - RemoveByGid as part of bucket deletions
    // - Remove as part of remove location (i.e. GC)
    //  
    // Note that for a maintenance operation to be scheduled it has to _both_ acquire a
    // regular async operation throttler token _and_ a maintenance throttler token, in that
    // exact order.
    private final Type type;
    // Internal maintenance throttler tuning parameters that only apply when type == DYNAMIC:
    private final IntegerNode window_size_increment;
    private final DoubleNode window_size_decrement_factor;
    private final DoubleNode window_size_backoff;
    private final IntegerNode min_window_size;
    private final IntegerNode max_window_size;
    private final DoubleNode resize_rate;

    public Maintenance_operation_throttler(Builder builder) {
      this(builder, true);
    }

    private Maintenance_operation_throttler(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "stor-filestor.maintenance_operation_throttler must be initialized: " + builder.__uninitialized);

      type = (builder.type == null) ?
          new Type(Type.UNLIMITED) : new Type(builder.type);
      window_size_increment = (builder.window_size_increment == null) ?
          new IntegerNode(10) : new IntegerNode(builder.window_size_increment);
      window_size_decrement_factor = (builder.window_size_decrement_factor == null) ?
          new DoubleNode(1.2D) : new DoubleNode(builder.window_size_decrement_factor);
      window_size_backoff = (builder.window_size_backoff == null) ?
          new DoubleNode(0.95D) : new DoubleNode(builder.window_size_backoff);
      min_window_size = (builder.min_window_size == null) ?
          new IntegerNode(10) : new IntegerNode(builder.min_window_size);
      max_window_size = (builder.max_window_size == null) ?
          new IntegerNode(-1) : new IntegerNode(builder.max_window_size);
      resize_rate = (builder.resize_rate == null) ?
          new DoubleNode(2.0D) : new DoubleNode(builder.resize_rate);
    }

    /**
     * @return stor-filestor.maintenance_operation_throttler.type
     */
    public Type.Enum type() {
      return type.value();
    }

    /**
     * @return stor-filestor.maintenance_operation_throttler.window_size_increment
     */
    public int window_size_increment() {
      return window_size_increment.value();
    }

    /**
     * @return stor-filestor.maintenance_operation_throttler.window_size_decrement_factor
     */
    public double window_size_decrement_factor() {
      return window_size_decrement_factor.value();
    }

    /**
     * @return stor-filestor.maintenance_operation_throttler.window_size_backoff
     */
    public double window_size_backoff() {
      return window_size_backoff.value();
    }

    /**
     * @return stor-filestor.maintenance_operation_throttler.min_window_size
     */
    public int min_window_size() {
      return min_window_size.value();
    }

    /**
     * @return stor-filestor.maintenance_operation_throttler.max_window_size
     */
    public int max_window_size() {
      return max_window_size.value();
    }

    /**
     * @return stor-filestor.maintenance_operation_throttler.resize_rate
     */
    public double resize_rate() {
      return resize_rate.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Maintenance_operation_throttler newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("maintenance_operation_throttler");
      return changes;
    }

    /**
     * This class represents stor-filestor.maintenance_operation_throttler.type
     * 
     * Specify throttling used for async _maintenance_ operations dispatched to Proton.
     * If enabled (i.e. set to DYNAMIC) this serves as a secondary throttling mechanism
     * for the following operations:
     * - Put/Remove as part of merge apply diffs
     * - RemoveByGid as part of bucket deletions
     * - Remove as part of remove location (i.e. GC)
     *  
     * Note that for a maintenance operation to be scheduled it has to _both_ acquire a
     * regular async operation throttler token _and_ a maintenance throttler token, in that
     * exact order.
     */
    public final static class Type extends EnumNode<Type.Enum> {

      public Type(){
        this.value = null;
      }

      public Type(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {UNLIMITED, DYNAMIC}
      public final static Enum UNLIMITED = Enum.UNLIMITED;
      public final static Enum DYNAMIC = Enum.DYNAMIC;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }
  }

}
