// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.content;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of stor-distribution
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class StorDistributionConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "c92d9731f286f2746a74fd1350b7c568";
  public final static String CONFIG_DEF_NAME = "stor-distribution";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.content";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.content",
    "redundancy int default=3",
    "initial_redundancy int default=0",
    "ensure_primary_persisted bool default=true",
    "ready_copies int default=0",
    "active_per_leaf_group bool default=false",
    "group[].index string",
    "group[].name string",
    "group[].capacity double default=1",
    "group[].partitions string default=\"\"",
    "group[].nodes[].index int",
    "group[].nodes[].retired bool default=false"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer redundancy = null;
    private Integer initial_redundancy = null;
    private Boolean ensure_primary_persisted = null;
    private Integer ready_copies = null;
    private Boolean active_per_leaf_group = null;
    public List<Group.Builder> group = new ArrayList<>();

    public Builder() { }

    public Builder(StorDistributionConfig config) {
      redundancy(config.redundancy());
      initial_redundancy(config.initial_redundancy());
      ensure_primary_persisted(config.ensure_primary_persisted());
      ready_copies(config.ready_copies());
      active_per_leaf_group(config.active_per_leaf_group());
      for (Group g : config.group()) {
        group(new Group.Builder(g));
      }
    }

    private Builder override(Builder __superior) {
      if (__superior.redundancy != null)
        redundancy(__superior.redundancy);
      if (__superior.initial_redundancy != null)
        initial_redundancy(__superior.initial_redundancy);
      if (__superior.ensure_primary_persisted != null)
        ensure_primary_persisted(__superior.ensure_primary_persisted);
      if (__superior.ready_copies != null)
        ready_copies(__superior.ready_copies);
      if (__superior.active_per_leaf_group != null)
        active_per_leaf_group(__superior.active_per_leaf_group);
      if (!__superior.group.isEmpty())
        group.addAll(__superior.group);
      return this;
    }

    public Builder redundancy(int __value) {
      redundancy = __value;
      return this;
    }

    private Builder redundancy(String __value) {
      return redundancy(Integer.valueOf(__value));
    }

    public Builder initial_redundancy(int __value) {
      initial_redundancy = __value;
      return this;
    }

    private Builder initial_redundancy(String __value) {
      return initial_redundancy(Integer.valueOf(__value));
    }

    public Builder ensure_primary_persisted(boolean __value) {
      ensure_primary_persisted = __value;
      return this;
    }

    private Builder ensure_primary_persisted(String __value) {
      return ensure_primary_persisted(Boolean.valueOf(__value));
    }

    public Builder ready_copies(int __value) {
      ready_copies = __value;
      return this;
    }

    private Builder ready_copies(String __value) {
      return ready_copies(Integer.valueOf(__value));
    }

    public Builder active_per_leaf_group(boolean __value) {
      active_per_leaf_group = __value;
      return this;
    }

    private Builder active_per_leaf_group(String __value) {
      return active_per_leaf_group(Boolean.valueOf(__value));
    }

    /**
     * Add the given builder to this builder's list of Group builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder group(Group.Builder __builder) {
      group.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder group(java.util.function.Consumer<Group.Builder> __func) {
      Group.Builder __inner = new Group.Builder();
      __func.accept(__inner);
      group.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Group builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder group(List<Group.Builder> __builders) {
      group = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public StorDistributionConfig build() {
      return new StorDistributionConfig(this);
    }

  }

  // Redundancy decides how many copies of documents will be stored. Documents
  // will store copies on enough nodes, such that the sum of the node reliability
  // factors is equal or above the redundancy.
  private final IntegerNode redundancy;
  // Initial redundancy allows put-operations to return as completed after
  // a subset of all copies have been persisted (known as initial persistence
  // in BCP terms).
  // Set to 0 to disable and use normal redundancy behavior instead.
  private final IntegerNode initial_redundancy;
  // If set, requires that the primary nodes copy should always be persisted
  // before an n-of-m initial persistence operation can complete.
  private final BooleanNode ensure_primary_persisted;
  // The number of copies that should be "ready" to be active.
  // Maximum is redundancy.
  private final IntegerNode ready_copies;
  // If this option is set true, the distributor will try to enforce one active copy
  // of buckets per leaf hierarchical group. This is a simple implementation for
  // search to be able to setup top level dispatcher to only send search to all
  // nodes in one group as they have a static cost per node used. If used,
  // hierarchical grouping can not be used for other purposes. Using this option
  // implies that:
  // - ready_copies == redundancy
  // - Only one level of hierarchical grouping defined.
  // - That level distributes copies to all defined groups.
  private final BooleanNode active_per_leaf_group;
  private final InnerNodeVector<Group> group;

  public StorDistributionConfig(Builder builder) {
    this(builder, true);
  }

  private StorDistributionConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "stor-distribution must be initialized: " + builder.__uninitialized);

    redundancy = (builder.redundancy == null) ?
        new IntegerNode(3) : new IntegerNode(builder.redundancy);
    initial_redundancy = (builder.initial_redundancy == null) ?
        new IntegerNode(0) : new IntegerNode(builder.initial_redundancy);
    ensure_primary_persisted = (builder.ensure_primary_persisted == null) ?
        new BooleanNode(true) : new BooleanNode(builder.ensure_primary_persisted);
    ready_copies = (builder.ready_copies == null) ?
        new IntegerNode(0) : new IntegerNode(builder.ready_copies);
    active_per_leaf_group = (builder.active_per_leaf_group == null) ?
        new BooleanNode(false) : new BooleanNode(builder.active_per_leaf_group);
    group = Group.createVector(builder.group);
  }

  /**
   * @return stor-distribution.redundancy
   */
  public int redundancy() {
    return redundancy.value();
  }

  /**
   * @return stor-distribution.initial_redundancy
   */
  public int initial_redundancy() {
    return initial_redundancy.value();
  }

  /**
   * @return stor-distribution.ensure_primary_persisted
   */
  public boolean ensure_primary_persisted() {
    return ensure_primary_persisted.value();
  }

  /**
   * @return stor-distribution.ready_copies
   */
  public int ready_copies() {
    return ready_copies.value();
  }

  /**
   * @return stor-distribution.active_per_leaf_group
   */
  public boolean active_per_leaf_group() {
    return active_per_leaf_group.value();
  }

  /**
   * @return stor-distribution.group[]
   */
  public List<Group> group() {
    return group;
  }

  /**
   * @param i the index of the value to return
   * @return stor-distribution.group[]
   */
  public Group group(int i) {
    return group.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(StorDistributionConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("stor-distribution");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents stor-distribution.group[]
   */
  public final static class Group extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "index",
        "name"
        ));

      private String index = null;
      private String name = null;
      private Double capacity = null;
      private String partitions = null;
      public List<Nodes.Builder> nodes = new ArrayList<>();

      public Builder() { }

      public Builder(Group config) {
        index(config.index());
        name(config.name());
        capacity(config.capacity());
        partitions(config.partitions());
        for (Nodes n : config.nodes()) {
          nodes(new Nodes.Builder(n));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.index != null)
          index(__superior.index);
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.capacity != null)
          capacity(__superior.capacity);
        if (__superior.partitions != null)
          partitions(__superior.partitions);
        if (!__superior.nodes.isEmpty())
          nodes.addAll(__superior.nodes);
        return this;
      }

      public Builder index(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        index = __value;
        __uninitialized.remove("index");
        return this;
      }


      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder capacity(double __value) {
        capacity = __value;
        return this;
      }

      private Builder capacity(String __value) {
        return capacity(Double.valueOf(__value));
      }

      public Builder partitions(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        partitions = __value;
        return this;
      }


      /**
       * Add the given builder to this builder's list of Nodes builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder nodes(Nodes.Builder __builder) {
        nodes.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder nodes(java.util.function.Consumer<Nodes.Builder> __func) {
        Nodes.Builder __inner = new Nodes.Builder();
        __func.accept(__inner);
        nodes.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Nodes builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder nodes(List<Nodes.Builder> __builders) {
        nodes = __builders;
        return this;
      }

      public Group build() {
        return new Group(this);
      }

    }

    // Hierarchical grouping divides the nodes into a tree of groups. Due to config
    // liking flat structures. The tree of groups is represented by a single array
    // of groups defined here, where index is a string that can have a form like
    // "1.2.1" in order to tell where in the tree structure the group is.
    private final StringNode index;
    // Each group needs to have a name. Makes it easier to operations that they can
    // name their groups according to what they want to call them.
    private final StringNode name;
    // Capacity of the given group
    private final DoubleNode capacity;
    // Partitions define how copies are divided among child groups/nodes.
    private final StringNode partitions;
    private final InnerNodeVector<Nodes> nodes;

    public Group(Builder builder) {
      this(builder, true);
    }

    private Group(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "stor-distribution.group[] must be initialized: " + builder.__uninitialized);

      index = (builder.index == null) ?
          new StringNode() : new StringNode(builder.index);
      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      capacity = (builder.capacity == null) ?
          new DoubleNode(1D) : new DoubleNode(builder.capacity);
      partitions = (builder.partitions == null) ?
          new StringNode("") : new StringNode(builder.partitions);
      nodes = Nodes.createVector(builder.nodes);
    }

    /**
     * @return stor-distribution.group[].index
     */
    public String index() {
      return index.value();
    }

    /**
     * @return stor-distribution.group[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return stor-distribution.group[].capacity
     */
    public double capacity() {
      return capacity.value();
    }

    /**
     * @return stor-distribution.group[].partitions
     */
    public String partitions() {
      return partitions.value();
    }

    /**
     * @return stor-distribution.group[].nodes[]
     */
    public List<Nodes> nodes() {
      return nodes;
    }

    /**
     * @param i the index of the value to return
     * @return stor-distribution.group[].nodes[]
     */
    public Nodes nodes(int i) {
      return nodes.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Group newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("group");
      return changes;
    }

    private static InnerNodeVector<Group> createVector(List<Builder> builders) {
        List<Group> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Group(b));
        }
        return new InnerNodeVector<Group>(elems);
    }

    /**
     * This class represents stor-distribution.group[].nodes[]
     */
    public final static class Nodes extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "index"
          ));

        private Integer index = null;
        private Boolean retired = null;

        public Builder() { }

        public Builder(Nodes config) {
          index(config.index());
          retired(config.retired());
        }

        private Builder override(Builder __superior) {
          if (__superior.index != null)
            index(__superior.index);
          if (__superior.retired != null)
            retired(__superior.retired);
          return this;
        }

        public Builder index(int __value) {
          index = __value;
          __uninitialized.remove("index");
          return this;
        }

        private Builder index(String __value) {
          return index(Integer.valueOf(__value));
        }

        public Builder retired(boolean __value) {
          retired = __value;
          return this;
        }

        private Builder retired(String __value) {
          return retired(Boolean.valueOf(__value));
        }

        public Nodes build() {
          return new Nodes(this);
        }

      }

      // Leaf groups will have a set of nodes within them. Branch groups will have
      // none.
      private final IntegerNode index;
      // Whether this node is retired.
      // The system will migrate all data away from retired nodes such that they can
      // eventually be removed without partial data loss
      private final BooleanNode retired;

      public Nodes(Builder builder) {
        this(builder, true);
      }

      private Nodes(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "stor-distribution.group[].nodes[] must be initialized: " + builder.__uninitialized);

        index = (builder.index == null) ?
            new IntegerNode() : new IntegerNode(builder.index);
        retired = (builder.retired == null) ?
            new BooleanNode(false) : new BooleanNode(builder.retired);
      }

      /**
       * @return stor-distribution.group[].nodes[].index
       */
      public int index() {
        return index.value();
      }

      /**
       * @return stor-distribution.group[].nodes[].retired
       */
      public boolean retired() {
        return retired.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Nodes newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("nodes");
        return changes;
      }

      private static InnerNodeVector<Nodes> createVector(List<Builder> builders) {
          List<Nodes> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Nodes(b));
          }
          return new InnerNodeVector<Nodes>(elems);
      }
    }
  }

}
