// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.content;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of persistence
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class PersistenceConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "e2ec2c9ef2aa6c99583a99ab1bcb5065";
  public final static String CONFIG_DEF_NAME = "persistence";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.content";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.content",
    "abort_operations_with_changed_bucket_ownership bool default=true",
    "abort_outdated_mutating_ideal_state_ops bool default=true",
    "abort_outdated_mutating_external_load_ops bool default=true",
    "fail_partition_on_error bool default=true",
    "revert_time_period int default=300",
    "keep_remove_time_period int default=604800",
    "maximum_versions_of_single_document_stored int default=5"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Boolean abort_operations_with_changed_bucket_ownership = null;
    private Boolean abort_outdated_mutating_ideal_state_ops = null;
    private Boolean abort_outdated_mutating_external_load_ops = null;
    private Boolean fail_partition_on_error = null;
    private Integer revert_time_period = null;
    private Integer keep_remove_time_period = null;
    private Integer maximum_versions_of_single_document_stored = null;

    public Builder() { }

    public Builder(PersistenceConfig config) {
      abort_operations_with_changed_bucket_ownership(config.abort_operations_with_changed_bucket_ownership());
      abort_outdated_mutating_ideal_state_ops(config.abort_outdated_mutating_ideal_state_ops());
      abort_outdated_mutating_external_load_ops(config.abort_outdated_mutating_external_load_ops());
      fail_partition_on_error(config.fail_partition_on_error());
      revert_time_period(config.revert_time_period());
      keep_remove_time_period(config.keep_remove_time_period());
      maximum_versions_of_single_document_stored(config.maximum_versions_of_single_document_stored());
    }

    private Builder override(Builder __superior) {
      if (__superior.abort_operations_with_changed_bucket_ownership != null)
        abort_operations_with_changed_bucket_ownership(__superior.abort_operations_with_changed_bucket_ownership);
      if (__superior.abort_outdated_mutating_ideal_state_ops != null)
        abort_outdated_mutating_ideal_state_ops(__superior.abort_outdated_mutating_ideal_state_ops);
      if (__superior.abort_outdated_mutating_external_load_ops != null)
        abort_outdated_mutating_external_load_ops(__superior.abort_outdated_mutating_external_load_ops);
      if (__superior.fail_partition_on_error != null)
        fail_partition_on_error(__superior.fail_partition_on_error);
      if (__superior.revert_time_period != null)
        revert_time_period(__superior.revert_time_period);
      if (__superior.keep_remove_time_period != null)
        keep_remove_time_period(__superior.keep_remove_time_period);
      if (__superior.maximum_versions_of_single_document_stored != null)
        maximum_versions_of_single_document_stored(__superior.maximum_versions_of_single_document_stored);
      return this;
    }

    public Builder abort_operations_with_changed_bucket_ownership(boolean __value) {
      abort_operations_with_changed_bucket_ownership = __value;
      return this;
    }

    private Builder abort_operations_with_changed_bucket_ownership(String __value) {
      return abort_operations_with_changed_bucket_ownership(Boolean.valueOf(__value));
    }

    public Builder abort_outdated_mutating_ideal_state_ops(boolean __value) {
      abort_outdated_mutating_ideal_state_ops = __value;
      return this;
    }

    private Builder abort_outdated_mutating_ideal_state_ops(String __value) {
      return abort_outdated_mutating_ideal_state_ops(Boolean.valueOf(__value));
    }

    public Builder abort_outdated_mutating_external_load_ops(boolean __value) {
      abort_outdated_mutating_external_load_ops = __value;
      return this;
    }

    private Builder abort_outdated_mutating_external_load_ops(String __value) {
      return abort_outdated_mutating_external_load_ops(Boolean.valueOf(__value));
    }

    public Builder fail_partition_on_error(boolean __value) {
      fail_partition_on_error = __value;
      return this;
    }

    private Builder fail_partition_on_error(String __value) {
      return fail_partition_on_error(Boolean.valueOf(__value));
    }

    public Builder revert_time_period(int __value) {
      revert_time_period = __value;
      return this;
    }

    private Builder revert_time_period(String __value) {
      return revert_time_period(Integer.valueOf(__value));
    }

    public Builder keep_remove_time_period(int __value) {
      keep_remove_time_period = __value;
      return this;
    }

    private Builder keep_remove_time_period(String __value) {
      return keep_remove_time_period(Integer.valueOf(__value));
    }

    public Builder maximum_versions_of_single_document_stored(int __value) {
      maximum_versions_of_single_document_stored = __value;
      return this;
    }

    private Builder maximum_versions_of_single_document_stored(String __value) {
      return maximum_versions_of_single_document_stored(Integer.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public PersistenceConfig build() {
      return new PersistenceConfig(this);
    }

  }

  // If set, causes the service layer to trigger an abort of any queued
  // operations for buckets whose ownership changes during a cluster state
  // change. This helps ensure consistency between the distributors and
  // the storage nodes by discarding operations that were not sent by the
  // new owning distributor. The service layer will also block any new
  // operations from happening until all operations currently executing for
  // buckets with changed ownership have completed.
  // Enabling this option has a potential of causing a minor performance
  // impact when a node goes up or down due to its blocking semantics, but
  // this should be on the order of tens to a few hundred milliseconds.
  private final BooleanNode abort_operations_with_changed_bucket_ownership;
  // If set, aborts any mutating ideal state operations that arrive to a node
  // that were scheduled and sent by distributors that no longer own the buckets
  // the operations are bound for. This option complements the above config,
  // as this is checked for every arriving message and not when the state changes.
  private final BooleanNode abort_outdated_mutating_ideal_state_ops;
  // If set, aborts any external (client) operations that arrive to a node from
  // a distributor that is no longer the owner of the bucket those operations
  // belong to. As with the abort_outdated_mutating_ideal_state_ops option,
  // this is a check that happens whenever a message arrives, not when the state
  // changes.
  private final BooleanNode abort_outdated_mutating_external_load_ops;
  // Whether or not to disable partitions when they report I/O errors
  private final BooleanNode fail_partition_on_error;
  // Time period to keep all updates (given in seconds). One can revert any
  // operation done within this time.
  private final IntegerNode revert_time_period;
  // Minimum number of seconds that document remove (tombstone) entries are
  // retained in a bucket before being automatically compacted away. In the case
  // where a node has been down for a longer period of time than this value
  // and then comes back up, there exists a possibility for documents to be
  // resurrected. This happens when documents existing on both the downed node
  // and the online nodes are marked as removed on the online nodes and then
  // subsequently compacted away along with their remove entries. When the old
  // node comes back online, it will appear to the system as if the node has
  // documents that do not exist on other nodes (as no remove-entries can be
  // found for them) and they will subsequently re-appear.
  private final IntegerNode keep_remove_time_period;
  // For providers supporting multiple document versions, this option specifies
  // a soft limit on the maximum number of versions that can be stored for a
  // single document at any given time. This is considered a soft limit as it
  // is possible for more versions to exist concurrently than what this config
  // value specifies in a case where the pressure on the containing bucket is not
  // yet high enough to warrant a compaction.
  // After a compaction has taken place, only the n _newest_ document versions
  // will be present in the compacted representation of the bucket.
  // This limitation takes precedence over what versions may be stored according
  // to revert_time_period.
  // Configured value must be at least 1.
  private final IntegerNode maximum_versions_of_single_document_stored;

  public PersistenceConfig(Builder builder) {
    this(builder, true);
  }

  private PersistenceConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "persistence must be initialized: " + builder.__uninitialized);

    abort_operations_with_changed_bucket_ownership = (builder.abort_operations_with_changed_bucket_ownership == null) ?
        new BooleanNode(true) : new BooleanNode(builder.abort_operations_with_changed_bucket_ownership);
    abort_outdated_mutating_ideal_state_ops = (builder.abort_outdated_mutating_ideal_state_ops == null) ?
        new BooleanNode(true) : new BooleanNode(builder.abort_outdated_mutating_ideal_state_ops);
    abort_outdated_mutating_external_load_ops = (builder.abort_outdated_mutating_external_load_ops == null) ?
        new BooleanNode(true) : new BooleanNode(builder.abort_outdated_mutating_external_load_ops);
    fail_partition_on_error = (builder.fail_partition_on_error == null) ?
        new BooleanNode(true) : new BooleanNode(builder.fail_partition_on_error);
    revert_time_period = (builder.revert_time_period == null) ?
        new IntegerNode(300) : new IntegerNode(builder.revert_time_period);
    keep_remove_time_period = (builder.keep_remove_time_period == null) ?
        new IntegerNode(604800) : new IntegerNode(builder.keep_remove_time_period);
    maximum_versions_of_single_document_stored = (builder.maximum_versions_of_single_document_stored == null) ?
        new IntegerNode(5) : new IntegerNode(builder.maximum_versions_of_single_document_stored);
  }

  /**
   * @return persistence.abort_operations_with_changed_bucket_ownership
   */
  public boolean abort_operations_with_changed_bucket_ownership() {
    return abort_operations_with_changed_bucket_ownership.value();
  }

  /**
   * @return persistence.abort_outdated_mutating_ideal_state_ops
   */
  public boolean abort_outdated_mutating_ideal_state_ops() {
    return abort_outdated_mutating_ideal_state_ops.value();
  }

  /**
   * @return persistence.abort_outdated_mutating_external_load_ops
   */
  public boolean abort_outdated_mutating_external_load_ops() {
    return abort_outdated_mutating_external_load_ops.value();
  }

  /**
   * @return persistence.fail_partition_on_error
   */
  public boolean fail_partition_on_error() {
    return fail_partition_on_error.value();
  }

  /**
   * @return persistence.revert_time_period
   */
  public int revert_time_period() {
    return revert_time_period.value();
  }

  /**
   * @return persistence.keep_remove_time_period
   */
  public int keep_remove_time_period() {
    return keep_remove_time_period.value();
  }

  /**
   * @return persistence.maximum_versions_of_single_document_stored
   */
  public int maximum_versions_of_single_document_stored() {
    return maximum_versions_of_single_document_stored.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(PersistenceConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("persistence");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
