// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.content;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of messagetyperouteselectorpolicy
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class MessagetyperouteselectorpolicyConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "3f950702e25c5b896922f81091100a3a";
  public final static String CONFIG_DEF_NAME = "messagetyperouteselectorpolicy";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.content";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.content",
    "defaultroute string",
    "route[].name string",
    "route[].messagetype int"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>(List.of(
      "defaultroute"
      ));

    private String defaultroute = null;
    public List<Route.Builder> route = new ArrayList<>();

    public Builder() { }

    public Builder(MessagetyperouteselectorpolicyConfig config) {
      defaultroute(config.defaultroute());
      for (Route r : config.route()) {
        route(new Route.Builder(r));
      }
    }

    private Builder override(Builder __superior) {
      if (__superior.defaultroute != null)
        defaultroute(__superior.defaultroute);
      if (!__superior.route.isEmpty())
        route.addAll(__superior.route);
      return this;
    }

    public Builder defaultroute(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      defaultroute = __value;
      __uninitialized.remove("defaultroute");
      return this;
    }


    /**
     * Add the given builder to this builder's list of Route builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder route(Route.Builder __builder) {
      route.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder route(java.util.function.Consumer<Route.Builder> __func) {
      Route.Builder __inner = new Route.Builder();
      __func.accept(__inner);
      route.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Route builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder route(List<Route.Builder> __builders) {
      route = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public MessagetyperouteselectorpolicyConfig build() {
      return new MessagetyperouteselectorpolicyConfig(this);
    }

  }

  // Default route if no override is set for a type.
  private final StringNode defaultroute;
  private final InnerNodeVector<Route> route;

  public MessagetyperouteselectorpolicyConfig(Builder builder) {
    this(builder, true);
  }

  private MessagetyperouteselectorpolicyConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "messagetyperouteselectorpolicy must be initialized: " + builder.__uninitialized);

    defaultroute = (builder.defaultroute == null) ?
        new StringNode() : new StringNode(builder.defaultroute);
    route = Route.createVector(builder.route);
  }

  /**
   * @return messagetyperouteselectorpolicy.defaultroute
   */
  public String defaultroute() {
    return defaultroute.value();
  }

  /**
   * @return messagetyperouteselectorpolicy.route[]
   */
  public List<Route> route() {
    return route;
  }

  /**
   * @param i the index of the value to return
   * @return messagetyperouteselectorpolicy.route[]
   */
  public Route route(int i) {
    return route.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(MessagetyperouteselectorpolicyConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("messagetyperouteselectorpolicy");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents messagetyperouteselectorpolicy.route[]
   */
  public final static class Route extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name",
        "messagetype"
        ));

      private String name = null;
      private Integer messagetype = null;

      public Builder() { }

      public Builder(Route config) {
        name(config.name());
        messagetype(config.messagetype());
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.messagetype != null)
          messagetype(__superior.messagetype);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder messagetype(int __value) {
        messagetype = __value;
        __uninitialized.remove("messagetype");
        return this;
      }

      private Builder messagetype(String __value) {
        return messagetype(Integer.valueOf(__value));
      }

      public Route build() {
        return new Route(this);
      }

    }

    // The name of the route.
    private final StringNode name;
    // The document protocol messagetype triggering this route.
    private final IntegerNode messagetype;

    public Route(Builder builder) {
      this(builder, true);
    }

    private Route(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "messagetyperouteselectorpolicy.route[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      messagetype = (builder.messagetype == null) ?
          new IntegerNode() : new IntegerNode(builder.messagetype);
    }

    /**
     * @return messagetyperouteselectorpolicy.route[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return messagetyperouteselectorpolicy.route[].messagetype
     */
    public int messagetype() {
      return messagetype.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Route newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("route");
      return changes;
    }

    private static InnerNodeVector<Route> createVector(List<Builder> builders) {
        List<Route> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Route(b));
        }
        return new InnerNodeVector<Route>(elems);
    }
  }

}
