// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.content;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of load-type
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 * This config is used to define load types in VESPA. Load types are merely
 * a way to distinguish types of load, as to present such types differently.
 * For instance, some metrics will be presented per load type, such that you
 * can see how that specific type is being handled. Load types are especially
 * useful for separating loads of different priority.
 */
public final class LoadTypeConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "d05d64950b5e21ee32a19fd88de62dd6";
  public final static String CONFIG_DEF_NAME = "load-type";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.content";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.content",
    "type[].id int restart",
    "type[].name string restart",
    "type[].priority string restart"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Type.Builder> type = new ArrayList<>();

    public Builder() { }

    public Builder(LoadTypeConfig config) {
      for (Type t : config.type()) {
        type(new Type.Builder(t));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.type.isEmpty())
        type.addAll(__superior.type);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Type builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder type(Type.Builder __builder) {
      type.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder type(java.util.function.Consumer<Type.Builder> __func) {
      Type.Builder __inner = new Type.Builder();
      __func.accept(__inner);
      type.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Type builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder type(List<Type.Builder> __builders) {
      type = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public LoadTypeConfig build() {
      return new LoadTypeConfig(this);
    }

  }

  private final InnerNodeVector<Type> type;

  public LoadTypeConfig(Builder builder) {
    this(builder, true);
  }

  private LoadTypeConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "load-type must be initialized: " + builder.__uninitialized);

    type = Type.createVector(builder.type);
  }

  /**
   * @return load-type.type[]
   */
  public List<Type> type() {
    return type;
  }

  /**
   * @param i the index of the value to return
   * @return load-type.type[]
   */
  public Type type(int i) {
    return type.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(LoadTypeConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("load-type");
      changes.compareArray(this.type, newConfig.type, "type", "",
                        (a,b) -> ((Type)a).getChangesRequiringRestart((Type)b));
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return true;
  }

  /**
   * This class represents load-type.type[]
   */
  public final static class Type extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "id",
        "name",
        "priority"
        ));

      private Integer id = null;
      private String name = null;
      private String priority = null;

      public Builder() { }

      public Builder(Type config) {
        id(config.id());
        name(config.name());
        priority(config.priority());
      }

      private Builder override(Builder __superior) {
        if (__superior.id != null)
          id(__superior.id);
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.priority != null)
          priority(__superior.priority);
        return this;
      }

      public Builder id(int __value) {
        id = __value;
        __uninitialized.remove("id");
        return this;
      }

      private Builder id(String __value) {
        return id(Integer.valueOf(__value));
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder priority(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        priority = __value;
        __uninitialized.remove("priority");
        return this;
      }


      public Type build() {
        return new Type(this);
      }

    }

    // The identifying index of this type. 0 cannot be used as it is
    // reserved for the default type. Other types should be
    // non-overlapping from 1 and upwards. No gaps are allowed in the
    // index range. (For performance reasons we want to use arrays
    // internally where the id is the index)
    //  
    // The identifier is used for efficient transfer of type information.
    // The types will be identified by names instead in more textual or
    // verbose interfaces.
    // restart flag was added automatically and needs to be verified.
    private final IntegerNode id;
    // The name of a given load type. Each load type must have a unique
    // name. The name "default" is reserved for the default type of id 0.
    // restart flag was added automatically and needs to be verified.
    private final StringNode name;
    // The default priority for the load type.
    // restart flag was added automatically and needs to be verified.
    private final StringNode priority;

    public Type(Builder builder) {
      this(builder, true);
    }

    private Type(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "load-type.type[] must be initialized: " + builder.__uninitialized);

      id = (builder.id == null) ?
          new IntegerNode() : new IntegerNode(builder.id);
      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      priority = (builder.priority == null) ?
          new StringNode() : new StringNode(builder.priority);
    }

    /**
     * @return load-type.type[].id
     */
    public int id() {
      return id.value();
    }

    /**
     * @return load-type.type[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return load-type.type[].priority
     */
    public String priority() {
      return priority.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Type newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("type");
        changes.compare(this.id, newConfig.id, "id", "The identifying index of this type. 0 cannot be used as it is\nreserved for the default type. Other types should be\nnon-overlapping from 1 and upwards. No gaps are allowed in the\nindex range. (For performance reasons we want to use arrays\ninternally where the id is the index)\n \nThe identifier is used for efficient transfer of type information.\nThe types will be identified by names instead in more textual or\nverbose interfaces.\nrestart flag was added automatically and needs to be verified.");
        changes.compare(this.name, newConfig.name, "name", "The name of a given load type. Each load type must have a unique\nname. The name \"default\" is reserved for the default type of id 0.\nrestart flag was added automatically and needs to be verified.");
        changes.compare(this.priority, newConfig.priority, "priority", "The default priority for the load type.\nrestart flag was added automatically and needs to be verified.");
      return changes;
    }

    private static InnerNodeVector<Type> createVector(List<Builder> builders) {
        List<Type> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Type(b));
        }
        return new InnerNodeVector<Type>(elems);
    }
  }

}
