// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.content;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of fleetcontroller
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class FleetcontrollerConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "12b9ae4ca6639f5ee350d94f7eff6995";
  public final static String CONFIG_DEF_NAME = "fleetcontroller";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.content";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.content",
    "cluster_name string restart",
    "index int restart",
    "fleet_controller_count int default=1",
    "zookeeper_session_timeout double default=30.0",
    "master_zookeeper_cooldown_period double default=60.0",
    "state_gather_count int default=1",
    "zookeeper_server string restart",
    "rpc_port int default=6500 restart",
    "http_port int default=0 restart",
    "storage_transition_time int default=30000",
    "distributor_transition_time int default=0",
    "init_progress_time int default=0",
    "min_time_between_new_systemstates int default=10000",
    "max_premature_crashes int default=100000",
    "stable_state_time_period int default=7200000",
    "event_log_max_size int default=1024",
    "event_node_log_max_size int default=1024",
    "total_distributor_count int default=0",
    "total_storage_count int default=0",
    "min_distributors_up_count int default=1",
    "min_storage_up_count int default=1",
    "min_distributor_up_ratio double default=0.01",
    "min_storage_up_ratio double default=0.01",
    "cycle_wait_time double default=0.1",
    "min_time_before_first_system_state_broadcast double default=30.0",
    "get_node_state_request_timeout double default=120.0",
    "max_slobrok_disconnect_grace_period double default=60.0",
    "show_local_systemstates_in_event_log bool default=true",
    "ideal_distribution_bits int default=16",
    "min_node_ratio_per_group double default=0.0",
    "max_deferred_task_version_wait_time_sec double default=30.0",
    "cluster_has_global_document_types bool default=false",
    "min_merge_completion_ratio double default=1.0",
    "enable_two_phase_cluster_state_transitions bool default=false",
    "enable_cluster_feed_block bool default=true",
    "cluster_feed_block_limit{} double",
    "cluster_feed_block_noise_level double default=0.01",
    "max_number_of_groups_allowed_to_be_down int default=-1",
    "include_distribution_config_in_cluster_state_bundle bool default=true",
    "aggregate_content_node_error_reports_from_distributors bool default=true"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>(List.of(
      "cluster_name",
      "index",
      "zookeeper_server"
      ));

    private String cluster_name = null;
    private Integer index = null;
    private Integer fleet_controller_count = null;
    private Double zookeeper_session_timeout = null;
    private Double master_zookeeper_cooldown_period = null;
    private Integer state_gather_count = null;
    private String zookeeper_server = null;
    private Integer rpc_port = null;
    private Integer http_port = null;
    private Integer storage_transition_time = null;
    private Integer distributor_transition_time = null;
    private Integer init_progress_time = null;
    private Integer min_time_between_new_systemstates = null;
    private Integer max_premature_crashes = null;
    private Integer stable_state_time_period = null;
    private Integer event_log_max_size = null;
    private Integer event_node_log_max_size = null;
    private Integer total_distributor_count = null;
    private Integer total_storage_count = null;
    private Integer min_distributors_up_count = null;
    private Integer min_storage_up_count = null;
    private Double min_distributor_up_ratio = null;
    private Double min_storage_up_ratio = null;
    private Double cycle_wait_time = null;
    private Double min_time_before_first_system_state_broadcast = null;
    private Double get_node_state_request_timeout = null;
    private Double max_slobrok_disconnect_grace_period = null;
    private Boolean show_local_systemstates_in_event_log = null;
    private Integer ideal_distribution_bits = null;
    private Double min_node_ratio_per_group = null;
    private Double max_deferred_task_version_wait_time_sec = null;
    private Boolean cluster_has_global_document_types = null;
    private Double min_merge_completion_ratio = null;
    private Boolean enable_two_phase_cluster_state_transitions = null;
    private Boolean enable_cluster_feed_block = null;
    public Map<String, Double> cluster_feed_block_limit = new LinkedHashMap<>();
    private Double cluster_feed_block_noise_level = null;
    private Integer max_number_of_groups_allowed_to_be_down = null;
    private Boolean include_distribution_config_in_cluster_state_bundle = null;
    private Boolean aggregate_content_node_error_reports_from_distributors = null;

    public Builder() { }

    public Builder(FleetcontrollerConfig config) {
      cluster_name(config.cluster_name());
      index(config.index());
      fleet_controller_count(config.fleet_controller_count());
      zookeeper_session_timeout(config.zookeeper_session_timeout());
      master_zookeeper_cooldown_period(config.master_zookeeper_cooldown_period());
      state_gather_count(config.state_gather_count());
      zookeeper_server(config.zookeeper_server());
      rpc_port(config.rpc_port());
      http_port(config.http_port());
      storage_transition_time(config.storage_transition_time());
      distributor_transition_time(config.distributor_transition_time());
      init_progress_time(config.init_progress_time());
      min_time_between_new_systemstates(config.min_time_between_new_systemstates());
      max_premature_crashes(config.max_premature_crashes());
      stable_state_time_period(config.stable_state_time_period());
      event_log_max_size(config.event_log_max_size());
      event_node_log_max_size(config.event_node_log_max_size());
      total_distributor_count(config.total_distributor_count());
      total_storage_count(config.total_storage_count());
      min_distributors_up_count(config.min_distributors_up_count());
      min_storage_up_count(config.min_storage_up_count());
      min_distributor_up_ratio(config.min_distributor_up_ratio());
      min_storage_up_ratio(config.min_storage_up_ratio());
      cycle_wait_time(config.cycle_wait_time());
      min_time_before_first_system_state_broadcast(config.min_time_before_first_system_state_broadcast());
      get_node_state_request_timeout(config.get_node_state_request_timeout());
      max_slobrok_disconnect_grace_period(config.max_slobrok_disconnect_grace_period());
      show_local_systemstates_in_event_log(config.show_local_systemstates_in_event_log());
      ideal_distribution_bits(config.ideal_distribution_bits());
      min_node_ratio_per_group(config.min_node_ratio_per_group());
      max_deferred_task_version_wait_time_sec(config.max_deferred_task_version_wait_time_sec());
      cluster_has_global_document_types(config.cluster_has_global_document_types());
      min_merge_completion_ratio(config.min_merge_completion_ratio());
      enable_two_phase_cluster_state_transitions(config.enable_two_phase_cluster_state_transitions());
      enable_cluster_feed_block(config.enable_cluster_feed_block());
      cluster_feed_block_limit(config.cluster_feed_block_limit());
      cluster_feed_block_noise_level(config.cluster_feed_block_noise_level());
      max_number_of_groups_allowed_to_be_down(config.max_number_of_groups_allowed_to_be_down());
      include_distribution_config_in_cluster_state_bundle(config.include_distribution_config_in_cluster_state_bundle());
      aggregate_content_node_error_reports_from_distributors(config.aggregate_content_node_error_reports_from_distributors());
    }

    private Builder override(Builder __superior) {
      if (__superior.cluster_name != null)
        cluster_name(__superior.cluster_name);
      if (__superior.index != null)
        index(__superior.index);
      if (__superior.fleet_controller_count != null)
        fleet_controller_count(__superior.fleet_controller_count);
      if (__superior.zookeeper_session_timeout != null)
        zookeeper_session_timeout(__superior.zookeeper_session_timeout);
      if (__superior.master_zookeeper_cooldown_period != null)
        master_zookeeper_cooldown_period(__superior.master_zookeeper_cooldown_period);
      if (__superior.state_gather_count != null)
        state_gather_count(__superior.state_gather_count);
      if (__superior.zookeeper_server != null)
        zookeeper_server(__superior.zookeeper_server);
      if (__superior.rpc_port != null)
        rpc_port(__superior.rpc_port);
      if (__superior.http_port != null)
        http_port(__superior.http_port);
      if (__superior.storage_transition_time != null)
        storage_transition_time(__superior.storage_transition_time);
      if (__superior.distributor_transition_time != null)
        distributor_transition_time(__superior.distributor_transition_time);
      if (__superior.init_progress_time != null)
        init_progress_time(__superior.init_progress_time);
      if (__superior.min_time_between_new_systemstates != null)
        min_time_between_new_systemstates(__superior.min_time_between_new_systemstates);
      if (__superior.max_premature_crashes != null)
        max_premature_crashes(__superior.max_premature_crashes);
      if (__superior.stable_state_time_period != null)
        stable_state_time_period(__superior.stable_state_time_period);
      if (__superior.event_log_max_size != null)
        event_log_max_size(__superior.event_log_max_size);
      if (__superior.event_node_log_max_size != null)
        event_node_log_max_size(__superior.event_node_log_max_size);
      if (__superior.total_distributor_count != null)
        total_distributor_count(__superior.total_distributor_count);
      if (__superior.total_storage_count != null)
        total_storage_count(__superior.total_storage_count);
      if (__superior.min_distributors_up_count != null)
        min_distributors_up_count(__superior.min_distributors_up_count);
      if (__superior.min_storage_up_count != null)
        min_storage_up_count(__superior.min_storage_up_count);
      if (__superior.min_distributor_up_ratio != null)
        min_distributor_up_ratio(__superior.min_distributor_up_ratio);
      if (__superior.min_storage_up_ratio != null)
        min_storage_up_ratio(__superior.min_storage_up_ratio);
      if (__superior.cycle_wait_time != null)
        cycle_wait_time(__superior.cycle_wait_time);
      if (__superior.min_time_before_first_system_state_broadcast != null)
        min_time_before_first_system_state_broadcast(__superior.min_time_before_first_system_state_broadcast);
      if (__superior.get_node_state_request_timeout != null)
        get_node_state_request_timeout(__superior.get_node_state_request_timeout);
      if (__superior.max_slobrok_disconnect_grace_period != null)
        max_slobrok_disconnect_grace_period(__superior.max_slobrok_disconnect_grace_period);
      if (__superior.show_local_systemstates_in_event_log != null)
        show_local_systemstates_in_event_log(__superior.show_local_systemstates_in_event_log);
      if (__superior.ideal_distribution_bits != null)
        ideal_distribution_bits(__superior.ideal_distribution_bits);
      if (__superior.min_node_ratio_per_group != null)
        min_node_ratio_per_group(__superior.min_node_ratio_per_group);
      if (__superior.max_deferred_task_version_wait_time_sec != null)
        max_deferred_task_version_wait_time_sec(__superior.max_deferred_task_version_wait_time_sec);
      if (__superior.cluster_has_global_document_types != null)
        cluster_has_global_document_types(__superior.cluster_has_global_document_types);
      if (__superior.min_merge_completion_ratio != null)
        min_merge_completion_ratio(__superior.min_merge_completion_ratio);
      if (__superior.enable_two_phase_cluster_state_transitions != null)
        enable_two_phase_cluster_state_transitions(__superior.enable_two_phase_cluster_state_transitions);
      if (__superior.enable_cluster_feed_block != null)
        enable_cluster_feed_block(__superior.enable_cluster_feed_block);
      cluster_feed_block_limit(__superior.cluster_feed_block_limit);
      if (__superior.cluster_feed_block_noise_level != null)
        cluster_feed_block_noise_level(__superior.cluster_feed_block_noise_level);
      if (__superior.max_number_of_groups_allowed_to_be_down != null)
        max_number_of_groups_allowed_to_be_down(__superior.max_number_of_groups_allowed_to_be_down);
      if (__superior.include_distribution_config_in_cluster_state_bundle != null)
        include_distribution_config_in_cluster_state_bundle(__superior.include_distribution_config_in_cluster_state_bundle);
      if (__superior.aggregate_content_node_error_reports_from_distributors != null)
        aggregate_content_node_error_reports_from_distributors(__superior.aggregate_content_node_error_reports_from_distributors);
      return this;
    }

    public Builder cluster_name(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      cluster_name = __value;
      __uninitialized.remove("cluster_name");
      return this;
    }


    public Builder index(int __value) {
      index = __value;
      __uninitialized.remove("index");
      return this;
    }

    private Builder index(String __value) {
      return index(Integer.valueOf(__value));
    }

    public Builder fleet_controller_count(int __value) {
      fleet_controller_count = __value;
      return this;
    }

    private Builder fleet_controller_count(String __value) {
      return fleet_controller_count(Integer.valueOf(__value));
    }

    public Builder zookeeper_session_timeout(double __value) {
      zookeeper_session_timeout = __value;
      return this;
    }

    private Builder zookeeper_session_timeout(String __value) {
      return zookeeper_session_timeout(Double.valueOf(__value));
    }

    public Builder master_zookeeper_cooldown_period(double __value) {
      master_zookeeper_cooldown_period = __value;
      return this;
    }

    private Builder master_zookeeper_cooldown_period(String __value) {
      return master_zookeeper_cooldown_period(Double.valueOf(__value));
    }

    public Builder state_gather_count(int __value) {
      state_gather_count = __value;
      return this;
    }

    private Builder state_gather_count(String __value) {
      return state_gather_count(Integer.valueOf(__value));
    }

    public Builder zookeeper_server(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      zookeeper_server = __value;
      __uninitialized.remove("zookeeper_server");
      return this;
    }


    public Builder rpc_port(int __value) {
      rpc_port = __value;
      return this;
    }

    private Builder rpc_port(String __value) {
      return rpc_port(Integer.valueOf(__value));
    }

    public Builder http_port(int __value) {
      http_port = __value;
      return this;
    }

    private Builder http_port(String __value) {
      return http_port(Integer.valueOf(__value));
    }

    public Builder storage_transition_time(int __value) {
      storage_transition_time = __value;
      return this;
    }

    private Builder storage_transition_time(String __value) {
      return storage_transition_time(Integer.valueOf(__value));
    }

    public Builder distributor_transition_time(int __value) {
      distributor_transition_time = __value;
      return this;
    }

    private Builder distributor_transition_time(String __value) {
      return distributor_transition_time(Integer.valueOf(__value));
    }

    public Builder init_progress_time(int __value) {
      init_progress_time = __value;
      return this;
    }

    private Builder init_progress_time(String __value) {
      return init_progress_time(Integer.valueOf(__value));
    }

    public Builder min_time_between_new_systemstates(int __value) {
      min_time_between_new_systemstates = __value;
      return this;
    }

    private Builder min_time_between_new_systemstates(String __value) {
      return min_time_between_new_systemstates(Integer.valueOf(__value));
    }

    public Builder max_premature_crashes(int __value) {
      max_premature_crashes = __value;
      return this;
    }

    private Builder max_premature_crashes(String __value) {
      return max_premature_crashes(Integer.valueOf(__value));
    }

    public Builder stable_state_time_period(int __value) {
      stable_state_time_period = __value;
      return this;
    }

    private Builder stable_state_time_period(String __value) {
      return stable_state_time_period(Integer.valueOf(__value));
    }

    public Builder event_log_max_size(int __value) {
      event_log_max_size = __value;
      return this;
    }

    private Builder event_log_max_size(String __value) {
      return event_log_max_size(Integer.valueOf(__value));
    }

    public Builder event_node_log_max_size(int __value) {
      event_node_log_max_size = __value;
      return this;
    }

    private Builder event_node_log_max_size(String __value) {
      return event_node_log_max_size(Integer.valueOf(__value));
    }

    public Builder total_distributor_count(int __value) {
      total_distributor_count = __value;
      return this;
    }

    private Builder total_distributor_count(String __value) {
      return total_distributor_count(Integer.valueOf(__value));
    }

    public Builder total_storage_count(int __value) {
      total_storage_count = __value;
      return this;
    }

    private Builder total_storage_count(String __value) {
      return total_storage_count(Integer.valueOf(__value));
    }

    public Builder min_distributors_up_count(int __value) {
      min_distributors_up_count = __value;
      return this;
    }

    private Builder min_distributors_up_count(String __value) {
      return min_distributors_up_count(Integer.valueOf(__value));
    }

    public Builder min_storage_up_count(int __value) {
      min_storage_up_count = __value;
      return this;
    }

    private Builder min_storage_up_count(String __value) {
      return min_storage_up_count(Integer.valueOf(__value));
    }

    public Builder min_distributor_up_ratio(double __value) {
      min_distributor_up_ratio = __value;
      return this;
    }

    private Builder min_distributor_up_ratio(String __value) {
      return min_distributor_up_ratio(Double.valueOf(__value));
    }

    public Builder min_storage_up_ratio(double __value) {
      min_storage_up_ratio = __value;
      return this;
    }

    private Builder min_storage_up_ratio(String __value) {
      return min_storage_up_ratio(Double.valueOf(__value));
    }

    public Builder cycle_wait_time(double __value) {
      cycle_wait_time = __value;
      return this;
    }

    private Builder cycle_wait_time(String __value) {
      return cycle_wait_time(Double.valueOf(__value));
    }

    public Builder min_time_before_first_system_state_broadcast(double __value) {
      min_time_before_first_system_state_broadcast = __value;
      return this;
    }

    private Builder min_time_before_first_system_state_broadcast(String __value) {
      return min_time_before_first_system_state_broadcast(Double.valueOf(__value));
    }

    public Builder get_node_state_request_timeout(double __value) {
      get_node_state_request_timeout = __value;
      return this;
    }

    private Builder get_node_state_request_timeout(String __value) {
      return get_node_state_request_timeout(Double.valueOf(__value));
    }

    public Builder max_slobrok_disconnect_grace_period(double __value) {
      max_slobrok_disconnect_grace_period = __value;
      return this;
    }

    private Builder max_slobrok_disconnect_grace_period(String __value) {
      return max_slobrok_disconnect_grace_period(Double.valueOf(__value));
    }

    public Builder show_local_systemstates_in_event_log(boolean __value) {
      show_local_systemstates_in_event_log = __value;
      return this;
    }

    private Builder show_local_systemstates_in_event_log(String __value) {
      return show_local_systemstates_in_event_log(Boolean.valueOf(__value));
    }

    public Builder ideal_distribution_bits(int __value) {
      ideal_distribution_bits = __value;
      return this;
    }

    private Builder ideal_distribution_bits(String __value) {
      return ideal_distribution_bits(Integer.valueOf(__value));
    }

    public Builder min_node_ratio_per_group(double __value) {
      min_node_ratio_per_group = __value;
      return this;
    }

    private Builder min_node_ratio_per_group(String __value) {
      return min_node_ratio_per_group(Double.valueOf(__value));
    }

    public Builder max_deferred_task_version_wait_time_sec(double __value) {
      max_deferred_task_version_wait_time_sec = __value;
      return this;
    }

    private Builder max_deferred_task_version_wait_time_sec(String __value) {
      return max_deferred_task_version_wait_time_sec(Double.valueOf(__value));
    }

    public Builder cluster_has_global_document_types(boolean __value) {
      cluster_has_global_document_types = __value;
      return this;
    }

    private Builder cluster_has_global_document_types(String __value) {
      return cluster_has_global_document_types(Boolean.valueOf(__value));
    }

    public Builder min_merge_completion_ratio(double __value) {
      min_merge_completion_ratio = __value;
      return this;
    }

    private Builder min_merge_completion_ratio(String __value) {
      return min_merge_completion_ratio(Double.valueOf(__value));
    }

    public Builder enable_two_phase_cluster_state_transitions(boolean __value) {
      enable_two_phase_cluster_state_transitions = __value;
      return this;
    }

    private Builder enable_two_phase_cluster_state_transitions(String __value) {
      return enable_two_phase_cluster_state_transitions(Boolean.valueOf(__value));
    }

    public Builder enable_cluster_feed_block(boolean __value) {
      enable_cluster_feed_block = __value;
      return this;
    }

    private Builder enable_cluster_feed_block(String __value) {
      return enable_cluster_feed_block(Boolean.valueOf(__value));
    }

    public Builder cluster_feed_block_limit(String __key, Double __value) {
      cluster_feed_block_limit.put(__key, __value);
      return this;
    }

    public Builder cluster_feed_block_limit(Map<String, Double> __values) {
      cluster_feed_block_limit.putAll(__values);
      return this;
    }

    private Builder cluster_feed_block_limit(String __key, String __value) {
      return cluster_feed_block_limit(__key, Double.valueOf(__value));
    }

    public Builder cluster_feed_block_noise_level(double __value) {
      cluster_feed_block_noise_level = __value;
      return this;
    }

    private Builder cluster_feed_block_noise_level(String __value) {
      return cluster_feed_block_noise_level(Double.valueOf(__value));
    }

    public Builder max_number_of_groups_allowed_to_be_down(int __value) {
      max_number_of_groups_allowed_to_be_down = __value;
      return this;
    }

    private Builder max_number_of_groups_allowed_to_be_down(String __value) {
      return max_number_of_groups_allowed_to_be_down(Integer.valueOf(__value));
    }

    public Builder include_distribution_config_in_cluster_state_bundle(boolean __value) {
      include_distribution_config_in_cluster_state_bundle = __value;
      return this;
    }

    private Builder include_distribution_config_in_cluster_state_bundle(String __value) {
      return include_distribution_config_in_cluster_state_bundle(Boolean.valueOf(__value));
    }

    public Builder aggregate_content_node_error_reports_from_distributors(boolean __value) {
      aggregate_content_node_error_reports_from_distributors = __value;
      return this;
    }

    private Builder aggregate_content_node_error_reports_from_distributors(String __value) {
      return aggregate_content_node_error_reports_from_distributors(Boolean.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public FleetcontrollerConfig build() {
      return new FleetcontrollerConfig(this);
    }

  }

  // Name of VDS cluster
  private final StringNode cluster_name;
  // The fleetcontroller index. Each fleetcontroller should have a unique index
  // which can be used to identify them.
  private final IntegerNode index;
  // Number of fleet controllers. If more than one, the fleetcontroller needs to
  // do master election in order to know which one is active. It then needs to
  // know how many exist.
  private final IntegerNode fleet_controller_count;
  // The number of seconds we can attempt to talk to zookeeper before our session
  // time out and we lose our connection.
  private final DoubleNode zookeeper_session_timeout;
  // When a master candidate see the master disappearing from ZooKeeper, it wants
  // to take over as master. But, before taking over, the master should be aware
  // that it has lost its zookeeper connection, so it will stop reacting as
  // master. Suggests setting this to 2-3 times the zookeeper session timeout.
  // (Set in number of seconds)
  private final DoubleNode master_zookeeper_cooldown_period;
  // Sets how many fleetcontrollers will gather state. A fleetcontroller
  // gathering state can take over quicker should the master fail.
  // If set to 1, only master will gather state. If set higher, others will
  // also do so, prioritizing those fleetcontrollers likely to be the ones to
  // take over if the master fails.
  // TODO: Deprecated, not used anymore, remove in Vespa 9
  private final IntegerNode state_gather_count;
  // Location of ZooKeeper servers
  private final StringNode zookeeper_server;
  // RPC Port used by fleetcontroller
  private final IntegerNode rpc_port;
  // Port where fleetcontroller listens for HTTP status request
  private final IntegerNode http_port;
  // Maximum number of milliseconds a storage node will be automatically reported
  // in maintenance due to node recently being available. (If 0, no time at all)
  private final IntegerNode storage_transition_time;
  // Maximum number of milliseconds a distributor will be automatically reported
  // in maintenance due to node recently being available. (If 0, no time at all)
  //  
  // Currently default is 0.. Should probably be more when we know it is working
  // correctly
  private final IntegerNode distributor_transition_time;
  // Maximum number of milliseconds allowed between progress increase during
  // initialization. If no progress have been made during this time period, the
  // node will be considered down.
  //  
  // Currently disabled as 5.0 nodes gets load while initializing which may be
  // higher pri than initializing, so nodes can stay in init for a long time.
  private final IntegerNode init_progress_time;
  // Minimum time (in ms) between system state updates. To limit updates in a
  // system where a lot is happening at the same time, this value will make sure
  // we dont change the state too often.
  private final IntegerNode min_time_between_new_systemstates;
  // The maximum amount of premature crashes a node is allowed to have in a row
  // before the fleetcontroller disables that node.
  private final IntegerNode max_premature_crashes;
  // If a node has been down or up this many milliseconds, clear the premature
  // crash count of a node and consider the node as stable
  private final IntegerNode stable_state_time_period;
  // The maximum number of events to keep in the event log
  private final IntegerNode event_log_max_size;
  // The maximum number of node events to keep in the node event log per node
  private final IntegerNode event_node_log_max_size;
  // The total number of distributor nodes that can exist. If 0, we dont know and
  // will use the highest distributor index number we have ever seen + 1.
  private final IntegerNode total_distributor_count;
  // The total number of storage nodes that can exist. If 0, we dont know and
  // will use the highest storage index number we have ever seen + 1.
  private final IntegerNode total_storage_count;
  // The minimum number of distributor nodes that should be up for the cluster
  // state to be up. (Retired nodes counts as up in this case)
  private final IntegerNode min_distributors_up_count;
  // The minimum number of storage nodes that should be up for the cluster state
  // to be up (Retired nodes counts as up in this case)
  private final IntegerNode min_storage_up_count;
  // The minimum ratio of known distributor nodes that should be up (or retired)
  // for the cluster state to stay up.
  private final DoubleNode min_distributor_up_ratio;
  // The minimum ratio of known storage nodes that should be up (or retired) for
  // the cluster state to stay up.
  private final DoubleNode min_storage_up_ratio;
  // Seconds to sleep after doing a work cycle where we did no work. Some
  // events do not interrupt the sleeping, such as slobrok changes, so shouldn't
  // set this too high
  private final DoubleNode cycle_wait_time;
  // Minimum time to pass in seconds before broadcasting our first systemstate as
  // a new fleetcontroller. Will broadcast earlier than this if we have gathered
  // state from all before this. To prevent disturbance when taking over as
  // fleetcontroller, give nodes a bit of time to answer so we dont temporarily
  // report nodes as down. See also max_slobrok_disconnect_grace_period and
  // get_node_state_request_timeout.
  private final DoubleNode min_time_before_first_system_state_broadcast;
  // Request timeout of node state requests. Keeping a high timeout allows us to
  // always have a pending operation with very low cost. Keeping a low timeout is
  // good to detect issues like packet loss. The default tries to balance the two
  // by not resending too often, but detecting packet loss within a minute at
  // least. If we can guarantee RPC layer to fail on packet loss within
  // reasonable time we should increase this default.
  private final DoubleNode get_node_state_request_timeout;
  // If a node is out of slobrok longer than this time period, assume the node
  // is down, even if we have a pending node state request to it. Slobrok does
  // a bit more keep alive checking than fleetcontroller, so it is possible that
  // the node disappears from slobrok while it still looks ok in fleetcontroller.
  private final DoubleNode max_slobrok_disconnect_grace_period;
  // Whether to show system states that have never been sent to storage nodes in
  // the event log.
  private final BooleanNode show_local_systemstates_in_event_log;
  // The ideal number of distribution bits this system should have
  private final IntegerNode ideal_distribution_bits;
  // Minimum ratio of nodes that have to be available (i.e. not Down) in any
  // hierarchic content cluster group. If a higher ratio than this is Down at
  // any point, the remaning nodes in the group will be automatically marked
  // as down. Group nodes will automatically be taken back up as soon as node
  // availability has been restored above the given threshold.
  // Default is 0, i.e. functionality is for all intents and purposes disabled.
  private final DoubleNode min_node_ratio_per_group;
  // If a cluster controller task has a dependency on a given cluster state
  // version being published and ACKed by the cluster, it will be put on a wait
  // queue while holding up the container thread associated with the task.
  // This config specifies the maximum time a task can be held in this queue
  // before being automatically failed out, if a version has not been ACKed
  // within this duration.
  private final DoubleNode max_deferred_task_version_wait_time_sec;
  // Whether or not the content cluster the controller has responsibility for
  // contains any document types that are tagged as global. If this is true,
  // global document-specific behavior is enabled that marks nodes down in the
  // default space if they have merges pending in the global bucket space.
  private final BooleanNode cluster_has_global_document_types;
  // The minimum merge completion ratio of buckets in a bucket space before it is considered complete.
  //  
  // Bucket merges are considered complete when:
  // ((buckets_total - buckets_pending) / buckets_total)) >= min_merge_completion_ratio
  private final DoubleNode min_merge_completion_ratio;
  // If enabled, cluster state transitions are performed as two distinct phases:
  //  
  // 1) state bundle propagation and bucket info gathering phase
  // 2) state activation phase, which is not performed until all nodes have completed phase 1
  //  
  // This is to enable read-only operations to pass through the system during phase 1
  // while nodes await phase 2. If this feature is disabled, nodes will implicitly do
  // phase 2 as part of phase 1 at their own leisure, which means that actual state
  // activation may happen at wildly different times throughout the cluster. The 2 phase
  // transition logic aims to minimize the window of time where active states diverge.
  private final BooleanNode enable_two_phase_cluster_state_transitions;
  // If enabled, the cluster controller observes reported (categorized) resource usage from content nodes (via host info),
  // and decides whether external feed should be blocked (or unblocked) in the entire cluster.
  //  
  // Each resource category has a limit, which is specified in cluster_feed_block_limit.
  // If one resource category from one content node is above the configured limit, feed is blocked.
  // This information is pushed to all distributor nodes via a new cluster state bundle.
  // The distributor nodes handle the actual feed blocking based on this information.
  private final BooleanNode enable_cluster_feed_block;
  // Contains all resource categories (key) with its corresponding feed block limit (value)
  // used when the cluster controller decides whether external feed should be blocked (or unblocked) in the entire cluster.
  //  
  // The keys used must match the similar keys in the host info JSON structure.
  // All limits are numbers between 0.0 and 1.0.
  private final Map<String, DoubleNode> cluster_feed_block_limit;
  // To avoid having the cluster feed block state flip-flop from nodes that are hovering
  // just around the feed block limits, this noise threshold implicitly makes the
  // feed block limit value _lower_ for a resource that is already exhausted. I.e. the
  // node must reach a lower resource usage than the limit for feed to be unblocked.
  // This is in absolute numbers, so 0.01 implies that a block limit of 0.8 effectively
  // becomes 0.79 for an already blocked node.
  private final DoubleNode cluster_feed_block_noise_level;
  // For apps that have several groups this controls how many groups are allowed to
  // be down simultaneously in this cluster. The default value of -1 means that
  // 1 group at a time is allowed to be down.
  private final IntegerNode max_number_of_groups_allowed_to_be_down;
  // Iff true, cluster state bundles sent from the cluster controller to distributors
  // and content nodes will include the current distribution config. The CC-provided
  // distribution config takes precedence over the node-local config. When enabled,
  // a given versioned state corresponds directly to a particular bucket ownership
  // and replica placement mapping for the ideal state algorithm.
  private final BooleanNode include_distribution_config_in_cluster_state_bundle;
  // Iff true, the cluster controller will aggregate error reports for content nodes
  // reported by the distributors in the cluster. Setting this to false will clear
  // any existing error aggregates on the cluster controller. It does not affect whether
  // the distributors actually report back error information, only the controller-side
  // aggregation of this information.
  private final BooleanNode aggregate_content_node_error_reports_from_distributors;

  public FleetcontrollerConfig(Builder builder) {
    this(builder, true);
  }

  private FleetcontrollerConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "fleetcontroller must be initialized: " + builder.__uninitialized);

    cluster_name = (builder.cluster_name == null) ?
        new StringNode() : new StringNode(builder.cluster_name);
    index = (builder.index == null) ?
        new IntegerNode() : new IntegerNode(builder.index);
    fleet_controller_count = (builder.fleet_controller_count == null) ?
        new IntegerNode(1) : new IntegerNode(builder.fleet_controller_count);
    zookeeper_session_timeout = (builder.zookeeper_session_timeout == null) ?
        new DoubleNode(30.0D) : new DoubleNode(builder.zookeeper_session_timeout);
    master_zookeeper_cooldown_period = (builder.master_zookeeper_cooldown_period == null) ?
        new DoubleNode(60.0D) : new DoubleNode(builder.master_zookeeper_cooldown_period);
    state_gather_count = (builder.state_gather_count == null) ?
        new IntegerNode(1) : new IntegerNode(builder.state_gather_count);
    zookeeper_server = (builder.zookeeper_server == null) ?
        new StringNode() : new StringNode(builder.zookeeper_server);
    rpc_port = (builder.rpc_port == null) ?
        new IntegerNode(6500) : new IntegerNode(builder.rpc_port);
    http_port = (builder.http_port == null) ?
        new IntegerNode(0) : new IntegerNode(builder.http_port);
    storage_transition_time = (builder.storage_transition_time == null) ?
        new IntegerNode(30000) : new IntegerNode(builder.storage_transition_time);
    distributor_transition_time = (builder.distributor_transition_time == null) ?
        new IntegerNode(0) : new IntegerNode(builder.distributor_transition_time);
    init_progress_time = (builder.init_progress_time == null) ?
        new IntegerNode(0) : new IntegerNode(builder.init_progress_time);
    min_time_between_new_systemstates = (builder.min_time_between_new_systemstates == null) ?
        new IntegerNode(10000) : new IntegerNode(builder.min_time_between_new_systemstates);
    max_premature_crashes = (builder.max_premature_crashes == null) ?
        new IntegerNode(100000) : new IntegerNode(builder.max_premature_crashes);
    stable_state_time_period = (builder.stable_state_time_period == null) ?
        new IntegerNode(7200000) : new IntegerNode(builder.stable_state_time_period);
    event_log_max_size = (builder.event_log_max_size == null) ?
        new IntegerNode(1024) : new IntegerNode(builder.event_log_max_size);
    event_node_log_max_size = (builder.event_node_log_max_size == null) ?
        new IntegerNode(1024) : new IntegerNode(builder.event_node_log_max_size);
    total_distributor_count = (builder.total_distributor_count == null) ?
        new IntegerNode(0) : new IntegerNode(builder.total_distributor_count);
    total_storage_count = (builder.total_storage_count == null) ?
        new IntegerNode(0) : new IntegerNode(builder.total_storage_count);
    min_distributors_up_count = (builder.min_distributors_up_count == null) ?
        new IntegerNode(1) : new IntegerNode(builder.min_distributors_up_count);
    min_storage_up_count = (builder.min_storage_up_count == null) ?
        new IntegerNode(1) : new IntegerNode(builder.min_storage_up_count);
    min_distributor_up_ratio = (builder.min_distributor_up_ratio == null) ?
        new DoubleNode(0.01D) : new DoubleNode(builder.min_distributor_up_ratio);
    min_storage_up_ratio = (builder.min_storage_up_ratio == null) ?
        new DoubleNode(0.01D) : new DoubleNode(builder.min_storage_up_ratio);
    cycle_wait_time = (builder.cycle_wait_time == null) ?
        new DoubleNode(0.1D) : new DoubleNode(builder.cycle_wait_time);
    min_time_before_first_system_state_broadcast = (builder.min_time_before_first_system_state_broadcast == null) ?
        new DoubleNode(30.0D) : new DoubleNode(builder.min_time_before_first_system_state_broadcast);
    get_node_state_request_timeout = (builder.get_node_state_request_timeout == null) ?
        new DoubleNode(120.0D) : new DoubleNode(builder.get_node_state_request_timeout);
    max_slobrok_disconnect_grace_period = (builder.max_slobrok_disconnect_grace_period == null) ?
        new DoubleNode(60.0D) : new DoubleNode(builder.max_slobrok_disconnect_grace_period);
    show_local_systemstates_in_event_log = (builder.show_local_systemstates_in_event_log == null) ?
        new BooleanNode(true) : new BooleanNode(builder.show_local_systemstates_in_event_log);
    ideal_distribution_bits = (builder.ideal_distribution_bits == null) ?
        new IntegerNode(16) : new IntegerNode(builder.ideal_distribution_bits);
    min_node_ratio_per_group = (builder.min_node_ratio_per_group == null) ?
        new DoubleNode(0.0D) : new DoubleNode(builder.min_node_ratio_per_group);
    max_deferred_task_version_wait_time_sec = (builder.max_deferred_task_version_wait_time_sec == null) ?
        new DoubleNode(30.0D) : new DoubleNode(builder.max_deferred_task_version_wait_time_sec);
    cluster_has_global_document_types = (builder.cluster_has_global_document_types == null) ?
        new BooleanNode(false) : new BooleanNode(builder.cluster_has_global_document_types);
    min_merge_completion_ratio = (builder.min_merge_completion_ratio == null) ?
        new DoubleNode(1.0D) : new DoubleNode(builder.min_merge_completion_ratio);
    enable_two_phase_cluster_state_transitions = (builder.enable_two_phase_cluster_state_transitions == null) ?
        new BooleanNode(false) : new BooleanNode(builder.enable_two_phase_cluster_state_transitions);
    enable_cluster_feed_block = (builder.enable_cluster_feed_block == null) ?
        new BooleanNode(true) : new BooleanNode(builder.enable_cluster_feed_block);
    cluster_feed_block_limit = LeafNodeMaps.asNodeMap(builder.cluster_feed_block_limit, new DoubleNode());
    cluster_feed_block_noise_level = (builder.cluster_feed_block_noise_level == null) ?
        new DoubleNode(0.01D) : new DoubleNode(builder.cluster_feed_block_noise_level);
    max_number_of_groups_allowed_to_be_down = (builder.max_number_of_groups_allowed_to_be_down == null) ?
        new IntegerNode(-1) : new IntegerNode(builder.max_number_of_groups_allowed_to_be_down);
    include_distribution_config_in_cluster_state_bundle = (builder.include_distribution_config_in_cluster_state_bundle == null) ?
        new BooleanNode(true) : new BooleanNode(builder.include_distribution_config_in_cluster_state_bundle);
    aggregate_content_node_error_reports_from_distributors = (builder.aggregate_content_node_error_reports_from_distributors == null) ?
        new BooleanNode(true) : new BooleanNode(builder.aggregate_content_node_error_reports_from_distributors);
  }

  /**
   * @return fleetcontroller.cluster_name
   */
  public String cluster_name() {
    return cluster_name.value();
  }

  /**
   * @return fleetcontroller.index
   */
  public int index() {
    return index.value();
  }

  /**
   * @return fleetcontroller.fleet_controller_count
   */
  public int fleet_controller_count() {
    return fleet_controller_count.value();
  }

  /**
   * @return fleetcontroller.zookeeper_session_timeout
   */
  public double zookeeper_session_timeout() {
    return zookeeper_session_timeout.value();
  }

  /**
   * @return fleetcontroller.master_zookeeper_cooldown_period
   */
  public double master_zookeeper_cooldown_period() {
    return master_zookeeper_cooldown_period.value();
  }

  /**
   * @return fleetcontroller.state_gather_count
   */
  public int state_gather_count() {
    return state_gather_count.value();
  }

  /**
   * @return fleetcontroller.zookeeper_server
   */
  public String zookeeper_server() {
    return zookeeper_server.value();
  }

  /**
   * @return fleetcontroller.rpc_port
   */
  public int rpc_port() {
    return rpc_port.value();
  }

  /**
   * @return fleetcontroller.http_port
   */
  public int http_port() {
    return http_port.value();
  }

  /**
   * @return fleetcontroller.storage_transition_time
   */
  public int storage_transition_time() {
    return storage_transition_time.value();
  }

  /**
   * @return fleetcontroller.distributor_transition_time
   */
  public int distributor_transition_time() {
    return distributor_transition_time.value();
  }

  /**
   * @return fleetcontroller.init_progress_time
   */
  public int init_progress_time() {
    return init_progress_time.value();
  }

  /**
   * @return fleetcontroller.min_time_between_new_systemstates
   */
  public int min_time_between_new_systemstates() {
    return min_time_between_new_systemstates.value();
  }

  /**
   * @return fleetcontroller.max_premature_crashes
   */
  public int max_premature_crashes() {
    return max_premature_crashes.value();
  }

  /**
   * @return fleetcontroller.stable_state_time_period
   */
  public int stable_state_time_period() {
    return stable_state_time_period.value();
  }

  /**
   * @return fleetcontroller.event_log_max_size
   */
  public int event_log_max_size() {
    return event_log_max_size.value();
  }

  /**
   * @return fleetcontroller.event_node_log_max_size
   */
  public int event_node_log_max_size() {
    return event_node_log_max_size.value();
  }

  /**
   * @return fleetcontroller.total_distributor_count
   */
  public int total_distributor_count() {
    return total_distributor_count.value();
  }

  /**
   * @return fleetcontroller.total_storage_count
   */
  public int total_storage_count() {
    return total_storage_count.value();
  }

  /**
   * @return fleetcontroller.min_distributors_up_count
   */
  public int min_distributors_up_count() {
    return min_distributors_up_count.value();
  }

  /**
   * @return fleetcontroller.min_storage_up_count
   */
  public int min_storage_up_count() {
    return min_storage_up_count.value();
  }

  /**
   * @return fleetcontroller.min_distributor_up_ratio
   */
  public double min_distributor_up_ratio() {
    return min_distributor_up_ratio.value();
  }

  /**
   * @return fleetcontroller.min_storage_up_ratio
   */
  public double min_storage_up_ratio() {
    return min_storage_up_ratio.value();
  }

  /**
   * @return fleetcontroller.cycle_wait_time
   */
  public double cycle_wait_time() {
    return cycle_wait_time.value();
  }

  /**
   * @return fleetcontroller.min_time_before_first_system_state_broadcast
   */
  public double min_time_before_first_system_state_broadcast() {
    return min_time_before_first_system_state_broadcast.value();
  }

  /**
   * @return fleetcontroller.get_node_state_request_timeout
   */
  public double get_node_state_request_timeout() {
    return get_node_state_request_timeout.value();
  }

  /**
   * @return fleetcontroller.max_slobrok_disconnect_grace_period
   */
  public double max_slobrok_disconnect_grace_period() {
    return max_slobrok_disconnect_grace_period.value();
  }

  /**
   * @return fleetcontroller.show_local_systemstates_in_event_log
   */
  public boolean show_local_systemstates_in_event_log() {
    return show_local_systemstates_in_event_log.value();
  }

  /**
   * @return fleetcontroller.ideal_distribution_bits
   */
  public int ideal_distribution_bits() {
    return ideal_distribution_bits.value();
  }

  /**
   * @return fleetcontroller.min_node_ratio_per_group
   */
  public double min_node_ratio_per_group() {
    return min_node_ratio_per_group.value();
  }

  /**
   * @return fleetcontroller.max_deferred_task_version_wait_time_sec
   */
  public double max_deferred_task_version_wait_time_sec() {
    return max_deferred_task_version_wait_time_sec.value();
  }

  /**
   * @return fleetcontroller.cluster_has_global_document_types
   */
  public boolean cluster_has_global_document_types() {
    return cluster_has_global_document_types.value();
  }

  /**
   * @return fleetcontroller.min_merge_completion_ratio
   */
  public double min_merge_completion_ratio() {
    return min_merge_completion_ratio.value();
  }

  /**
   * @return fleetcontroller.enable_two_phase_cluster_state_transitions
   */
  public boolean enable_two_phase_cluster_state_transitions() {
    return enable_two_phase_cluster_state_transitions.value();
  }

  /**
   * @return fleetcontroller.enable_cluster_feed_block
   */
  public boolean enable_cluster_feed_block() {
    return enable_cluster_feed_block.value();
  }

  /**
   * @return fleetcontroller.cluster_feed_block_limit{}
   */
  public Map<String, Double> cluster_feed_block_limit() {
    return LeafNodeMaps.asValueMap(cluster_feed_block_limit);
  }

  /**
   * @param key the key of the value to return
   * @return fleetcontroller.cluster_feed_block_limit{}
   */
  public double cluster_feed_block_limit(String key) {
    return cluster_feed_block_limit.get(key).value();
  }

  /**
   * @return fleetcontroller.cluster_feed_block_noise_level
   */
  public double cluster_feed_block_noise_level() {
    return cluster_feed_block_noise_level.value();
  }

  /**
   * @return fleetcontroller.max_number_of_groups_allowed_to_be_down
   */
  public int max_number_of_groups_allowed_to_be_down() {
    return max_number_of_groups_allowed_to_be_down.value();
  }

  /**
   * @return fleetcontroller.include_distribution_config_in_cluster_state_bundle
   */
  public boolean include_distribution_config_in_cluster_state_bundle() {
    return include_distribution_config_in_cluster_state_bundle.value();
  }

  /**
   * @return fleetcontroller.aggregate_content_node_error_reports_from_distributors
   */
  public boolean aggregate_content_node_error_reports_from_distributors() {
    return aggregate_content_node_error_reports_from_distributors.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(FleetcontrollerConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("fleetcontroller");
      changes.compare(this.cluster_name, newConfig.cluster_name, "cluster_name", "Name of VDS cluster");
      changes.compare(this.index, newConfig.index, "index", "The fleetcontroller index. Each fleetcontroller should have a unique index\nwhich can be used to identify them.");
      changes.compare(this.zookeeper_server, newConfig.zookeeper_server, "zookeeper_server", "Location of ZooKeeper servers");
      changes.compare(this.rpc_port, newConfig.rpc_port, "rpc_port", "RPC Port used by fleetcontroller");
      changes.compare(this.http_port, newConfig.http_port, "http_port", "Port where fleetcontroller listens for HTTP status request");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return true;
  }


}
