// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.vespa.config.content;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of all-clusters-bucket-spaces
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class AllClustersBucketSpacesConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "fe076e3aab3f4ffbfc49ed1695357507";
  public final static String CONFIG_DEF_NAME = "all-clusters-bucket-spaces";
  public final static String CONFIG_DEF_NAMESPACE = "vespa.config.content";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=vespa.config.content",
    "cluster{}.documentType{}.bucketSpace string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public Map<String, Cluster.Builder> cluster = new LinkedHashMap<>();

    public Builder() { }

    public Builder(AllClustersBucketSpacesConfig config) {
      for (Map.Entry<String, Cluster> __entry : config.cluster().entrySet()) {
        cluster(__entry.getKey(), new Cluster.Builder(__entry.getValue()));
      }
    }

    private Builder override(Builder __superior) {
      cluster(__superior.cluster);
      return this;
    }

    public Builder cluster(String __key, Cluster.Builder __value) {
      cluster.put(__key, __value);
      return this;
    }

    public Builder cluster(Map<String, Cluster.Builder> __values) {
      cluster.putAll(__values);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before using it as the value
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder cluster(String __key, java.util.function.Consumer<Cluster.Builder> __func) {
      Cluster.Builder __inner = new Cluster.Builder();
      __func.accept(__inner);
      cluster.put(__key, __inner);
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public AllClustersBucketSpacesConfig build() {
      return new AllClustersBucketSpacesConfig(this);
    }

  }

  private final Map<String, Cluster> cluster;

  public AllClustersBucketSpacesConfig(Builder builder) {
    this(builder, true);
  }

  private AllClustersBucketSpacesConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "all-clusters-bucket-spaces must be initialized: " + builder.__uninitialized);

    cluster = Cluster.createMap(builder.cluster);
  }

  /**
   * @return all-clusters-bucket-spaces.cluster{}
   */
  public Map<String, Cluster> cluster() {
    return Collections.unmodifiableMap(cluster);
  }

  /**
   * @param key the key of the value to return
   * @return all-clusters-bucket-spaces.cluster{}
   */
  public Cluster cluster(String key) {
    return cluster.get(key);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(AllClustersBucketSpacesConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("all-clusters-bucket-spaces");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents all-clusters-bucket-spaces.cluster{}
   */
  public final static class Cluster extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      public Map<String, DocumentType.Builder> documentType = new LinkedHashMap<>();

      public Builder() { }

      public Builder(Cluster config) {
        for (Map.Entry<String, DocumentType> __entry : config.documentType().entrySet()) {
          documentType(__entry.getKey(), new DocumentType.Builder(__entry.getValue()));
        }
      }

      private Builder override(Builder __superior) {
        documentType(__superior.documentType);
        return this;
      }

      public Builder documentType(String __key, DocumentType.Builder __value) {
        documentType.put(__key, __value);
        return this;
      }

      public Builder documentType(Map<String, DocumentType.Builder> __values) {
        documentType.putAll(__values);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before using it as the value
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder documentType(String __key, java.util.function.Consumer<DocumentType.Builder> __func) {
        DocumentType.Builder __inner = new DocumentType.Builder();
        __func.accept(__inner);
        documentType.put(__key, __inner);
        return this;
      }

      public Cluster build() {
        return new Cluster(this);
      }

    }

    private final Map<String, DocumentType> documentType;

    public Cluster(Builder builder) {
      this(builder, true);
    }

    private Cluster(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "all-clusters-bucket-spaces.cluster{} must be initialized: " + builder.__uninitialized);

      documentType = DocumentType.createMap(builder.documentType);
    }

    /**
     * @return all-clusters-bucket-spaces.cluster{}.documentType{}
     */
    public Map<String, DocumentType> documentType() {
      return Collections.unmodifiableMap(documentType);
    }

    /**
     * @param key the key of the value to return
     * @return all-clusters-bucket-spaces.cluster{}.documentType{}
     */
    public DocumentType documentType(String key) {
      return documentType.get(key);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Cluster newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("cluster");
      return changes;
    }

    private static Map<String, Cluster> createMap(Map<String, Builder> builders) {
      Map<String, Cluster> ret = new LinkedHashMap<>();
      for(String key : builders.keySet()) {
        ret.put(key, new Cluster(builders.get(key)));
      }
      return Collections.unmodifiableMap(ret);
    }

    /**
     * This class represents all-clusters-bucket-spaces.cluster{}.documentType{}
     */
    public final static class DocumentType extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "bucketSpace"
          ));

        private String bucketSpace = null;

        public Builder() { }

        public Builder(DocumentType config) {
          bucketSpace(config.bucketSpace());
        }

        private Builder override(Builder __superior) {
          if (__superior.bucketSpace != null)
            bucketSpace(__superior.bucketSpace);
          return this;
        }

        public Builder bucketSpace(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          bucketSpace = __value;
          __uninitialized.remove("bucketSpace");
          return this;
        }


        public DocumentType build() {
          return new DocumentType(this);
        }

      }

      // This config contains the document types handled by all content clusters
      // and the bucket spaces they belong to.
      // The bucket space a document type in a particular cluster belongs to.
      private final StringNode bucketSpace;

      public DocumentType(Builder builder) {
        this(builder, true);
      }

      private DocumentType(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "all-clusters-bucket-spaces.cluster{}.documentType{} must be initialized: " + builder.__uninitialized);

        bucketSpace = (builder.bucketSpace == null) ?
            new StringNode() : new StringNode(builder.bucketSpace);
      }

      /**
       * @return all-clusters-bucket-spaces.cluster{}.documentType{}.bucketSpace
       */
      public String bucketSpace() {
        return bucketSpace.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(DocumentType newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("documentType");
        return changes;
      }

      private static Map<String, DocumentType> createMap(Map<String, Builder> builders) {
        Map<String, DocumentType> ret = new LinkedHashMap<>();
        for(String key : builders.keySet()) {
          ret.put(key, new DocumentType(builders.get(key)));
        }
        return Collections.unmodifiableMap(ret);
      }
    }
  }

}
