// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.search.significance.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of significance
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class SignificanceConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "cd65548117bf815dadc2ffb105ec8c8b";
  public final static String CONFIG_DEF_NAME = "significance";
  public final static String CONFIG_DEF_NAMESPACE = "search.significance.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=search.significance.config",
    "model[].path model"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Model.Builder> model = new ArrayList<>();

    public Builder() { }

    public Builder(SignificanceConfig config) {
      for (Model m : config.model()) {
        model(new Model.Builder(m));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.model.isEmpty())
        model.addAll(__superior.model);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Model builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder model(Model.Builder __builder) {
      model.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder model(java.util.function.Consumer<Model.Builder> __func) {
      Model.Builder __inner = new Model.Builder();
      __func.accept(__inner);
      model.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Model builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder model(List<Model.Builder> __builders) {
      model = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public SignificanceConfig build() {
      return new SignificanceConfig(this);
    }

  }

  private final InnerNodeVector<Model> model;

  public SignificanceConfig(Builder builder) {
    this(builder, true);
  }

  private SignificanceConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "significance must be initialized: " + builder.__uninitialized);

    model = Model.createVector(builder.model);
  }

  /**
   * @return significance.model[]
   */
  public List<Model> model() {
    return model;
  }

  /**
   * @param i the index of the value to return
   * @return significance.model[]
   */
  public Model model(int i) {
    return model.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(SignificanceConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("significance");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents significance.model[]
   */
  public final static class Model extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "path"
        ));

      private ModelReference path = null;

      public Builder() { }

      public Builder(Model config) {
        path(config.path.getModelReference());
      }

      private Builder override(Builder __superior) {
        if (__superior.path != null)
          path(__superior.path);
        return this;
      }

      public Builder path(ModelReference __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        path = __value;
        __uninitialized.remove("path");
        return this;
      }


      public Model build() {
        return new Model(this);
      }

    }

    private final ModelNode path;

    public Model(Builder builder) {
      this(builder, true);
    }

    private Model(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "significance.model[] must be initialized: " + builder.__uninitialized);

      path = (builder.path == null) ?
          new ModelNode() : new ModelNode(builder.path);
    }

    /**
     * @return significance.model[].path
     */
    public Path path() {
      return path.value();
    }

    /**
     * @return significance.model[].path ModelReference
     */
    public ModelReference pathReference() {
      return path.getModelReference();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Model newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("model");
      return changes;
    }

    private static InnerNodeVector<Model> createVector(List<Builder> builders) {
        List<Model> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Model(b));
        }
        return new InnerNodeVector<Model>(elems);
    }
  }

}
