// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.language.huggingface.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of hugging-face-tokenizer
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class HuggingFaceTokenizerConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "3cb0f5da9cf3a1bd23ab75d8a6b9b771";
  public final static String CONFIG_DEF_NAME = "hugging-face-tokenizer";
  public final static String CONFIG_DEF_NAMESPACE = "language.huggingface.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=language.huggingface.config",
    "model[].language string",
    "model[].path model",
    "addSpecialTokens bool default=true",
    "maxLength int default=-1",
    "truncation enum { ON, OFF, NOTSET } default=NOTSET",
    "padding enum { ON, OFF, NOTSET } default=NOTSET"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Model.Builder> model = new ArrayList<>();
    private Boolean addSpecialTokens = null;
    private Integer maxLength = null;
    private Truncation.Enum truncation = null;
    private Padding.Enum padding = null;

    public Builder() { }

    public Builder(HuggingFaceTokenizerConfig config) {
      for (Model m : config.model()) {
        model(new Model.Builder(m));
      }
      addSpecialTokens(config.addSpecialTokens());
      maxLength(config.maxLength());
      truncation(config.truncation());
      padding(config.padding());
    }

    private Builder override(Builder __superior) {
      if (!__superior.model.isEmpty())
        model.addAll(__superior.model);
      if (__superior.addSpecialTokens != null)
        addSpecialTokens(__superior.addSpecialTokens);
      if (__superior.maxLength != null)
        maxLength(__superior.maxLength);
      if (__superior.truncation != null)
        truncation(__superior.truncation);
      if (__superior.padding != null)
        padding(__superior.padding);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Model builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder model(Model.Builder __builder) {
      model.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder model(java.util.function.Consumer<Model.Builder> __func) {
      Model.Builder __inner = new Model.Builder();
      __func.accept(__inner);
      model.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Model builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder model(List<Model.Builder> __builders) {
      model = __builders;
      return this;
    }

    public Builder addSpecialTokens(boolean __value) {
      addSpecialTokens = __value;
      return this;
    }

    private Builder addSpecialTokens(String __value) {
      return addSpecialTokens(Boolean.valueOf(__value));
    }

    public Builder maxLength(int __value) {
      maxLength = __value;
      return this;
    }

    private Builder maxLength(String __value) {
      return maxLength(Integer.valueOf(__value));
    }

    public Builder truncation(Truncation.Enum __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      truncation = __value;
      return this;
    }

    private Builder truncation(String __value) {
      return truncation(Truncation.Enum.valueOf(__value));
    }

    public Builder padding(Padding.Enum __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      padding = __value;
      return this;
    }

    private Builder padding(String __value) {
      return padding(Padding.Enum.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public HuggingFaceTokenizerConfig build() {
      return new HuggingFaceTokenizerConfig(this);
    }

  }

  private final InnerNodeVector<Model> model;
  // Include special tokens in output
  private final BooleanNode addSpecialTokens;
  // Used for truncation/padding. Use -1 for model default.
  private final IntegerNode maxLength;
  // Truncation strategy. Use NOTSET for model default.
  private final Truncation truncation;
  // Padding strategy. Use NOTSET for model default.
  private final Padding padding;

  public HuggingFaceTokenizerConfig(Builder builder) {
    this(builder, true);
  }

  private HuggingFaceTokenizerConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "hugging-face-tokenizer must be initialized: " + builder.__uninitialized);

    model = Model.createVector(builder.model);
    addSpecialTokens = (builder.addSpecialTokens == null) ?
        new BooleanNode(true) : new BooleanNode(builder.addSpecialTokens);
    maxLength = (builder.maxLength == null) ?
        new IntegerNode(-1) : new IntegerNode(builder.maxLength);
    truncation = (builder.truncation == null) ?
        new Truncation(Truncation.NOTSET) : new Truncation(builder.truncation);
    padding = (builder.padding == null) ?
        new Padding(Padding.NOTSET) : new Padding(builder.padding);
  }

  /**
   * @return hugging-face-tokenizer.model[]
   */
  public List<Model> model() {
    return model;
  }

  /**
   * @param i the index of the value to return
   * @return hugging-face-tokenizer.model[]
   */
  public Model model(int i) {
    return model.get(i);
  }

  /**
   * @return hugging-face-tokenizer.addSpecialTokens
   */
  public boolean addSpecialTokens() {
    return addSpecialTokens.value();
  }

  /**
   * @return hugging-face-tokenizer.maxLength
   */
  public int maxLength() {
    return maxLength.value();
  }

  /**
   * @return hugging-face-tokenizer.truncation
   */
  public Truncation.Enum truncation() {
    return truncation.value();
  }

  /**
   * @return hugging-face-tokenizer.padding
   */
  public Padding.Enum padding() {
    return padding.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(HuggingFaceTokenizerConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("hugging-face-tokenizer");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents hugging-face-tokenizer.model[]
   */
  public final static class Model extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "language",
        "path"
        ));

      private String language = null;
      private ModelReference path = null;

      public Builder() { }

      public Builder(Model config) {
        language(config.language());
        path(config.path.getModelReference());
      }

      private Builder override(Builder __superior) {
        if (__superior.language != null)
          language(__superior.language);
        if (__superior.path != null)
          path(__superior.path);
        return this;
      }

      public Builder language(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        language = __value;
        __uninitialized.remove("language");
        return this;
      }


      public Builder path(ModelReference __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        path = __value;
        __uninitialized.remove("path");
        return this;
      }


      public Model build() {
        return new Model(this);
      }

    }

    // The language a model is for, one of the language tags in com.yahoo.language.Language.
    // Use "unknown" for models to be used with any language.
    private final StringNode language;
    // The path to the model relative to the application package root
    private final ModelNode path;

    public Model(Builder builder) {
      this(builder, true);
    }

    private Model(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "hugging-face-tokenizer.model[] must be initialized: " + builder.__uninitialized);

      language = (builder.language == null) ?
          new StringNode() : new StringNode(builder.language);
      path = (builder.path == null) ?
          new ModelNode() : new ModelNode(builder.path);
    }

    /**
     * @return hugging-face-tokenizer.model[].language
     */
    public String language() {
      return language.value();
    }

    /**
     * @return hugging-face-tokenizer.model[].path
     */
    public Path path() {
      return path.value();
    }

    /**
     * @return hugging-face-tokenizer.model[].path ModelReference
     */
    public ModelReference pathReference() {
      return path.getModelReference();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Model newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("model");
      return changes;
    }

    private static InnerNodeVector<Model> createVector(List<Builder> builders) {
        List<Model> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Model(b));
        }
        return new InnerNodeVector<Model>(elems);
    }
  }

  /**
   * This class represents hugging-face-tokenizer.truncation
   * 
   * Truncation strategy. Use NOTSET for model default.
   */
  public final static class Truncation extends EnumNode<Truncation.Enum> {

    public Truncation(){
      this.value = null;
    }

    public Truncation(Enum enumValue) {
      super(enumValue != null);
      this.value = enumValue;
    }

    public enum Enum {ON, OFF, NOTSET}
    public final static Enum ON = Enum.ON;
    public final static Enum OFF = Enum.OFF;
    public final static Enum NOTSET = Enum.NOTSET;

    @Override
    protected boolean doSetValue(String name) {
      try {
        value = Enum.valueOf(name);
        return true;
      } catch (IllegalArgumentException e) {
      }
      return false;
    }
  }

  /**
   * This class represents hugging-face-tokenizer.padding
   * 
   * Padding strategy. Use NOTSET for model default.
   */
  public final static class Padding extends EnumNode<Padding.Enum> {

    public Padding(){
      this.value = null;
    }

    public Padding(Enum enumValue) {
      super(enumValue != null);
      this.value = enumValue;
    }

    public enum Enum {ON, OFF, NOTSET}
    public final static Enum ON = Enum.ON;
    public final static Enum OFF = Enum.OFF;
    public final static Enum NOTSET = Enum.NOTSET;

    @Override
    protected boolean doSetValue(String name) {
      try {
        value = Enum.valueOf(name);
        return true;
      } catch (IllegalArgumentException e) {
      }
      return false;
    }
  }

}
