// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.jdisc.http.filter.security.cloud.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of cloud-token-data-plane-filter
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class CloudTokenDataPlaneFilterConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "78394f8ff526a398631884b738ad8758";
  public final static String CONFIG_DEF_NAME = "cloud-token-data-plane-filter";
  public final static String CONFIG_DEF_NAMESPACE = "jdisc.http.filter.security.cloud.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=jdisc.http.filter.security.cloud.config",
    "tokenContext string default=\"\"",
    "clients[].id string",
    "clients[].permissions[] string",
    "clients[].tokens[].id string",
    "clients[].tokens[].fingerprints[] string",
    "clients[].tokens[].checkAccessHashes[] string",
    "clients[].tokens[].expirations[] string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private String tokenContext = null;
    public List<Clients.Builder> clients = new ArrayList<>();

    public Builder() { }

    public Builder(CloudTokenDataPlaneFilterConfig config) {
      tokenContext(config.tokenContext());
      for (Clients c : config.clients()) {
        clients(new Clients.Builder(c));
      }
    }

    private Builder override(Builder __superior) {
      if (__superior.tokenContext != null)
        tokenContext(__superior.tokenContext);
      if (!__superior.clients.isEmpty())
        clients.addAll(__superior.clients);
      return this;
    }

    public Builder tokenContext(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      tokenContext = __value;
      return this;
    }


    /**
     * Add the given builder to this builder's list of Clients builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder clients(Clients.Builder __builder) {
      clients.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder clients(java.util.function.Consumer<Clients.Builder> __func) {
      Clients.Builder __inner = new Clients.Builder();
      __func.accept(__inner);
      clients.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Clients builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder clients(List<Clients.Builder> __builders) {
      clients = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public CloudTokenDataPlaneFilterConfig build() {
      return new CloudTokenDataPlaneFilterConfig(this);
    }

  }

  private final StringNode tokenContext;
  private final InnerNodeVector<Clients> clients;

  public CloudTokenDataPlaneFilterConfig(Builder builder) {
    this(builder, true);
  }

  private CloudTokenDataPlaneFilterConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "cloud-token-data-plane-filter must be initialized: " + builder.__uninitialized);

    tokenContext = (builder.tokenContext == null) ?
        new StringNode("") : new StringNode(builder.tokenContext);
    clients = Clients.createVector(builder.clients);
  }

  /**
   * @return cloud-token-data-plane-filter.tokenContext
   */
  public String tokenContext() {
    return tokenContext.value();
  }

  /**
   * @return cloud-token-data-plane-filter.clients[]
   */
  public List<Clients> clients() {
    return clients;
  }

  /**
   * @param i the index of the value to return
   * @return cloud-token-data-plane-filter.clients[]
   */
  public Clients clients(int i) {
    return clients.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(CloudTokenDataPlaneFilterConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("cloud-token-data-plane-filter");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents cloud-token-data-plane-filter.clients[]
   */
  public final static class Clients extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "id"
        ));

      private String id = null;
      public List<String> permissions = new ArrayList<>();
      public List<Tokens.Builder> tokens = new ArrayList<>();

      public Builder() { }

      public Builder(Clients config) {
        id(config.id());
        permissions(config.permissions());
        for (Tokens t : config.tokens()) {
          tokens(new Tokens.Builder(t));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.id != null)
          id(__superior.id);
        if (!__superior.permissions.isEmpty())
          permissions.addAll(__superior.permissions);
        if (!__superior.tokens.isEmpty())
          tokens.addAll(__superior.tokens);
        return this;
      }

      public Builder id(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        id = __value;
        __uninitialized.remove("id");
        return this;
      }


      public Builder permissions(String __value) {
        permissions.add(__value);
        return this;
      }

      public Builder permissions(Collection<String> __values) {
        permissions.addAll(__values);
        return this;
      }

      /**
       * Add the given builder to this builder's list of Tokens builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder tokens(Tokens.Builder __builder) {
        tokens.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder tokens(java.util.function.Consumer<Tokens.Builder> __func) {
        Tokens.Builder __inner = new Tokens.Builder();
        __func.accept(__inner);
        tokens.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Tokens builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder tokens(List<Tokens.Builder> __builders) {
        tokens = __builders;
        return this;
      }

      public Clients build() {
        return new Clients(this);
      }

    }

    private final StringNode id;
    private final LeafNodeVector<String, StringNode> permissions;
    private final InnerNodeVector<Tokens> tokens;

    public Clients(Builder builder) {
      this(builder, true);
    }

    private Clients(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "cloud-token-data-plane-filter.clients[] must be initialized: " + builder.__uninitialized);

      id = (builder.id == null) ?
          new StringNode() : new StringNode(builder.id);
      permissions = new LeafNodeVector<>(builder.permissions, new StringNode());
      tokens = Tokens.createVector(builder.tokens);
    }

    /**
     * @return cloud-token-data-plane-filter.clients[].id
     */
    public String id() {
      return id.value();
    }

    /**
     * @return cloud-token-data-plane-filter.clients[].permissions[]
     */
    public List<String> permissions() {
      return permissions.asList();
    }

    /**
     * @param i the index of the value to return
     * @return cloud-token-data-plane-filter.clients[].permissions[]
     */
    public String permissions(int i) {
      return permissions.get(i).value();
    }

    /**
     * @return cloud-token-data-plane-filter.clients[].tokens[]
     */
    public List<Tokens> tokens() {
      return tokens;
    }

    /**
     * @param i the index of the value to return
     * @return cloud-token-data-plane-filter.clients[].tokens[]
     */
    public Tokens tokens(int i) {
      return tokens.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Clients newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("clients");
      return changes;
    }

    private static InnerNodeVector<Clients> createVector(List<Builder> builders) {
        List<Clients> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Clients(b));
        }
        return new InnerNodeVector<Clients>(elems);
    }

    /**
     * This class represents cloud-token-data-plane-filter.clients[].tokens[]
     */
    public final static class Tokens extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "id"
          ));

        private String id = null;
        public List<String> fingerprints = new ArrayList<>();
        public List<String> checkAccessHashes = new ArrayList<>();
        public List<String> expirations = new ArrayList<>();

        public Builder() { }

        public Builder(Tokens config) {
          id(config.id());
          fingerprints(config.fingerprints());
          checkAccessHashes(config.checkAccessHashes());
          expirations(config.expirations());
        }

        private Builder override(Builder __superior) {
          if (__superior.id != null)
            id(__superior.id);
          if (!__superior.fingerprints.isEmpty())
            fingerprints.addAll(__superior.fingerprints);
          if (!__superior.checkAccessHashes.isEmpty())
            checkAccessHashes.addAll(__superior.checkAccessHashes);
          if (!__superior.expirations.isEmpty())
            expirations.addAll(__superior.expirations);
          return this;
        }

        public Builder id(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          id = __value;
          __uninitialized.remove("id");
          return this;
        }


        public Builder fingerprints(String __value) {
          fingerprints.add(__value);
          return this;
        }

        public Builder fingerprints(Collection<String> __values) {
          fingerprints.addAll(__values);
          return this;
        }

        public Builder checkAccessHashes(String __value) {
          checkAccessHashes.add(__value);
          return this;
        }

        public Builder checkAccessHashes(Collection<String> __values) {
          checkAccessHashes.addAll(__values);
          return this;
        }

        public Builder expirations(String __value) {
          expirations.add(__value);
          return this;
        }

        public Builder expirations(Collection<String> __values) {
          expirations.addAll(__values);
          return this;
        }

        public Tokens build() {
          return new Tokens(this);
        }

      }

      private final StringNode id;
      private final LeafNodeVector<String, StringNode> fingerprints;
      private final LeafNodeVector<String, StringNode> checkAccessHashes;
      private final LeafNodeVector<String, StringNode> expirations;

      public Tokens(Builder builder) {
        this(builder, true);
      }

      private Tokens(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "cloud-token-data-plane-filter.clients[].tokens[] must be initialized: " + builder.__uninitialized);

        id = (builder.id == null) ?
            new StringNode() : new StringNode(builder.id);
        fingerprints = new LeafNodeVector<>(builder.fingerprints, new StringNode());
        checkAccessHashes = new LeafNodeVector<>(builder.checkAccessHashes, new StringNode());
        expirations = new LeafNodeVector<>(builder.expirations, new StringNode());
      }

      /**
       * @return cloud-token-data-plane-filter.clients[].tokens[].id
       */
      public String id() {
        return id.value();
      }

      /**
       * @return cloud-token-data-plane-filter.clients[].tokens[].fingerprints[]
       */
      public List<String> fingerprints() {
        return fingerprints.asList();
      }

      /**
       * @param i the index of the value to return
       * @return cloud-token-data-plane-filter.clients[].tokens[].fingerprints[]
       */
      public String fingerprints(int i) {
        return fingerprints.get(i).value();
      }

      /**
       * @return cloud-token-data-plane-filter.clients[].tokens[].checkAccessHashes[]
       */
      public List<String> checkAccessHashes() {
        return checkAccessHashes.asList();
      }

      /**
       * @param i the index of the value to return
       * @return cloud-token-data-plane-filter.clients[].tokens[].checkAccessHashes[]
       */
      public String checkAccessHashes(int i) {
        return checkAccessHashes.get(i).value();
      }

      /**
       * @return cloud-token-data-plane-filter.clients[].tokens[].expirations[]
       */
      public List<String> expirations() {
        return expirations.asList();
      }

      /**
       * @param i the index of the value to return
       * @return cloud-token-data-plane-filter.clients[].tokens[].expirations[]
       */
      public String expirations(int i) {
        return expirations.get(i).value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Tokens newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("tokens");
        return changes;
      }

      private static InnerNodeVector<Tokens> createVector(List<Builder> builders) {
          List<Tokens> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Tokens(b));
          }
          return new InnerNodeVector<Tokens>(elems);
      }
    }
  }

}
