// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.jdisc.http.filter.security.cloud.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of cloud-data-plane-filter
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class CloudDataPlaneFilterConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "ed2e1a73db2928397d1f4c8737fecd9b";
  public final static String CONFIG_DEF_NAME = "cloud-data-plane-filter";
  public final static String CONFIG_DEF_NAMESPACE = "jdisc.http.filter.security.cloud.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=jdisc.http.filter.security.cloud.config",
    "legacyMode bool default=false",
    "clients[].id string",
    "clients[].permissions[] string",
    "clients[].certificates[] string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Boolean legacyMode = null;
    public List<Clients.Builder> clients = new ArrayList<>();

    public Builder() { }

    public Builder(CloudDataPlaneFilterConfig config) {
      legacyMode(config.legacyMode());
      for (Clients c : config.clients()) {
        clients(new Clients.Builder(c));
      }
    }

    private Builder override(Builder __superior) {
      if (__superior.legacyMode != null)
        legacyMode(__superior.legacyMode);
      if (!__superior.clients.isEmpty())
        clients.addAll(__superior.clients);
      return this;
    }

    public Builder legacyMode(boolean __value) {
      legacyMode = __value;
      return this;
    }

    private Builder legacyMode(String __value) {
      return legacyMode(Boolean.valueOf(__value));
    }

    /**
     * Add the given builder to this builder's list of Clients builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder clients(Clients.Builder __builder) {
      clients.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder clients(java.util.function.Consumer<Clients.Builder> __func) {
      Clients.Builder __inner = new Clients.Builder();
      __func.accept(__inner);
      clients.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Clients builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder clients(List<Clients.Builder> __builders) {
      clients = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public CloudDataPlaneFilterConfig build() {
      return new CloudDataPlaneFilterConfig(this);
    }

  }

  private final BooleanNode legacyMode;
  private final InnerNodeVector<Clients> clients;

  public CloudDataPlaneFilterConfig(Builder builder) {
    this(builder, true);
  }

  private CloudDataPlaneFilterConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "cloud-data-plane-filter must be initialized: " + builder.__uninitialized);

    legacyMode = (builder.legacyMode == null) ?
        new BooleanNode(false) : new BooleanNode(builder.legacyMode);
    clients = Clients.createVector(builder.clients);
  }

  /**
   * @return cloud-data-plane-filter.legacyMode
   */
  public boolean legacyMode() {
    return legacyMode.value();
  }

  /**
   * @return cloud-data-plane-filter.clients[]
   */
  public List<Clients> clients() {
    return clients;
  }

  /**
   * @param i the index of the value to return
   * @return cloud-data-plane-filter.clients[]
   */
  public Clients clients(int i) {
    return clients.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(CloudDataPlaneFilterConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("cloud-data-plane-filter");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents cloud-data-plane-filter.clients[]
   */
  public final static class Clients extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "id"
        ));

      private String id = null;
      public List<String> permissions = new ArrayList<>();
      public List<String> certificates = new ArrayList<>();

      public Builder() { }

      public Builder(Clients config) {
        id(config.id());
        permissions(config.permissions());
        certificates(config.certificates());
      }

      private Builder override(Builder __superior) {
        if (__superior.id != null)
          id(__superior.id);
        if (!__superior.permissions.isEmpty())
          permissions.addAll(__superior.permissions);
        if (!__superior.certificates.isEmpty())
          certificates.addAll(__superior.certificates);
        return this;
      }

      public Builder id(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        id = __value;
        __uninitialized.remove("id");
        return this;
      }


      public Builder permissions(String __value) {
        permissions.add(__value);
        return this;
      }

      public Builder permissions(Collection<String> __values) {
        permissions.addAll(__values);
        return this;
      }

      public Builder certificates(String __value) {
        certificates.add(__value);
        return this;
      }

      public Builder certificates(Collection<String> __values) {
        certificates.addAll(__values);
        return this;
      }

      public Clients build() {
        return new Clients(this);
      }

    }

    private final StringNode id;
    private final LeafNodeVector<String, StringNode> permissions;
    private final LeafNodeVector<String, StringNode> certificates;

    public Clients(Builder builder) {
      this(builder, true);
    }

    private Clients(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "cloud-data-plane-filter.clients[] must be initialized: " + builder.__uninitialized);

      id = (builder.id == null) ?
          new StringNode() : new StringNode(builder.id);
      permissions = new LeafNodeVector<>(builder.permissions, new StringNode());
      certificates = new LeafNodeVector<>(builder.certificates, new StringNode());
    }

    /**
     * @return cloud-data-plane-filter.clients[].id
     */
    public String id() {
      return id.value();
    }

    /**
     * @return cloud-data-plane-filter.clients[].permissions[]
     */
    public List<String> permissions() {
      return permissions.asList();
    }

    /**
     * @param i the index of the value to return
     * @return cloud-data-plane-filter.clients[].permissions[]
     */
    public String permissions(int i) {
      return permissions.get(i).value();
    }

    /**
     * @return cloud-data-plane-filter.clients[].certificates[]
     */
    public List<String> certificates() {
      return certificates.asList();
    }

    /**
     * @param i the index of the value to return
     * @return cloud-data-plane-filter.clients[].certificates[]
     */
    public String certificates(int i) {
      return certificates.get(i).value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Clients newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("clients");
      return changes;
    }

    private static InnerNodeVector<Clients> createVector(List<Builder> builders) {
        List<Clients> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Clients(b));
        }
        return new InnerNodeVector<Clients>(elems);
    }
  }

}
