// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.embedding;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of col-bert-embedder
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class ColBertEmbedderConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "7181e75fd83db85a555143a3f5d8dcd6";
  public final static String CONFIG_DEF_NAME = "col-bert-embedder";
  public final static String CONFIG_DEF_NAMESPACE = "embedding";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=embedding",
    "tokenizerPath model",
    "transformerModel model",
    "maxQueryTokens int default=32",
    "maxDocumentTokens int default=512",
    "transformerMaxTokens int default=512",
    "transformerInputIds string default=input_ids",
    "transformerAttentionMask string default=attention_mask",
    "transformerStartSequenceToken int default=101",
    "transformerEndSequenceToken int default=102",
    "transformerMaskToken int default=103",
    "transformerPadToken int default=0",
    "queryTokenId int default=1",
    "documentTokenId int default=2",
    "transformerOutput string default=contextual",
    "transformerExecutionMode enum { parallel, sequential } default=sequential",
    "transformerInterOpThreads int default=1",
    "transformerIntraOpThreads int default=-4",
    "transformerGpuDevice int default=0"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>(List.of(
      "tokenizerPath",
      "transformerModel"
      ));

    private ModelReference tokenizerPath = null;
    private ModelReference transformerModel = null;
    private Integer maxQueryTokens = null;
    private Integer maxDocumentTokens = null;
    private Integer transformerMaxTokens = null;
    private String transformerInputIds = null;
    private String transformerAttentionMask = null;
    private Integer transformerStartSequenceToken = null;
    private Integer transformerEndSequenceToken = null;
    private Integer transformerMaskToken = null;
    private Integer transformerPadToken = null;
    private Integer queryTokenId = null;
    private Integer documentTokenId = null;
    private String transformerOutput = null;
    private TransformerExecutionMode.Enum transformerExecutionMode = null;
    private Integer transformerInterOpThreads = null;
    private Integer transformerIntraOpThreads = null;
    private Integer transformerGpuDevice = null;

    public Builder() { }

    public Builder(ColBertEmbedderConfig config) {
      tokenizerPath(config.tokenizerPath.getModelReference());
      transformerModel(config.transformerModel.getModelReference());
      maxQueryTokens(config.maxQueryTokens());
      maxDocumentTokens(config.maxDocumentTokens());
      transformerMaxTokens(config.transformerMaxTokens());
      transformerInputIds(config.transformerInputIds());
      transformerAttentionMask(config.transformerAttentionMask());
      transformerStartSequenceToken(config.transformerStartSequenceToken());
      transformerEndSequenceToken(config.transformerEndSequenceToken());
      transformerMaskToken(config.transformerMaskToken());
      transformerPadToken(config.transformerPadToken());
      queryTokenId(config.queryTokenId());
      documentTokenId(config.documentTokenId());
      transformerOutput(config.transformerOutput());
      transformerExecutionMode(config.transformerExecutionMode());
      transformerInterOpThreads(config.transformerInterOpThreads());
      transformerIntraOpThreads(config.transformerIntraOpThreads());
      transformerGpuDevice(config.transformerGpuDevice());
    }

    private Builder override(Builder __superior) {
      if (__superior.tokenizerPath != null)
        tokenizerPath(__superior.tokenizerPath);
      if (__superior.transformerModel != null)
        transformerModel(__superior.transformerModel);
      if (__superior.maxQueryTokens != null)
        maxQueryTokens(__superior.maxQueryTokens);
      if (__superior.maxDocumentTokens != null)
        maxDocumentTokens(__superior.maxDocumentTokens);
      if (__superior.transformerMaxTokens != null)
        transformerMaxTokens(__superior.transformerMaxTokens);
      if (__superior.transformerInputIds != null)
        transformerInputIds(__superior.transformerInputIds);
      if (__superior.transformerAttentionMask != null)
        transformerAttentionMask(__superior.transformerAttentionMask);
      if (__superior.transformerStartSequenceToken != null)
        transformerStartSequenceToken(__superior.transformerStartSequenceToken);
      if (__superior.transformerEndSequenceToken != null)
        transformerEndSequenceToken(__superior.transformerEndSequenceToken);
      if (__superior.transformerMaskToken != null)
        transformerMaskToken(__superior.transformerMaskToken);
      if (__superior.transformerPadToken != null)
        transformerPadToken(__superior.transformerPadToken);
      if (__superior.queryTokenId != null)
        queryTokenId(__superior.queryTokenId);
      if (__superior.documentTokenId != null)
        documentTokenId(__superior.documentTokenId);
      if (__superior.transformerOutput != null)
        transformerOutput(__superior.transformerOutput);
      if (__superior.transformerExecutionMode != null)
        transformerExecutionMode(__superior.transformerExecutionMode);
      if (__superior.transformerInterOpThreads != null)
        transformerInterOpThreads(__superior.transformerInterOpThreads);
      if (__superior.transformerIntraOpThreads != null)
        transformerIntraOpThreads(__superior.transformerIntraOpThreads);
      if (__superior.transformerGpuDevice != null)
        transformerGpuDevice(__superior.transformerGpuDevice);
      return this;
    }

    public Builder tokenizerPath(ModelReference __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      tokenizerPath = __value;
      __uninitialized.remove("tokenizerPath");
      return this;
    }


    public Builder transformerModel(ModelReference __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      transformerModel = __value;
      __uninitialized.remove("transformerModel");
      return this;
    }


    public Builder maxQueryTokens(int __value) {
      maxQueryTokens = __value;
      return this;
    }

    private Builder maxQueryTokens(String __value) {
      return maxQueryTokens(Integer.valueOf(__value));
    }

    public Builder maxDocumentTokens(int __value) {
      maxDocumentTokens = __value;
      return this;
    }

    private Builder maxDocumentTokens(String __value) {
      return maxDocumentTokens(Integer.valueOf(__value));
    }

    public Builder transformerMaxTokens(int __value) {
      transformerMaxTokens = __value;
      return this;
    }

    private Builder transformerMaxTokens(String __value) {
      return transformerMaxTokens(Integer.valueOf(__value));
    }

    public Builder transformerInputIds(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      transformerInputIds = __value;
      return this;
    }


    public Builder transformerAttentionMask(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      transformerAttentionMask = __value;
      return this;
    }


    public Builder transformerStartSequenceToken(int __value) {
      transformerStartSequenceToken = __value;
      return this;
    }

    private Builder transformerStartSequenceToken(String __value) {
      return transformerStartSequenceToken(Integer.valueOf(__value));
    }

    public Builder transformerEndSequenceToken(int __value) {
      transformerEndSequenceToken = __value;
      return this;
    }

    private Builder transformerEndSequenceToken(String __value) {
      return transformerEndSequenceToken(Integer.valueOf(__value));
    }

    public Builder transformerMaskToken(int __value) {
      transformerMaskToken = __value;
      return this;
    }

    private Builder transformerMaskToken(String __value) {
      return transformerMaskToken(Integer.valueOf(__value));
    }

    public Builder transformerPadToken(int __value) {
      transformerPadToken = __value;
      return this;
    }

    private Builder transformerPadToken(String __value) {
      return transformerPadToken(Integer.valueOf(__value));
    }

    public Builder queryTokenId(int __value) {
      queryTokenId = __value;
      return this;
    }

    private Builder queryTokenId(String __value) {
      return queryTokenId(Integer.valueOf(__value));
    }

    public Builder documentTokenId(int __value) {
      documentTokenId = __value;
      return this;
    }

    private Builder documentTokenId(String __value) {
      return documentTokenId(Integer.valueOf(__value));
    }

    public Builder transformerOutput(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      transformerOutput = __value;
      return this;
    }


    public Builder transformerExecutionMode(TransformerExecutionMode.Enum __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      transformerExecutionMode = __value;
      return this;
    }

    private Builder transformerExecutionMode(String __value) {
      return transformerExecutionMode(TransformerExecutionMode.Enum.valueOf(__value));
    }

    public Builder transformerInterOpThreads(int __value) {
      transformerInterOpThreads = __value;
      return this;
    }

    private Builder transformerInterOpThreads(String __value) {
      return transformerInterOpThreads(Integer.valueOf(__value));
    }

    public Builder transformerIntraOpThreads(int __value) {
      transformerIntraOpThreads = __value;
      return this;
    }

    private Builder transformerIntraOpThreads(String __value) {
      return transformerIntraOpThreads(Integer.valueOf(__value));
    }

    public Builder transformerGpuDevice(int __value) {
      transformerGpuDevice = __value;
      return this;
    }

    private Builder transformerGpuDevice(String __value) {
      return transformerGpuDevice(Integer.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ColBertEmbedderConfig build() {
      return new ColBertEmbedderConfig(this);
    }

  }

  // Path to tokenizer.json
  private final ModelNode tokenizerPath;
  // Path to model.onnx
  private final ModelNode transformerModel;
  // Max query tokens for ColBERT
  private final IntegerNode maxQueryTokens;
  // Max document query tokens for ColBERT
  private final IntegerNode maxDocumentTokens;
  // Max length of token sequence model can handle
  private final IntegerNode transformerMaxTokens;
  // Input names
  private final StringNode transformerInputIds;
  private final StringNode transformerAttentionMask;
  // special token ids
  private final IntegerNode transformerStartSequenceToken;
  private final IntegerNode transformerEndSequenceToken;
  private final IntegerNode transformerMaskToken;
  private final IntegerNode transformerPadToken;
  private final IntegerNode queryTokenId;
  private final IntegerNode documentTokenId;
  // Output name
  private final StringNode transformerOutput;
  // Settings for ONNX model evaluation
  private final TransformerExecutionMode transformerExecutionMode;
  private final IntegerNode transformerInterOpThreads;
  private final IntegerNode transformerIntraOpThreads;
  // GPU device id, -1 for CPU
  private final IntegerNode transformerGpuDevice;

  public ColBertEmbedderConfig(Builder builder) {
    this(builder, true);
  }

  private ColBertEmbedderConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "col-bert-embedder must be initialized: " + builder.__uninitialized);

    tokenizerPath = (builder.tokenizerPath == null) ?
        new ModelNode() : new ModelNode(builder.tokenizerPath);
    transformerModel = (builder.transformerModel == null) ?
        new ModelNode() : new ModelNode(builder.transformerModel);
    maxQueryTokens = (builder.maxQueryTokens == null) ?
        new IntegerNode(32) : new IntegerNode(builder.maxQueryTokens);
    maxDocumentTokens = (builder.maxDocumentTokens == null) ?
        new IntegerNode(512) : new IntegerNode(builder.maxDocumentTokens);
    transformerMaxTokens = (builder.transformerMaxTokens == null) ?
        new IntegerNode(512) : new IntegerNode(builder.transformerMaxTokens);
    transformerInputIds = (builder.transformerInputIds == null) ?
        new StringNode("input_ids") : new StringNode(builder.transformerInputIds);
    transformerAttentionMask = (builder.transformerAttentionMask == null) ?
        new StringNode("attention_mask") : new StringNode(builder.transformerAttentionMask);
    transformerStartSequenceToken = (builder.transformerStartSequenceToken == null) ?
        new IntegerNode(101) : new IntegerNode(builder.transformerStartSequenceToken);
    transformerEndSequenceToken = (builder.transformerEndSequenceToken == null) ?
        new IntegerNode(102) : new IntegerNode(builder.transformerEndSequenceToken);
    transformerMaskToken = (builder.transformerMaskToken == null) ?
        new IntegerNode(103) : new IntegerNode(builder.transformerMaskToken);
    transformerPadToken = (builder.transformerPadToken == null) ?
        new IntegerNode(0) : new IntegerNode(builder.transformerPadToken);
    queryTokenId = (builder.queryTokenId == null) ?
        new IntegerNode(1) : new IntegerNode(builder.queryTokenId);
    documentTokenId = (builder.documentTokenId == null) ?
        new IntegerNode(2) : new IntegerNode(builder.documentTokenId);
    transformerOutput = (builder.transformerOutput == null) ?
        new StringNode("contextual") : new StringNode(builder.transformerOutput);
    transformerExecutionMode = (builder.transformerExecutionMode == null) ?
        new TransformerExecutionMode(TransformerExecutionMode.sequential) : new TransformerExecutionMode(builder.transformerExecutionMode);
    transformerInterOpThreads = (builder.transformerInterOpThreads == null) ?
        new IntegerNode(1) : new IntegerNode(builder.transformerInterOpThreads);
    transformerIntraOpThreads = (builder.transformerIntraOpThreads == null) ?
        new IntegerNode(-4) : new IntegerNode(builder.transformerIntraOpThreads);
    transformerGpuDevice = (builder.transformerGpuDevice == null) ?
        new IntegerNode(0) : new IntegerNode(builder.transformerGpuDevice);
  }

  /**
   * @return col-bert-embedder.tokenizerPath
   */
  public Path tokenizerPath() {
    return tokenizerPath.value();
  }

  /**
   * @return col-bert-embedder.tokenizerPath ModelReference
   */
  public ModelReference tokenizerPathReference() {
    return tokenizerPath.getModelReference();
  }

  /**
   * @return col-bert-embedder.transformerModel
   */
  public Path transformerModel() {
    return transformerModel.value();
  }

  /**
   * @return col-bert-embedder.transformerModel ModelReference
   */
  public ModelReference transformerModelReference() {
    return transformerModel.getModelReference();
  }

  /**
   * @return col-bert-embedder.maxQueryTokens
   */
  public int maxQueryTokens() {
    return maxQueryTokens.value();
  }

  /**
   * @return col-bert-embedder.maxDocumentTokens
   */
  public int maxDocumentTokens() {
    return maxDocumentTokens.value();
  }

  /**
   * @return col-bert-embedder.transformerMaxTokens
   */
  public int transformerMaxTokens() {
    return transformerMaxTokens.value();
  }

  /**
   * @return col-bert-embedder.transformerInputIds
   */
  public String transformerInputIds() {
    return transformerInputIds.value();
  }

  /**
   * @return col-bert-embedder.transformerAttentionMask
   */
  public String transformerAttentionMask() {
    return transformerAttentionMask.value();
  }

  /**
   * @return col-bert-embedder.transformerStartSequenceToken
   */
  public int transformerStartSequenceToken() {
    return transformerStartSequenceToken.value();
  }

  /**
   * @return col-bert-embedder.transformerEndSequenceToken
   */
  public int transformerEndSequenceToken() {
    return transformerEndSequenceToken.value();
  }

  /**
   * @return col-bert-embedder.transformerMaskToken
   */
  public int transformerMaskToken() {
    return transformerMaskToken.value();
  }

  /**
   * @return col-bert-embedder.transformerPadToken
   */
  public int transformerPadToken() {
    return transformerPadToken.value();
  }

  /**
   * @return col-bert-embedder.queryTokenId
   */
  public int queryTokenId() {
    return queryTokenId.value();
  }

  /**
   * @return col-bert-embedder.documentTokenId
   */
  public int documentTokenId() {
    return documentTokenId.value();
  }

  /**
   * @return col-bert-embedder.transformerOutput
   */
  public String transformerOutput() {
    return transformerOutput.value();
  }

  /**
   * @return col-bert-embedder.transformerExecutionMode
   */
  public TransformerExecutionMode.Enum transformerExecutionMode() {
    return transformerExecutionMode.value();
  }

  /**
   * @return col-bert-embedder.transformerInterOpThreads
   */
  public int transformerInterOpThreads() {
    return transformerInterOpThreads.value();
  }

  /**
   * @return col-bert-embedder.transformerIntraOpThreads
   */
  public int transformerIntraOpThreads() {
    return transformerIntraOpThreads.value();
  }

  /**
   * @return col-bert-embedder.transformerGpuDevice
   */
  public int transformerGpuDevice() {
    return transformerGpuDevice.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ColBertEmbedderConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("col-bert-embedder");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents col-bert-embedder.transformerExecutionMode
   * 
   * Settings for ONNX model evaluation
   */
  public final static class TransformerExecutionMode extends EnumNode<TransformerExecutionMode.Enum> {

    public TransformerExecutionMode(){
      this.value = null;
    }

    public TransformerExecutionMode(Enum enumValue) {
      super(enumValue != null);
      this.value = enumValue;
    }

    public enum Enum {parallel, sequential}
    public final static Enum parallel = Enum.parallel;
    public final static Enum sequential = Enum.sequential;

    @Override
    protected boolean doSetValue(String name) {
      try {
        value = Enum.valueOf(name);
        return true;
      } catch (IllegalArgumentException e) {
      }
      return false;
    }
  }

}
