// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.embedding;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of bert-base-embedder
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class BertBaseEmbedderConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "c5bffd334dab9189e0ab0d01a931a449";
  public final static String CONFIG_DEF_NAME = "bert-base-embedder";
  public final static String CONFIG_DEF_NAMESPACE = "embedding";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=embedding",
    "tokenizerVocab model",
    "transformerModel model",
    "transformerMaxTokens int default=384",
    "poolingStrategy enum { cls, mean } default=mean",
    "transformerInputIds string default=input_ids",
    "transformerAttentionMask string default=attention_mask",
    "transformerTokenTypeIds string default=token_type_ids",
    "transformerStartSequenceToken int default=101",
    "transformerEndSequenceToken int default=102",
    "transformerOutput string default=output_0",
    "onnxExecutionMode enum { parallel, sequential } default=sequential",
    "onnxInterOpThreads int default=1",
    "onnxIntraOpThreads int default=-4",
    "onnxGpuDevice int default=0"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>(List.of(
      "tokenizerVocab",
      "transformerModel"
      ));

    private ModelReference tokenizerVocab = null;
    private ModelReference transformerModel = null;
    private Integer transformerMaxTokens = null;
    private PoolingStrategy.Enum poolingStrategy = null;
    private String transformerInputIds = null;
    private String transformerAttentionMask = null;
    private String transformerTokenTypeIds = null;
    private Integer transformerStartSequenceToken = null;
    private Integer transformerEndSequenceToken = null;
    private String transformerOutput = null;
    private OnnxExecutionMode.Enum onnxExecutionMode = null;
    private Integer onnxInterOpThreads = null;
    private Integer onnxIntraOpThreads = null;
    private Integer onnxGpuDevice = null;

    public Builder() { }

    public Builder(BertBaseEmbedderConfig config) {
      tokenizerVocab(config.tokenizerVocab.getModelReference());
      transformerModel(config.transformerModel.getModelReference());
      transformerMaxTokens(config.transformerMaxTokens());
      poolingStrategy(config.poolingStrategy());
      transformerInputIds(config.transformerInputIds());
      transformerAttentionMask(config.transformerAttentionMask());
      transformerTokenTypeIds(config.transformerTokenTypeIds());
      transformerStartSequenceToken(config.transformerStartSequenceToken());
      transformerEndSequenceToken(config.transformerEndSequenceToken());
      transformerOutput(config.transformerOutput());
      onnxExecutionMode(config.onnxExecutionMode());
      onnxInterOpThreads(config.onnxInterOpThreads());
      onnxIntraOpThreads(config.onnxIntraOpThreads());
      onnxGpuDevice(config.onnxGpuDevice());
    }

    private Builder override(Builder __superior) {
      if (__superior.tokenizerVocab != null)
        tokenizerVocab(__superior.tokenizerVocab);
      if (__superior.transformerModel != null)
        transformerModel(__superior.transformerModel);
      if (__superior.transformerMaxTokens != null)
        transformerMaxTokens(__superior.transformerMaxTokens);
      if (__superior.poolingStrategy != null)
        poolingStrategy(__superior.poolingStrategy);
      if (__superior.transformerInputIds != null)
        transformerInputIds(__superior.transformerInputIds);
      if (__superior.transformerAttentionMask != null)
        transformerAttentionMask(__superior.transformerAttentionMask);
      if (__superior.transformerTokenTypeIds != null)
        transformerTokenTypeIds(__superior.transformerTokenTypeIds);
      if (__superior.transformerStartSequenceToken != null)
        transformerStartSequenceToken(__superior.transformerStartSequenceToken);
      if (__superior.transformerEndSequenceToken != null)
        transformerEndSequenceToken(__superior.transformerEndSequenceToken);
      if (__superior.transformerOutput != null)
        transformerOutput(__superior.transformerOutput);
      if (__superior.onnxExecutionMode != null)
        onnxExecutionMode(__superior.onnxExecutionMode);
      if (__superior.onnxInterOpThreads != null)
        onnxInterOpThreads(__superior.onnxInterOpThreads);
      if (__superior.onnxIntraOpThreads != null)
        onnxIntraOpThreads(__superior.onnxIntraOpThreads);
      if (__superior.onnxGpuDevice != null)
        onnxGpuDevice(__superior.onnxGpuDevice);
      return this;
    }

    public Builder tokenizerVocab(ModelReference __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      tokenizerVocab = __value;
      __uninitialized.remove("tokenizerVocab");
      return this;
    }


    public Builder transformerModel(ModelReference __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      transformerModel = __value;
      __uninitialized.remove("transformerModel");
      return this;
    }


    public Builder transformerMaxTokens(int __value) {
      transformerMaxTokens = __value;
      return this;
    }

    private Builder transformerMaxTokens(String __value) {
      return transformerMaxTokens(Integer.valueOf(__value));
    }

    public Builder poolingStrategy(PoolingStrategy.Enum __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      poolingStrategy = __value;
      return this;
    }

    private Builder poolingStrategy(String __value) {
      return poolingStrategy(PoolingStrategy.Enum.valueOf(__value));
    }

    public Builder transformerInputIds(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      transformerInputIds = __value;
      return this;
    }


    public Builder transformerAttentionMask(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      transformerAttentionMask = __value;
      return this;
    }


    public Builder transformerTokenTypeIds(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      transformerTokenTypeIds = __value;
      return this;
    }


    public Builder transformerStartSequenceToken(int __value) {
      transformerStartSequenceToken = __value;
      return this;
    }

    private Builder transformerStartSequenceToken(String __value) {
      return transformerStartSequenceToken(Integer.valueOf(__value));
    }

    public Builder transformerEndSequenceToken(int __value) {
      transformerEndSequenceToken = __value;
      return this;
    }

    private Builder transformerEndSequenceToken(String __value) {
      return transformerEndSequenceToken(Integer.valueOf(__value));
    }

    public Builder transformerOutput(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      transformerOutput = __value;
      return this;
    }


    public Builder onnxExecutionMode(OnnxExecutionMode.Enum __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      onnxExecutionMode = __value;
      return this;
    }

    private Builder onnxExecutionMode(String __value) {
      return onnxExecutionMode(OnnxExecutionMode.Enum.valueOf(__value));
    }

    public Builder onnxInterOpThreads(int __value) {
      onnxInterOpThreads = __value;
      return this;
    }

    private Builder onnxInterOpThreads(String __value) {
      return onnxInterOpThreads(Integer.valueOf(__value));
    }

    public Builder onnxIntraOpThreads(int __value) {
      onnxIntraOpThreads = __value;
      return this;
    }

    private Builder onnxIntraOpThreads(String __value) {
      return onnxIntraOpThreads(Integer.valueOf(__value));
    }

    public Builder onnxGpuDevice(int __value) {
      onnxGpuDevice = __value;
      return this;
    }

    private Builder onnxGpuDevice(String __value) {
      return onnxGpuDevice(Integer.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public BertBaseEmbedderConfig build() {
      return new BertBaseEmbedderConfig(this);
    }

  }

  // Wordpiece tokenizer
  private final ModelNode tokenizerVocab;
  private final ModelNode transformerModel;
  // Max length of token sequence model can handle
  private final IntegerNode transformerMaxTokens;
  // Pooling strategy
  private final PoolingStrategy poolingStrategy;
  // Input names
  private final StringNode transformerInputIds;
  private final StringNode transformerAttentionMask;
  private final StringNode transformerTokenTypeIds;
  // special token ids
  private final IntegerNode transformerStartSequenceToken;
  private final IntegerNode transformerEndSequenceToken;
  // Output name
  private final StringNode transformerOutput;
  // Settings for ONNX model evaluation
  private final OnnxExecutionMode onnxExecutionMode;
  private final IntegerNode onnxInterOpThreads;
  private final IntegerNode onnxIntraOpThreads;
  // GPU device id, -1 for CPU
  private final IntegerNode onnxGpuDevice;

  public BertBaseEmbedderConfig(Builder builder) {
    this(builder, true);
  }

  private BertBaseEmbedderConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "bert-base-embedder must be initialized: " + builder.__uninitialized);

    tokenizerVocab = (builder.tokenizerVocab == null) ?
        new ModelNode() : new ModelNode(builder.tokenizerVocab);
    transformerModel = (builder.transformerModel == null) ?
        new ModelNode() : new ModelNode(builder.transformerModel);
    transformerMaxTokens = (builder.transformerMaxTokens == null) ?
        new IntegerNode(384) : new IntegerNode(builder.transformerMaxTokens);
    poolingStrategy = (builder.poolingStrategy == null) ?
        new PoolingStrategy(PoolingStrategy.mean) : new PoolingStrategy(builder.poolingStrategy);
    transformerInputIds = (builder.transformerInputIds == null) ?
        new StringNode("input_ids") : new StringNode(builder.transformerInputIds);
    transformerAttentionMask = (builder.transformerAttentionMask == null) ?
        new StringNode("attention_mask") : new StringNode(builder.transformerAttentionMask);
    transformerTokenTypeIds = (builder.transformerTokenTypeIds == null) ?
        new StringNode("token_type_ids") : new StringNode(builder.transformerTokenTypeIds);
    transformerStartSequenceToken = (builder.transformerStartSequenceToken == null) ?
        new IntegerNode(101) : new IntegerNode(builder.transformerStartSequenceToken);
    transformerEndSequenceToken = (builder.transformerEndSequenceToken == null) ?
        new IntegerNode(102) : new IntegerNode(builder.transformerEndSequenceToken);
    transformerOutput = (builder.transformerOutput == null) ?
        new StringNode("output_0") : new StringNode(builder.transformerOutput);
    onnxExecutionMode = (builder.onnxExecutionMode == null) ?
        new OnnxExecutionMode(OnnxExecutionMode.sequential) : new OnnxExecutionMode(builder.onnxExecutionMode);
    onnxInterOpThreads = (builder.onnxInterOpThreads == null) ?
        new IntegerNode(1) : new IntegerNode(builder.onnxInterOpThreads);
    onnxIntraOpThreads = (builder.onnxIntraOpThreads == null) ?
        new IntegerNode(-4) : new IntegerNode(builder.onnxIntraOpThreads);
    onnxGpuDevice = (builder.onnxGpuDevice == null) ?
        new IntegerNode(0) : new IntegerNode(builder.onnxGpuDevice);
  }

  /**
   * @return bert-base-embedder.tokenizerVocab
   */
  public Path tokenizerVocab() {
    return tokenizerVocab.value();
  }

  /**
   * @return bert-base-embedder.tokenizerVocab ModelReference
   */
  public ModelReference tokenizerVocabReference() {
    return tokenizerVocab.getModelReference();
  }

  /**
   * @return bert-base-embedder.transformerModel
   */
  public Path transformerModel() {
    return transformerModel.value();
  }

  /**
   * @return bert-base-embedder.transformerModel ModelReference
   */
  public ModelReference transformerModelReference() {
    return transformerModel.getModelReference();
  }

  /**
   * @return bert-base-embedder.transformerMaxTokens
   */
  public int transformerMaxTokens() {
    return transformerMaxTokens.value();
  }

  /**
   * @return bert-base-embedder.poolingStrategy
   */
  public PoolingStrategy.Enum poolingStrategy() {
    return poolingStrategy.value();
  }

  /**
   * @return bert-base-embedder.transformerInputIds
   */
  public String transformerInputIds() {
    return transformerInputIds.value();
  }

  /**
   * @return bert-base-embedder.transformerAttentionMask
   */
  public String transformerAttentionMask() {
    return transformerAttentionMask.value();
  }

  /**
   * @return bert-base-embedder.transformerTokenTypeIds
   */
  public String transformerTokenTypeIds() {
    return transformerTokenTypeIds.value();
  }

  /**
   * @return bert-base-embedder.transformerStartSequenceToken
   */
  public int transformerStartSequenceToken() {
    return transformerStartSequenceToken.value();
  }

  /**
   * @return bert-base-embedder.transformerEndSequenceToken
   */
  public int transformerEndSequenceToken() {
    return transformerEndSequenceToken.value();
  }

  /**
   * @return bert-base-embedder.transformerOutput
   */
  public String transformerOutput() {
    return transformerOutput.value();
  }

  /**
   * @return bert-base-embedder.onnxExecutionMode
   */
  public OnnxExecutionMode.Enum onnxExecutionMode() {
    return onnxExecutionMode.value();
  }

  /**
   * @return bert-base-embedder.onnxInterOpThreads
   */
  public int onnxInterOpThreads() {
    return onnxInterOpThreads.value();
  }

  /**
   * @return bert-base-embedder.onnxIntraOpThreads
   */
  public int onnxIntraOpThreads() {
    return onnxIntraOpThreads.value();
  }

  /**
   * @return bert-base-embedder.onnxGpuDevice
   */
  public int onnxGpuDevice() {
    return onnxGpuDevice.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(BertBaseEmbedderConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("bert-base-embedder");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents bert-base-embedder.poolingStrategy
   * 
   * Pooling strategy
   */
  public final static class PoolingStrategy extends EnumNode<PoolingStrategy.Enum> {

    public PoolingStrategy(){
      this.value = null;
    }

    public PoolingStrategy(Enum enumValue) {
      super(enumValue != null);
      this.value = enumValue;
    }

    public enum Enum {cls, mean}
    public final static Enum cls = Enum.cls;
    public final static Enum mean = Enum.mean;

    @Override
    protected boolean doSetValue(String name) {
      try {
        value = Enum.valueOf(name);
        return true;
      } catch (IllegalArgumentException e) {
      }
      return false;
    }
  }

  /**
   * This class represents bert-base-embedder.onnxExecutionMode
   * 
   * Settings for ONNX model evaluation
   */
  public final static class OnnxExecutionMode extends EnumNode<OnnxExecutionMode.Enum> {

    public OnnxExecutionMode(){
      this.value = null;
    }

    public OnnxExecutionMode(Enum enumValue) {
      super(enumValue != null);
      this.value = enumValue;
    }

    public enum Enum {parallel, sequential}
    public final static Enum parallel = Enum.parallel;
    public final static Enum sequential = Enum.sequential;

    @Override
    protected boolean doSetValue(String name) {
      try {
        value = Enum.valueOf(name);
        return true;
      } catch (IllegalArgumentException e) {
      }
      return false;
    }
  }

}
