// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.document.restapi;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of document-operation-executor
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class DocumentOperationExecutorConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "3d34b7912db3c1f76ed611270a014a4b";
  public final static String CONFIG_DEF_NAME = "document-operation-executor";
  public final static String CONFIG_DEF_NAMESPACE = "com.yahoo.document.restapi";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "package=com.yahoo.document.restapi",
    "resendDelayMillis int default=10",
    "maxThrottled int default=256",
    "maxThrottledAge double default=3.0",
    "maxThrottledBytes double default=-0.25"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer resendDelayMillis = null;
    private Integer maxThrottled = null;
    private Double maxThrottledAge = null;
    private Double maxThrottledBytes = null;

    public Builder() { }

    public Builder(DocumentOperationExecutorConfig config) {
      resendDelayMillis(config.resendDelayMillis());
      maxThrottled(config.maxThrottled());
      maxThrottledAge(config.maxThrottledAge());
      maxThrottledBytes(config.maxThrottledBytes());
    }

    private Builder override(Builder __superior) {
      if (__superior.resendDelayMillis != null)
        resendDelayMillis(__superior.resendDelayMillis);
      if (__superior.maxThrottled != null)
        maxThrottled(__superior.maxThrottled);
      if (__superior.maxThrottledAge != null)
        maxThrottledAge(__superior.maxThrottledAge);
      if (__superior.maxThrottledBytes != null)
        maxThrottledBytes(__superior.maxThrottledBytes);
      return this;
    }

    public Builder resendDelayMillis(int __value) {
      resendDelayMillis = __value;
      return this;
    }

    private Builder resendDelayMillis(String __value) {
      return resendDelayMillis(Integer.valueOf(__value));
    }

    public Builder maxThrottled(int __value) {
      maxThrottled = __value;
      return this;
    }

    private Builder maxThrottled(String __value) {
      return maxThrottled(Integer.valueOf(__value));
    }

    public Builder maxThrottledAge(double __value) {
      maxThrottledAge = __value;
      return this;
    }

    private Builder maxThrottledAge(String __value) {
      return maxThrottledAge(Double.valueOf(__value));
    }

    public Builder maxThrottledBytes(double __value) {
      maxThrottledBytes = __value;
      return this;
    }

    private Builder maxThrottledBytes(String __value) {
      return maxThrottledBytes(Double.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public DocumentOperationExecutorConfig build() {
      return new DocumentOperationExecutorConfig(this);
    }

  }

  // Duration for which resender thread sleeps after an operation is throttled
  private final IntegerNode resendDelayMillis;
  // Bound on number of document operations to keep in queue — further operations are rejected.
  // Set to 0 to disable queue and dispatch directly to documentapi instead.
  private final IntegerNode maxThrottled;
  // Max age in seconds for operations in queue.
  private final DoubleNode maxThrottledAge;
  // Maximum total bytes of document operations to keep in queue.
  // - If 0>, the the number of bytes as an absolute value.
  // - If 0, allow infinite number of bytes (in other words disables the size restriction).
  // - If <0, the number of bytes as a ratio of the JVM's maximum heap size (e.g. -0.5 for 50% of max heap).
  private final DoubleNode maxThrottledBytes;

  public DocumentOperationExecutorConfig(Builder builder) {
    this(builder, true);
  }

  private DocumentOperationExecutorConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "document-operation-executor must be initialized: " + builder.__uninitialized);

    resendDelayMillis = (builder.resendDelayMillis == null) ?
        new IntegerNode(10) : new IntegerNode(builder.resendDelayMillis);
    maxThrottled = (builder.maxThrottled == null) ?
        new IntegerNode(256) : new IntegerNode(builder.maxThrottled);
    maxThrottledAge = (builder.maxThrottledAge == null) ?
        new DoubleNode(3.0D) : new DoubleNode(builder.maxThrottledAge);
    maxThrottledBytes = (builder.maxThrottledBytes == null) ?
        new DoubleNode(-0.25D) : new DoubleNode(builder.maxThrottledBytes);
  }

  /**
   * @return document-operation-executor.resendDelayMillis
   */
  public int resendDelayMillis() {
    return resendDelayMillis.value();
  }

  /**
   * @return document-operation-executor.maxThrottled
   */
  public int maxThrottled() {
    return maxThrottled.value();
  }

  /**
   * @return document-operation-executor.maxThrottledAge
   */
  public double maxThrottledAge() {
    return maxThrottledAge.value();
  }

  /**
   * @return document-operation-executor.maxThrottledBytes
   */
  public double maxThrottledBytes() {
    return maxThrottledBytes.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(DocumentOperationExecutorConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("document-operation-executor");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
