// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.cloud.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of zookeeper-server
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class ZookeeperServerConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "df50f0640cedb06f94499efacb35784a";
  public final static String CONFIG_DEF_NAME = "zookeeper-server";
  public final static String CONFIG_DEF_NAMESPACE = "cloud.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=cloud.config",
    "zooKeeperConfigFile string default=\"var/zookeeper/conf/zookeeper.cfg\"",
    "tickTime int default=6000",
    "initLimit int default=20",
    "syncLimit int default=15",
    "maxClientConnections int default=0",
    "dataDir string default=\"var/zookeeper\"",
    "clientPort int default=2181",
    "snapshotCount int default=50000",
    "autopurge.purgeInterval int default=1",
    "autopurge.snapRetainCount int default=15",
    "myidFile string default=\"var/zookeeper/myid\"",
    "juteMaxBuffer int default=52428800",
    "myid int restart",
    "server[].id int",
    "server[].hostname string",
    "server[].clientPort int default=2181",
    "server[].quorumPort int default=2182",
    "server[].electionPort int default=2183",
    "server[].joining bool default=false",
    "server[].retired bool default=false",
    "trustEmptySnapshot bool default=true",
    "dynamicReconfiguration bool default=false",
    "snapshotMethod string default=\"\"",
    "vespaTlsConfigFile string default=\"\"",
    "leaderCloseSocketAsync bool default=false",
    "learnerAsyncSending bool default=false",
    "reconfigureEnsemble bool default=true",
    "preAllocSizeKb long default=65536"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>(List.of(
      "myid"
      ));

    private String zooKeeperConfigFile = null;
    private Integer tickTime = null;
    private Integer initLimit = null;
    private Integer syncLimit = null;
    private Integer maxClientConnections = null;
    private String dataDir = null;
    private Integer clientPort = null;
    private Integer snapshotCount = null;
    public Autopurge.Builder autopurge = new Autopurge.Builder();
    private String myidFile = null;
    private Integer juteMaxBuffer = null;
    private Integer myid = null;
    public List<Server.Builder> server = new ArrayList<>();
    private Boolean trustEmptySnapshot = null;
    private Boolean dynamicReconfiguration = null;
    private String snapshotMethod = null;
    private String vespaTlsConfigFile = null;
    private Boolean leaderCloseSocketAsync = null;
    private Boolean learnerAsyncSending = null;
    private Boolean reconfigureEnsemble = null;
    private Long preAllocSizeKb = null;

    public Builder() { }

    public Builder(ZookeeperServerConfig config) {
      zooKeeperConfigFile(config.zooKeeperConfigFile());
      tickTime(config.tickTime());
      initLimit(config.initLimit());
      syncLimit(config.syncLimit());
      maxClientConnections(config.maxClientConnections());
      dataDir(config.dataDir());
      clientPort(config.clientPort());
      snapshotCount(config.snapshotCount());
      autopurge(new Autopurge.Builder(config.autopurge()));
      myidFile(config.myidFile());
      juteMaxBuffer(config.juteMaxBuffer());
      myid(config.myid());
      for (Server s : config.server()) {
        server(new Server.Builder(s));
      }
      trustEmptySnapshot(config.trustEmptySnapshot());
      dynamicReconfiguration(config.dynamicReconfiguration());
      snapshotMethod(config.snapshotMethod());
      vespaTlsConfigFile(config.vespaTlsConfigFile());
      leaderCloseSocketAsync(config.leaderCloseSocketAsync());
      learnerAsyncSending(config.learnerAsyncSending());
      reconfigureEnsemble(config.reconfigureEnsemble());
      preAllocSizeKb(config.preAllocSizeKb());
    }

    private Builder override(Builder __superior) {
      if (__superior.zooKeeperConfigFile != null)
        zooKeeperConfigFile(__superior.zooKeeperConfigFile);
      if (__superior.tickTime != null)
        tickTime(__superior.tickTime);
      if (__superior.initLimit != null)
        initLimit(__superior.initLimit);
      if (__superior.syncLimit != null)
        syncLimit(__superior.syncLimit);
      if (__superior.maxClientConnections != null)
        maxClientConnections(__superior.maxClientConnections);
      if (__superior.dataDir != null)
        dataDir(__superior.dataDir);
      if (__superior.clientPort != null)
        clientPort(__superior.clientPort);
      if (__superior.snapshotCount != null)
        snapshotCount(__superior.snapshotCount);
      autopurge(autopurge.override(__superior.autopurge));
      if (__superior.myidFile != null)
        myidFile(__superior.myidFile);
      if (__superior.juteMaxBuffer != null)
        juteMaxBuffer(__superior.juteMaxBuffer);
      if (__superior.myid != null)
        myid(__superior.myid);
      if (!__superior.server.isEmpty())
        server.addAll(__superior.server);
      if (__superior.trustEmptySnapshot != null)
        trustEmptySnapshot(__superior.trustEmptySnapshot);
      if (__superior.dynamicReconfiguration != null)
        dynamicReconfiguration(__superior.dynamicReconfiguration);
      if (__superior.snapshotMethod != null)
        snapshotMethod(__superior.snapshotMethod);
      if (__superior.vespaTlsConfigFile != null)
        vespaTlsConfigFile(__superior.vespaTlsConfigFile);
      if (__superior.leaderCloseSocketAsync != null)
        leaderCloseSocketAsync(__superior.leaderCloseSocketAsync);
      if (__superior.learnerAsyncSending != null)
        learnerAsyncSending(__superior.learnerAsyncSending);
      if (__superior.reconfigureEnsemble != null)
        reconfigureEnsemble(__superior.reconfigureEnsemble);
      if (__superior.preAllocSizeKb != null)
        preAllocSizeKb(__superior.preAllocSizeKb);
      return this;
    }

    public Builder zooKeeperConfigFile(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      zooKeeperConfigFile = __value;
      return this;
    }


    public Builder tickTime(int __value) {
      tickTime = __value;
      return this;
    }

    private Builder tickTime(String __value) {
      return tickTime(Integer.valueOf(__value));
    }

    public Builder initLimit(int __value) {
      initLimit = __value;
      return this;
    }

    private Builder initLimit(String __value) {
      return initLimit(Integer.valueOf(__value));
    }

    public Builder syncLimit(int __value) {
      syncLimit = __value;
      return this;
    }

    private Builder syncLimit(String __value) {
      return syncLimit(Integer.valueOf(__value));
    }

    public Builder maxClientConnections(int __value) {
      maxClientConnections = __value;
      return this;
    }

    private Builder maxClientConnections(String __value) {
      return maxClientConnections(Integer.valueOf(__value));
    }

    public Builder dataDir(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      dataDir = __value;
      return this;
    }


    public Builder clientPort(int __value) {
      clientPort = __value;
      return this;
    }

    private Builder clientPort(String __value) {
      return clientPort(Integer.valueOf(__value));
    }

    public Builder snapshotCount(int __value) {
      snapshotCount = __value;
      return this;
    }

    private Builder snapshotCount(String __value) {
      return snapshotCount(Integer.valueOf(__value));
    }

    public Builder autopurge(Autopurge.Builder __builder) {
      autopurge = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder autopurge(java.util.function.Consumer<Autopurge.Builder> __func) {
      Autopurge.Builder __inner = new Autopurge.Builder();
      __func.accept(__inner);
      autopurge = __inner;
      return this;
    }

    public Builder myidFile(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      myidFile = __value;
      return this;
    }


    public Builder juteMaxBuffer(int __value) {
      juteMaxBuffer = __value;
      return this;
    }

    private Builder juteMaxBuffer(String __value) {
      return juteMaxBuffer(Integer.valueOf(__value));
    }

    public Builder myid(int __value) {
      myid = __value;
      __uninitialized.remove("myid");
      return this;
    }

    private Builder myid(String __value) {
      return myid(Integer.valueOf(__value));
    }

    /**
     * Add the given builder to this builder's list of Server builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder server(Server.Builder __builder) {
      server.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder server(java.util.function.Consumer<Server.Builder> __func) {
      Server.Builder __inner = new Server.Builder();
      __func.accept(__inner);
      server.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Server builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder server(List<Server.Builder> __builders) {
      server = __builders;
      return this;
    }

    public Builder trustEmptySnapshot(boolean __value) {
      trustEmptySnapshot = __value;
      return this;
    }

    private Builder trustEmptySnapshot(String __value) {
      return trustEmptySnapshot(Boolean.valueOf(__value));
    }

    public Builder dynamicReconfiguration(boolean __value) {
      dynamicReconfiguration = __value;
      return this;
    }

    private Builder dynamicReconfiguration(String __value) {
      return dynamicReconfiguration(Boolean.valueOf(__value));
    }

    public Builder snapshotMethod(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      snapshotMethod = __value;
      return this;
    }


    public Builder vespaTlsConfigFile(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      vespaTlsConfigFile = __value;
      return this;
    }


    public Builder leaderCloseSocketAsync(boolean __value) {
      leaderCloseSocketAsync = __value;
      return this;
    }

    private Builder leaderCloseSocketAsync(String __value) {
      return leaderCloseSocketAsync(Boolean.valueOf(__value));
    }

    public Builder learnerAsyncSending(boolean __value) {
      learnerAsyncSending = __value;
      return this;
    }

    private Builder learnerAsyncSending(String __value) {
      return learnerAsyncSending(Boolean.valueOf(__value));
    }

    public Builder reconfigureEnsemble(boolean __value) {
      reconfigureEnsemble = __value;
      return this;
    }

    private Builder reconfigureEnsemble(String __value) {
      return reconfigureEnsemble(Boolean.valueOf(__value));
    }

    public Builder preAllocSizeKb(long __value) {
      preAllocSizeKb = __value;
      return this;
    }

    private Builder preAllocSizeKb(String __value) {
      return preAllocSizeKb(Long.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ZookeeperServerConfig build() {
      return new ZookeeperServerConfig(this);
    }

  }

  // Vespa home is prepended if the file is relative
  private final StringNode zooKeeperConfigFile;
  // For more info about the values below, see ZooKeeper documentation
  // tick time in milliseconds, min and max session timeout are 2 and 20 times this value
  private final IntegerNode tickTime;
  private final IntegerNode initLimit;
  private final IntegerNode syncLimit;
  private final IntegerNode maxClientConnections;
  // Vespa home is prepended if the file is relative
  private final StringNode dataDir;
  private final IntegerNode clientPort;
  private final IntegerNode snapshotCount;
  private final Autopurge autopurge;
  // Vespa home is prepended if the file is relative
  private final StringNode myidFile;
  // Jute maxbuffer. Used by zookeeper to determine max buffer when serializing/deserializing
  // Note: If decreasing it one must be sure that no node has stored more bytes than this
  // See also corresponding field in curator.def
  private final IntegerNode juteMaxBuffer;
  private final IntegerNode myid;
  private final InnerNodeVector<Server> server;
  // Needed when upgrading from ZooKeeper 3.4 to 3.5, see https://issues.apache.org/jira/browse/ZOOKEEPER-3056,
  // and in general where there is a zookeeper ensemble running that has had few transactions.
  // TODO: Consider setting this to false by default (and override where appropriate)
  private final BooleanNode trustEmptySnapshot;
  // Whether to enable support for dynamic reconfiguration of the ZooKeeper ensemble.
  private final BooleanNode dynamicReconfiguration;
  // Set the snapshot compression method: "gz" for GZIP or "snappy" for Snappy. Any other value disables compression.
  private final StringNode snapshotMethod;
  // Uses default Vespa mTLS config if empty string
  private final StringNode vespaTlsConfigFile;
  private final BooleanNode leaderCloseSocketAsync;
  private final BooleanNode learnerAsyncSending;
  // Whether the ZooKeeper ensemble should be reconfigured automatically if servers change. This only has an effect if
  // dynamicReconfiguration=true.
  private final BooleanNode reconfigureEnsemble;
  // To avoid seeks ZooKeeper allocates space in the transaction log file in blocks of preAllocSize kilobytes. The default block size is 64M
  // Can/should be reduced for tests
  private final LongNode preAllocSizeKb;

  public ZookeeperServerConfig(Builder builder) {
    this(builder, true);
  }

  private ZookeeperServerConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "zookeeper-server must be initialized: " + builder.__uninitialized);

    zooKeeperConfigFile = (builder.zooKeeperConfigFile == null) ?
        new StringNode("var/zookeeper/conf/zookeeper.cfg") : new StringNode(builder.zooKeeperConfigFile);
    tickTime = (builder.tickTime == null) ?
        new IntegerNode(6000) : new IntegerNode(builder.tickTime);
    initLimit = (builder.initLimit == null) ?
        new IntegerNode(20) : new IntegerNode(builder.initLimit);
    syncLimit = (builder.syncLimit == null) ?
        new IntegerNode(15) : new IntegerNode(builder.syncLimit);
    maxClientConnections = (builder.maxClientConnections == null) ?
        new IntegerNode(0) : new IntegerNode(builder.maxClientConnections);
    dataDir = (builder.dataDir == null) ?
        new StringNode("var/zookeeper") : new StringNode(builder.dataDir);
    clientPort = (builder.clientPort == null) ?
        new IntegerNode(2181) : new IntegerNode(builder.clientPort);
    snapshotCount = (builder.snapshotCount == null) ?
        new IntegerNode(50000) : new IntegerNode(builder.snapshotCount);
    autopurge = new Autopurge(builder.autopurge, throwIfUninitialized);
    myidFile = (builder.myidFile == null) ?
        new StringNode("var/zookeeper/myid") : new StringNode(builder.myidFile);
    juteMaxBuffer = (builder.juteMaxBuffer == null) ?
        new IntegerNode(52428800) : new IntegerNode(builder.juteMaxBuffer);
    myid = (builder.myid == null) ?
        new IntegerNode() : new IntegerNode(builder.myid);
    server = Server.createVector(builder.server);
    trustEmptySnapshot = (builder.trustEmptySnapshot == null) ?
        new BooleanNode(true) : new BooleanNode(builder.trustEmptySnapshot);
    dynamicReconfiguration = (builder.dynamicReconfiguration == null) ?
        new BooleanNode(false) : new BooleanNode(builder.dynamicReconfiguration);
    snapshotMethod = (builder.snapshotMethod == null) ?
        new StringNode("") : new StringNode(builder.snapshotMethod);
    vespaTlsConfigFile = (builder.vespaTlsConfigFile == null) ?
        new StringNode("") : new StringNode(builder.vespaTlsConfigFile);
    leaderCloseSocketAsync = (builder.leaderCloseSocketAsync == null) ?
        new BooleanNode(false) : new BooleanNode(builder.leaderCloseSocketAsync);
    learnerAsyncSending = (builder.learnerAsyncSending == null) ?
        new BooleanNode(false) : new BooleanNode(builder.learnerAsyncSending);
    reconfigureEnsemble = (builder.reconfigureEnsemble == null) ?
        new BooleanNode(true) : new BooleanNode(builder.reconfigureEnsemble);
    preAllocSizeKb = (builder.preAllocSizeKb == null) ?
        new LongNode(65536L) : new LongNode(builder.preAllocSizeKb);
  }

  /**
   * @return zookeeper-server.zooKeeperConfigFile
   */
  public String zooKeeperConfigFile() {
    return zooKeeperConfigFile.value();
  }

  /**
   * @return zookeeper-server.tickTime
   */
  public int tickTime() {
    return tickTime.value();
  }

  /**
   * @return zookeeper-server.initLimit
   */
  public int initLimit() {
    return initLimit.value();
  }

  /**
   * @return zookeeper-server.syncLimit
   */
  public int syncLimit() {
    return syncLimit.value();
  }

  /**
   * @return zookeeper-server.maxClientConnections
   */
  public int maxClientConnections() {
    return maxClientConnections.value();
  }

  /**
   * @return zookeeper-server.dataDir
   */
  public String dataDir() {
    return dataDir.value();
  }

  /**
   * @return zookeeper-server.clientPort
   */
  public int clientPort() {
    return clientPort.value();
  }

  /**
   * @return zookeeper-server.snapshotCount
   */
  public int snapshotCount() {
    return snapshotCount.value();
  }

  /**
   * @return zookeeper-server.autopurge
   */
  public Autopurge autopurge() {
    return autopurge;
  }

  /**
   * @return zookeeper-server.myidFile
   */
  public String myidFile() {
    return myidFile.value();
  }

  /**
   * @return zookeeper-server.juteMaxBuffer
   */
  public int juteMaxBuffer() {
    return juteMaxBuffer.value();
  }

  /**
   * @return zookeeper-server.myid
   */
  public int myid() {
    return myid.value();
  }

  /**
   * @return zookeeper-server.server[]
   */
  public List<Server> server() {
    return server;
  }

  /**
   * @param i the index of the value to return
   * @return zookeeper-server.server[]
   */
  public Server server(int i) {
    return server.get(i);
  }

  /**
   * @return zookeeper-server.trustEmptySnapshot
   */
  public boolean trustEmptySnapshot() {
    return trustEmptySnapshot.value();
  }

  /**
   * @return zookeeper-server.dynamicReconfiguration
   */
  public boolean dynamicReconfiguration() {
    return dynamicReconfiguration.value();
  }

  /**
   * @return zookeeper-server.snapshotMethod
   */
  public String snapshotMethod() {
    return snapshotMethod.value();
  }

  /**
   * @return zookeeper-server.vespaTlsConfigFile
   */
  public String vespaTlsConfigFile() {
    return vespaTlsConfigFile.value();
  }

  /**
   * @return zookeeper-server.leaderCloseSocketAsync
   */
  public boolean leaderCloseSocketAsync() {
    return leaderCloseSocketAsync.value();
  }

  /**
   * @return zookeeper-server.learnerAsyncSending
   */
  public boolean learnerAsyncSending() {
    return learnerAsyncSending.value();
  }

  /**
   * @return zookeeper-server.reconfigureEnsemble
   */
  public boolean reconfigureEnsemble() {
    return reconfigureEnsemble.value();
  }

  /**
   * @return zookeeper-server.preAllocSizeKb
   */
  public long preAllocSizeKb() {
    return preAllocSizeKb.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ZookeeperServerConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("zookeeper-server");
      changes.compare(this.myid, newConfig.myid, "myid", "");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return true;
  }

  /**
   * This class represents zookeeper-server.autopurge
   */
  public final static class Autopurge extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Integer purgeInterval = null;
      private Integer snapRetainCount = null;

      public Builder() { }

      public Builder(Autopurge config) {
        purgeInterval(config.purgeInterval());
        snapRetainCount(config.snapRetainCount());
      }

      private Builder override(Builder __superior) {
        if (__superior.purgeInterval != null)
          purgeInterval(__superior.purgeInterval);
        if (__superior.snapRetainCount != null)
          snapRetainCount(__superior.snapRetainCount);
        return this;
      }

      public Builder purgeInterval(int __value) {
        purgeInterval = __value;
        return this;
      }

      private Builder purgeInterval(String __value) {
        return purgeInterval(Integer.valueOf(__value));
      }

      public Builder snapRetainCount(int __value) {
        snapRetainCount = __value;
        return this;
      }

      private Builder snapRetainCount(String __value) {
        return snapRetainCount(Integer.valueOf(__value));
      }

      public Autopurge build() {
        return new Autopurge(this);
      }

    }

    // Purge interval in hours
    private final IntegerNode purgeInterval;
    private final IntegerNode snapRetainCount;

    public Autopurge(Builder builder) {
      this(builder, true);
    }

    private Autopurge(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "zookeeper-server.autopurge must be initialized: " + builder.__uninitialized);

      purgeInterval = (builder.purgeInterval == null) ?
          new IntegerNode(1) : new IntegerNode(builder.purgeInterval);
      snapRetainCount = (builder.snapRetainCount == null) ?
          new IntegerNode(15) : new IntegerNode(builder.snapRetainCount);
    }

    /**
     * @return zookeeper-server.autopurge.purgeInterval
     */
    public int purgeInterval() {
      return purgeInterval.value();
    }

    /**
     * @return zookeeper-server.autopurge.snapRetainCount
     */
    public int snapRetainCount() {
      return snapRetainCount.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Autopurge newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("autopurge");
      return changes;
    }
  }

  /**
   * This class represents zookeeper-server.server[]
   */
  public final static class Server extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "id",
        "hostname"
        ));

      private Integer id = null;
      private String hostname = null;
      private Integer clientPort = null;
      private Integer quorumPort = null;
      private Integer electionPort = null;
      private Boolean joining = null;
      private Boolean retired = null;

      public Builder() { }

      public Builder(Server config) {
        id(config.id());
        hostname(config.hostname());
        clientPort(config.clientPort());
        quorumPort(config.quorumPort());
        electionPort(config.electionPort());
        joining(config.joining());
        retired(config.retired());
      }

      private Builder override(Builder __superior) {
        if (__superior.id != null)
          id(__superior.id);
        if (__superior.hostname != null)
          hostname(__superior.hostname);
        if (__superior.clientPort != null)
          clientPort(__superior.clientPort);
        if (__superior.quorumPort != null)
          quorumPort(__superior.quorumPort);
        if (__superior.electionPort != null)
          electionPort(__superior.electionPort);
        if (__superior.joining != null)
          joining(__superior.joining);
        if (__superior.retired != null)
          retired(__superior.retired);
        return this;
      }

      public Builder id(int __value) {
        id = __value;
        __uninitialized.remove("id");
        return this;
      }

      private Builder id(String __value) {
        return id(Integer.valueOf(__value));
      }

      public Builder hostname(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        hostname = __value;
        __uninitialized.remove("hostname");
        return this;
      }


      public Builder clientPort(int __value) {
        clientPort = __value;
        return this;
      }

      private Builder clientPort(String __value) {
        return clientPort(Integer.valueOf(__value));
      }

      public Builder quorumPort(int __value) {
        quorumPort = __value;
        return this;
      }

      private Builder quorumPort(String __value) {
        return quorumPort(Integer.valueOf(__value));
      }

      public Builder electionPort(int __value) {
        electionPort = __value;
        return this;
      }

      private Builder electionPort(String __value) {
        return electionPort(Integer.valueOf(__value));
      }

      public Builder joining(boolean __value) {
        joining = __value;
        return this;
      }

      private Builder joining(String __value) {
        return joining(Boolean.valueOf(__value));
      }

      public Builder retired(boolean __value) {
        retired = __value;
        return this;
      }

      private Builder retired(String __value) {
        return retired(Boolean.valueOf(__value));
      }

      public Server build() {
        return new Server(this);
      }

    }

    private final IntegerNode id;
    private final StringNode hostname;
    private final IntegerNode clientPort;
    private final IntegerNode quorumPort;
    private final IntegerNode electionPort;
    // Whether this server is joining an existing cluster
    private final BooleanNode joining;
    // Whether this server is retired, and about to be removed
    private final BooleanNode retired;

    public Server(Builder builder) {
      this(builder, true);
    }

    private Server(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "zookeeper-server.server[] must be initialized: " + builder.__uninitialized);

      id = (builder.id == null) ?
          new IntegerNode() : new IntegerNode(builder.id);
      hostname = (builder.hostname == null) ?
          new StringNode() : new StringNode(builder.hostname);
      clientPort = (builder.clientPort == null) ?
          new IntegerNode(2181) : new IntegerNode(builder.clientPort);
      quorumPort = (builder.quorumPort == null) ?
          new IntegerNode(2182) : new IntegerNode(builder.quorumPort);
      electionPort = (builder.electionPort == null) ?
          new IntegerNode(2183) : new IntegerNode(builder.electionPort);
      joining = (builder.joining == null) ?
          new BooleanNode(false) : new BooleanNode(builder.joining);
      retired = (builder.retired == null) ?
          new BooleanNode(false) : new BooleanNode(builder.retired);
    }

    /**
     * @return zookeeper-server.server[].id
     */
    public int id() {
      return id.value();
    }

    /**
     * @return zookeeper-server.server[].hostname
     */
    public String hostname() {
      return hostname.value();
    }

    /**
     * @return zookeeper-server.server[].clientPort
     */
    public int clientPort() {
      return clientPort.value();
    }

    /**
     * @return zookeeper-server.server[].quorumPort
     */
    public int quorumPort() {
      return quorumPort.value();
    }

    /**
     * @return zookeeper-server.server[].electionPort
     */
    public int electionPort() {
      return electionPort.value();
    }

    /**
     * @return zookeeper-server.server[].joining
     */
    public boolean joining() {
      return joining.value();
    }

    /**
     * @return zookeeper-server.server[].retired
     */
    public boolean retired() {
      return retired.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Server newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("server");
      return changes;
    }

    private static InnerNodeVector<Server> createVector(List<Builder> builders) {
        List<Server> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Server(b));
        }
        return new InnerNodeVector<Server>(elems);
    }
  }

}
