// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.cloud.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of slobroks
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class SlobroksConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "4d375b91d30ffdbbe45de52ee5aa9fe0";
  public final static String CONFIG_DEF_NAME = "slobroks";
  public final static String CONFIG_DEF_NAMESPACE = "cloud.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=cloud.config",
    "slobrok[].connectionspec string restart"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Slobrok.Builder> slobrok = new ArrayList<>();

    public Builder() { }

    public Builder(SlobroksConfig config) {
      for (Slobrok s : config.slobrok()) {
        slobrok(new Slobrok.Builder(s));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.slobrok.isEmpty())
        slobrok.addAll(__superior.slobrok);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Slobrok builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder slobrok(Slobrok.Builder __builder) {
      slobrok.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder slobrok(java.util.function.Consumer<Slobrok.Builder> __func) {
      Slobrok.Builder __inner = new Slobrok.Builder();
      __func.accept(__inner);
      slobrok.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Slobrok builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder slobrok(List<Slobrok.Builder> __builders) {
      slobrok = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public SlobroksConfig build() {
      return new SlobroksConfig(this);
    }

  }

  private final InnerNodeVector<Slobrok> slobrok;

  public SlobroksConfig(Builder builder) {
    this(builder, true);
  }

  private SlobroksConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "slobroks must be initialized: " + builder.__uninitialized);

    slobrok = Slobrok.createVector(builder.slobrok);
  }

  /**
   * @return slobroks.slobrok[]
   */
  public List<Slobrok> slobrok() {
    return slobrok;
  }

  /**
   * @param i the index of the value to return
   * @return slobroks.slobrok[]
   */
  public Slobrok slobrok(int i) {
    return slobrok.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(SlobroksConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("slobroks");
      changes.compareArray(this.slobrok, newConfig.slobrok, "slobrok", "",
                        (a,b) -> ((Slobrok)a).getChangesRequiringRestart((Slobrok)b));
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return true;
  }

  /**
   * This class represents slobroks.slobrok[]
   */
  public final static class Slobrok extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "connectionspec"
        ));

      private String connectionspec = null;

      public Builder() { }

      public Builder(Slobrok config) {
        connectionspec(config.connectionspec());
      }

      private Builder override(Builder __superior) {
        if (__superior.connectionspec != null)
          connectionspec(__superior.connectionspec);
        return this;
      }

      public Builder connectionspec(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        connectionspec = __value;
        __uninitialized.remove("connectionspec");
        return this;
      }


      public Slobrok build() {
        return new Slobrok(this);
      }

    }

    // Changes to this config requires restart
    // The connectionspec for a slobrok is used for connecting to it using
    // the FNET Remote Tools framework. It is normally on the form
    // tcp/hostname:portnumber where hostname is the same name returned by
    // gethostname() on the machine. This string is also used by the
    // actual slobrok to figure out which port it should listen to.
    private final StringNode connectionspec;

    public Slobrok(Builder builder) {
      this(builder, true);
    }

    private Slobrok(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "slobroks.slobrok[] must be initialized: " + builder.__uninitialized);

      connectionspec = (builder.connectionspec == null) ?
          new StringNode() : new StringNode(builder.connectionspec);
    }

    /**
     * @return slobroks.slobrok[].connectionspec
     */
    public String connectionspec() {
      return connectionspec.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Slobrok newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("slobrok");
        changes.compare(this.connectionspec, newConfig.connectionspec, "connectionspec", "Changes to this config requires restart\n\nThe connectionspec for a slobrok is used for connecting to it using\nthe FNET Remote Tools framework. It is normally on the form\ntcp/hostname:portnumber where hostname is the same name returned by\ngethostname() on the machine. This string is also used by the\nactual slobrok to figure out which port it should listen to.\n");
      return changes;
    }

    private static InnerNodeVector<Slobrok> createVector(List<Builder> builders) {
        List<Slobrok> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Slobrok(b));
        }
        return new InnerNodeVector<Slobrok>(elems);
    }
  }

}
