// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.cloud.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of sentinel
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class SentinelConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "aa9115ebf63cfc6721f75ada21d7cdfa";
  public final static String CONFIG_DEF_NAME = "sentinel";
  public final static String CONFIG_DEF_NAMESPACE = "cloud.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=cloud.config",
    "port.telnet int default=19098",
    "port.rpc int default=19097",
    "application.tenant string default=\"default\"",
    "application.name string default=\"default\"",
    "application.environment string default=\"default\"",
    "application.instance string default=\"default\"",
    "application.region string default=\"default\"",
    "connectivity.minOkPercent int default=50",
    "connectivity.maxBadCount int default=1",
    "service[].command string",
    "service[].environ[].varname string",
    "service[].environ[].varvalue string",
    "service[].logctl[].componentSpec string",
    "service[].logctl[].levelsModSpec string",
    "service[].preShutdownCommand string default=\"\"",
    "service[].name string",
    "service[].autostart bool default=false",
    "service[].autorestart bool default=true",
    "service[].id reference",
    "service[].affinity.cpuSocket int default=-1"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public Port.Builder port = new Port.Builder();
    public Application.Builder application = new Application.Builder();
    public Connectivity.Builder connectivity = new Connectivity.Builder();
    public List<Service.Builder> service = new ArrayList<>();

    public Builder() { }

    public Builder(SentinelConfig config) {
      port(new Port.Builder(config.port()));
      application(new Application.Builder(config.application()));
      connectivity(new Connectivity.Builder(config.connectivity()));
      for (Service s : config.service()) {
        service(new Service.Builder(s));
      }
    }

    private Builder override(Builder __superior) {
      port(port.override(__superior.port));
      application(application.override(__superior.application));
      connectivity(connectivity.override(__superior.connectivity));
      if (!__superior.service.isEmpty())
        service.addAll(__superior.service);
      return this;
    }

    public Builder port(Port.Builder __builder) {
      port = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder port(java.util.function.Consumer<Port.Builder> __func) {
      Port.Builder __inner = new Port.Builder();
      __func.accept(__inner);
      port = __inner;
      return this;
    }

    public Builder application(Application.Builder __builder) {
      application = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder application(java.util.function.Consumer<Application.Builder> __func) {
      Application.Builder __inner = new Application.Builder();
      __func.accept(__inner);
      application = __inner;
      return this;
    }

    public Builder connectivity(Connectivity.Builder __builder) {
      connectivity = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder connectivity(java.util.function.Consumer<Connectivity.Builder> __func) {
      Connectivity.Builder __inner = new Connectivity.Builder();
      __func.accept(__inner);
      connectivity = __inner;
      return this;
    }

    /**
     * Add the given builder to this builder's list of Service builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder service(Service.Builder __builder) {
      service.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder service(java.util.function.Consumer<Service.Builder> __func) {
      Service.Builder __inner = new Service.Builder();
      __func.accept(__inner);
      service.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Service builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder service(List<Service.Builder> __builders) {
      service = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public SentinelConfig build() {
      return new SentinelConfig(this);
    }

  }

  private final Port port;
  private final Application application;
  private final Connectivity connectivity;
  private final InnerNodeVector<Service> service;

  public SentinelConfig(Builder builder) {
    this(builder, true);
  }

  private SentinelConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "sentinel must be initialized: " + builder.__uninitialized);

    port = new Port(builder.port, throwIfUninitialized);
    application = new Application(builder.application, throwIfUninitialized);
    connectivity = new Connectivity(builder.connectivity, throwIfUninitialized);
    service = Service.createVector(builder.service);
  }

  /**
   * @return sentinel.port
   */
  public Port port() {
    return port;
  }

  /**
   * @return sentinel.application
   */
  public Application application() {
    return application;
  }

  /**
   * @return sentinel.connectivity
   */
  public Connectivity connectivity() {
    return connectivity;
  }

  /**
   * @return sentinel.service[]
   */
  public List<Service> service() {
    return service;
  }

  /**
   * @param i the index of the value to return
   * @return sentinel.service[]
   */
  public Service service(int i) {
    return service.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(SentinelConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("sentinel");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents sentinel.port
   */
  public final static class Port extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Integer telnet = null;
      private Integer rpc = null;

      public Builder() { }

      public Builder(Port config) {
        telnet(config.telnet());
        rpc(config.rpc());
      }

      private Builder override(Builder __superior) {
        if (__superior.telnet != null)
          telnet(__superior.telnet);
        if (__superior.rpc != null)
          rpc(__superior.rpc);
        return this;
      }

      public Builder telnet(int __value) {
        telnet = __value;
        return this;
      }

      private Builder telnet(String __value) {
        return telnet(Integer.valueOf(__value));
      }

      public Builder rpc(int __value) {
        rpc = __value;
        return this;
      }

      private Builder rpc(String __value) {
        return rpc(Integer.valueOf(__value));
      }

      public Port build() {
        return new Port(this);
      }

    }

    // The port where sentinel should run its telnet interface
    private final IntegerNode telnet;
    // The port where sentinel should run its RPC interface
    private final IntegerNode rpc;

    public Port(Builder builder) {
      this(builder, true);
    }

    private Port(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "sentinel.port must be initialized: " + builder.__uninitialized);

      telnet = (builder.telnet == null) ?
          new IntegerNode(19098) : new IntegerNode(builder.telnet);
      rpc = (builder.rpc == null) ?
          new IntegerNode(19097) : new IntegerNode(builder.rpc);
    }

    /**
     * @return sentinel.port.telnet
     */
    public int telnet() {
      return telnet.value();
    }

    /**
     * @return sentinel.port.rpc
     */
    public int rpc() {
      return rpc.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Port newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("port");
      return changes;
    }
  }

  /**
   * This class represents sentinel.application
   */
  public final static class Application extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private String tenant = null;
      private String name = null;
      private String environment = null;
      private String instance = null;
      private String region = null;

      public Builder() { }

      public Builder(Application config) {
        tenant(config.tenant());
        name(config.name());
        environment(config.environment());
        instance(config.instance());
        region(config.region());
      }

      private Builder override(Builder __superior) {
        if (__superior.tenant != null)
          tenant(__superior.tenant);
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.environment != null)
          environment(__superior.environment);
        if (__superior.instance != null)
          instance(__superior.instance);
        if (__superior.region != null)
          region(__superior.region);
        return this;
      }

      public Builder tenant(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        tenant = __value;
        return this;
      }


      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        return this;
      }


      public Builder environment(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        environment = __value;
        return this;
      }


      public Builder instance(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        instance = __value;
        return this;
      }


      public Builder region(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        region = __value;
        return this;
      }


      public Application build() {
        return new Application(this);
      }

    }

    // Meta info about the application running on this node. All values are
    // exported to child processes as $VESPA_APPLICATION_TENANT,
    // $VESPA_APPLICATION_NAME, $VESPA_APPLICATION_ENVIRONMENT, $VESPA_APPLICATION_REGION
    // and $VESPA_APPLICATION_INSTANCE
    private final StringNode tenant;
    private final StringNode name;
    private final StringNode environment;
    private final StringNode instance;
    private final StringNode region;

    public Application(Builder builder) {
      this(builder, true);
    }

    private Application(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "sentinel.application must be initialized: " + builder.__uninitialized);

      tenant = (builder.tenant == null) ?
          new StringNode("default") : new StringNode(builder.tenant);
      name = (builder.name == null) ?
          new StringNode("default") : new StringNode(builder.name);
      environment = (builder.environment == null) ?
          new StringNode("default") : new StringNode(builder.environment);
      instance = (builder.instance == null) ?
          new StringNode("default") : new StringNode(builder.instance);
      region = (builder.region == null) ?
          new StringNode("default") : new StringNode(builder.region);
    }

    /**
     * @return sentinel.application.tenant
     */
    public String tenant() {
      return tenant.value();
    }

    /**
     * @return sentinel.application.name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return sentinel.application.environment
     */
    public String environment() {
      return environment.value();
    }

    /**
     * @return sentinel.application.instance
     */
    public String instance() {
      return instance.value();
    }

    /**
     * @return sentinel.application.region
     */
    public String region() {
      return region.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Application newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("application");
      return changes;
    }
  }

  /**
   * This class represents sentinel.connectivity
   */
  public final static class Connectivity extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Integer minOkPercent = null;
      private Integer maxBadCount = null;

      public Builder() { }

      public Builder(Connectivity config) {
        minOkPercent(config.minOkPercent());
        maxBadCount(config.maxBadCount());
      }

      private Builder override(Builder __superior) {
        if (__superior.minOkPercent != null)
          minOkPercent(__superior.minOkPercent);
        if (__superior.maxBadCount != null)
          maxBadCount(__superior.maxBadCount);
        return this;
      }

      public Builder minOkPercent(int __value) {
        minOkPercent = __value;
        return this;
      }

      private Builder minOkPercent(String __value) {
        return minOkPercent(Integer.valueOf(__value));
      }

      public Builder maxBadCount(int __value) {
        maxBadCount = __value;
        return this;
      }

      private Builder maxBadCount(String __value) {
        return maxBadCount(Integer.valueOf(__value));
      }

      public Connectivity build() {
        return new Connectivity(this);
      }

    }

    // Connectivity checks run before starting services and measure how
    // many nodes in the Vespa cluster we can connect to and how many of
    // those that can connect back to us. We delay starting services
    // if we have more problems than the following limits allow:
    // Percentage of nodes that must be up and fully OK, minimum
    private final IntegerNode minOkPercent;
    // Absolute number of nodes with confirmed network connectivity problems, maximum
    private final IntegerNode maxBadCount;

    public Connectivity(Builder builder) {
      this(builder, true);
    }

    private Connectivity(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "sentinel.connectivity must be initialized: " + builder.__uninitialized);

      minOkPercent = (builder.minOkPercent == null) ?
          new IntegerNode(50) : new IntegerNode(builder.minOkPercent);
      maxBadCount = (builder.maxBadCount == null) ?
          new IntegerNode(1) : new IntegerNode(builder.maxBadCount);
    }

    /**
     * @return sentinel.connectivity.minOkPercent
     */
    public int minOkPercent() {
      return minOkPercent.value();
    }

    /**
     * @return sentinel.connectivity.maxBadCount
     */
    public int maxBadCount() {
      return maxBadCount.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Connectivity newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("connectivity");
      return changes;
    }
  }

  /**
   * This class represents sentinel.service[]
   */
  public final static class Service extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "command",
        "name",
        "id"
        ));

      private String command = null;
      public List<Environ.Builder> environ = new ArrayList<>();
      public List<Logctl.Builder> logctl = new ArrayList<>();
      private String preShutdownCommand = null;
      private String name = null;
      private Boolean autostart = null;
      private Boolean autorestart = null;
      private String id = null;
      public Affinity.Builder affinity = new Affinity.Builder();

      public Builder() { }

      public Builder(Service config) {
        command(config.command());
        for (Environ e : config.environ()) {
          environ(new Environ.Builder(e));
        }
        for (Logctl l : config.logctl()) {
          logctl(new Logctl.Builder(l));
        }
        preShutdownCommand(config.preShutdownCommand());
        name(config.name());
        autostart(config.autostart());
        autorestart(config.autorestart());
        id(config.id());
        affinity(new Affinity.Builder(config.affinity()));
      }

      private Builder override(Builder __superior) {
        if (__superior.command != null)
          command(__superior.command);
        if (!__superior.environ.isEmpty())
          environ.addAll(__superior.environ);
        if (!__superior.logctl.isEmpty())
          logctl.addAll(__superior.logctl);
        if (__superior.preShutdownCommand != null)
          preShutdownCommand(__superior.preShutdownCommand);
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.autostart != null)
          autostart(__superior.autostart);
        if (__superior.autorestart != null)
          autorestart(__superior.autorestart);
        if (__superior.id != null)
          id(__superior.id);
        affinity(affinity.override(__superior.affinity));
        return this;
      }

      public Builder command(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        command = __value;
        __uninitialized.remove("command");
        return this;
      }


      /**
       * Add the given builder to this builder's list of Environ builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder environ(Environ.Builder __builder) {
        environ.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder environ(java.util.function.Consumer<Environ.Builder> __func) {
        Environ.Builder __inner = new Environ.Builder();
        __func.accept(__inner);
        environ.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Environ builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder environ(List<Environ.Builder> __builders) {
        environ = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Logctl builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder logctl(Logctl.Builder __builder) {
        logctl.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder logctl(java.util.function.Consumer<Logctl.Builder> __func) {
        Logctl.Builder __inner = new Logctl.Builder();
        __func.accept(__inner);
        logctl.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Logctl builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder logctl(List<Logctl.Builder> __builders) {
        logctl = __builders;
        return this;
      }

      public Builder preShutdownCommand(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        preShutdownCommand = __value;
        return this;
      }


      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder autostart(boolean __value) {
        autostart = __value;
        return this;
      }

      private Builder autostart(String __value) {
        return autostart(Boolean.valueOf(__value));
      }

      public Builder autorestart(boolean __value) {
        autorestart = __value;
        return this;
      }

      private Builder autorestart(String __value) {
        return autorestart(Boolean.valueOf(__value));
      }

      public Builder id(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        id = __value;
        __uninitialized.remove("id");
        return this;
      }


      public Builder affinity(Affinity.Builder __builder) {
        affinity = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder affinity(java.util.function.Consumer<Affinity.Builder> __func) {
        Affinity.Builder __inner = new Affinity.Builder();
        __func.accept(__inner);
        affinity = __inner;
        return this;
      }

      public Service build() {
        return new Service(this);
      }

    }

    // The command to run. This will be run by sh -c, and the following
    // environment variables are defined: $ROOT, $VESPA_SERVICE_NAME,
    // $VESPA_CONFIG_ID
    //  
    // stdin points to /dev/null
    // stdout and stderr connected to sentinel via pipe on startup.
    private final StringNode command;
    private final InnerNodeVector<Environ> environ;
    private final InnerNodeVector<Logctl> logctl;
    // The command to run before stopping service. The same properties as for
    // startup command holds.
    private final StringNode preShutdownCommand;
    // The service name for this service. Exported in VESPA_SERVICE_NAME
    // environment variable. All services must have unique names.
    // The service name is used by to start/stop services, and to list
    // them. It is also logged in the service field in every log message.
    private final StringNode name;
    // Should the service be auto-started by configd as soon as it starts up,
    // or must it be started manually? Almost always true.
    private final BooleanNode autostart;
    // Should the service automatically be restarted if it exits?
    private final BooleanNode autorestart;
    // Config reference to the service being started.
    // Exported in the VESPA_CONFIG_ID environment variable.
    private final ReferenceNode id;
    private final Affinity affinity;

    public Service(Builder builder) {
      this(builder, true);
    }

    private Service(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "sentinel.service[] must be initialized: " + builder.__uninitialized);

      command = (builder.command == null) ?
          new StringNode() : new StringNode(builder.command);
      environ = Environ.createVector(builder.environ);
      logctl = Logctl.createVector(builder.logctl);
      preShutdownCommand = (builder.preShutdownCommand == null) ?
          new StringNode("") : new StringNode(builder.preShutdownCommand);
      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      autostart = (builder.autostart == null) ?
          new BooleanNode(false) : new BooleanNode(builder.autostart);
      autorestart = (builder.autorestart == null) ?
          new BooleanNode(true) : new BooleanNode(builder.autorestart);
      id = (builder.id == null) ?
          new ReferenceNode() : new ReferenceNode(builder.id);
      affinity = new Affinity(builder.affinity, throwIfUninitialized);
    }

    /**
     * @return sentinel.service[].command
     */
    public String command() {
      return command.value();
    }

    /**
     * @return sentinel.service[].environ[]
     */
    public List<Environ> environ() {
      return environ;
    }

    /**
     * @param i the index of the value to return
     * @return sentinel.service[].environ[]
     */
    public Environ environ(int i) {
      return environ.get(i);
    }

    /**
     * @return sentinel.service[].logctl[]
     */
    public List<Logctl> logctl() {
      return logctl;
    }

    /**
     * @param i the index of the value to return
     * @return sentinel.service[].logctl[]
     */
    public Logctl logctl(int i) {
      return logctl.get(i);
    }

    /**
     * @return sentinel.service[].preShutdownCommand
     */
    public String preShutdownCommand() {
      return preShutdownCommand.value();
    }

    /**
     * @return sentinel.service[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return sentinel.service[].autostart
     */
    public boolean autostart() {
      return autostart.value();
    }

    /**
     * @return sentinel.service[].autorestart
     */
    public boolean autorestart() {
      return autorestart.value();
    }

    /**
     * @return sentinel.service[].id
     */
    public String id() {
      return id.value();
    }

    /**
     * @return sentinel.service[].affinity
     */
    public Affinity affinity() {
      return affinity;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Service newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("service");
      return changes;
    }

    private static InnerNodeVector<Service> createVector(List<Builder> builders) {
        List<Service> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Service(b));
        }
        return new InnerNodeVector<Service>(elems);
    }

    /**
     * This class represents sentinel.service[].environ[]
     */
    public final static class Environ extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "varname",
          "varvalue"
          ));

        private String varname = null;
        private String varvalue = null;

        public Builder() { }

        public Builder(Environ config) {
          varname(config.varname());
          varvalue(config.varvalue());
        }

        private Builder override(Builder __superior) {
          if (__superior.varname != null)
            varname(__superior.varname);
          if (__superior.varvalue != null)
            varvalue(__superior.varvalue);
          return this;
        }

        public Builder varname(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          varname = __value;
          __uninitialized.remove("varname");
          return this;
        }


        public Builder varvalue(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          varvalue = __value;
          __uninitialized.remove("varvalue");
          return this;
        }


        public Environ build() {
          return new Environ(this);
        }

      }

      // Extra environment variables that will be exposed for this service
      private final StringNode varname;
      private final StringNode varvalue;

      public Environ(Builder builder) {
        this(builder, true);
      }

      private Environ(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "sentinel.service[].environ[] must be initialized: " + builder.__uninitialized);

        varname = (builder.varname == null) ?
            new StringNode() : new StringNode(builder.varname);
        varvalue = (builder.varvalue == null) ?
            new StringNode() : new StringNode(builder.varvalue);
      }

      /**
       * @return sentinel.service[].environ[].varname
       */
      public String varname() {
        return varname.value();
      }

      /**
       * @return sentinel.service[].environ[].varvalue
       */
      public String varvalue() {
        return varvalue.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Environ newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("environ");
        return changes;
      }

      private static InnerNodeVector<Environ> createVector(List<Builder> builders) {
          List<Environ> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Environ(b));
          }
          return new InnerNodeVector<Environ>(elems);
      }
    }

    /**
     * This class represents sentinel.service[].logctl[]
     */
    public final static class Logctl extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "componentSpec",
          "levelsModSpec"
          ));

        private String componentSpec = null;
        private String levelsModSpec = null;

        public Builder() { }

        public Builder(Logctl config) {
          componentSpec(config.componentSpec());
          levelsModSpec(config.levelsModSpec());
        }

        private Builder override(Builder __superior) {
          if (__superior.componentSpec != null)
            componentSpec(__superior.componentSpec);
          if (__superior.levelsModSpec != null)
            levelsModSpec(__superior.levelsModSpec);
          return this;
        }

        public Builder componentSpec(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          componentSpec = __value;
          __uninitialized.remove("componentSpec");
          return this;
        }


        public Builder levelsModSpec(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          levelsModSpec = __value;
          __uninitialized.remove("levelsModSpec");
          return this;
        }


        public Logctl build() {
          return new Logctl(this);
        }

      }

      // Tune log-level settings for specific components
      private final StringNode componentSpec;
      private final StringNode levelsModSpec;

      public Logctl(Builder builder) {
        this(builder, true);
      }

      private Logctl(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "sentinel.service[].logctl[] must be initialized: " + builder.__uninitialized);

        componentSpec = (builder.componentSpec == null) ?
            new StringNode() : new StringNode(builder.componentSpec);
        levelsModSpec = (builder.levelsModSpec == null) ?
            new StringNode() : new StringNode(builder.levelsModSpec);
      }

      /**
       * @return sentinel.service[].logctl[].componentSpec
       */
      public String componentSpec() {
        return componentSpec.value();
      }

      /**
       * @return sentinel.service[].logctl[].levelsModSpec
       */
      public String levelsModSpec() {
        return levelsModSpec.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Logctl newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("logctl");
        return changes;
      }

      private static InnerNodeVector<Logctl> createVector(List<Builder> builders) {
          List<Logctl> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Logctl(b));
          }
          return new InnerNodeVector<Logctl>(elems);
      }
    }

    /**
     * This class represents sentinel.service[].affinity
     */
    public final static class Affinity extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Integer cpuSocket = null;

        public Builder() { }

        public Builder(Affinity config) {
          cpuSocket(config.cpuSocket());
        }

        private Builder override(Builder __superior) {
          if (__superior.cpuSocket != null)
            cpuSocket(__superior.cpuSocket);
          return this;
        }

        public Builder cpuSocket(int __value) {
          cpuSocket = __value;
          return this;
        }

        private Builder cpuSocket(String __value) {
          return cpuSocket(Integer.valueOf(__value));
        }

        public Affinity build() {
          return new Affinity(this);
        }

      }

      // Affinity of this service towards a CPU socket
      private final IntegerNode cpuSocket;

      public Affinity(Builder builder) {
        this(builder, true);
      }

      private Affinity(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "sentinel.service[].affinity must be initialized: " + builder.__uninitialized);

        cpuSocket = (builder.cpuSocket == null) ?
            new IntegerNode(-1) : new IntegerNode(builder.cpuSocket);
      }

      /**
       * @return sentinel.service[].affinity.cpuSocket
       */
      public int cpuSocket() {
        return cpuSocket.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Affinity newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("affinity");
        return changes;
      }
    }
  }

}
