// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.cloud.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of open-telemetry
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class OpenTelemetryConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "7ca00a9409bc0071551d4f0335adacae";
  public final static String CONFIG_DEF_NAME = "open-telemetry";
  public final static String CONFIG_DEF_NAMESPACE = "cloud.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=cloud.config",
    "yaml string",
    "refPaths[] string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>(List.of(
      "yaml"
      ));

    private String yaml = null;
    public List<String> refPaths = new ArrayList<>();

    public Builder() { }

    public Builder(OpenTelemetryConfig config) {
      yaml(config.yaml());
      refPaths(config.refPaths());
    }

    private Builder override(Builder __superior) {
      if (__superior.yaml != null)
        yaml(__superior.yaml);
      if (!__superior.refPaths.isEmpty())
        refPaths.addAll(__superior.refPaths);
      return this;
    }

    public Builder yaml(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      yaml = __value;
      __uninitialized.remove("yaml");
      return this;
    }


    public Builder refPaths(String __value) {
      refPaths.add(__value);
      return this;
    }

    public Builder refPaths(Collection<String> __values) {
      refPaths.addAll(__values);
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public OpenTelemetryConfig build() {
      return new OpenTelemetryConfig(this);
    }

  }

  // For now - store entire config in one string
  private final StringNode yaml;
  // Referenced paths
  private final LeafNodeVector<String, StringNode> refPaths;

  public OpenTelemetryConfig(Builder builder) {
    this(builder, true);
  }

  private OpenTelemetryConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "open-telemetry must be initialized: " + builder.__uninitialized);

    yaml = (builder.yaml == null) ?
        new StringNode() : new StringNode(builder.yaml);
    refPaths = new LeafNodeVector<>(builder.refPaths, new StringNode());
  }

  /**
   * @return open-telemetry.yaml
   */
  public String yaml() {
    return yaml.value();
  }

  /**
   * @return open-telemetry.refPaths[]
   */
  public List<String> refPaths() {
    return refPaths.asList();
  }

  /**
   * @param i the index of the value to return
   * @return open-telemetry.refPaths[]
   */
  public String refPaths(int i) {
    return refPaths.get(i).value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(OpenTelemetryConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("open-telemetry");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
