// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.cloud.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of model
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class ModelConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "665f15b69fcddf6de75c32230ffdfc0e";
  public final static String CONFIG_DEF_NAME = "model";
  public final static String CONFIG_DEF_NAMESPACE = "cloud.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=cloud.config",
    "vespaVersion string default=\"unknown\"",
    "hosts[].name string default=\"(unknownhostname)\"",
    "hosts[].services[].name string default=\"(noservicename)\"",
    "hosts[].services[].type string default=\"(noservicetype)\"",
    "hosts[].services[].configid string default=\"(noconfigid)\"",
    "hosts[].services[].clustertype string default=\"(unknownclustertype)\"",
    "hosts[].services[].clustername string default=\"(unknownclustername)\"",
    "hosts[].services[].index int default=0",
    "hosts[].services[].ports[].number int default=-1",
    "hosts[].services[].ports[].tags string default=\"(notags)\""
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private String vespaVersion = null;
    public List<Hosts.Builder> hosts = new ArrayList<>();

    public Builder() { }

    public Builder(ModelConfig config) {
      vespaVersion(config.vespaVersion());
      for (Hosts h : config.hosts()) {
        hosts(new Hosts.Builder(h));
      }
    }

    private Builder override(Builder __superior) {
      if (__superior.vespaVersion != null)
        vespaVersion(__superior.vespaVersion);
      if (!__superior.hosts.isEmpty())
        hosts.addAll(__superior.hosts);
      return this;
    }

    public Builder vespaVersion(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      vespaVersion = __value;
      return this;
    }


    /**
     * Add the given builder to this builder's list of Hosts builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder hosts(Hosts.Builder __builder) {
      hosts.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder hosts(java.util.function.Consumer<Hosts.Builder> __func) {
      Hosts.Builder __inner = new Hosts.Builder();
      __func.accept(__inner);
      hosts.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Hosts builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder hosts(List<Hosts.Builder> __builders) {
      hosts = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ModelConfig build() {
      return new ModelConfig(this);
    }

  }

  private final StringNode vespaVersion;
  private final InnerNodeVector<Hosts> hosts;

  public ModelConfig(Builder builder) {
    this(builder, true);
  }

  private ModelConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "model must be initialized: " + builder.__uninitialized);

    vespaVersion = (builder.vespaVersion == null) ?
        new StringNode("unknown") : new StringNode(builder.vespaVersion);
    hosts = Hosts.createVector(builder.hosts);
  }

  /**
   * @return model.vespaVersion
   */
  public String vespaVersion() {
    return vespaVersion.value();
  }

  /**
   * @return model.hosts[]
   */
  public List<Hosts> hosts() {
    return hosts;
  }

  /**
   * @param i the index of the value to return
   * @return model.hosts[]
   */
  public Hosts hosts(int i) {
    return hosts.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ModelConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("model");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents model.hosts[]
   */
  public final static class Hosts extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private String name = null;
      public List<Services.Builder> services = new ArrayList<>();

      public Builder() { }

      public Builder(Hosts config) {
        name(config.name());
        for (Services s : config.services()) {
          services(new Services.Builder(s));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (!__superior.services.isEmpty())
          services.addAll(__superior.services);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        return this;
      }


      /**
       * Add the given builder to this builder's list of Services builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder services(Services.Builder __builder) {
        services.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder services(java.util.function.Consumer<Services.Builder> __func) {
        Services.Builder __inner = new Services.Builder();
        __func.accept(__inner);
        services.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Services builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder services(List<Services.Builder> __builders) {
        services = __builders;
        return this;
      }

      public Hosts build() {
        return new Hosts(this);
      }

    }

    private final StringNode name;
    private final InnerNodeVector<Services> services;

    public Hosts(Builder builder) {
      this(builder, true);
    }

    private Hosts(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "model.hosts[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode("(unknownhostname)") : new StringNode(builder.name);
      services = Services.createVector(builder.services);
    }

    /**
     * @return model.hosts[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return model.hosts[].services[]
     */
    public List<Services> services() {
      return services;
    }

    /**
     * @param i the index of the value to return
     * @return model.hosts[].services[]
     */
    public Services services(int i) {
      return services.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Hosts newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("hosts");
      return changes;
    }

    private static InnerNodeVector<Hosts> createVector(List<Builder> builders) {
        List<Hosts> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Hosts(b));
        }
        return new InnerNodeVector<Hosts>(elems);
    }

    /**
     * This class represents model.hosts[].services[]
     */
    public final static class Services extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private String name = null;
        private String type = null;
        private String configid = null;
        private String clustertype = null;
        private String clustername = null;
        private Integer index = null;
        public List<Ports.Builder> ports = new ArrayList<>();

        public Builder() { }

        public Builder(Services config) {
          name(config.name());
          type(config.type());
          configid(config.configid());
          clustertype(config.clustertype());
          clustername(config.clustername());
          index(config.index());
          for (Ports p : config.ports()) {
            ports(new Ports.Builder(p));
          }
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          if (__superior.type != null)
            type(__superior.type);
          if (__superior.configid != null)
            configid(__superior.configid);
          if (__superior.clustertype != null)
            clustertype(__superior.clustertype);
          if (__superior.clustername != null)
            clustername(__superior.clustername);
          if (__superior.index != null)
            index(__superior.index);
          if (!__superior.ports.isEmpty())
            ports.addAll(__superior.ports);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          return this;
        }


        public Builder type(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          type = __value;
          return this;
        }


        public Builder configid(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          configid = __value;
          return this;
        }


        public Builder clustertype(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          clustertype = __value;
          return this;
        }


        public Builder clustername(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          clustername = __value;
          return this;
        }


        public Builder index(int __value) {
          index = __value;
          return this;
        }

        private Builder index(String __value) {
          return index(Integer.valueOf(__value));
        }

        /**
         * Add the given builder to this builder's list of Ports builders
         * @param __builder a builder
         * @return this builder
         */
        public Builder ports(Ports.Builder __builder) {
          ports.add(__builder);
          return this;
        }

        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder ports(java.util.function.Consumer<Ports.Builder> __func) {
          Ports.Builder __inner = new Ports.Builder();
          __func.accept(__inner);
          ports.add(__inner);
          return this;
        }

        /**
         * Set the given list as this builder's list of Ports builders
         * @param __builders a list of builders
         * @return this builder
         */
        public Builder ports(List<Ports.Builder> __builders) {
          ports = __builders;
          return this;
        }

        public Services build() {
          return new Services(this);
        }

      }

      private final StringNode name;
      private final StringNode type;
      private final StringNode configid;
      private final StringNode clustertype;
      private final StringNode clustername;
      private final IntegerNode index;
      private final InnerNodeVector<Ports> ports;

      public Services(Builder builder) {
        this(builder, true);
      }

      private Services(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "model.hosts[].services[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode("(noservicename)") : new StringNode(builder.name);
        type = (builder.type == null) ?
            new StringNode("(noservicetype)") : new StringNode(builder.type);
        configid = (builder.configid == null) ?
            new StringNode("(noconfigid)") : new StringNode(builder.configid);
        clustertype = (builder.clustertype == null) ?
            new StringNode("(unknownclustertype)") : new StringNode(builder.clustertype);
        clustername = (builder.clustername == null) ?
            new StringNode("(unknownclustername)") : new StringNode(builder.clustername);
        index = (builder.index == null) ?
            new IntegerNode(0) : new IntegerNode(builder.index);
        ports = Ports.createVector(builder.ports);
      }

      /**
       * @return model.hosts[].services[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return model.hosts[].services[].type
       */
      public String type() {
        return type.value();
      }

      /**
       * @return model.hosts[].services[].configid
       */
      public String configid() {
        return configid.value();
      }

      /**
       * @return model.hosts[].services[].clustertype
       */
      public String clustertype() {
        return clustertype.value();
      }

      /**
       * @return model.hosts[].services[].clustername
       */
      public String clustername() {
        return clustername.value();
      }

      /**
       * @return model.hosts[].services[].index
       */
      public int index() {
        return index.value();
      }

      /**
       * @return model.hosts[].services[].ports[]
       */
      public List<Ports> ports() {
        return ports;
      }

      /**
       * @param i the index of the value to return
       * @return model.hosts[].services[].ports[]
       */
      public Ports ports(int i) {
        return ports.get(i);
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Services newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("services");
        return changes;
      }

      private static InnerNodeVector<Services> createVector(List<Builder> builders) {
          List<Services> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Services(b));
          }
          return new InnerNodeVector<Services>(elems);
      }

      /**
       * This class represents model.hosts[].services[].ports[]
       */
      public final static class Ports extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>();

          private Integer number = null;
          private String tags = null;

          public Builder() { }

          public Builder(Ports config) {
            number(config.number());
            tags(config.tags());
          }

          private Builder override(Builder __superior) {
            if (__superior.number != null)
              number(__superior.number);
            if (__superior.tags != null)
              tags(__superior.tags);
            return this;
          }

          public Builder number(int __value) {
            number = __value;
            return this;
          }

          private Builder number(String __value) {
            return number(Integer.valueOf(__value));
          }

          public Builder tags(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            tags = __value;
            return this;
          }


          public Ports build() {
            return new Ports(this);
          }

        }

        private final IntegerNode number;
        private final StringNode tags;

        public Ports(Builder builder) {
          this(builder, true);
        }

        private Ports(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "model.hosts[].services[].ports[] must be initialized: " + builder.__uninitialized);

          number = (builder.number == null) ?
              new IntegerNode(-1) : new IntegerNode(builder.number);
          tags = (builder.tags == null) ?
              new StringNode("(notags)") : new StringNode(builder.tags);
        }

        /**
         * @return model.hosts[].services[].ports[].number
         */
        public int number() {
          return number.value();
        }

        /**
         * @return model.hosts[].services[].ports[].tags
         */
        public String tags() {
          return tags.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Ports newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("ports");
          return changes;
        }

        private static InnerNodeVector<Ports> createVector(List<Builder> builders) {
            List<Ports> elems = new ArrayList<>();
            for (Builder b : builders) {
                elems.add(new Ports(b));
            }
            return new InnerNodeVector<Ports>(elems);
        }
      }
    }
  }

}
