// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.cloud.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of logforwarder
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class LogforwarderConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "d5e5313aea917591fe88b9d777c75001";
  public final static String CONFIG_DEF_NAME = "logforwarder";
  public final static String CONFIG_DEF_NAMESPACE = "cloud.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=cloud.config",
    "deploymentServer string default=\"\"",
    "clientName string default=\"\"",
    "splunkHome string default=\"/opt/splunkforwarder\"",
    "phoneHomeInterval int default=60",
    "role string default=\"\""
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private String deploymentServer = null;
    private String clientName = null;
    private String splunkHome = null;
    private Integer phoneHomeInterval = null;
    private String role = null;

    public Builder() { }

    public Builder(LogforwarderConfig config) {
      deploymentServer(config.deploymentServer());
      clientName(config.clientName());
      splunkHome(config.splunkHome());
      phoneHomeInterval(config.phoneHomeInterval());
      role(config.role());
    }

    private Builder override(Builder __superior) {
      if (__superior.deploymentServer != null)
        deploymentServer(__superior.deploymentServer);
      if (__superior.clientName != null)
        clientName(__superior.clientName);
      if (__superior.splunkHome != null)
        splunkHome(__superior.splunkHome);
      if (__superior.phoneHomeInterval != null)
        phoneHomeInterval(__superior.phoneHomeInterval);
      if (__superior.role != null)
        role(__superior.role);
      return this;
    }

    public Builder deploymentServer(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      deploymentServer = __value;
      return this;
    }


    public Builder clientName(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      clientName = __value;
      return this;
    }


    public Builder splunkHome(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      splunkHome = __value;
      return this;
    }


    public Builder phoneHomeInterval(int __value) {
      phoneHomeInterval = __value;
      return this;
    }

    private Builder phoneHomeInterval(String __value) {
      return phoneHomeInterval(Integer.valueOf(__value));
    }

    public Builder role(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      role = __value;
      return this;
    }


    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public LogforwarderConfig build() {
      return new LogforwarderConfig(this);
    }

  }

  // only splunk type config for now
  private final StringNode deploymentServer;
  private final StringNode clientName;
  private final StringNode splunkHome;
  private final IntegerNode phoneHomeInterval;
  private final StringNode role;

  public LogforwarderConfig(Builder builder) {
    this(builder, true);
  }

  private LogforwarderConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "logforwarder must be initialized: " + builder.__uninitialized);

    deploymentServer = (builder.deploymentServer == null) ?
        new StringNode("") : new StringNode(builder.deploymentServer);
    clientName = (builder.clientName == null) ?
        new StringNode("") : new StringNode(builder.clientName);
    splunkHome = (builder.splunkHome == null) ?
        new StringNode("/opt/splunkforwarder") : new StringNode(builder.splunkHome);
    phoneHomeInterval = (builder.phoneHomeInterval == null) ?
        new IntegerNode(60) : new IntegerNode(builder.phoneHomeInterval);
    role = (builder.role == null) ?
        new StringNode("") : new StringNode(builder.role);
  }

  /**
   * @return logforwarder.deploymentServer
   */
  public String deploymentServer() {
    return deploymentServer.value();
  }

  /**
   * @return logforwarder.clientName
   */
  public String clientName() {
    return clientName.value();
  }

  /**
   * @return logforwarder.splunkHome
   */
  public String splunkHome() {
    return splunkHome.value();
  }

  /**
   * @return logforwarder.phoneHomeInterval
   */
  public int phoneHomeInterval() {
    return phoneHomeInterval.value();
  }

  /**
   * @return logforwarder.role
   */
  public String role() {
    return role.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(LogforwarderConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("logforwarder");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
