// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.cloud.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of lb-services
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 * Config for load balancer that needs to know about all services for
 * all tenants and applications in a config server cluster
 */
public final class LbServicesConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "71d168615a8aa43c5ca2bbc6526adb7c";
  public final static String CONFIG_DEF_NAME = "lb-services";
  public final static String CONFIG_DEF_NAMESPACE = "cloud.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=cloud.config",
    "tenants{}.applications{}.activeRotation bool default=true",
    "tenants{}.applications{}.endpoints[].dnsName string",
    "tenants{}.applications{}.endpoints[].clusterId string",
    "tenants{}.applications{}.endpoints[].scope enum {application, global, zone}",
    "tenants{}.applications{}.endpoints[].routingMethod enum {shared, sharedLayer4}",
    "tenants{}.applications{}.endpoints[].weight int default=1",
    "tenants{}.applications{}.endpoints[].hosts[] string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public Map<String, Tenants.Builder> tenants = new LinkedHashMap<>();

    public Builder() { }

    public Builder(LbServicesConfig config) {
      for (Map.Entry<String, Tenants> __entry : config.tenants().entrySet()) {
        tenants(__entry.getKey(), new Tenants.Builder(__entry.getValue()));
      }
    }

    private Builder override(Builder __superior) {
      tenants(__superior.tenants);
      return this;
    }

    public Builder tenants(String __key, Tenants.Builder __value) {
      tenants.put(__key, __value);
      return this;
    }

    public Builder tenants(Map<String, Tenants.Builder> __values) {
      tenants.putAll(__values);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before using it as the value
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder tenants(String __key, java.util.function.Consumer<Tenants.Builder> __func) {
      Tenants.Builder __inner = new Tenants.Builder();
      __func.accept(__inner);
      tenants.put(__key, __inner);
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public LbServicesConfig build() {
      return new LbServicesConfig(this);
    }

  }

  private final Map<String, Tenants> tenants;

  public LbServicesConfig(Builder builder) {
    this(builder, true);
  }

  private LbServicesConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "lb-services must be initialized: " + builder.__uninitialized);

    tenants = Tenants.createMap(builder.tenants);
  }

  /**
   * @return lb-services.tenants{}
   */
  public Map<String, Tenants> tenants() {
    return Collections.unmodifiableMap(tenants);
  }

  /**
   * @param key the key of the value to return
   * @return lb-services.tenants{}
   */
  public Tenants tenants(String key) {
    return tenants.get(key);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(LbServicesConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("lb-services");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents lb-services.tenants{}
   */
  public final static class Tenants extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      public Map<String, Applications.Builder> applications = new LinkedHashMap<>();

      public Builder() { }

      public Builder(Tenants config) {
        for (Map.Entry<String, Applications> __entry : config.applications().entrySet()) {
          applications(__entry.getKey(), new Applications.Builder(__entry.getValue()));
        }
      }

      private Builder override(Builder __superior) {
        applications(__superior.applications);
        return this;
      }

      public Builder applications(String __key, Applications.Builder __value) {
        applications.put(__key, __value);
        return this;
      }

      public Builder applications(Map<String, Applications.Builder> __values) {
        applications.putAll(__values);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before using it as the value
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder applications(String __key, java.util.function.Consumer<Applications.Builder> __func) {
        Applications.Builder __inner = new Applications.Builder();
        __func.accept(__inner);
        applications.put(__key, __inner);
        return this;
      }

      public Tenants build() {
        return new Tenants(this);
      }

    }

    private final Map<String, Applications> applications;

    public Tenants(Builder builder) {
      this(builder, true);
    }

    private Tenants(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "lb-services.tenants{} must be initialized: " + builder.__uninitialized);

      applications = Applications.createMap(builder.applications);
    }

    /**
     * @return lb-services.tenants{}.applications{}
     */
    public Map<String, Applications> applications() {
      return Collections.unmodifiableMap(applications);
    }

    /**
     * @param key the key of the value to return
     * @return lb-services.tenants{}.applications{}
     */
    public Applications applications(String key) {
      return applications.get(key);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Tenants newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("tenants");
      return changes;
    }

    private static Map<String, Tenants> createMap(Map<String, Builder> builders) {
      Map<String, Tenants> ret = new LinkedHashMap<>();
      for(String key : builders.keySet()) {
        ret.put(key, new Tenants(builders.get(key)));
      }
      return Collections.unmodifiableMap(ret);
    }

    /**
     * This class represents lb-services.tenants{}.applications{}
     */
    public final static class Applications extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Boolean activeRotation = null;
        public List<Endpoints.Builder> endpoints = new ArrayList<>();

        public Builder() { }

        public Builder(Applications config) {
          activeRotation(config.activeRotation());
          for (Endpoints e : config.endpoints()) {
            endpoints(new Endpoints.Builder(e));
          }
        }

        private Builder override(Builder __superior) {
          if (__superior.activeRotation != null)
            activeRotation(__superior.activeRotation);
          if (!__superior.endpoints.isEmpty())
            endpoints.addAll(__superior.endpoints);
          return this;
        }

        public Builder activeRotation(boolean __value) {
          activeRotation = __value;
          return this;
        }

        private Builder activeRotation(String __value) {
          return activeRotation(Boolean.valueOf(__value));
        }

        /**
         * Add the given builder to this builder's list of Endpoints builders
         * @param __builder a builder
         * @return this builder
         */
        public Builder endpoints(Endpoints.Builder __builder) {
          endpoints.add(__builder);
          return this;
        }

        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder endpoints(java.util.function.Consumer<Endpoints.Builder> __func) {
          Endpoints.Builder __inner = new Endpoints.Builder();
          __func.accept(__inner);
          endpoints.add(__inner);
          return this;
        }

        /**
         * Set the given list as this builder's list of Endpoints builders
         * @param __builders a list of builders
         * @return this builder
         */
        public Builder endpoints(List<Endpoints.Builder> __builders) {
          endpoints = __builders;
          return this;
        }

        public Applications build() {
          return new Applications(this);
        }

      }

      // Active rotation given as flag 'active' for a prod region in deployment.xml
      // Default true for now (since code in config-model to set it is not ready yet), should have no default value
      private final BooleanNode activeRotation;
      private final InnerNodeVector<Endpoints> endpoints;

      public Applications(Builder builder) {
        this(builder, true);
      }

      private Applications(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "lb-services.tenants{}.applications{} must be initialized: " + builder.__uninitialized);

        activeRotation = (builder.activeRotation == null) ?
            new BooleanNode(true) : new BooleanNode(builder.activeRotation);
        endpoints = Endpoints.createVector(builder.endpoints);
      }

      /**
       * @return lb-services.tenants{}.applications{}.activeRotation
       */
      public boolean activeRotation() {
        return activeRotation.value();
      }

      /**
       * @return lb-services.tenants{}.applications{}.endpoints[]
       */
      public List<Endpoints> endpoints() {
        return endpoints;
      }

      /**
       * @param i the index of the value to return
       * @return lb-services.tenants{}.applications{}.endpoints[]
       */
      public Endpoints endpoints(int i) {
        return endpoints.get(i);
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Applications newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("applications");
        return changes;
      }

      private static Map<String, Applications> createMap(Map<String, Builder> builders) {
        Map<String, Applications> ret = new LinkedHashMap<>();
        for(String key : builders.keySet()) {
          ret.put(key, new Applications(builders.get(key)));
        }
        return Collections.unmodifiableMap(ret);
      }

      /**
       * This class represents lb-services.tenants{}.applications{}.endpoints[]
       */
      public final static class Endpoints extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>(List.of(
            "dnsName",
            "clusterId",
            "scope",
            "routingMethod"
            ));

          private String dnsName = null;
          private String clusterId = null;
          private Scope.Enum scope = null;
          private RoutingMethod.Enum routingMethod = null;
          private Integer weight = null;
          public List<String> hosts = new ArrayList<>();

          public Builder() { }

          public Builder(Endpoints config) {
            dnsName(config.dnsName());
            clusterId(config.clusterId());
            scope(config.scope());
            routingMethod(config.routingMethod());
            weight(config.weight());
            hosts(config.hosts());
          }

          private Builder override(Builder __superior) {
            if (__superior.dnsName != null)
              dnsName(__superior.dnsName);
            if (__superior.clusterId != null)
              clusterId(__superior.clusterId);
            if (__superior.scope != null)
              scope(__superior.scope);
            if (__superior.routingMethod != null)
              routingMethod(__superior.routingMethod);
            if (__superior.weight != null)
              weight(__superior.weight);
            if (!__superior.hosts.isEmpty())
              hosts.addAll(__superior.hosts);
            return this;
          }

          public Builder dnsName(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            dnsName = __value;
            __uninitialized.remove("dnsName");
            return this;
          }


          public Builder clusterId(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            clusterId = __value;
            __uninitialized.remove("clusterId");
            return this;
          }


          public Builder scope(Scope.Enum __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            scope = __value;
            __uninitialized.remove("scope");
            return this;
          }

          private Builder scope(String __value) {
            return scope(Scope.Enum.valueOf(__value));
          }

          public Builder routingMethod(RoutingMethod.Enum __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            routingMethod = __value;
            __uninitialized.remove("routingMethod");
            return this;
          }

          private Builder routingMethod(String __value) {
            return routingMethod(RoutingMethod.Enum.valueOf(__value));
          }

          public Builder weight(int __value) {
            weight = __value;
            return this;
          }

          private Builder weight(String __value) {
            return weight(Integer.valueOf(__value));
          }

          public Builder hosts(String __value) {
            hosts.add(__value);
            return this;
          }

          public Builder hosts(Collection<String> __values) {
            hosts.addAll(__values);
            return this;
          }

          public Endpoints build() {
            return new Endpoints(this);
          }

        }

        private final StringNode dnsName;
        private final StringNode clusterId;
        private final Scope scope;
        private final RoutingMethod routingMethod;
        private final IntegerNode weight;
        private final LeafNodeVector<String, StringNode> hosts;

        public Endpoints(Builder builder) {
          this(builder, true);
        }

        private Endpoints(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "lb-services.tenants{}.applications{}.endpoints[] must be initialized: " + builder.__uninitialized);

          dnsName = (builder.dnsName == null) ?
              new StringNode() : new StringNode(builder.dnsName);
          clusterId = (builder.clusterId == null) ?
              new StringNode() : new StringNode(builder.clusterId);
          scope = (builder.scope == null) ?
              new Scope() : new Scope(builder.scope);
          routingMethod = (builder.routingMethod == null) ?
              new RoutingMethod() : new RoutingMethod(builder.routingMethod);
          weight = (builder.weight == null) ?
              new IntegerNode(1) : new IntegerNode(builder.weight);
          hosts = new LeafNodeVector<>(builder.hosts, new StringNode());
        }

        /**
         * @return lb-services.tenants{}.applications{}.endpoints[].dnsName
         */
        public String dnsName() {
          return dnsName.value();
        }

        /**
         * @return lb-services.tenants{}.applications{}.endpoints[].clusterId
         */
        public String clusterId() {
          return clusterId.value();
        }

        /**
         * @return lb-services.tenants{}.applications{}.endpoints[].scope
         */
        public Scope.Enum scope() {
          return scope.value();
        }

        /**
         * @return lb-services.tenants{}.applications{}.endpoints[].routingMethod
         */
        public RoutingMethod.Enum routingMethod() {
          return routingMethod.value();
        }

        /**
         * @return lb-services.tenants{}.applications{}.endpoints[].weight
         */
        public int weight() {
          return weight.value();
        }

        /**
         * @return lb-services.tenants{}.applications{}.endpoints[].hosts[]
         */
        public List<String> hosts() {
          return hosts.asList();
        }

        /**
         * @param i the index of the value to return
         * @return lb-services.tenants{}.applications{}.endpoints[].hosts[]
         */
        public String hosts(int i) {
          return hosts.get(i).value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Endpoints newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("endpoints");
          return changes;
        }

        private static InnerNodeVector<Endpoints> createVector(List<Builder> builders) {
            List<Endpoints> elems = new ArrayList<>();
            for (Builder b : builders) {
                elems.add(new Endpoints(b));
            }
            return new InnerNodeVector<Endpoints>(elems);
        }

        /**
         * This class represents lb-services.tenants{}.applications{}.endpoints[].scope
         */
        public final static class Scope extends EnumNode<Scope.Enum> {

          public Scope(){
            this.value = null;
          }

          public Scope(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
          }

          public enum Enum {application, global, zone}
          public final static Enum application = Enum.application;
          public final static Enum global = Enum.global;
          public final static Enum zone = Enum.zone;

          @Override
          protected boolean doSetValue(String name) {
            try {
              value = Enum.valueOf(name);
              return true;
            } catch (IllegalArgumentException e) {
            }
            return false;
          }
        }

        /**
         * This class represents lb-services.tenants{}.applications{}.endpoints[].routingMethod
         */
        public final static class RoutingMethod extends EnumNode<RoutingMethod.Enum> {

          public RoutingMethod(){
            this.value = null;
          }

          public RoutingMethod(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
          }

          public enum Enum {shared, sharedLayer4}
          public final static Enum shared = Enum.shared;
          public final static Enum sharedLayer4 = Enum.sharedLayer4;

          @Override
          protected boolean doSetValue(String name) {
            try {
              value = Enum.valueOf(name);
              return true;
            } catch (IllegalArgumentException e) {
            }
            return false;
          }
        }
      }
    }
  }

}
