// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.cloud.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of dataplane-proxy
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class DataplaneProxyConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "e0b5fd391f1f63ae96c755f6f0776341";
  public final static String CONFIG_DEF_NAME = "dataplane-proxy";
  public final static String CONFIG_DEF_NAMESPACE = "cloud.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=cloud.config",
    "tokenPort int",
    "mtlsPort int",
    "serverCertificate string",
    "serverKey string",
    "tokenEndpoints[] string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>(List.of(
      "tokenPort",
      "mtlsPort",
      "serverCertificate",
      "serverKey"
      ));

    private Integer tokenPort = null;
    private Integer mtlsPort = null;
    private String serverCertificate = null;
    private String serverKey = null;
    public List<String> tokenEndpoints = new ArrayList<>();

    public Builder() { }

    public Builder(DataplaneProxyConfig config) {
      tokenPort(config.tokenPort());
      mtlsPort(config.mtlsPort());
      serverCertificate(config.serverCertificate());
      serverKey(config.serverKey());
      tokenEndpoints(config.tokenEndpoints());
    }

    private Builder override(Builder __superior) {
      if (__superior.tokenPort != null)
        tokenPort(__superior.tokenPort);
      if (__superior.mtlsPort != null)
        mtlsPort(__superior.mtlsPort);
      if (__superior.serverCertificate != null)
        serverCertificate(__superior.serverCertificate);
      if (__superior.serverKey != null)
        serverKey(__superior.serverKey);
      if (!__superior.tokenEndpoints.isEmpty())
        tokenEndpoints.addAll(__superior.tokenEndpoints);
      return this;
    }

    public Builder tokenPort(int __value) {
      tokenPort = __value;
      __uninitialized.remove("tokenPort");
      return this;
    }

    private Builder tokenPort(String __value) {
      return tokenPort(Integer.valueOf(__value));
    }

    public Builder mtlsPort(int __value) {
      mtlsPort = __value;
      __uninitialized.remove("mtlsPort");
      return this;
    }

    private Builder mtlsPort(String __value) {
      return mtlsPort(Integer.valueOf(__value));
    }

    public Builder serverCertificate(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      serverCertificate = __value;
      __uninitialized.remove("serverCertificate");
      return this;
    }


    public Builder serverKey(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      serverKey = __value;
      __uninitialized.remove("serverKey");
      return this;
    }


    public Builder tokenEndpoints(String __value) {
      tokenEndpoints.add(__value);
      return this;
    }

    public Builder tokenEndpoints(Collection<String> __values) {
      tokenEndpoints.addAll(__values);
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public DataplaneProxyConfig build() {
      return new DataplaneProxyConfig(this);
    }

  }

  // The port Jdisc will be listening on
  private final IntegerNode tokenPort;
  private final IntegerNode mtlsPort;
  // Server certificate and key to be used when creating server socket
  private final StringNode serverCertificate;
  private final StringNode serverKey;
  // Host names that should be considered token endpoints
  private final LeafNodeVector<String, StringNode> tokenEndpoints;

  public DataplaneProxyConfig(Builder builder) {
    this(builder, true);
  }

  private DataplaneProxyConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "dataplane-proxy must be initialized: " + builder.__uninitialized);

    tokenPort = (builder.tokenPort == null) ?
        new IntegerNode() : new IntegerNode(builder.tokenPort);
    mtlsPort = (builder.mtlsPort == null) ?
        new IntegerNode() : new IntegerNode(builder.mtlsPort);
    serverCertificate = (builder.serverCertificate == null) ?
        new StringNode() : new StringNode(builder.serverCertificate);
    serverKey = (builder.serverKey == null) ?
        new StringNode() : new StringNode(builder.serverKey);
    tokenEndpoints = new LeafNodeVector<>(builder.tokenEndpoints, new StringNode());
  }

  /**
   * @return dataplane-proxy.tokenPort
   */
  public int tokenPort() {
    return tokenPort.value();
  }

  /**
   * @return dataplane-proxy.mtlsPort
   */
  public int mtlsPort() {
    return mtlsPort.value();
  }

  /**
   * @return dataplane-proxy.serverCertificate
   */
  public String serverCertificate() {
    return serverCertificate.value();
  }

  /**
   * @return dataplane-proxy.serverKey
   */
  public String serverKey() {
    return serverKey.value();
  }

  /**
   * @return dataplane-proxy.tokenEndpoints[]
   */
  public List<String> tokenEndpoints() {
    return tokenEndpoints.asList();
  }

  /**
   * @param i the index of the value to return
   * @return dataplane-proxy.tokenEndpoints[]
   */
  public String tokenEndpoints(int i) {
    return tokenEndpoints.get(i).value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(DataplaneProxyConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("dataplane-proxy");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
