// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.cloud.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of curator
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class CuratorConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "b6e0820b08bf306ecd8f9001a8c24ed0";
  public final static String CONFIG_DEF_NAME = "curator";
  public final static String CONFIG_DEF_NAMESPACE = "cloud.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=cloud.config",
    "server[].hostname string",
    "server[].port int default=2181",
    "zookeeperLocalhostAffinity bool default=false",
    "zookeeperSessionTimeoutSeconds int default=120",
    "juteMaxBuffer int default=52428800"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Server.Builder> server = new ArrayList<>();
    private Boolean zookeeperLocalhostAffinity = null;
    private Integer zookeeperSessionTimeoutSeconds = null;
    private Integer juteMaxBuffer = null;

    public Builder() { }

    public Builder(CuratorConfig config) {
      for (Server s : config.server()) {
        server(new Server.Builder(s));
      }
      zookeeperLocalhostAffinity(config.zookeeperLocalhostAffinity());
      zookeeperSessionTimeoutSeconds(config.zookeeperSessionTimeoutSeconds());
      juteMaxBuffer(config.juteMaxBuffer());
    }

    private Builder override(Builder __superior) {
      if (!__superior.server.isEmpty())
        server.addAll(__superior.server);
      if (__superior.zookeeperLocalhostAffinity != null)
        zookeeperLocalhostAffinity(__superior.zookeeperLocalhostAffinity);
      if (__superior.zookeeperSessionTimeoutSeconds != null)
        zookeeperSessionTimeoutSeconds(__superior.zookeeperSessionTimeoutSeconds);
      if (__superior.juteMaxBuffer != null)
        juteMaxBuffer(__superior.juteMaxBuffer);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Server builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder server(Server.Builder __builder) {
      server.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder server(java.util.function.Consumer<Server.Builder> __func) {
      Server.Builder __inner = new Server.Builder();
      __func.accept(__inner);
      server.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Server builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder server(List<Server.Builder> __builders) {
      server = __builders;
      return this;
    }

    public Builder zookeeperLocalhostAffinity(boolean __value) {
      zookeeperLocalhostAffinity = __value;
      return this;
    }

    private Builder zookeeperLocalhostAffinity(String __value) {
      return zookeeperLocalhostAffinity(Boolean.valueOf(__value));
    }

    public Builder zookeeperSessionTimeoutSeconds(int __value) {
      zookeeperSessionTimeoutSeconds = __value;
      return this;
    }

    private Builder zookeeperSessionTimeoutSeconds(String __value) {
      return zookeeperSessionTimeoutSeconds(Integer.valueOf(__value));
    }

    public Builder juteMaxBuffer(int __value) {
      juteMaxBuffer = __value;
      return this;
    }

    private Builder juteMaxBuffer(String __value) {
      return juteMaxBuffer(Integer.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public CuratorConfig build() {
      return new CuratorConfig(this);
    }

  }

  private final InnerNodeVector<Server> server;
  // if true, only connect to server on localhost (must be in one of the servers above)
  private final BooleanNode zookeeperLocalhostAffinity;
  // session timeout, the high default is used by config servers
  private final IntegerNode zookeeperSessionTimeoutSeconds;
  // Jute maxbuffer. Used by zookeeper to determine max buffer when serializing/deserializing
  // Value used in server must equal or than this one (so if decreasing it one must be sure
  // that no client needs to use more bytes than this), see corresponding field in zookeeper-server.def
  private final IntegerNode juteMaxBuffer;

  public CuratorConfig(Builder builder) {
    this(builder, true);
  }

  private CuratorConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "curator must be initialized: " + builder.__uninitialized);

    server = Server.createVector(builder.server);
    zookeeperLocalhostAffinity = (builder.zookeeperLocalhostAffinity == null) ?
        new BooleanNode(false) : new BooleanNode(builder.zookeeperLocalhostAffinity);
    zookeeperSessionTimeoutSeconds = (builder.zookeeperSessionTimeoutSeconds == null) ?
        new IntegerNode(120) : new IntegerNode(builder.zookeeperSessionTimeoutSeconds);
    juteMaxBuffer = (builder.juteMaxBuffer == null) ?
        new IntegerNode(52428800) : new IntegerNode(builder.juteMaxBuffer);
  }

  /**
   * @return curator.server[]
   */
  public List<Server> server() {
    return server;
  }

  /**
   * @param i the index of the value to return
   * @return curator.server[]
   */
  public Server server(int i) {
    return server.get(i);
  }

  /**
   * @return curator.zookeeperLocalhostAffinity
   */
  public boolean zookeeperLocalhostAffinity() {
    return zookeeperLocalhostAffinity.value();
  }

  /**
   * @return curator.zookeeperSessionTimeoutSeconds
   */
  public int zookeeperSessionTimeoutSeconds() {
    return zookeeperSessionTimeoutSeconds.value();
  }

  /**
   * @return curator.juteMaxBuffer
   */
  public int juteMaxBuffer() {
    return juteMaxBuffer.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(CuratorConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("curator");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents curator.server[]
   */
  public final static class Server extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "hostname"
        ));

      private String hostname = null;
      private Integer port = null;

      public Builder() { }

      public Builder(Server config) {
        hostname(config.hostname());
        port(config.port());
      }

      private Builder override(Builder __superior) {
        if (__superior.hostname != null)
          hostname(__superior.hostname);
        if (__superior.port != null)
          port(__superior.port);
        return this;
      }

      public Builder hostname(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        hostname = __value;
        __uninitialized.remove("hostname");
        return this;
      }


      public Builder port(int __value) {
        port = __value;
        return this;
      }

      private Builder port(String __value) {
        return port(Integer.valueOf(__value));
      }

      public Server build() {
        return new Server(this);
      }

    }

    // hostname and port of servers that curator will connect to
    private final StringNode hostname;
    private final IntegerNode port;

    public Server(Builder builder) {
      this(builder, true);
    }

    private Server(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "curator.server[] must be initialized: " + builder.__uninitialized);

      hostname = (builder.hostname == null) ?
          new StringNode() : new StringNode(builder.hostname);
      port = (builder.port == null) ?
          new IntegerNode(2181) : new IntegerNode(builder.port);
    }

    /**
     * @return curator.server[].hostname
     */
    public String hostname() {
      return hostname.value();
    }

    /**
     * @return curator.server[].port
     */
    public int port() {
      return port.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Server newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("server");
      return changes;
    }

    private static InnerNodeVector<Server> createVector(List<Builder> builders) {
        List<Server> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Server(b));
        }
        return new InnerNodeVector<Server>(elems);
    }
  }

}
