// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.cloud.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of configserver
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class ConfigserverConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "3540a5404b21db60ef5ba53535322be1";
  public final static String CONFIG_DEF_NAME = "configserver";
  public final static String CONFIG_DEF_NAMESPACE = "cloud.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=cloud.config",
    "rpcport int default=19070",
    "httpport int default=19071",
    "numRpcThreads int default=0",
    "zookeeperserver[].hostname string",
    "zookeeperserver[].port int default=2181",
    "zookeeper.barrierTimeout long default=360",
    "zookeeperLocalhostAffinity bool default=true",
    "sessionLifetime long default=3600",
    "barrierWaitForAllTimeout long default=5",
    "configModelPluginDir[] string",
    "configServerDBDir string default=\"var/db/vespa/config_server/serverdb/\"",
    "configDefinitionsDir string default=\"share/vespa/configdefinitions/\"",
    "fileReferencesDir string default=\"var/db/vespa/filedistribution/\"",
    "maxApplicationPackageSize long default=8589934592",
    "masterGeneration long default=0",
    "multitenant bool default=false",
    "numDelayedResponseThreads int default=1",
    "serverId string default=\"localhost\"",
    "hostedVespa bool default=false",
    "numParallelTenantLoaders int default=4",
    "numRedeploymentThreads int default=4",
    "applicationDirectory string default=\"conf/configserver-app\"",
    "cloud string default=\"default\"",
    "environment string default=\"prod\"",
    "region string default=\"default\"",
    "system string default=\"main\"",
    "zoneDnsSuffixes[] string",
    "maxgetconfigclients int default=1000000",
    "maxoutputbuffersize int default=65536",
    "useVespaVersionInRequest bool default=true",
    "payloadCompressionType enum { UNCOMPRESSED, LZ4 } default=LZ4",
    "loadBalancerAddress string default=\"\"",
    "athenzDnsSuffix string default=\"\"",
    "ztsUrl string default=\"\"",
    "tenantSecretDomain string default=\"\"",
    "maintainerIntervalMinutes int default=30",
    "keepUnusedFileReferencesMinutes int default=300",
    "keepSessionsWithUnknownStatusHours int default=3",
    "maxDurationOfBootstrap long default=7200",
    "sleepTimeWhenRedeployingFails long default=15",
    "canReturnEmptySentinelConfig bool default=false",
    "serverNodeType enum {config, controller} default=config"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer rpcport = null;
    private Integer httpport = null;
    private Integer numRpcThreads = null;
    public List<Zookeeperserver.Builder> zookeeperserver = new ArrayList<>();
    public Zookeeper.Builder zookeeper = new Zookeeper.Builder();
    private Boolean zookeeperLocalhostAffinity = null;
    private Long sessionLifetime = null;
    private Long barrierWaitForAllTimeout = null;
    public List<String> configModelPluginDir = new ArrayList<>();
    private String configServerDBDir = null;
    private String configDefinitionsDir = null;
    private String fileReferencesDir = null;
    private Long maxApplicationPackageSize = null;
    private Long masterGeneration = null;
    private Boolean multitenant = null;
    private Integer numDelayedResponseThreads = null;
    private String serverId = null;
    private Boolean hostedVespa = null;
    private Integer numParallelTenantLoaders = null;
    private Integer numRedeploymentThreads = null;
    private String applicationDirectory = null;
    private String cloud = null;
    private String environment = null;
    private String region = null;
    private String system = null;
    public List<String> zoneDnsSuffixes = new ArrayList<>();
    private Integer maxgetconfigclients = null;
    private Integer maxoutputbuffersize = null;
    private Boolean useVespaVersionInRequest = null;
    private PayloadCompressionType.Enum payloadCompressionType = null;
    private String loadBalancerAddress = null;
    private String athenzDnsSuffix = null;
    private String ztsUrl = null;
    private String tenantSecretDomain = null;
    private Integer maintainerIntervalMinutes = null;
    private Integer keepUnusedFileReferencesMinutes = null;
    private Integer keepSessionsWithUnknownStatusHours = null;
    private Long maxDurationOfBootstrap = null;
    private Long sleepTimeWhenRedeployingFails = null;
    private Boolean canReturnEmptySentinelConfig = null;
    private ServerNodeType.Enum serverNodeType = null;

    public Builder() { }

    public Builder(ConfigserverConfig config) {
      rpcport(config.rpcport());
      httpport(config.httpport());
      numRpcThreads(config.numRpcThreads());
      for (Zookeeperserver z : config.zookeeperserver()) {
        zookeeperserver(new Zookeeperserver.Builder(z));
      }
      zookeeper(new Zookeeper.Builder(config.zookeeper()));
      zookeeperLocalhostAffinity(config.zookeeperLocalhostAffinity());
      sessionLifetime(config.sessionLifetime());
      barrierWaitForAllTimeout(config.barrierWaitForAllTimeout());
      configModelPluginDir(config.configModelPluginDir());
      configServerDBDir(config.configServerDBDir());
      configDefinitionsDir(config.configDefinitionsDir());
      fileReferencesDir(config.fileReferencesDir());
      maxApplicationPackageSize(config.maxApplicationPackageSize());
      masterGeneration(config.masterGeneration());
      multitenant(config.multitenant());
      numDelayedResponseThreads(config.numDelayedResponseThreads());
      serverId(config.serverId());
      hostedVespa(config.hostedVespa());
      numParallelTenantLoaders(config.numParallelTenantLoaders());
      numRedeploymentThreads(config.numRedeploymentThreads());
      applicationDirectory(config.applicationDirectory());
      cloud(config.cloud());
      environment(config.environment());
      region(config.region());
      system(config.system());
      zoneDnsSuffixes(config.zoneDnsSuffixes());
      maxgetconfigclients(config.maxgetconfigclients());
      maxoutputbuffersize(config.maxoutputbuffersize());
      useVespaVersionInRequest(config.useVespaVersionInRequest());
      payloadCompressionType(config.payloadCompressionType());
      loadBalancerAddress(config.loadBalancerAddress());
      athenzDnsSuffix(config.athenzDnsSuffix());
      ztsUrl(config.ztsUrl());
      tenantSecretDomain(config.tenantSecretDomain());
      maintainerIntervalMinutes(config.maintainerIntervalMinutes());
      keepUnusedFileReferencesMinutes(config.keepUnusedFileReferencesMinutes());
      keepSessionsWithUnknownStatusHours(config.keepSessionsWithUnknownStatusHours());
      maxDurationOfBootstrap(config.maxDurationOfBootstrap());
      sleepTimeWhenRedeployingFails(config.sleepTimeWhenRedeployingFails());
      canReturnEmptySentinelConfig(config.canReturnEmptySentinelConfig());
      serverNodeType(config.serverNodeType());
    }

    private Builder override(Builder __superior) {
      if (__superior.rpcport != null)
        rpcport(__superior.rpcport);
      if (__superior.httpport != null)
        httpport(__superior.httpport);
      if (__superior.numRpcThreads != null)
        numRpcThreads(__superior.numRpcThreads);
      if (!__superior.zookeeperserver.isEmpty())
        zookeeperserver.addAll(__superior.zookeeperserver);
      zookeeper(zookeeper.override(__superior.zookeeper));
      if (__superior.zookeeperLocalhostAffinity != null)
        zookeeperLocalhostAffinity(__superior.zookeeperLocalhostAffinity);
      if (__superior.sessionLifetime != null)
        sessionLifetime(__superior.sessionLifetime);
      if (__superior.barrierWaitForAllTimeout != null)
        barrierWaitForAllTimeout(__superior.barrierWaitForAllTimeout);
      if (!__superior.configModelPluginDir.isEmpty())
        configModelPluginDir.addAll(__superior.configModelPluginDir);
      if (__superior.configServerDBDir != null)
        configServerDBDir(__superior.configServerDBDir);
      if (__superior.configDefinitionsDir != null)
        configDefinitionsDir(__superior.configDefinitionsDir);
      if (__superior.fileReferencesDir != null)
        fileReferencesDir(__superior.fileReferencesDir);
      if (__superior.maxApplicationPackageSize != null)
        maxApplicationPackageSize(__superior.maxApplicationPackageSize);
      if (__superior.masterGeneration != null)
        masterGeneration(__superior.masterGeneration);
      if (__superior.multitenant != null)
        multitenant(__superior.multitenant);
      if (__superior.numDelayedResponseThreads != null)
        numDelayedResponseThreads(__superior.numDelayedResponseThreads);
      if (__superior.serverId != null)
        serverId(__superior.serverId);
      if (__superior.hostedVespa != null)
        hostedVespa(__superior.hostedVespa);
      if (__superior.numParallelTenantLoaders != null)
        numParallelTenantLoaders(__superior.numParallelTenantLoaders);
      if (__superior.numRedeploymentThreads != null)
        numRedeploymentThreads(__superior.numRedeploymentThreads);
      if (__superior.applicationDirectory != null)
        applicationDirectory(__superior.applicationDirectory);
      if (__superior.cloud != null)
        cloud(__superior.cloud);
      if (__superior.environment != null)
        environment(__superior.environment);
      if (__superior.region != null)
        region(__superior.region);
      if (__superior.system != null)
        system(__superior.system);
      if (!__superior.zoneDnsSuffixes.isEmpty())
        zoneDnsSuffixes.addAll(__superior.zoneDnsSuffixes);
      if (__superior.maxgetconfigclients != null)
        maxgetconfigclients(__superior.maxgetconfigclients);
      if (__superior.maxoutputbuffersize != null)
        maxoutputbuffersize(__superior.maxoutputbuffersize);
      if (__superior.useVespaVersionInRequest != null)
        useVespaVersionInRequest(__superior.useVespaVersionInRequest);
      if (__superior.payloadCompressionType != null)
        payloadCompressionType(__superior.payloadCompressionType);
      if (__superior.loadBalancerAddress != null)
        loadBalancerAddress(__superior.loadBalancerAddress);
      if (__superior.athenzDnsSuffix != null)
        athenzDnsSuffix(__superior.athenzDnsSuffix);
      if (__superior.ztsUrl != null)
        ztsUrl(__superior.ztsUrl);
      if (__superior.tenantSecretDomain != null)
        tenantSecretDomain(__superior.tenantSecretDomain);
      if (__superior.maintainerIntervalMinutes != null)
        maintainerIntervalMinutes(__superior.maintainerIntervalMinutes);
      if (__superior.keepUnusedFileReferencesMinutes != null)
        keepUnusedFileReferencesMinutes(__superior.keepUnusedFileReferencesMinutes);
      if (__superior.keepSessionsWithUnknownStatusHours != null)
        keepSessionsWithUnknownStatusHours(__superior.keepSessionsWithUnknownStatusHours);
      if (__superior.maxDurationOfBootstrap != null)
        maxDurationOfBootstrap(__superior.maxDurationOfBootstrap);
      if (__superior.sleepTimeWhenRedeployingFails != null)
        sleepTimeWhenRedeployingFails(__superior.sleepTimeWhenRedeployingFails);
      if (__superior.canReturnEmptySentinelConfig != null)
        canReturnEmptySentinelConfig(__superior.canReturnEmptySentinelConfig);
      if (__superior.serverNodeType != null)
        serverNodeType(__superior.serverNodeType);
      return this;
    }

    public Builder rpcport(int __value) {
      rpcport = __value;
      return this;
    }

    private Builder rpcport(String __value) {
      return rpcport(Integer.valueOf(__value));
    }

    public Builder httpport(int __value) {
      httpport = __value;
      return this;
    }

    private Builder httpport(String __value) {
      return httpport(Integer.valueOf(__value));
    }

    public Builder numRpcThreads(int __value) {
      numRpcThreads = __value;
      return this;
    }

    private Builder numRpcThreads(String __value) {
      return numRpcThreads(Integer.valueOf(__value));
    }

    /**
     * Add the given builder to this builder's list of Zookeeperserver builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder zookeeperserver(Zookeeperserver.Builder __builder) {
      zookeeperserver.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder zookeeperserver(java.util.function.Consumer<Zookeeperserver.Builder> __func) {
      Zookeeperserver.Builder __inner = new Zookeeperserver.Builder();
      __func.accept(__inner);
      zookeeperserver.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Zookeeperserver builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder zookeeperserver(List<Zookeeperserver.Builder> __builders) {
      zookeeperserver = __builders;
      return this;
    }

    public Builder zookeeper(Zookeeper.Builder __builder) {
      zookeeper = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder zookeeper(java.util.function.Consumer<Zookeeper.Builder> __func) {
      Zookeeper.Builder __inner = new Zookeeper.Builder();
      __func.accept(__inner);
      zookeeper = __inner;
      return this;
    }

    public Builder zookeeperLocalhostAffinity(boolean __value) {
      zookeeperLocalhostAffinity = __value;
      return this;
    }

    private Builder zookeeperLocalhostAffinity(String __value) {
      return zookeeperLocalhostAffinity(Boolean.valueOf(__value));
    }

    public Builder sessionLifetime(long __value) {
      sessionLifetime = __value;
      return this;
    }

    private Builder sessionLifetime(String __value) {
      return sessionLifetime(Long.valueOf(__value));
    }

    public Builder barrierWaitForAllTimeout(long __value) {
      barrierWaitForAllTimeout = __value;
      return this;
    }

    private Builder barrierWaitForAllTimeout(String __value) {
      return barrierWaitForAllTimeout(Long.valueOf(__value));
    }

    public Builder configModelPluginDir(String __value) {
      configModelPluginDir.add(__value);
      return this;
    }

    public Builder configModelPluginDir(Collection<String> __values) {
      configModelPluginDir.addAll(__values);
      return this;
    }

    public Builder configServerDBDir(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      configServerDBDir = __value;
      return this;
    }


    public Builder configDefinitionsDir(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      configDefinitionsDir = __value;
      return this;
    }


    public Builder fileReferencesDir(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      fileReferencesDir = __value;
      return this;
    }


    public Builder maxApplicationPackageSize(long __value) {
      maxApplicationPackageSize = __value;
      return this;
    }

    private Builder maxApplicationPackageSize(String __value) {
      return maxApplicationPackageSize(Long.valueOf(__value));
    }

    public Builder masterGeneration(long __value) {
      masterGeneration = __value;
      return this;
    }

    private Builder masterGeneration(String __value) {
      return masterGeneration(Long.valueOf(__value));
    }

    public Builder multitenant(boolean __value) {
      multitenant = __value;
      return this;
    }

    private Builder multitenant(String __value) {
      return multitenant(Boolean.valueOf(__value));
    }

    public Builder numDelayedResponseThreads(int __value) {
      numDelayedResponseThreads = __value;
      return this;
    }

    private Builder numDelayedResponseThreads(String __value) {
      return numDelayedResponseThreads(Integer.valueOf(__value));
    }

    public Builder serverId(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      serverId = __value;
      return this;
    }


    public Builder hostedVespa(boolean __value) {
      hostedVespa = __value;
      return this;
    }

    private Builder hostedVespa(String __value) {
      return hostedVespa(Boolean.valueOf(__value));
    }

    public Builder numParallelTenantLoaders(int __value) {
      numParallelTenantLoaders = __value;
      return this;
    }

    private Builder numParallelTenantLoaders(String __value) {
      return numParallelTenantLoaders(Integer.valueOf(__value));
    }

    public Builder numRedeploymentThreads(int __value) {
      numRedeploymentThreads = __value;
      return this;
    }

    private Builder numRedeploymentThreads(String __value) {
      return numRedeploymentThreads(Integer.valueOf(__value));
    }

    public Builder applicationDirectory(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      applicationDirectory = __value;
      return this;
    }


    public Builder cloud(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      cloud = __value;
      return this;
    }


    public Builder environment(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      environment = __value;
      return this;
    }


    public Builder region(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      region = __value;
      return this;
    }


    public Builder system(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      system = __value;
      return this;
    }


    public Builder zoneDnsSuffixes(String __value) {
      zoneDnsSuffixes.add(__value);
      return this;
    }

    public Builder zoneDnsSuffixes(Collection<String> __values) {
      zoneDnsSuffixes.addAll(__values);
      return this;
    }

    public Builder maxgetconfigclients(int __value) {
      maxgetconfigclients = __value;
      return this;
    }

    private Builder maxgetconfigclients(String __value) {
      return maxgetconfigclients(Integer.valueOf(__value));
    }

    public Builder maxoutputbuffersize(int __value) {
      maxoutputbuffersize = __value;
      return this;
    }

    private Builder maxoutputbuffersize(String __value) {
      return maxoutputbuffersize(Integer.valueOf(__value));
    }

    public Builder useVespaVersionInRequest(boolean __value) {
      useVespaVersionInRequest = __value;
      return this;
    }

    private Builder useVespaVersionInRequest(String __value) {
      return useVespaVersionInRequest(Boolean.valueOf(__value));
    }

    public Builder payloadCompressionType(PayloadCompressionType.Enum __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      payloadCompressionType = __value;
      return this;
    }

    private Builder payloadCompressionType(String __value) {
      return payloadCompressionType(PayloadCompressionType.Enum.valueOf(__value));
    }

    public Builder loadBalancerAddress(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      loadBalancerAddress = __value;
      return this;
    }


    public Builder athenzDnsSuffix(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      athenzDnsSuffix = __value;
      return this;
    }


    public Builder ztsUrl(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      ztsUrl = __value;
      return this;
    }


    public Builder tenantSecretDomain(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      tenantSecretDomain = __value;
      return this;
    }


    public Builder maintainerIntervalMinutes(int __value) {
      maintainerIntervalMinutes = __value;
      return this;
    }

    private Builder maintainerIntervalMinutes(String __value) {
      return maintainerIntervalMinutes(Integer.valueOf(__value));
    }

    public Builder keepUnusedFileReferencesMinutes(int __value) {
      keepUnusedFileReferencesMinutes = __value;
      return this;
    }

    private Builder keepUnusedFileReferencesMinutes(String __value) {
      return keepUnusedFileReferencesMinutes(Integer.valueOf(__value));
    }

    public Builder keepSessionsWithUnknownStatusHours(int __value) {
      keepSessionsWithUnknownStatusHours = __value;
      return this;
    }

    private Builder keepSessionsWithUnknownStatusHours(String __value) {
      return keepSessionsWithUnknownStatusHours(Integer.valueOf(__value));
    }

    public Builder maxDurationOfBootstrap(long __value) {
      maxDurationOfBootstrap = __value;
      return this;
    }

    private Builder maxDurationOfBootstrap(String __value) {
      return maxDurationOfBootstrap(Long.valueOf(__value));
    }

    public Builder sleepTimeWhenRedeployingFails(long __value) {
      sleepTimeWhenRedeployingFails = __value;
      return this;
    }

    private Builder sleepTimeWhenRedeployingFails(String __value) {
      return sleepTimeWhenRedeployingFails(Long.valueOf(__value));
    }

    public Builder canReturnEmptySentinelConfig(boolean __value) {
      canReturnEmptySentinelConfig = __value;
      return this;
    }

    private Builder canReturnEmptySentinelConfig(String __value) {
      return canReturnEmptySentinelConfig(Boolean.valueOf(__value));
    }

    public Builder serverNodeType(ServerNodeType.Enum __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      serverNodeType = __value;
      return this;
    }

    private Builder serverNodeType(String __value) {
      return serverNodeType(ServerNodeType.Enum.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ConfigserverConfig build() {
      return new ConfigserverConfig(this);
    }

  }

  // Ports
  private final IntegerNode rpcport;
  private final IntegerNode httpport;
  // 0 means use the number of CPU cores available
  private final IntegerNode numRpcThreads;
  private final InnerNodeVector<Zookeeperserver> zookeeperserver;
  private final Zookeeper zookeeper;
  private final BooleanNode zookeeperLocalhostAffinity;
  private final LongNode sessionLifetime;
  // How long to wait for all ZooKeeper servers to reach barrier after quorum has reached barrier. In seconds
  private final LongNode barrierWaitForAllTimeout;
  // Directories
  private final LeafNodeVector<String, StringNode> configModelPluginDir;
  private final StringNode configServerDBDir;
  private final StringNode configDefinitionsDir;
  private final StringNode fileReferencesDir;
  // Application package
  // The maximum decompressed size of an application package, in bytes. Defaults to 8 GB
  private final LongNode maxApplicationPackageSize;
  // Misc
  private final LongNode masterGeneration;
  private final BooleanNode multitenant;
  private final IntegerNode numDelayedResponseThreads;
  private final StringNode serverId;
  private final BooleanNode hostedVespa;
  private final IntegerNode numParallelTenantLoaders;
  private final IntegerNode numRedeploymentThreads;
  // Configserver app
  private final StringNode applicationDirectory;
  // Zone information
  private final StringNode cloud;
  private final StringNode environment;
  private final StringNode region;
  private final StringNode system;
  // TODO: Unused, remove in Vespa 9 at the latest
  private final LeafNodeVector<String, StringNode> zoneDnsSuffixes;
  // RPC protocol
  private final IntegerNode maxgetconfigclients;
  private final IntegerNode maxoutputbuffersize;
  private final BooleanNode useVespaVersionInRequest;
  private final PayloadCompressionType payloadCompressionType;
  // Athenz config
  private final StringNode loadBalancerAddress;
  private final StringNode athenzDnsSuffix;
  private final StringNode ztsUrl;
  private final StringNode tenantSecretDomain;
  // Maintenance settings
  private final IntegerNode maintainerIntervalMinutes;
  private final IntegerNode keepUnusedFileReferencesMinutes;
  private final IntegerNode keepSessionsWithUnknownStatusHours;
  // Bootstrapping
  // How long bootstrapping can take before giving up (in seconds)
  private final LongNode maxDurationOfBootstrap;
  // Initial time for how long to sleep before redeploying again if it fails (in seconds)
  // Code uses backoff, so wait time will increase for every iteration
  private final LongNode sleepTimeWhenRedeployingFails;
  private final BooleanNode canReturnEmptySentinelConfig;
  private final ServerNodeType serverNodeType;

  public ConfigserverConfig(Builder builder) {
    this(builder, true);
  }

  private ConfigserverConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "configserver must be initialized: " + builder.__uninitialized);

    rpcport = (builder.rpcport == null) ?
        new IntegerNode(19070) : new IntegerNode(builder.rpcport);
    httpport = (builder.httpport == null) ?
        new IntegerNode(19071) : new IntegerNode(builder.httpport);
    numRpcThreads = (builder.numRpcThreads == null) ?
        new IntegerNode(0) : new IntegerNode(builder.numRpcThreads);
    zookeeperserver = Zookeeperserver.createVector(builder.zookeeperserver);
    zookeeper = new Zookeeper(builder.zookeeper, throwIfUninitialized);
    zookeeperLocalhostAffinity = (builder.zookeeperLocalhostAffinity == null) ?
        new BooleanNode(true) : new BooleanNode(builder.zookeeperLocalhostAffinity);
    sessionLifetime = (builder.sessionLifetime == null) ?
        new LongNode(3600L) : new LongNode(builder.sessionLifetime);
    barrierWaitForAllTimeout = (builder.barrierWaitForAllTimeout == null) ?
        new LongNode(5L) : new LongNode(builder.barrierWaitForAllTimeout);
    configModelPluginDir = new LeafNodeVector<>(builder.configModelPluginDir, new StringNode());
    configServerDBDir = (builder.configServerDBDir == null) ?
        new StringNode("var/db/vespa/config_server/serverdb/") : new StringNode(builder.configServerDBDir);
    configDefinitionsDir = (builder.configDefinitionsDir == null) ?
        new StringNode("share/vespa/configdefinitions/") : new StringNode(builder.configDefinitionsDir);
    fileReferencesDir = (builder.fileReferencesDir == null) ?
        new StringNode("var/db/vespa/filedistribution/") : new StringNode(builder.fileReferencesDir);
    maxApplicationPackageSize = (builder.maxApplicationPackageSize == null) ?
        new LongNode(8589934592L) : new LongNode(builder.maxApplicationPackageSize);
    masterGeneration = (builder.masterGeneration == null) ?
        new LongNode(0L) : new LongNode(builder.masterGeneration);
    multitenant = (builder.multitenant == null) ?
        new BooleanNode(false) : new BooleanNode(builder.multitenant);
    numDelayedResponseThreads = (builder.numDelayedResponseThreads == null) ?
        new IntegerNode(1) : new IntegerNode(builder.numDelayedResponseThreads);
    serverId = (builder.serverId == null) ?
        new StringNode("localhost") : new StringNode(builder.serverId);
    hostedVespa = (builder.hostedVespa == null) ?
        new BooleanNode(false) : new BooleanNode(builder.hostedVespa);
    numParallelTenantLoaders = (builder.numParallelTenantLoaders == null) ?
        new IntegerNode(4) : new IntegerNode(builder.numParallelTenantLoaders);
    numRedeploymentThreads = (builder.numRedeploymentThreads == null) ?
        new IntegerNode(4) : new IntegerNode(builder.numRedeploymentThreads);
    applicationDirectory = (builder.applicationDirectory == null) ?
        new StringNode("conf/configserver-app") : new StringNode(builder.applicationDirectory);
    cloud = (builder.cloud == null) ?
        new StringNode("default") : new StringNode(builder.cloud);
    environment = (builder.environment == null) ?
        new StringNode("prod") : new StringNode(builder.environment);
    region = (builder.region == null) ?
        new StringNode("default") : new StringNode(builder.region);
    system = (builder.system == null) ?
        new StringNode("main") : new StringNode(builder.system);
    zoneDnsSuffixes = new LeafNodeVector<>(builder.zoneDnsSuffixes, new StringNode());
    maxgetconfigclients = (builder.maxgetconfigclients == null) ?
        new IntegerNode(1000000) : new IntegerNode(builder.maxgetconfigclients);
    maxoutputbuffersize = (builder.maxoutputbuffersize == null) ?
        new IntegerNode(65536) : new IntegerNode(builder.maxoutputbuffersize);
    useVespaVersionInRequest = (builder.useVespaVersionInRequest == null) ?
        new BooleanNode(true) : new BooleanNode(builder.useVespaVersionInRequest);
    payloadCompressionType = (builder.payloadCompressionType == null) ?
        new PayloadCompressionType(PayloadCompressionType.LZ4) : new PayloadCompressionType(builder.payloadCompressionType);
    loadBalancerAddress = (builder.loadBalancerAddress == null) ?
        new StringNode("") : new StringNode(builder.loadBalancerAddress);
    athenzDnsSuffix = (builder.athenzDnsSuffix == null) ?
        new StringNode("") : new StringNode(builder.athenzDnsSuffix);
    ztsUrl = (builder.ztsUrl == null) ?
        new StringNode("") : new StringNode(builder.ztsUrl);
    tenantSecretDomain = (builder.tenantSecretDomain == null) ?
        new StringNode("") : new StringNode(builder.tenantSecretDomain);
    maintainerIntervalMinutes = (builder.maintainerIntervalMinutes == null) ?
        new IntegerNode(30) : new IntegerNode(builder.maintainerIntervalMinutes);
    keepUnusedFileReferencesMinutes = (builder.keepUnusedFileReferencesMinutes == null) ?
        new IntegerNode(300) : new IntegerNode(builder.keepUnusedFileReferencesMinutes);
    keepSessionsWithUnknownStatusHours = (builder.keepSessionsWithUnknownStatusHours == null) ?
        new IntegerNode(3) : new IntegerNode(builder.keepSessionsWithUnknownStatusHours);
    maxDurationOfBootstrap = (builder.maxDurationOfBootstrap == null) ?
        new LongNode(7200L) : new LongNode(builder.maxDurationOfBootstrap);
    sleepTimeWhenRedeployingFails = (builder.sleepTimeWhenRedeployingFails == null) ?
        new LongNode(15L) : new LongNode(builder.sleepTimeWhenRedeployingFails);
    canReturnEmptySentinelConfig = (builder.canReturnEmptySentinelConfig == null) ?
        new BooleanNode(false) : new BooleanNode(builder.canReturnEmptySentinelConfig);
    serverNodeType = (builder.serverNodeType == null) ?
        new ServerNodeType(ServerNodeType.config) : new ServerNodeType(builder.serverNodeType);
  }

  /**
   * @return configserver.rpcport
   */
  public int rpcport() {
    return rpcport.value();
  }

  /**
   * @return configserver.httpport
   */
  public int httpport() {
    return httpport.value();
  }

  /**
   * @return configserver.numRpcThreads
   */
  public int numRpcThreads() {
    return numRpcThreads.value();
  }

  /**
   * @return configserver.zookeeperserver[]
   */
  public List<Zookeeperserver> zookeeperserver() {
    return zookeeperserver;
  }

  /**
   * @param i the index of the value to return
   * @return configserver.zookeeperserver[]
   */
  public Zookeeperserver zookeeperserver(int i) {
    return zookeeperserver.get(i);
  }

  /**
   * @return configserver.zookeeper
   */
  public Zookeeper zookeeper() {
    return zookeeper;
  }

  /**
   * @return configserver.zookeeperLocalhostAffinity
   */
  public boolean zookeeperLocalhostAffinity() {
    return zookeeperLocalhostAffinity.value();
  }

  /**
   * @return configserver.sessionLifetime
   */
  public long sessionLifetime() {
    return sessionLifetime.value();
  }

  /**
   * @return configserver.barrierWaitForAllTimeout
   */
  public long barrierWaitForAllTimeout() {
    return barrierWaitForAllTimeout.value();
  }

  /**
   * @return configserver.configModelPluginDir[]
   */
  public List<String> configModelPluginDir() {
    return configModelPluginDir.asList();
  }

  /**
   * @param i the index of the value to return
   * @return configserver.configModelPluginDir[]
   */
  public String configModelPluginDir(int i) {
    return configModelPluginDir.get(i).value();
  }

  /**
   * @return configserver.configServerDBDir
   */
  public String configServerDBDir() {
    return configServerDBDir.value();
  }

  /**
   * @return configserver.configDefinitionsDir
   */
  public String configDefinitionsDir() {
    return configDefinitionsDir.value();
  }

  /**
   * @return configserver.fileReferencesDir
   */
  public String fileReferencesDir() {
    return fileReferencesDir.value();
  }

  /**
   * @return configserver.maxApplicationPackageSize
   */
  public long maxApplicationPackageSize() {
    return maxApplicationPackageSize.value();
  }

  /**
   * @return configserver.masterGeneration
   */
  public long masterGeneration() {
    return masterGeneration.value();
  }

  /**
   * @return configserver.multitenant
   */
  public boolean multitenant() {
    return multitenant.value();
  }

  /**
   * @return configserver.numDelayedResponseThreads
   */
  public int numDelayedResponseThreads() {
    return numDelayedResponseThreads.value();
  }

  /**
   * @return configserver.serverId
   */
  public String serverId() {
    return serverId.value();
  }

  /**
   * @return configserver.hostedVespa
   */
  public boolean hostedVespa() {
    return hostedVespa.value();
  }

  /**
   * @return configserver.numParallelTenantLoaders
   */
  public int numParallelTenantLoaders() {
    return numParallelTenantLoaders.value();
  }

  /**
   * @return configserver.numRedeploymentThreads
   */
  public int numRedeploymentThreads() {
    return numRedeploymentThreads.value();
  }

  /**
   * @return configserver.applicationDirectory
   */
  public String applicationDirectory() {
    return applicationDirectory.value();
  }

  /**
   * @return configserver.cloud
   */
  public String cloud() {
    return cloud.value();
  }

  /**
   * @return configserver.environment
   */
  public String environment() {
    return environment.value();
  }

  /**
   * @return configserver.region
   */
  public String region() {
    return region.value();
  }

  /**
   * @return configserver.system
   */
  public String system() {
    return system.value();
  }

  /**
   * @return configserver.zoneDnsSuffixes[]
   */
  public List<String> zoneDnsSuffixes() {
    return zoneDnsSuffixes.asList();
  }

  /**
   * @param i the index of the value to return
   * @return configserver.zoneDnsSuffixes[]
   */
  public String zoneDnsSuffixes(int i) {
    return zoneDnsSuffixes.get(i).value();
  }

  /**
   * @return configserver.maxgetconfigclients
   */
  public int maxgetconfigclients() {
    return maxgetconfigclients.value();
  }

  /**
   * @return configserver.maxoutputbuffersize
   */
  public int maxoutputbuffersize() {
    return maxoutputbuffersize.value();
  }

  /**
   * @return configserver.useVespaVersionInRequest
   */
  public boolean useVespaVersionInRequest() {
    return useVespaVersionInRequest.value();
  }

  /**
   * @return configserver.payloadCompressionType
   */
  public PayloadCompressionType.Enum payloadCompressionType() {
    return payloadCompressionType.value();
  }

  /**
   * @return configserver.loadBalancerAddress
   */
  public String loadBalancerAddress() {
    return loadBalancerAddress.value();
  }

  /**
   * @return configserver.athenzDnsSuffix
   */
  public String athenzDnsSuffix() {
    return athenzDnsSuffix.value();
  }

  /**
   * @return configserver.ztsUrl
   */
  public String ztsUrl() {
    return ztsUrl.value();
  }

  /**
   * @return configserver.tenantSecretDomain
   */
  public String tenantSecretDomain() {
    return tenantSecretDomain.value();
  }

  /**
   * @return configserver.maintainerIntervalMinutes
   */
  public int maintainerIntervalMinutes() {
    return maintainerIntervalMinutes.value();
  }

  /**
   * @return configserver.keepUnusedFileReferencesMinutes
   */
  public int keepUnusedFileReferencesMinutes() {
    return keepUnusedFileReferencesMinutes.value();
  }

  /**
   * @return configserver.keepSessionsWithUnknownStatusHours
   */
  public int keepSessionsWithUnknownStatusHours() {
    return keepSessionsWithUnknownStatusHours.value();
  }

  /**
   * @return configserver.maxDurationOfBootstrap
   */
  public long maxDurationOfBootstrap() {
    return maxDurationOfBootstrap.value();
  }

  /**
   * @return configserver.sleepTimeWhenRedeployingFails
   */
  public long sleepTimeWhenRedeployingFails() {
    return sleepTimeWhenRedeployingFails.value();
  }

  /**
   * @return configserver.canReturnEmptySentinelConfig
   */
  public boolean canReturnEmptySentinelConfig() {
    return canReturnEmptySentinelConfig.value();
  }

  /**
   * @return configserver.serverNodeType
   */
  public ServerNodeType.Enum serverNodeType() {
    return serverNodeType.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ConfigserverConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("configserver");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents configserver.zookeeperserver[]
   */
  public final static class Zookeeperserver extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "hostname"
        ));

      private String hostname = null;
      private Integer port = null;

      public Builder() { }

      public Builder(Zookeeperserver config) {
        hostname(config.hostname());
        port(config.port());
      }

      private Builder override(Builder __superior) {
        if (__superior.hostname != null)
          hostname(__superior.hostname);
        if (__superior.port != null)
          port(__superior.port);
        return this;
      }

      public Builder hostname(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        hostname = __value;
        __uninitialized.remove("hostname");
        return this;
      }


      public Builder port(int __value) {
        port = __value;
        return this;
      }

      private Builder port(String __value) {
        return port(Integer.valueOf(__value));
      }

      public Zookeeperserver build() {
        return new Zookeeperserver(this);
      }

    }

    // ZooKeeper
    private final StringNode hostname;
    private final IntegerNode port;

    public Zookeeperserver(Builder builder) {
      this(builder, true);
    }

    private Zookeeperserver(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "configserver.zookeeperserver[] must be initialized: " + builder.__uninitialized);

      hostname = (builder.hostname == null) ?
          new StringNode() : new StringNode(builder.hostname);
      port = (builder.port == null) ?
          new IntegerNode(2181) : new IntegerNode(builder.port);
    }

    /**
     * @return configserver.zookeeperserver[].hostname
     */
    public String hostname() {
      return hostname.value();
    }

    /**
     * @return configserver.zookeeperserver[].port
     */
    public int port() {
      return port.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Zookeeperserver newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("zookeeperserver");
      return changes;
    }

    private static InnerNodeVector<Zookeeperserver> createVector(List<Builder> builders) {
        List<Zookeeperserver> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Zookeeperserver(b));
        }
        return new InnerNodeVector<Zookeeperserver>(elems);
    }
  }

  /**
   * This class represents configserver.zookeeper
   */
  public final static class Zookeeper extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Long barrierTimeout = null;

      public Builder() { }

      public Builder(Zookeeper config) {
        barrierTimeout(config.barrierTimeout());
      }

      private Builder override(Builder __superior) {
        if (__superior.barrierTimeout != null)
          barrierTimeout(__superior.barrierTimeout);
        return this;
      }

      public Builder barrierTimeout(long __value) {
        barrierTimeout = __value;
        return this;
      }

      private Builder barrierTimeout(String __value) {
        return barrierTimeout(Long.valueOf(__value));
      }

      public Zookeeper build() {
        return new Zookeeper(this);
      }

    }

    // ZK write timeout in seconds, must be long enough to write application packages to other nodes
    private final LongNode barrierTimeout;

    public Zookeeper(Builder builder) {
      this(builder, true);
    }

    private Zookeeper(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "configserver.zookeeper must be initialized: " + builder.__uninitialized);

      barrierTimeout = (builder.barrierTimeout == null) ?
          new LongNode(360L) : new LongNode(builder.barrierTimeout);
    }

    /**
     * @return configserver.zookeeper.barrierTimeout
     */
    public long barrierTimeout() {
      return barrierTimeout.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Zookeeper newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("zookeeper");
      return changes;
    }
  }

  /**
   * This class represents configserver.payloadCompressionType
   */
  public final static class PayloadCompressionType extends EnumNode<PayloadCompressionType.Enum> {

    public PayloadCompressionType(){
      this.value = null;
    }

    public PayloadCompressionType(Enum enumValue) {
      super(enumValue != null);
      this.value = enumValue;
    }

    public enum Enum {UNCOMPRESSED, LZ4}
    public final static Enum UNCOMPRESSED = Enum.UNCOMPRESSED;
    public final static Enum LZ4 = Enum.LZ4;

    @Override
    protected boolean doSetValue(String name) {
      try {
        value = Enum.valueOf(name);
        return true;
      } catch (IllegalArgumentException e) {
      }
      return false;
    }
  }

  /**
   * This class represents configserver.serverNodeType
   */
  public final static class ServerNodeType extends EnumNode<ServerNodeType.Enum> {

    public ServerNodeType(){
      this.value = null;
    }

    public ServerNodeType(Enum enumValue) {
      super(enumValue != null);
      this.value = enumValue;
    }

    public enum Enum {config, controller}
    public final static Enum config = Enum.config;
    public final static Enum controller = Enum.controller;

    @Override
    protected boolean doSetValue(String name) {
      try {
        value = Enum.valueOf(name);
        return true;
      } catch (IllegalArgumentException e) {
      }
      return false;
    }
  }

}
