// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.cloud.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of cluster-list
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class ClusterListConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "60753c6ae77aed1d217248dc8118fba7";
  public final static String CONFIG_DEF_NAME = "cluster-list";
  public final static String CONFIG_DEF_NAMESPACE = "cloud.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=cloud.config",
    "storage[].name string",
    "storage[].configid string default=\"\""
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Storage.Builder> storage = new ArrayList<>();

    public Builder() { }

    public Builder(ClusterListConfig config) {
      for (Storage s : config.storage()) {
        storage(new Storage.Builder(s));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.storage.isEmpty())
        storage.addAll(__superior.storage);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Storage builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder storage(Storage.Builder __builder) {
      storage.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder storage(java.util.function.Consumer<Storage.Builder> __func) {
      Storage.Builder __inner = new Storage.Builder();
      __func.accept(__inner);
      storage.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Storage builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder storage(List<Storage.Builder> __builders) {
      storage = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ClusterListConfig build() {
      return new ClusterListConfig(this);
    }

  }

  private final InnerNodeVector<Storage> storage;

  public ClusterListConfig(Builder builder) {
    this(builder, true);
  }

  private ClusterListConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "cluster-list must be initialized: " + builder.__uninitialized);

    storage = Storage.createVector(builder.storage);
  }

  /**
   * @return cluster-list.storage[]
   */
  public List<Storage> storage() {
    return storage;
  }

  /**
   * @param i the index of the value to return
   * @return cluster-list.storage[]
   */
  public Storage storage(int i) {
    return storage.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ClusterListConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("cluster-list");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents cluster-list.storage[]
   */
  public final static class Storage extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name"
        ));

      private String name = null;
      private String configid = null;

      public Builder() { }

      public Builder(Storage config) {
        name(config.name());
        configid(config.configid());
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.configid != null)
          configid(__superior.configid);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder configid(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        configid = __value;
        return this;
      }


      public Storage build() {
        return new Storage(this);
      }

    }

    private final StringNode name;
    private final StringNode configid;

    public Storage(Builder builder) {
      this(builder, true);
    }

    private Storage(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "cluster-list.storage[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      configid = (builder.configid == null) ?
          new StringNode("") : new StringNode(builder.configid);
    }

    /**
     * @return cluster-list.storage[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return cluster-list.storage[].configid
     */
    public String configid() {
      return configid.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Storage newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("storage");
      return changes;
    }

    private static InnerNodeVector<Storage> createVector(List<Builder> builders) {
        List<Storage> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Storage(b));
        }
        return new InnerNodeVector<Storage>(elems);
    }
  }

}
