// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.cloud.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of cluster-info
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 * Information about the cluster the subscriber is a part of
 */
public final class ClusterInfoConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "1ac343c1a3847be9291c3e07b7916f24";
  public final static String CONFIG_DEF_NAME = "cluster-info";
  public final static String CONFIG_DEF_NAMESPACE = "cloud.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=cloud.config",
    "clusterId string",
    "nodeCount int",
    "nodeIndices[] int",
    "services[].index int default=-1",
    "services[].hostname string default=\"(nohostname)\"",
    "services[].ports[].number int default=-1",
    "services[].ports[].tags string default=\"(notags)\""
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>(List.of(
      "clusterId",
      "nodeCount"
      ));

    private String clusterId = null;
    private Integer nodeCount = null;
    public List<Integer> nodeIndices = new ArrayList<>();
    public List<Services.Builder> services = new ArrayList<>();

    public Builder() { }

    public Builder(ClusterInfoConfig config) {
      clusterId(config.clusterId());
      nodeCount(config.nodeCount());
      nodeIndices(config.nodeIndices());
      for (Services s : config.services()) {
        services(new Services.Builder(s));
      }
    }

    private Builder override(Builder __superior) {
      if (__superior.clusterId != null)
        clusterId(__superior.clusterId);
      if (__superior.nodeCount != null)
        nodeCount(__superior.nodeCount);
      if (!__superior.nodeIndices.isEmpty())
        nodeIndices.addAll(__superior.nodeIndices);
      if (!__superior.services.isEmpty())
        services.addAll(__superior.services);
      return this;
    }

    public Builder clusterId(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      clusterId = __value;
      __uninitialized.remove("clusterId");
      return this;
    }


    public Builder nodeCount(int __value) {
      nodeCount = __value;
      __uninitialized.remove("nodeCount");
      return this;
    }

    private Builder nodeCount(String __value) {
      return nodeCount(Integer.valueOf(__value));
    }

    public Builder nodeIndices(Integer __value) {
      nodeIndices.add(__value);
      return this;
    }

    public Builder nodeIndices(Collection<Integer> __values) {
      nodeIndices.addAll(__values);
      return this;
    }

    private Builder nodeIndices(String __value) {
      return nodeIndices(Integer.valueOf(__value));
    }

    /**
     * Add the given builder to this builder's list of Services builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder services(Services.Builder __builder) {
      services.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder services(java.util.function.Consumer<Services.Builder> __func) {
      Services.Builder __inner = new Services.Builder();
      __func.accept(__inner);
      services.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Services builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder services(List<Services.Builder> __builders) {
      services = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ClusterInfoConfig build() {
      return new ClusterInfoConfig(this);
    }

  }

  // clusterId is same as clustername in model
  private final StringNode clusterId;
  private final IntegerNode nodeCount;
  private final LeafNodeVector<Integer, IntegerNode> nodeIndices;
  private final InnerNodeVector<Services> services;

  public ClusterInfoConfig(Builder builder) {
    this(builder, true);
  }

  private ClusterInfoConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "cluster-info must be initialized: " + builder.__uninitialized);

    clusterId = (builder.clusterId == null) ?
        new StringNode() : new StringNode(builder.clusterId);
    nodeCount = (builder.nodeCount == null) ?
        new IntegerNode() : new IntegerNode(builder.nodeCount);
    nodeIndices = new LeafNodeVector<>(builder.nodeIndices, new IntegerNode());
    services = Services.createVector(builder.services);
  }

  /**
   * @return cluster-info.clusterId
   */
  public String clusterId() {
    return clusterId.value();
  }

  /**
   * @return cluster-info.nodeCount
   */
  public int nodeCount() {
    return nodeCount.value();
  }

  /**
   * @return cluster-info.nodeIndices[]
   */
  public List<Integer> nodeIndices() {
    return nodeIndices.asList();
  }

  /**
   * @param i the index of the value to return
   * @return cluster-info.nodeIndices[]
   */
  public int nodeIndices(int i) {
    return nodeIndices.get(i).value();
  }

  /**
   * @return cluster-info.services[]
   */
  public List<Services> services() {
    return services;
  }

  /**
   * @param i the index of the value to return
   * @return cluster-info.services[]
   */
  public Services services(int i) {
    return services.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ClusterInfoConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("cluster-info");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents cluster-info.services[]
   */
  public final static class Services extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Integer index = null;
      private String hostname = null;
      public List<Ports.Builder> ports = new ArrayList<>();

      public Builder() { }

      public Builder(Services config) {
        index(config.index());
        hostname(config.hostname());
        for (Ports p : config.ports()) {
          ports(new Ports.Builder(p));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.index != null)
          index(__superior.index);
        if (__superior.hostname != null)
          hostname(__superior.hostname);
        if (!__superior.ports.isEmpty())
          ports.addAll(__superior.ports);
        return this;
      }

      public Builder index(int __value) {
        index = __value;
        return this;
      }

      private Builder index(String __value) {
        return index(Integer.valueOf(__value));
      }

      public Builder hostname(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        hostname = __value;
        return this;
      }


      /**
       * Add the given builder to this builder's list of Ports builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder ports(Ports.Builder __builder) {
        ports.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder ports(java.util.function.Consumer<Ports.Builder> __func) {
        Ports.Builder __inner = new Ports.Builder();
        __func.accept(__inner);
        ports.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Ports builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder ports(List<Ports.Builder> __builders) {
        ports = __builders;
        return this;
      }

      public Services build() {
        return new Services(this);
      }

    }

    private final IntegerNode index;
    private final StringNode hostname;
    private final InnerNodeVector<Ports> ports;

    public Services(Builder builder) {
      this(builder, true);
    }

    private Services(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "cluster-info.services[] must be initialized: " + builder.__uninitialized);

      index = (builder.index == null) ?
          new IntegerNode(-1) : new IntegerNode(builder.index);
      hostname = (builder.hostname == null) ?
          new StringNode("(nohostname)") : new StringNode(builder.hostname);
      ports = Ports.createVector(builder.ports);
    }

    /**
     * @return cluster-info.services[].index
     */
    public int index() {
      return index.value();
    }

    /**
     * @return cluster-info.services[].hostname
     */
    public String hostname() {
      return hostname.value();
    }

    /**
     * @return cluster-info.services[].ports[]
     */
    public List<Ports> ports() {
      return ports;
    }

    /**
     * @param i the index of the value to return
     * @return cluster-info.services[].ports[]
     */
    public Ports ports(int i) {
      return ports.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Services newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("services");
      return changes;
    }

    private static InnerNodeVector<Services> createVector(List<Builder> builders) {
        List<Services> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Services(b));
        }
        return new InnerNodeVector<Services>(elems);
    }

    /**
     * This class represents cluster-info.services[].ports[]
     */
    public final static class Ports extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private Integer number = null;
        private String tags = null;

        public Builder() { }

        public Builder(Ports config) {
          number(config.number());
          tags(config.tags());
        }

        private Builder override(Builder __superior) {
          if (__superior.number != null)
            number(__superior.number);
          if (__superior.tags != null)
            tags(__superior.tags);
          return this;
        }

        public Builder number(int __value) {
          number = __value;
          return this;
        }

        private Builder number(String __value) {
          return number(Integer.valueOf(__value));
        }

        public Builder tags(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          tags = __value;
          return this;
        }


        public Ports build() {
          return new Ports(this);
        }

      }

      private final IntegerNode number;
      private final StringNode tags;

      public Ports(Builder builder) {
        this(builder, true);
      }

      private Ports(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "cluster-info.services[].ports[] must be initialized: " + builder.__uninitialized);

        number = (builder.number == null) ?
            new IntegerNode(-1) : new IntegerNode(builder.number);
        tags = (builder.tags == null) ?
            new StringNode("(notags)") : new StringNode(builder.tags);
      }

      /**
       * @return cluster-info.services[].ports[].number
       */
      public int number() {
        return number.value();
      }

      /**
       * @return cluster-info.services[].ports[].tags
       */
      public String tags() {
        return tags.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Ports newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("ports");
        return changes;
      }

      private static InnerNodeVector<Ports> createVector(List<Builder> builders) {
          List<Ports> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Ports(b));
          }
          return new InnerNodeVector<Ports>(elems);
      }
    }
  }

}
