// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.cloud.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of application-id
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 * Application Id config (tenant, application, instance)
 */
public final class ApplicationIdConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "fde6b077639d9f215db08d33b94fec26";
  public final static String CONFIG_DEF_NAME = "application-id";
  public final static String CONFIG_DEF_NAMESPACE = "cloud.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=cloud.config",
    "tenant string default=\"(unknowntenant)\"",
    "application string default=\"(unknownapplication)\"",
    "instance string default=\"(unknowninstance)\""
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private String tenant = null;
    private String application = null;
    private String instance = null;

    public Builder() { }

    public Builder(ApplicationIdConfig config) {
      tenant(config.tenant());
      application(config.application());
      instance(config.instance());
    }

    private Builder override(Builder __superior) {
      if (__superior.tenant != null)
        tenant(__superior.tenant);
      if (__superior.application != null)
        application(__superior.application);
      if (__superior.instance != null)
        instance(__superior.instance);
      return this;
    }

    public Builder tenant(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      tenant = __value;
      return this;
    }


    public Builder application(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      application = __value;
      return this;
    }


    public Builder instance(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      instance = __value;
      return this;
    }


    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ApplicationIdConfig build() {
      return new ApplicationIdConfig(this);
    }

  }

  private final StringNode tenant;
  private final StringNode application;
  private final StringNode instance;

  public ApplicationIdConfig(Builder builder) {
    this(builder, true);
  }

  private ApplicationIdConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "application-id must be initialized: " + builder.__uninitialized);

    tenant = (builder.tenant == null) ?
        new StringNode("(unknowntenant)") : new StringNode(builder.tenant);
    application = (builder.application == null) ?
        new StringNode("(unknownapplication)") : new StringNode(builder.application);
    instance = (builder.instance == null) ?
        new StringNode("(unknowninstance)") : new StringNode(builder.instance);
  }

  /**
   * @return application-id.tenant
   */
  public String tenant() {
    return tenant.value();
  }

  /**
   * @return application-id.application
   */
  public String application() {
    return application.value();
  }

  /**
   * @return application-id.instance
   */
  public String instance() {
    return instance.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ApplicationIdConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("application-id");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
