// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package ai.vespa.embedding.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of gguf-embedder
 *
 */
public final class GgufEmbedderConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "bfc79396a20b2df2060479ae97d8c602";
  public final static String CONFIG_DEF_NAME = "gguf-embedder";
  public final static String CONFIG_DEF_NAMESPACE = "ai.vespa.embedding.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "package=ai.vespa.embedding.config",
    "embeddingModel model",
    "gpuLayers int default=0",
    "poolingType enum {UNSPECIFIED, NONE, MEAN, CLS, LAST, RANK} default=UNSPECIFIED",
    "physicalMaxBatchSize int default=-1",
    "logicalMaxBatchSize int default=-1",
    "continuousBatching bool default=false",
    "contextSize int default=0",
    "maxPromptTokens int default=0",
    "seed int default = -1",
    "parallel int default=1",
    "threads double default=0",
    "batchThreads double default=0",
    "prependQuery string default=\"\"",
    "prependDocument string default=\"\"",
    "normalize bool default=false"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>(List.of(
      "embeddingModel"
      ));

    private ModelReference embeddingModel = null;
    private Integer gpuLayers = null;
    private PoolingType.Enum poolingType = null;
    private Integer physicalMaxBatchSize = null;
    private Integer logicalMaxBatchSize = null;
    private Boolean continuousBatching = null;
    private Integer contextSize = null;
    private Integer maxPromptTokens = null;
    private Integer seed = null;
    private Integer parallel = null;
    private Double threads = null;
    private Double batchThreads = null;
    private String prependQuery = null;
    private String prependDocument = null;
    private Boolean normalize = null;

    public Builder() { }

    public Builder(GgufEmbedderConfig config) {
      embeddingModel(config.embeddingModel.getModelReference());
      gpuLayers(config.gpuLayers());
      poolingType(config.poolingType());
      physicalMaxBatchSize(config.physicalMaxBatchSize());
      logicalMaxBatchSize(config.logicalMaxBatchSize());
      continuousBatching(config.continuousBatching());
      contextSize(config.contextSize());
      maxPromptTokens(config.maxPromptTokens());
      seed(config.seed());
      parallel(config.parallel());
      threads(config.threads());
      batchThreads(config.batchThreads());
      prependQuery(config.prependQuery());
      prependDocument(config.prependDocument());
      normalize(config.normalize());
    }

    private Builder override(Builder __superior) {
      if (__superior.embeddingModel != null)
        embeddingModel(__superior.embeddingModel);
      if (__superior.gpuLayers != null)
        gpuLayers(__superior.gpuLayers);
      if (__superior.poolingType != null)
        poolingType(__superior.poolingType);
      if (__superior.physicalMaxBatchSize != null)
        physicalMaxBatchSize(__superior.physicalMaxBatchSize);
      if (__superior.logicalMaxBatchSize != null)
        logicalMaxBatchSize(__superior.logicalMaxBatchSize);
      if (__superior.continuousBatching != null)
        continuousBatching(__superior.continuousBatching);
      if (__superior.contextSize != null)
        contextSize(__superior.contextSize);
      if (__superior.maxPromptTokens != null)
        maxPromptTokens(__superior.maxPromptTokens);
      if (__superior.seed != null)
        seed(__superior.seed);
      if (__superior.parallel != null)
        parallel(__superior.parallel);
      if (__superior.threads != null)
        threads(__superior.threads);
      if (__superior.batchThreads != null)
        batchThreads(__superior.batchThreads);
      if (__superior.prependQuery != null)
        prependQuery(__superior.prependQuery);
      if (__superior.prependDocument != null)
        prependDocument(__superior.prependDocument);
      if (__superior.normalize != null)
        normalize(__superior.normalize);
      return this;
    }

    public Builder embeddingModel(ModelReference __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      embeddingModel = __value;
      __uninitialized.remove("embeddingModel");
      return this;
    }


    public Builder gpuLayers(int __value) {
      gpuLayers = __value;
      return this;
    }

    private Builder gpuLayers(String __value) {
      return gpuLayers(Integer.valueOf(__value));
    }

    public Builder poolingType(PoolingType.Enum __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      poolingType = __value;
      return this;
    }

    private Builder poolingType(String __value) {
      return poolingType(PoolingType.Enum.valueOf(__value));
    }

    public Builder physicalMaxBatchSize(int __value) {
      physicalMaxBatchSize = __value;
      return this;
    }

    private Builder physicalMaxBatchSize(String __value) {
      return physicalMaxBatchSize(Integer.valueOf(__value));
    }

    public Builder logicalMaxBatchSize(int __value) {
      logicalMaxBatchSize = __value;
      return this;
    }

    private Builder logicalMaxBatchSize(String __value) {
      return logicalMaxBatchSize(Integer.valueOf(__value));
    }

    public Builder continuousBatching(boolean __value) {
      continuousBatching = __value;
      return this;
    }

    private Builder continuousBatching(String __value) {
      return continuousBatching(Boolean.valueOf(__value));
    }

    public Builder contextSize(int __value) {
      contextSize = __value;
      return this;
    }

    private Builder contextSize(String __value) {
      return contextSize(Integer.valueOf(__value));
    }

    public Builder maxPromptTokens(int __value) {
      maxPromptTokens = __value;
      return this;
    }

    private Builder maxPromptTokens(String __value) {
      return maxPromptTokens(Integer.valueOf(__value));
    }

    public Builder seed(int __value) {
      seed = __value;
      return this;
    }

    private Builder seed(String __value) {
      return seed(Integer.valueOf(__value));
    }

    public Builder parallel(int __value) {
      parallel = __value;
      return this;
    }

    private Builder parallel(String __value) {
      return parallel(Integer.valueOf(__value));
    }

    public Builder threads(double __value) {
      threads = __value;
      return this;
    }

    private Builder threads(String __value) {
      return threads(Double.valueOf(__value));
    }

    public Builder batchThreads(double __value) {
      batchThreads = __value;
      return this;
    }

    private Builder batchThreads(String __value) {
      return batchThreads(Double.valueOf(__value));
    }

    public Builder prependQuery(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      prependQuery = __value;
      return this;
    }


    public Builder prependDocument(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      prependDocument = __value;
      return this;
    }


    public Builder normalize(boolean __value) {
      normalize = __value;
      return this;
    }

    private Builder normalize(String __value) {
      return normalize(Boolean.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public GgufEmbedderConfig build() {
      return new GgufEmbedderConfig(this);
    }

  }

  // GGUF embedding model
  private final ModelNode embeddingModel;
  // Maximum number of model layers to run on GPU (default: 0 = CPU-only).
  private final IntegerNode gpuLayers;
  // Set pooling type for embeddings (default: UNSPECIFIED, UNSPECIFIED = model default).
  private final PoolingType poolingType;
  // Set the physical maximum batch size (default: -1 = use runtime default).
  private final IntegerNode physicalMaxBatchSize;
  // Set the logical maximum batch size (default: -1 = use runtime default).
  private final IntegerNode logicalMaxBatchSize;
  // Continuous batching mode (default: false).
  private final BooleanNode continuousBatching;
  // Set the size of the prompt context (default: 0 = loaded from model).
  private final IntegerNode contextSize;
  // Set the number of tokens to keep from the initial prompt (default: 0 = all)
  private final IntegerNode maxPromptTokens;
  // Random number generator seed used by LLM runtime during inference (default: -1 = use random seed).
  private final IntegerNode seed;
  // Set the maximum number of parallel sequences to decode (default: 1 = no parallel decoding).
  private final IntegerNode parallel;
  // Set the number of threads to use during generation (default: 0 = use runtime default).
  // - If 0>, the the number of threads as an absolute value.
  // - If 0, use runtime default.
  // - If <0, the number of threads as a ratio of the cpu cores, e.g. -1 for all cores.
  private final DoubleNode threads;
  // Set the number of threads to use during batch and prompt processing (default: 0 = use runtime default).
  // - If 0>, the the number of threads as an absolute value.
  // - If 0, use runtime default.
  // - If <0, the number of threads as a ratio of the cpu cores, e.g. -1 for all cores.
  private final DoubleNode batchThreads;
  // Prefix to prepend to prompt (if in query context)
  private final StringNode prependQuery;
  // Prefix to prepend to prompt (if in document context)
  private final StringNode prependDocument;
  // Normalize output embeddings
  private final BooleanNode normalize;

  public GgufEmbedderConfig(Builder builder) {
    this(builder, true);
  }

  private GgufEmbedderConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "gguf-embedder must be initialized: " + builder.__uninitialized);

    embeddingModel = (builder.embeddingModel == null) ?
        new ModelNode() : new ModelNode(builder.embeddingModel);
    gpuLayers = (builder.gpuLayers == null) ?
        new IntegerNode(0) : new IntegerNode(builder.gpuLayers);
    poolingType = (builder.poolingType == null) ?
        new PoolingType(PoolingType.UNSPECIFIED) : new PoolingType(builder.poolingType);
    physicalMaxBatchSize = (builder.physicalMaxBatchSize == null) ?
        new IntegerNode(-1) : new IntegerNode(builder.physicalMaxBatchSize);
    logicalMaxBatchSize = (builder.logicalMaxBatchSize == null) ?
        new IntegerNode(-1) : new IntegerNode(builder.logicalMaxBatchSize);
    continuousBatching = (builder.continuousBatching == null) ?
        new BooleanNode(false) : new BooleanNode(builder.continuousBatching);
    contextSize = (builder.contextSize == null) ?
        new IntegerNode(0) : new IntegerNode(builder.contextSize);
    maxPromptTokens = (builder.maxPromptTokens == null) ?
        new IntegerNode(0) : new IntegerNode(builder.maxPromptTokens);
    seed = (builder.seed == null) ?
        new IntegerNode(-1) : new IntegerNode(builder.seed);
    parallel = (builder.parallel == null) ?
        new IntegerNode(1) : new IntegerNode(builder.parallel);
    threads = (builder.threads == null) ?
        new DoubleNode(0D) : new DoubleNode(builder.threads);
    batchThreads = (builder.batchThreads == null) ?
        new DoubleNode(0D) : new DoubleNode(builder.batchThreads);
    prependQuery = (builder.prependQuery == null) ?
        new StringNode("") : new StringNode(builder.prependQuery);
    prependDocument = (builder.prependDocument == null) ?
        new StringNode("") : new StringNode(builder.prependDocument);
    normalize = (builder.normalize == null) ?
        new BooleanNode(false) : new BooleanNode(builder.normalize);
  }

  /**
   * @return gguf-embedder.embeddingModel
   */
  public Path embeddingModel() {
    return embeddingModel.value();
  }

  /**
   * @return gguf-embedder.embeddingModel ModelReference
   */
  public ModelReference embeddingModelReference() {
    return embeddingModel.getModelReference();
  }

  /**
   * @return gguf-embedder.gpuLayers
   */
  public int gpuLayers() {
    return gpuLayers.value();
  }

  /**
   * @return gguf-embedder.poolingType
   */
  public PoolingType.Enum poolingType() {
    return poolingType.value();
  }

  /**
   * @return gguf-embedder.physicalMaxBatchSize
   */
  public int physicalMaxBatchSize() {
    return physicalMaxBatchSize.value();
  }

  /**
   * @return gguf-embedder.logicalMaxBatchSize
   */
  public int logicalMaxBatchSize() {
    return logicalMaxBatchSize.value();
  }

  /**
   * @return gguf-embedder.continuousBatching
   */
  public boolean continuousBatching() {
    return continuousBatching.value();
  }

  /**
   * @return gguf-embedder.contextSize
   */
  public int contextSize() {
    return contextSize.value();
  }

  /**
   * @return gguf-embedder.maxPromptTokens
   */
  public int maxPromptTokens() {
    return maxPromptTokens.value();
  }

  /**
   * @return gguf-embedder.seed
   */
  public int seed() {
    return seed.value();
  }

  /**
   * @return gguf-embedder.parallel
   */
  public int parallel() {
    return parallel.value();
  }

  /**
   * @return gguf-embedder.threads
   */
  public double threads() {
    return threads.value();
  }

  /**
   * @return gguf-embedder.batchThreads
   */
  public double batchThreads() {
    return batchThreads.value();
  }

  /**
   * @return gguf-embedder.prependQuery
   */
  public String prependQuery() {
    return prependQuery.value();
  }

  /**
   * @return gguf-embedder.prependDocument
   */
  public String prependDocument() {
    return prependDocument.value();
  }

  /**
   * @return gguf-embedder.normalize
   */
  public boolean normalize() {
    return normalize.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(GgufEmbedderConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("gguf-embedder");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents gguf-embedder.poolingType
   * 
   * Set pooling type for embeddings (default: UNSPECIFIED, UNSPECIFIED = model default).
   */
  public final static class PoolingType extends EnumNode<PoolingType.Enum> {

    public PoolingType(){
      this.value = null;
    }

    public PoolingType(Enum enumValue) {
      super(enumValue != null);
      this.value = enumValue;
    }

    public enum Enum {UNSPECIFIED, NONE, MEAN, CLS, LAST, RANK}
    public final static Enum UNSPECIFIED = Enum.UNSPECIFIED;
    public final static Enum NONE = Enum.NONE;
    public final static Enum MEAN = Enum.MEAN;
    public final static Enum CLS = Enum.CLS;
    public final static Enum LAST = Enum.LAST;
    public final static Enum RANK = Enum.RANK;

    @Override
    protected boolean doSetValue(String name) {
      try {
        value = Enum.valueOf(name);
        return true;
      } catch (IllegalArgumentException e) {
      }
      return false;
    }
  }

}
