/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.protocol;

import com.yahoo.slime.ArrayTraverser;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Type;
import com.yahoo.yolean.trace.TraceNode;

public class SlimeTraceDeserializer {
    private final Inspector entry;

    public SlimeTraceDeserializer(Inspector inspector) {
        this.entry = inspector;
    }

    public TraceNode deserialize() {
        return SlimeTraceDeserializer.deserialize(this.entry);
    }

    private static TraceNode deserialize(Inspector entry) {
        Object payload = SlimeTraceDeserializer.decodePayload(entry.field("payload"));
        long timestamp = SlimeTraceDeserializer.decodeTimestamp(entry.field("timestamp"));
        final TraceNode node = new TraceNode(payload, timestamp);
        Inspector children = entry.field("children");
        children.traverse(new ArrayTraverser(){

            public void entry(int idx, Inspector inspector) {
                node.add(SlimeTraceDeserializer.deserialize(inspector));
            }
        });
        return node;
    }

    private static long decodeTimestamp(Inspector entry) {
        return entry.asLong();
    }

    private static Object decodePayload(Inspector entry) {
        return switch (entry.type()) {
            case Type.STRING -> entry.asString();
            case Type.LONG -> entry.asLong();
            case Type.BOOL -> entry.asBool();
            case Type.DOUBLE -> entry.asDouble();
            case Type.DATA -> entry.asData();
            default -> null;
        };
    }
}

