/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class NetworkPorts {
    private final List<Allocation> allocations;

    public NetworkPorts(Collection<Allocation> allocations) {
        this.allocations = List.copyOf(allocations);
    }

    public Collection<Allocation> allocations() {
        return this.allocations;
    }

    public int size() {
        return this.allocations.size();
    }

    public int hashCode() {
        return this.allocations.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof NetworkPorts)) {
            return false;
        }
        return ((NetworkPorts)other).allocations.equals(this.allocations);
    }

    public static class Allocation {
        public final int port;
        public final String serviceType;
        public final String configId;
        public final String portSuffix;

        public Allocation(int port, String serviceType, String configId, String portSuffix) {
            this.port = port;
            this.serviceType = Objects.requireNonNull(serviceType, "servceType cannot be null");
            this.configId = Objects.requireNonNull(configId, "configId cannot be null");
            this.portSuffix = Objects.requireNonNull(portSuffix, "portSuffix cannot be null");
        }

        public String key() {
            StringBuilder buf = new StringBuilder();
            buf.append("t=").append(this.serviceType);
            buf.append(" cfg=").append(this.configId);
            buf.append(" suf=").append(this.portSuffix);
            return buf.toString();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("[port=").append(this.port);
            buf.append(" serviceType=").append(this.serviceType);
            buf.append(" configId=").append(this.configId);
            buf.append(" suffix=").append(this.portSuffix);
            buf.append("]");
            return buf.toString();
        }

        public int hashCode() {
            return Objects.hash(this.port, this.serviceType, this.configId, this.portSuffix);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Allocation)) {
                return false;
            }
            Allocation other = (Allocation)o;
            if (other.port != this.port) {
                return false;
            }
            if (!other.serviceType.equals(this.serviceType)) {
                return false;
            }
            if (!other.configId.equals(this.configId)) {
                return false;
            }
            return other.portSuffix.equals(this.portSuffix);
        }
    }
}

