/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import java.util.Set;
import java.util.stream.Collectors;

public class Tags {
    private final Set<String> tags;

    public Tags(Set<String> tags) {
        this.tags = Set.copyOf(tags);
    }

    public boolean contains(String tag) {
        return this.tags.contains(tag);
    }

    public boolean intersects(Tags other) {
        return this.tags.stream().anyMatch(other::contains);
    }

    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    public boolean containsAll(Tags other) {
        return this.tags.containsAll(other.tags);
    }

    public String asString() {
        return this.tags.stream().sorted().collect(Collectors.joining(" "));
    }

    public String toString() {
        return this.asString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        return this.tags.equals(((Tags)other).tags);
    }

    public int hashCode() {
        return this.tags.hashCode();
    }

    public static Tags empty() {
        return new Tags(Set.of());
    }

    public static Tags fromString(String tagsString) {
        if (tagsString == null || tagsString.isBlank()) {
            return Tags.empty();
        }
        return new Tags(Set.of(tagsString.trim().split(" +")));
    }
}

