// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.config.provisioning;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of node-repository
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class NodeRepositoryConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "2ca80d4add7e3bf026f530d31b984a0a";
  public final static String CONFIG_DEF_NAME = "node-repository";
  public final static String CONFIG_DEF_NAMESPACE = "config.provisioning";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=config.provisioning",
    "containerImage string default=\"registry.example.com:9999/myorg/vespa\"",
    "tenantContainerImage string default=\"\"",
    "tenantGpuContainerImage string default=\"\"",
    "useCuratorClientCache bool default=false",
    "nodeCacheSize long default=3000"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private String containerImage = null;
    private String tenantContainerImage = null;
    private String tenantGpuContainerImage = null;
    private Boolean useCuratorClientCache = null;
    private Long nodeCacheSize = null;

    public Builder() { }

    public Builder(NodeRepositoryConfig config) {
      containerImage(config.containerImage());
      tenantContainerImage(config.tenantContainerImage());
      tenantGpuContainerImage(config.tenantGpuContainerImage());
      useCuratorClientCache(config.useCuratorClientCache());
      nodeCacheSize(config.nodeCacheSize());
    }

    private Builder override(Builder __superior) {
      if (__superior.containerImage != null)
        containerImage(__superior.containerImage);
      if (__superior.tenantContainerImage != null)
        tenantContainerImage(__superior.tenantContainerImage);
      if (__superior.tenantGpuContainerImage != null)
        tenantGpuContainerImage(__superior.tenantGpuContainerImage);
      if (__superior.useCuratorClientCache != null)
        useCuratorClientCache(__superior.useCuratorClientCache);
      if (__superior.nodeCacheSize != null)
        nodeCacheSize(__superior.nodeCacheSize);
      return this;
    }

    public Builder containerImage(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      containerImage = __value;
      return this;
    }


    public Builder tenantContainerImage(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      tenantContainerImage = __value;
      return this;
    }


    public Builder tenantGpuContainerImage(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      tenantGpuContainerImage = __value;
      return this;
    }


    public Builder useCuratorClientCache(boolean __value) {
      useCuratorClientCache = __value;
      return this;
    }

    private Builder useCuratorClientCache(String __value) {
      return useCuratorClientCache(Boolean.valueOf(__value));
    }

    public Builder nodeCacheSize(long __value) {
      nodeCacheSize = __value;
      return this;
    }

    private Builder nodeCacheSize(String __value) {
      return nodeCacheSize(Long.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public NodeRepositoryConfig build() {
      return new NodeRepositoryConfig(this);
    }

  }

  // Default container image to use for nodes.
  private final StringNode containerImage;
  // Default container image to use for tenant nodes. If this is unset (empty), it defaults to containerImage.
  private final StringNode tenantContainerImage;
  // Default container image to use for tenant nodes with GPU resources. If this is unset (empty), starting nodes with GPUs will fail
  private final StringNode tenantGpuContainerImage;
  // Whether to cache data read from ZooKeeper in-memory.
  private final BooleanNode useCuratorClientCache;
  // The number of Node objects to cache in-memory.
  private final LongNode nodeCacheSize;

  public NodeRepositoryConfig(Builder builder) {
    this(builder, true);
  }

  private NodeRepositoryConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "node-repository must be initialized: " + builder.__uninitialized);

    containerImage = (builder.containerImage == null) ?
        new StringNode("registry.example.com:9999/myorg/vespa") : new StringNode(builder.containerImage);
    tenantContainerImage = (builder.tenantContainerImage == null) ?
        new StringNode("") : new StringNode(builder.tenantContainerImage);
    tenantGpuContainerImage = (builder.tenantGpuContainerImage == null) ?
        new StringNode("") : new StringNode(builder.tenantGpuContainerImage);
    useCuratorClientCache = (builder.useCuratorClientCache == null) ?
        new BooleanNode(false) : new BooleanNode(builder.useCuratorClientCache);
    nodeCacheSize = (builder.nodeCacheSize == null) ?
        new LongNode(3000L) : new LongNode(builder.nodeCacheSize);
  }

  /**
   * @return node-repository.containerImage
   */
  public String containerImage() {
    return containerImage.value();
  }

  /**
   * @return node-repository.tenantContainerImage
   */
  public String tenantContainerImage() {
    return tenantContainerImage.value();
  }

  /**
   * @return node-repository.tenantGpuContainerImage
   */
  public String tenantGpuContainerImage() {
    return tenantGpuContainerImage.value();
  }

  /**
   * @return node-repository.useCuratorClientCache
   */
  public boolean useCuratorClientCache() {
    return useCuratorClientCache.value();
  }

  /**
   * @return node-repository.nodeCacheSize
   */
  public long nodeCacheSize() {
    return nodeCacheSize.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(NodeRepositoryConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("node-repository");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
